# ----------------------------------------------------------------------------
#
#  Copyright (C) 2018-2022 Fons Adriaensen <fons@linuxaudio.org>
#    
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http:#www.gnu.org/licenses/>.
#
# ----------------------------------------------------------------------------


from PyQt5 import QtGui


# Global definitions.
#
# Note: other modules should use 'import globdef as',
# and not 'from globdef import'. The latter will
# ignore changes made after import, e.g. by darkpal().
 

# Sizes.
#
ELM_XS = 41
ELM_YS = 41
IP_YS = 93
OP_XS = 93

# Fonts.
#
VAL_FONT = QtGui.QFont ("sans", 7, QtGui.QFont.Bold)
BUT_FONT = QtGui.QFont ("sans", 9, QtGui.QFont.Bold)
LAB_FONT = QtGui.QFont ("sans", 8, QtGui.QFont.Bold)

# Callback actions.
#
ACT_GAIN  = 0
ACT_DELAY = 1
ACT_MUTE  = 2
ACT_SOLO  = 3
#ACT_CLEAR = 4
#ACT_COPY  = 5
#ACT_PASTE = 6

# Colors.
#
COL0 = QtGui.QColor (0, 0, 0)
COL2 = QtGui.QColor (255, 0, 0)
COL3 = QtGui.QColor (255, 140, 0)
COL4 = QtGui.QColor (255, 255, 0)
COL5 = QtGui.QColor (0, 255, 0)
COL6 = QtGui.QColor (0, 0, 150)
COL9 = QtGui.QColor (255, 255, 255)
FG_N = QtGui.QColor (210, 210, 220)
MK_N = COL0

# Dark theme.
#
def darkpal (app):
    global FG_N, MK_N
    
    bgc = QtGui.QColor (60, 60, 60)
    fgc = QtGui.QColor (255, 255, 255)
    dark = QtGui.QColor (0, 0, 0)
    lite = QtGui.QColor (150, 150, 150)
    pal = app.palette()
    pal.setColor(pal.Window, bgc)
    pal.setColor(pal.Button, bgc)
    pal.setColor(pal.Base, bgc)
    pal.setColor(pal.WindowText, fgc)
    pal.setColor(pal.ButtonText, fgc)
    pal.setColor(pal.Text, fgc)
    pal.setColor(pal.Dark, dark)
    pal.setColor(pal.Light, lite)
    app.setPalette (pal)
    FG_N = QtGui.QColor (80, 80, 100)
    MK_N = COL9

