complete -c ruff -n "__fish_use_subcommand" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_use_subcommand" -s q -l quiet -d 'Print diagnostics, but nothing else'
complete -c ruff -n "__fish_use_subcommand" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
complete -c ruff -n "__fish_use_subcommand" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_use_subcommand" -s V -l version -d 'Print version'
complete -c ruff -n "__fish_use_subcommand" -f -a "check" -d 'Run Ruff on the given files or directories (default)'
complete -c ruff -n "__fish_use_subcommand" -f -a "rule" -d 'Explain a rule (or all rules)'
complete -c ruff -n "__fish_use_subcommand" -f -a "config" -d 'List or describe the available configuration options'
complete -c ruff -n "__fish_use_subcommand" -f -a "linter" -d 'List all supported upstream linters'
complete -c ruff -n "__fish_use_subcommand" -f -a "clean" -d 'Clear any caches in the current directory and any subdirectories'
complete -c ruff -n "__fish_use_subcommand" -f -a "generate-shell-completion" -d 'Generate shell completion'
complete -c ruff -n "__fish_use_subcommand" -f -a "format" -d 'Run the Ruff formatter on the given files or directories'
complete -c ruff -n "__fish_use_subcommand" -f -a "version" -d 'Display Ruff\'s version'
complete -c ruff -n "__fish_use_subcommand" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ruff -n "__fish_seen_subcommand_from check" -l output-format -d 'Output serialization format for violations' -r -f -a "{text	,json	,json-lines	,junit	,grouped	,github	,gitlab	,pylint	,azure	,sarif	}"
complete -c ruff -n "__fish_seen_subcommand_from check" -s o -l output-file -d 'Specify file to write the linter output to (default: stdout)' -r -F
complete -c ruff -n "__fish_seen_subcommand_from check" -l target-version -d 'The minimum Python version that should be supported' -r -f -a "{py37	,py38	,py39	,py310	,py311	,py312	}"
complete -c ruff -n "__fish_seen_subcommand_from check" -l config -d 'Path to the `pyproject.toml` or `ruff.toml` file to use for configuration' -r -F
complete -c ruff -n "__fish_seen_subcommand_from check" -l select -d 'Comma-separated list of rule codes to enable (or ALL, to enable all rules)' -r -f -a "{ALL	all rules,F	Pyflakes,C90	mccabe,I	isort,N	pep8-naming,D	pydocstyle,UP	pyupgrade,YTT	flake8-2020,ANN	flake8-annotations,ASYNC	flake8-async,TRIO	flake8-trio,S	flake8-bandit,BLE	flake8-blind-except,FBT	flake8-boolean-trap,B	flake8-bugbear,A	flake8-builtins,COM	flake8-commas,CPY	flake8-copyright,C4	flake8-comprehensions,DTZ	flake8-datetimez,T10	flake8-debugger,DJ	flake8-django,EM	flake8-errmsg,EXE	flake8-executable,FA	flake8-future-annotations,ISC	flake8-implicit-str-concat,ICN	flake8-import-conventions,G	flake8-logging-format,INP	flake8-no-pep420,PIE	flake8-pie,T20	flake8-print,PYI	flake8-pyi,PT	flake8-pytest-style,Q	flake8-quotes,RSE	flake8-raise,RET	flake8-return,SLF	flake8-self,SLOT	flake8-slots,SIM	flake8-simplify,TID	flake8-tidy-imports,TCH	flake8-type-checking,INT	flake8-gettext,ARG	flake8-unused-arguments,PTH	flake8-use-pathlib,TD	flake8-todos,FIX	flake8-fixme,ERA	eradicate,PD	pandas-vet,PGH	pygrep-hooks,PL	Pylint,TRY	tryceratops,FLY	flynt,NPY	NumPy-specific rules,AIR	Airflow,PERF	Perflint,FURB	refurb,LOG	flake8-logging,RUF	Ruff-specific rules,AIR001	airflow-variable-name-task-id-mismatch,ERA001	commented-out-code,YTT101	sys-version-slice3,YTT102	sys-version2,YTT103	sys-version-cmp-str3,YTT201	sys-version-info0-eq3,YTT202	six-py3,YTT203	sys-version-info1-cmp-int,YTT204	sys-version-info-minor-cmp-int,YTT301	sys-version0,YTT302	sys-version-cmp-str10,YTT303	sys-version-slice1,ANN001	missing-type-function-argument,ANN002	missing-type-args,ANN003	missing-type-kwargs,ANN101	missing-type-self,ANN102	missing-type-cls,ANN201	missing-return-type-undocumented-public-function,ANN202	missing-return-type-private-function,ANN204	missing-return-type-special-method,ANN205	missing-return-type-static-method,ANN206	missing-return-type-class-method,ANN401	any-type,ASYNC100	blocking-http-call-in-async-function,ASYNC101	open-sleep-or-subprocess-in-async-function,ASYNC102	blocking-os-call-in-async-function,S101	assert,S102	exec-builtin,S103	bad-file-permissions,S104	hardcoded-bind-all-interfaces,S105	hardcoded-password-string,S106	hardcoded-password-func-arg,S107	hardcoded-password-default,S108	hardcoded-temp-file,S110	try-except-pass,S112	try-except-continue,S113	request-without-timeout,S201	flask-debug-true,S202	tarfile-unsafe-members,S301	suspicious-pickle-usage,S302	suspicious-marshal-usage,S303	suspicious-insecure-hash-usage,S304	suspicious-insecure-cipher-usage,S305	suspicious-insecure-cipher-mode-usage,S306	suspicious-mktemp-usage,S307	suspicious-eval-usage,S308	suspicious-mark-safe-usage,S310	suspicious-url-open-usage,S311	suspicious-non-cryptographic-random-usage,S312	suspicious-telnet-usage,S313	suspicious-xmlc-element-tree-usage,S314	suspicious-xml-element-tree-usage,S315	suspicious-xml-expat-reader-usage,S316	suspicious-xml-expat-builder-usage,S317	suspicious-xml-sax-usage,S318	suspicious-xml-mini-dom-usage,S319	suspicious-xml-pull-dom-usage,S320	suspicious-xmle-tree-usage,S321	suspicious-ftp-lib-usage,S323	suspicious-unverified-context-usage,S324	hashlib-insecure-hash-function,S401	suspicious-telnetlib-import,S402	suspicious-ftplib-import,S403	suspicious-pickle-import,S404	suspicious-subprocess-import,S405	suspicious-xml-etree-import,S406	suspicious-xml-sax-import,S407	suspicious-xml-expat-import,S408	suspicious-xml-minidom-import,S409	suspicious-xml-pulldom-import,S410	suspicious-lxml-import,S411	suspicious-xmlrpc-import,S412	suspicious-httpoxy-import,S413	suspicious-pycrypto-import,S415	suspicious-pyghmi-import,S501	request-with-no-cert-validation,S502	ssl-insecure-version,S503	ssl-with-bad-defaults,S504	ssl-with-no-version,S505	weak-cryptographic-key,S506	unsafe-yaml-load,S507	ssh-no-host-key-verification,S508	snmp-insecure-version,S509	snmp-weak-cryptography,S601	paramiko-call,S602	subprocess-popen-with-shell-equals-true,S603	subprocess-without-shell-equals-true,S604	call-with-shell-equals-true,S605	start-process-with-a-shell,S606	start-process-with-no-shell,S607	start-process-with-partial-path,S608	hardcoded-sql-expression,S609	unix-command-wildcard-injection,S611	django-raw-sql,S612	logging-config-insecure-listen,S701	jinja2-autoescape-false,S702	mako-templates,BLE001	blind-except,FBT001	boolean-type-hint-positional-argument,FBT002	boolean-default-value-positional-argument,FBT003	boolean-positional-value-in-call,B002	unary-prefix-increment-decrement,B003	assignment-to-os-environ,B004	unreliable-callable-check,B005	strip-with-multi-characters,B006	mutable-argument-default,B007	unused-loop-control-variable,B008	function-call-in-default-argument,B009	get-attr-with-constant,B010	set-attr-with-constant,B011	assert-false,B012	jump-statement-in-finally,B013	redundant-tuple-in-exception-handler,B014	duplicate-handler-exception,B015	useless-comparison,B016	raise-literal,B017	assert-raises-exception,B018	useless-expression,B019	cached-instance-method,B020	loop-variable-overrides-iterator,B021	f-string-docstring,B022	useless-contextlib-suppress,B023	function-uses-loop-variable,B024	abstract-base-class-without-abstract-method,B025	duplicate-try-block-exception,B026	star-arg-unpacking-after-keyword-arg,B027	empty-method-without-abstract-decorator,B028	no-explicit-stacklevel,B029	except-with-empty-tuple,B030	except-with-non-exception-classes,B031	reuse-of-groupby-generator,B032	unintentional-type-annotation,B033	duplicate-value,B034	re-sub-positional-args,B904	raise-without-from-inside-except,B905	zip-without-explicit-strict,A001	builtin-variable-shadowing,A002	builtin-argument-shadowing,A003	builtin-attribute-shadowing,COM812	missing-trailing-comma,COM818	trailing-comma-on-bare-tuple,COM819	prohibited-trailing-comma,C400	unnecessary-generator-list,C401	unnecessary-generator-set,C402	unnecessary-generator-dict,C403	unnecessary-list-comprehension-set,C404	unnecessary-list-comprehension-dict,C405	unnecessary-literal-set,C406	unnecessary-literal-dict,C408	unnecessary-collection-call,C409	unnecessary-literal-within-tuple-call,C410	unnecessary-literal-within-list-call,C411	unnecessary-list-call,C413	unnecessary-call-around-sorted,C414	unnecessary-double-cast-or-process,C415	unnecessary-subscript-reversal,C416	unnecessary-comprehension,C417	unnecessary-map,C418	unnecessary-literal-within-dict-call,C419	unnecessary-comprehension-any-all,CPY001	missing-copyright-notice,DTZ001	call-datetime-without-tzinfo,DTZ002	call-datetime-today,DTZ003	call-datetime-utcnow,DTZ004	call-datetime-utcfromtimestamp,DTZ005	call-datetime-now-without-tzinfo,DTZ006	call-datetime-fromtimestamp,DTZ007	call-datetime-strptime-without-zone,DTZ011	call-date-today,DTZ012	call-date-fromtimestamp,T100	debugger,DJ001	django-nullable-model-string-field,DJ003	django-locals-in-render-function,DJ006	django-exclude-with-model-form,DJ007	django-all-with-model-form,DJ008	django-model-without-dunder-str,DJ012	django-unordered-body-content-in-model,DJ013	django-non-leading-receiver-decorator,EM101	raw-string-in-exception,EM102	f-string-in-exception,EM103	dot-format-in-exception,EXE001	shebang-not-executable,EXE002	shebang-missing-executable-file,EXE003	shebang-missing-python,EXE004	shebang-leading-whitespace,EXE005	shebang-not-first-line,FIX001	line-contains-fixme,FIX002	line-contains-todo,FIX003	line-contains-xxx,FIX004	line-contains-hack,FA100	future-rewritable-type-annotation,FA102	future-required-type-annotation,INT001	f-string-in-get-text-func-call,INT002	format-in-get-text-func-call,INT003	printf-in-get-text-func-call,ISC001	single-line-implicit-string-concatenation,ISC002	multi-line-implicit-string-concatenation,ISC003	explicit-string-concatenation,ICN001	unconventional-import-alias,ICN002	banned-import-alias,ICN003	banned-import-from,LOG001	direct-logger-instantiation,LOG002	invalid-get-logger-argument,LOG007	exception-without-exc-info,LOG009	undocumented-warn,G001	logging-string-format,G002	logging-percent-format,G003	logging-string-concat,G004	logging-f-string,G010	logging-warn,G101	logging-extra-attr-clash,G201	logging-exc-info,G202	logging-redundant-exc-info,INP001	implicit-namespace-package,PIE790	unnecessary-placeholder,PIE794	duplicate-class-field-definition,PIE796	non-unique-enums,PIE800	unnecessary-spread,PIE804	unnecessary-dict-kwargs,PIE807	reimplemented-container-builtin,PIE808	unnecessary-range-start,PIE810	multiple-starts-ends-with,T201	print,T203	p-print,PYI001	unprefixed-type-param,PYI002	complex-if-statement-in-stub,PYI003	unrecognized-version-info-check,PYI004	patch-version-comparison,PYI005	wrong-tuple-length-version-comparison,PYI006	bad-version-info-comparison,PYI007	unrecognized-platform-check,PYI008	unrecognized-platform-name,PYI009	pass-statement-stub-body,PYI010	non-empty-stub-body,PYI011	typed-argument-default-in-stub,PYI012	pass-in-class-body,PYI013	ellipsis-in-non-empty-class-body,PYI014	argument-default-in-stub,PYI015	assignment-default-in-stub,PYI016	duplicate-union-member,PYI017	complex-assignment-in-stub,PYI018	unused-private-type-var,PYI019	custom-type-var-return-type,PYI020	quoted-annotation-in-stub,PYI021	docstring-in-stub,PYI024	collections-named-tuple,PYI025	unaliased-collections-abc-set-import,PYI026	type-alias-without-annotation,PYI029	str-or-repr-defined-in-stub,PYI030	unnecessary-literal-union,PYI032	any-eq-ne-annotation,PYI033	type-comment-in-stub,PYI034	non-self-return-type,PYI035	unassigned-special-variable-in-stub,PYI036	bad-exit-annotation,PYI041	redundant-numeric-union,PYI042	snake-case-type-alias,PYI043	t-suffixed-type-alias,PYI044	future-annotations-in-stub,PYI045	iter-method-return-iterable,PYI046	unused-private-protocol,PYI047	unused-private-type-alias,PYI048	stub-body-multiple-statements,PYI049	unused-private-typed-dict,PYI050	no-return-argument-annotation-in-stub,PYI051	redundant-literal-union,PYI052	unannotated-assignment-in-stub,PYI053	string-or-bytes-too-long,PYI054	numeric-literal-too-long,PYI055	unnecessary-type-union,PYI056	unsupported-method-call-on-all,PYI058	generator-return-from-iter-method,PT001	pytest-fixture-incorrect-parentheses-style,PT002	pytest-fixture-positional-args,PT003	pytest-extraneous-scope-function,PT004	pytest-missing-fixture-name-underscore,PT005	pytest-incorrect-fixture-name-underscore,PT006	pytest-parametrize-names-wrong-type,PT007	pytest-parametrize-values-wrong-type,PT008	pytest-patch-with-lambda,PT009	pytest-unittest-assertion,PT010	pytest-raises-without-exception,PT011	pytest-raises-too-broad,PT012	pytest-raises-with-multiple-statements,PT013	pytest-incorrect-pytest-import,PT014	pytest-duplicate-parametrize-test-cases,PT015	pytest-assert-always-false,PT016	pytest-fail-without-message,PT017	pytest-assert-in-except,PT018	pytest-composite-assertion,PT019	pytest-fixture-param-without-value,PT020	pytest-deprecated-yield-fixture,PT021	pytest-fixture-finalizer-callback,PT022	pytest-useless-yield-fixture,PT023	pytest-incorrect-mark-parentheses-style,PT024	pytest-unnecessary-asyncio-mark-on-fixture,PT025	pytest-erroneous-use-fixtures-on-fixture,PT026	pytest-use-fixtures-without-parameters,PT027	pytest-unittest-raises-assertion,Q000	bad-quotes-inline-string,Q001	bad-quotes-multiline-string,Q002	bad-quotes-docstring,Q003	avoidable-escaped-quote,Q004	unnecessary-escaped-quote,RSE102	unnecessary-paren-on-raise-exception,RET501	unnecessary-return-none,RET502	implicit-return-value,RET503	implicit-return,RET504	unnecessary-assign,RET505	superfluous-else-return,RET506	superfluous-else-raise,RET507	superfluous-else-continue,RET508	superfluous-else-break,SLF001	private-member-access,SIM101	duplicate-isinstance-call,SIM102	collapsible-if,SIM103	needless-bool,SIM105	suppressible-exception,SIM107	return-in-try-except-finally,SIM108	if-else-block-instead-of-if-exp,SIM109	compare-with-tuple,SIM110	reimplemented-builtin,SIM112	uncapitalized-environment-variables,SIM113	enumerate-for-loop,SIM114	if-with-same-arms,SIM115	open-file-with-context-handler,SIM116	if-else-block-instead-of-dict-lookup,SIM117	multiple-with-statements,SIM118	in-dict-keys,SIM201	negate-equal-op,SIM202	negate-not-equal-op,SIM208	double-negation,SIM210	if-expr-with-true-false,SIM211	if-expr-with-false-true,SIM212	if-expr-with-twisted-arms,SIM220	expr-and-not-expr,SIM221	expr-or-not-expr,SIM222	expr-or-true,SIM223	expr-and-false,SIM300	yoda-conditions,SIM401	if-else-block-instead-of-dict-get,SIM910	dict-get-with-none-default,SIM911	zip-dict-keys-and-values,SLOT000	no-slots-in-str-subclass,SLOT001	no-slots-in-tuple-subclass,SLOT002	no-slots-in-namedtuple-subclass,TID251	banned-api,TID252	relative-imports,TID253	banned-module-level-imports,TD001	invalid-todo-tag,TD002	missing-todo-author,TD003	missing-todo-link,TD004	missing-todo-colon,TD005	missing-todo-description,TD006	invalid-todo-capitalization,TD007	missing-space-after-todo-colon,TRIO100	trio-timeout-without-await,TRIO105	trio-sync-call,TRIO109	trio-async-function-with-timeout,TRIO110	trio-unneeded-sleep,TRIO115	trio-zero-sleep-call,TCH001	typing-only-first-party-import,TCH002	typing-only-third-party-import,TCH003	typing-only-standard-library-import,TCH004	runtime-import-in-type-checking-block,TCH005	empty-type-checking-block,TCH006	runtime-string-union,ARG001	unused-function-argument,ARG002	unused-method-argument,ARG003	unused-class-method-argument,ARG004	unused-static-method-argument,ARG005	unused-lambda-argument,PTH100	os-path-abspath,PTH101	os-chmod,PTH102	os-mkdir,PTH103	os-makedirs,PTH104	os-rename,PTH105	os-replace,PTH106	os-rmdir,PTH107	os-remove,PTH108	os-unlink,PTH109	os-getcwd,PTH110	os-path-exists,PTH111	os-path-expanduser,PTH112	os-path-isdir,PTH113	os-path-isfile,PTH114	os-path-islink,PTH115	os-readlink,PTH116	os-stat,PTH117	os-path-isabs,PTH118	os-path-join,PTH119	os-path-basename,PTH120	os-path-dirname,PTH121	os-path-samefile,PTH122	os-path-splitext,PTH123	builtin-open,PTH124	py-path,PTH201	path-constructor-current-directory,PTH202	os-path-getsize,PTH203	os-path-getatime,PTH204	os-path-getmtime,PTH205	os-path-getctime,PTH206	os-sep-split,PTH207	glob,FLY002	static-join-to-f-string,I001	unsorted-imports,I002	missing-required-import,C901	complex-structure,NPY001	numpy-deprecated-type-alias,NPY002	numpy-legacy-random,NPY003	numpy-deprecated-function,NPY201	numpy2-deprecation,N801	invalid-class-name,N802	invalid-function-name,N803	invalid-argument-name,N804	invalid-first-argument-name-for-class-method,N805	invalid-first-argument-name-for-method,N806	non-lowercase-variable-in-function,N807	dunder-function-name,N811	constant-imported-as-non-constant,N812	lowercase-imported-as-non-lowercase,N813	camelcase-imported-as-lowercase,N814	camelcase-imported-as-constant,N815	mixed-case-variable-in-class-scope,N816	mixed-case-variable-in-global-scope,N817	camelcase-imported-as-acronym,N818	error-suffix-on-exception-name,N999	invalid-module-name,PD002	pandas-use-of-inplace-argument,PD003	pandas-use-of-dot-is-null,PD004	pandas-use-of-dot-not-null,PD007	pandas-use-of-dot-ix,PD008	pandas-use-of-dot-at,PD009	pandas-use-of-dot-iat,PD010	pandas-use-of-dot-pivot-or-unstack,PD011	pandas-use-of-dot-values,PD012	pandas-use-of-dot-read-table,PD013	pandas-use-of-dot-stack,PD015	pandas-use-of-pd-merge,PD101	pandas-nunique-constant-series-check,PD901	pandas-df-variable-name,PERF101	unnecessary-list-cast,PERF102	incorrect-dict-iterator,PERF203	try-except-in-loop,PERF401	manual-list-comprehension,PERF402	manual-list-copy,PERF403	manual-dict-comprehension,E101	mixed-spaces-and-tabs,E111	indentation-with-invalid-multiple,E112	no-indented-block,E113	unexpected-indentation,E114	indentation-with-invalid-multiple-comment,E115	no-indented-block-comment,E116	unexpected-indentation-comment,E117	over-indented,E201	whitespace-after-open-bracket,E202	whitespace-before-close-bracket,E203	whitespace-before-punctuation,E211	whitespace-before-parameters,E221	multiple-spaces-before-operator,E222	multiple-spaces-after-operator,E223	tab-before-operator,E224	tab-after-operator,E225	missing-whitespace-around-operator,E226	missing-whitespace-around-arithmetic-operator,E227	missing-whitespace-around-bitwise-or-shift-operator,E228	missing-whitespace-around-modulo-operator,E231	missing-whitespace,E241	multiple-spaces-after-comma,E242	tab-after-comma,E251	unexpected-spaces-around-keyword-parameter-equals,E252	missing-whitespace-around-parameter-equals,E261	too-few-spaces-before-inline-comment,E262	no-space-after-inline-comment,E265	no-space-after-block-comment,E266	multiple-leading-hashes-for-block-comment,E271	multiple-spaces-after-keyword,E272	multiple-spaces-before-keyword,E273	tab-after-keyword,E274	tab-before-keyword,E275	missing-whitespace-after-keyword,E401	multiple-imports-on-one-line,E402	module-import-not-at-top-of-file,E501	line-too-long,E701	multiple-statements-on-one-line-colon,E702	multiple-statements-on-one-line-semicolon,E703	useless-semicolon,E711	none-comparison,E712	true-false-comparison,E713	not-in-test,E714	not-is-test,E721	type-comparison,E722	bare-except,E731	lambda-assignment,E741	ambiguous-variable-name,E742	ambiguous-class-name,E743	ambiguous-function-name,E902	io-error,E999	syntax-error,W191	tab-indentation,W291	trailing-whitespace,W292	missing-newline-at-end-of-file,W293	blank-line-with-whitespace,W505	doc-line-too-long,W605	invalid-escape-sequence,D100	undocumented-public-module,D101	undocumented-public-class,D102	undocumented-public-method,D103	undocumented-public-function,D104	undocumented-public-package,D105	undocumented-magic-method,D106	undocumented-public-nested-class,D107	undocumented-public-init,D200	fits-on-one-line,D201	no-blank-line-before-function,D202	no-blank-line-after-function,D203	one-blank-line-before-class,D204	one-blank-line-after-class,D205	blank-line-after-summary,D206	indent-with-spaces,D207	under-indentation,D208	over-indentation,D209	new-line-after-last-paragraph,D210	surrounding-whitespace,D211	blank-line-before-class,D212	multi-line-summary-first-line,D213	multi-line-summary-second-line,D214	section-not-over-indented,D215	section-underline-not-over-indented,D300	triple-single-quotes,D301	escape-sequence-in-docstring,D400	ends-in-period,D401	non-imperative-mood,D402	no-signature,D403	first-line-capitalized,D404	docstring-starts-with-this,D405	capitalize-section-name,D406	new-line-after-section-name,D407	dashed-underline-after-section,D408	section-underline-after-name,D409	section-underline-matches-section-length,D410	no-blank-line-after-section,D411	no-blank-line-before-section,D412	blank-lines-between-header-and-content,D413	blank-line-after-last-section,D414	empty-docstring-section,D415	ends-in-punctuation,D416	section-name-ends-in-colon,D417	undocumented-param,D418	overload-with-docstring,D419	empty-docstring,F401	unused-import,F402	import-shadowed-by-loop-var,F403	undefined-local-with-import-star,F404	late-future-import,F405	undefined-local-with-import-star-usage,F406	undefined-local-with-nested-import-star-usage,F407	future-feature-not-defined,F501	percent-format-invalid-format,F502	percent-format-expected-mapping,F503	percent-format-expected-sequence,F504	percent-format-extra-named-arguments,F505	percent-format-missing-argument,F506	percent-format-mixed-positional-and-named,F507	percent-format-positional-count-mismatch,F508	percent-format-star-requires-sequence,F509	percent-format-unsupported-format-character,F521	string-dot-format-invalid-format,F522	string-dot-format-extra-named-arguments,F523	string-dot-format-extra-positional-arguments,F524	string-dot-format-missing-arguments,F525	string-dot-format-mixing-automatic,F541	f-string-missing-placeholders,F601	multi-value-repeated-key-literal,F602	multi-value-repeated-key-variable,F621	expressions-in-star-assignment,F622	multiple-starred-expressions,F631	assert-tuple,F632	is-literal,F633	invalid-print-syntax,F634	if-tuple,F701	break-outside-loop,F702	continue-outside-loop,F704	yield-outside-function,F706	return-outside-function,F707	default-except-not-last,F722	forward-annotation-syntax-error,F811	redefined-while-unused,F821	undefined-name,F822	undefined-export,F823	undefined-local,F841	unused-variable,F842	unused-annotation,F901	raise-not-implemented,PGH001	eval,PGH002	deprecated-log-warn,PGH003	blanket-type-ignore,PGH004	blanket-noqa,PGH005	invalid-mock-access,PLC0105	type-name-incorrect-variance,PLC0131	type-bivariance,PLC0132	type-param-name-mismatch,PLC0205	single-string-slots,PLC0208	iteration-over-set,PLC0414	useless-import-alias,PLC0415	import-outside-top-level,PLC1901	compare-to-empty-string,PLC2401	non-ascii-name,PLC2403	non-ascii-import-name,PLC2701	import-private-name,PLC2801	unnecessary-dunder-call,PLC3002	unnecessary-direct-lambda-call,PLE0100	yield-in-init,PLE0101	return-in-init,PLE0116	continue-in-finally,PLE0117	nonlocal-without-binding,PLE0118	load-before-global-declaration,PLE0241	duplicate-bases,PLE0302	unexpected-special-method-signature,PLE0307	invalid-str-return-type,PLE0604	invalid-all-object,PLE0605	invalid-all-format,PLE0704	misplaced-bare-raise,PLE1132	repeated-keyword-argument,PLE1142	await-outside-async,PLE1205	logging-too-many-args,PLE1206	logging-too-few-args,PLE1300	bad-string-format-character,PLE1307	bad-string-format-type,PLE1310	bad-str-strip-call,PLE1507	invalid-envvar-value,PLE1700	yield-from-in-async-function,PLE2502	bidirectional-unicode,PLE2510	invalid-character-backspace,PLE2512	invalid-character-sub,PLE2513	invalid-character-esc,PLE2514	invalid-character-nul,PLE2515	invalid-character-zero-width-space,PLR0124	comparison-with-itself,PLR0133	comparison-of-constant,PLR0202	no-classmethod-decorator,PLR0203	no-staticmethod-decorator,PLR0206	property-with-parameters,PLR0402	manual-from-import,PLR0904	too-many-public-methods,PLR0911	too-many-return-statements,PLR0912	too-many-branches,PLR0913	too-many-arguments,PLR0914	too-many-locals,PLR0915	too-many-statements,PLR0916	too-many-boolean-expressions,PLR0917	too-many-positional,PLR1701	repeated-isinstance-calls,PLR1704	redefined-argument-from-local,PLR1706	and-or-ternary,PLR1711	useless-return,PLR1714	repeated-equality-comparison,PLR1722	sys-exit-alias,PLR1733	unnecessary-dict-index-lookup,PLR1736	unnecessary-list-index-lookup,PLR2004	magic-value-comparison,PLR2044	empty-comment,PLR5501	collapsible-else-if,PLR6201	literal-membership,PLR6301	no-self-use,PLW0108	unnecessary-lambda,PLW0120	useless-else-on-loop,PLW0127	self-assigning-variable,PLW0129	assert-on-string-literal,PLW0131	named-expr-without-context,PLW0245	super-without-brackets,PLW0406	import-self,PLW0602	global-variable-not-assigned,PLW0603	global-statement,PLW0604	global-at-module-level,PLW0711	binary-op-exception,PLW1501	bad-open-mode,PLW1508	invalid-envvar-default,PLW1509	subprocess-popen-preexec-fn,PLW1510	subprocess-run-without-check,PLW1514	unspecified-encoding,PLW1641	eq-without-hash,PLW2101	useless-with-lock,PLW2901	redefined-loop-name,PLW3201	bad-dunder-method-name,PLW3301	nested-min-max,UP001	useless-metaclass-type,UP003	type-of-primitive,UP004	useless-object-inheritance,UP005	deprecated-unittest-alias,UP006	non-pep585-annotation,UP007	non-pep604-annotation,UP008	super-call-with-parameters,UP009	utf8-encoding-declaration,UP010	unnecessary-future-import,UP011	lru-cache-without-parameters,UP012	unnecessary-encode-utf8,UP013	convert-typed-dict-functional-to-class,UP014	convert-named-tuple-functional-to-class,UP015	redundant-open-modes,UP017	datetime-timezone-utc,UP018	native-literals,UP019	typing-text-str-alias,UP020	open-alias,UP021	replace-universal-newlines,UP022	replace-stdout-stderr,UP023	deprecated-c-element-tree,UP024	os-error-alias,UP025	unicode-kind-prefix,UP026	deprecated-mock-import,UP027	unpacked-list-comprehension,UP028	yield-in-for-loop,UP029	unnecessary-builtin-import,UP030	format-literals,UP031	printf-string-formatting,UP032	f-string,UP033	lru-cache-with-maxsize-none,UP034	extraneous-parentheses,UP035	deprecated-import,UP036	outdated-version-block,UP037	quoted-annotation,UP038	non-pep604-isinstance,UP039	unnecessary-class-parentheses,UP040	non-pep695-type-alias,UP041	timeout-error-alias,FURB101	read-whole-file,FURB105	print-empty-string,FURB113	repeated-append,FURB118	reimplemented-operator,FURB131	delete-full-slice,FURB132	check-and-remove-from-set,FURB136	if-expr-min-max,FURB140	reimplemented-starmap,FURB145	slice-copy,FURB148	unnecessary-enumerate,FURB152	math-constant,FURB161	bit-count,FURB163	redundant-log-base,FURB167	regex-flag-alias,FURB168	isinstance-type-none,FURB169	type-none-comparison,FURB171	single-item-membership-test,FURB177	implicit-cwd,FURB181	hashlib-digest-hex,RUF001	ambiguous-unicode-character-string,RUF002	ambiguous-unicode-character-docstring,RUF003	ambiguous-unicode-character-comment,RUF005	collection-literal-concatenation,RUF006	asyncio-dangling-task,RUF007	pairwise-over-zipped,RUF008	mutable-dataclass-default,RUF009	function-call-in-dataclass-default-argument,RUF010	explicit-f-string-type-conversion,RUF011	static-key-dict-comprehension,RUF012	mutable-class-default,RUF013	implicit-optional,RUF015	unnecessary-iterable-allocation-for-first-element,RUF016	invalid-index-type,RUF017	quadratic-list-summation,RUF018	assignment-in-assert,RUF019	unnecessary-key-check,RUF020	never-union,RUF021	parenthesize-chained-operators,RUF022	unsorted-dunder-all,RUF100	unused-noqa,RUF200	invalid-pyproject-toml,TRY002	raise-vanilla-class,TRY003	raise-vanilla-args,TRY004	type-check-without-type-error,TRY200	reraise-no-cause,TRY201	verbose-raise,TRY300	try-consider-else,TRY301	raise-within-try,TRY302	useless-try-except,TRY400	error-instead-of-exception,TRY401	verbose-log-message}"
complete -c ruff -n "__fish_seen_subcommand_from check" -l ignore -d 'Comma-separated list of rule codes to disable' -r -f -a "{ALL	all rules,F	Pyflakes,C90	mccabe,I	isort,N	pep8-naming,D	pydocstyle,UP	pyupgrade,YTT	flake8-2020,ANN	flake8-annotations,ASYNC	flake8-async,TRIO	flake8-trio,S	flake8-bandit,BLE	flake8-blind-except,FBT	flake8-boolean-trap,B	flake8-bugbear,A	flake8-builtins,COM	flake8-commas,CPY	flake8-copyright,C4	flake8-comprehensions,DTZ	flake8-datetimez,T10	flake8-debugger,DJ	flake8-django,EM	flake8-errmsg,EXE	flake8-executable,FA	flake8-future-annotations,ISC	flake8-implicit-str-concat,ICN	flake8-import-conventions,G	flake8-logging-format,INP	flake8-no-pep420,PIE	flake8-pie,T20	flake8-print,PYI	flake8-pyi,PT	flake8-pytest-style,Q	flake8-quotes,RSE	flake8-raise,RET	flake8-return,SLF	flake8-self,SLOT	flake8-slots,SIM	flake8-simplify,TID	flake8-tidy-imports,TCH	flake8-type-checking,INT	flake8-gettext,ARG	flake8-unused-arguments,PTH	flake8-use-pathlib,TD	flake8-todos,FIX	flake8-fixme,ERA	eradicate,PD	pandas-vet,PGH	pygrep-hooks,PL	Pylint,TRY	tryceratops,FLY	flynt,NPY	NumPy-specific rules,AIR	Airflow,PERF	Perflint,FURB	refurb,LOG	flake8-logging,RUF	Ruff-specific rules,AIR001	airflow-variable-name-task-id-mismatch,ERA001	commented-out-code,YTT101	sys-version-slice3,YTT102	sys-version2,YTT103	sys-version-cmp-str3,YTT201	sys-version-info0-eq3,YTT202	six-py3,YTT203	sys-version-info1-cmp-int,YTT204	sys-version-info-minor-cmp-int,YTT301	sys-version0,YTT302	sys-version-cmp-str10,YTT303	sys-version-slice1,ANN001	missing-type-function-argument,ANN002	missing-type-args,ANN003	missing-type-kwargs,ANN101	missing-type-self,ANN102	missing-type-cls,ANN201	missing-return-type-undocumented-public-function,ANN202	missing-return-type-private-function,ANN204	missing-return-type-special-method,ANN205	missing-return-type-static-method,ANN206	missing-return-type-class-method,ANN401	any-type,ASYNC100	blocking-http-call-in-async-function,ASYNC101	open-sleep-or-subprocess-in-async-function,ASYNC102	blocking-os-call-in-async-function,S101	assert,S102	exec-builtin,S103	bad-file-permissions,S104	hardcoded-bind-all-interfaces,S105	hardcoded-password-string,S106	hardcoded-password-func-arg,S107	hardcoded-password-default,S108	hardcoded-temp-file,S110	try-except-pass,S112	try-except-continue,S113	request-without-timeout,S201	flask-debug-true,S202	tarfile-unsafe-members,S301	suspicious-pickle-usage,S302	suspicious-marshal-usage,S303	suspicious-insecure-hash-usage,S304	suspicious-insecure-cipher-usage,S305	suspicious-insecure-cipher-mode-usage,S306	suspicious-mktemp-usage,S307	suspicious-eval-usage,S308	suspicious-mark-safe-usage,S310	suspicious-url-open-usage,S311	suspicious-non-cryptographic-random-usage,S312	suspicious-telnet-usage,S313	suspicious-xmlc-element-tree-usage,S314	suspicious-xml-element-tree-usage,S315	suspicious-xml-expat-reader-usage,S316	suspicious-xml-expat-builder-usage,S317	suspicious-xml-sax-usage,S318	suspicious-xml-mini-dom-usage,S319	suspicious-xml-pull-dom-usage,S320	suspicious-xmle-tree-usage,S321	suspicious-ftp-lib-usage,S323	suspicious-unverified-context-usage,S324	hashlib-insecure-hash-function,S401	suspicious-telnetlib-import,S402	suspicious-ftplib-import,S403	suspicious-pickle-import,S404	suspicious-subprocess-import,S405	suspicious-xml-etree-import,S406	suspicious-xml-sax-import,S407	suspicious-xml-expat-import,S408	suspicious-xml-minidom-import,S409	suspicious-xml-pulldom-import,S410	suspicious-lxml-import,S411	suspicious-xmlrpc-import,S412	suspicious-httpoxy-import,S413	suspicious-pycrypto-import,S415	suspicious-pyghmi-import,S501	request-with-no-cert-validation,S502	ssl-insecure-version,S503	ssl-with-bad-defaults,S504	ssl-with-no-version,S505	weak-cryptographic-key,S506	unsafe-yaml-load,S507	ssh-no-host-key-verification,S508	snmp-insecure-version,S509	snmp-weak-cryptography,S601	paramiko-call,S602	subprocess-popen-with-shell-equals-true,S603	subprocess-without-shell-equals-true,S604	call-with-shell-equals-true,S605	start-process-with-a-shell,S606	start-process-with-no-shell,S607	start-process-with-partial-path,S608	hardcoded-sql-expression,S609	unix-command-wildcard-injection,S611	django-raw-sql,S612	logging-config-insecure-listen,S701	jinja2-autoescape-false,S702	mako-templates,BLE001	blind-except,FBT001	boolean-type-hint-positional-argument,FBT002	boolean-default-value-positional-argument,FBT003	boolean-positional-value-in-call,B002	unary-prefix-increment-decrement,B003	assignment-to-os-environ,B004	unreliable-callable-check,B005	strip-with-multi-characters,B006	mutable-argument-default,B007	unused-loop-control-variable,B008	function-call-in-default-argument,B009	get-attr-with-constant,B010	set-attr-with-constant,B011	assert-false,B012	jump-statement-in-finally,B013	redundant-tuple-in-exception-handler,B014	duplicate-handler-exception,B015	useless-comparison,B016	raise-literal,B017	assert-raises-exception,B018	useless-expression,B019	cached-instance-method,B020	loop-variable-overrides-iterator,B021	f-string-docstring,B022	useless-contextlib-suppress,B023	function-uses-loop-variable,B024	abstract-base-class-without-abstract-method,B025	duplicate-try-block-exception,B026	star-arg-unpacking-after-keyword-arg,B027	empty-method-without-abstract-decorator,B028	no-explicit-stacklevel,B029	except-with-empty-tuple,B030	except-with-non-exception-classes,B031	reuse-of-groupby-generator,B032	unintentional-type-annotation,B033	duplicate-value,B034	re-sub-positional-args,B904	raise-without-from-inside-except,B905	zip-without-explicit-strict,A001	builtin-variable-shadowing,A002	builtin-argument-shadowing,A003	builtin-attribute-shadowing,COM812	missing-trailing-comma,COM818	trailing-comma-on-bare-tuple,COM819	prohibited-trailing-comma,C400	unnecessary-generator-list,C401	unnecessary-generator-set,C402	unnecessary-generator-dict,C403	unnecessary-list-comprehension-set,C404	unnecessary-list-comprehension-dict,C405	unnecessary-literal-set,C406	unnecessary-literal-dict,C408	unnecessary-collection-call,C409	unnecessary-literal-within-tuple-call,C410	unnecessary-literal-within-list-call,C411	unnecessary-list-call,C413	unnecessary-call-around-sorted,C414	unnecessary-double-cast-or-process,C415	unnecessary-subscript-reversal,C416	unnecessary-comprehension,C417	unnecessary-map,C418	unnecessary-literal-within-dict-call,C419	unnecessary-comprehension-any-all,CPY001	missing-copyright-notice,DTZ001	call-datetime-without-tzinfo,DTZ002	call-datetime-today,DTZ003	call-datetime-utcnow,DTZ004	call-datetime-utcfromtimestamp,DTZ005	call-datetime-now-without-tzinfo,DTZ006	call-datetime-fromtimestamp,DTZ007	call-datetime-strptime-without-zone,DTZ011	call-date-today,DTZ012	call-date-fromtimestamp,T100	debugger,DJ001	django-nullable-model-string-field,DJ003	django-locals-in-render-function,DJ006	django-exclude-with-model-form,DJ007	django-all-with-model-form,DJ008	django-model-without-dunder-str,DJ012	django-unordered-body-content-in-model,DJ013	django-non-leading-receiver-decorator,EM101	raw-string-in-exception,EM102	f-string-in-exception,EM103	dot-format-in-exception,EXE001	shebang-not-executable,EXE002	shebang-missing-executable-file,EXE003	shebang-missing-python,EXE004	shebang-leading-whitespace,EXE005	shebang-not-first-line,FIX001	line-contains-fixme,FIX002	line-contains-todo,FIX003	line-contains-xxx,FIX004	line-contains-hack,FA100	future-rewritable-type-annotation,FA102	future-required-type-annotation,INT001	f-string-in-get-text-func-call,INT002	format-in-get-text-func-call,INT003	printf-in-get-text-func-call,ISC001	single-line-implicit-string-concatenation,ISC002	multi-line-implicit-string-concatenation,ISC003	explicit-string-concatenation,ICN001	unconventional-import-alias,ICN002	banned-import-alias,ICN003	banned-import-from,LOG001	direct-logger-instantiation,LOG002	invalid-get-logger-argument,LOG007	exception-without-exc-info,LOG009	undocumented-warn,G001	logging-string-format,G002	logging-percent-format,G003	logging-string-concat,G004	logging-f-string,G010	logging-warn,G101	logging-extra-attr-clash,G201	logging-exc-info,G202	logging-redundant-exc-info,INP001	implicit-namespace-package,PIE790	unnecessary-placeholder,PIE794	duplicate-class-field-definition,PIE796	non-unique-enums,PIE800	unnecessary-spread,PIE804	unnecessary-dict-kwargs,PIE807	reimplemented-container-builtin,PIE808	unnecessary-range-start,PIE810	multiple-starts-ends-with,T201	print,T203	p-print,PYI001	unprefixed-type-param,PYI002	complex-if-statement-in-stub,PYI003	unrecognized-version-info-check,PYI004	patch-version-comparison,PYI005	wrong-tuple-length-version-comparison,PYI006	bad-version-info-comparison,PYI007	unrecognized-platform-check,PYI008	unrecognized-platform-name,PYI009	pass-statement-stub-body,PYI010	non-empty-stub-body,PYI011	typed-argument-default-in-stub,PYI012	pass-in-class-body,PYI013	ellipsis-in-non-empty-class-body,PYI014	argument-default-in-stub,PYI015	assignment-default-in-stub,PYI016	duplicate-union-member,PYI017	complex-assignment-in-stub,PYI018	unused-private-type-var,PYI019	custom-type-var-return-type,PYI020	quoted-annotation-in-stub,PYI021	docstring-in-stub,PYI024	collections-named-tuple,PYI025	unaliased-collections-abc-set-import,PYI026	type-alias-without-annotation,PYI029	str-or-repr-defined-in-stub,PYI030	unnecessary-literal-union,PYI032	any-eq-ne-annotation,PYI033	type-comment-in-stub,PYI034	non-self-return-type,PYI035	unassigned-special-variable-in-stub,PYI036	bad-exit-annotation,PYI041	redundant-numeric-union,PYI042	snake-case-type-alias,PYI043	t-suffixed-type-alias,PYI044	future-annotations-in-stub,PYI045	iter-method-return-iterable,PYI046	unused-private-protocol,PYI047	unused-private-type-alias,PYI048	stub-body-multiple-statements,PYI049	unused-private-typed-dict,PYI050	no-return-argument-annotation-in-stub,PYI051	redundant-literal-union,PYI052	unannotated-assignment-in-stub,PYI053	string-or-bytes-too-long,PYI054	numeric-literal-too-long,PYI055	unnecessary-type-union,PYI056	unsupported-method-call-on-all,PYI058	generator-return-from-iter-method,PT001	pytest-fixture-incorrect-parentheses-style,PT002	pytest-fixture-positional-args,PT003	pytest-extraneous-scope-function,PT004	pytest-missing-fixture-name-underscore,PT005	pytest-incorrect-fixture-name-underscore,PT006	pytest-parametrize-names-wrong-type,PT007	pytest-parametrize-values-wrong-type,PT008	pytest-patch-with-lambda,PT009	pytest-unittest-assertion,PT010	pytest-raises-without-exception,PT011	pytest-raises-too-broad,PT012	pytest-raises-with-multiple-statements,PT013	pytest-incorrect-pytest-import,PT014	pytest-duplicate-parametrize-test-cases,PT015	pytest-assert-always-false,PT016	pytest-fail-without-message,PT017	pytest-assert-in-except,PT018	pytest-composite-assertion,PT019	pytest-fixture-param-without-value,PT020	pytest-deprecated-yield-fixture,PT021	pytest-fixture-finalizer-callback,PT022	pytest-useless-yield-fixture,PT023	pytest-incorrect-mark-parentheses-style,PT024	pytest-unnecessary-asyncio-mark-on-fixture,PT025	pytest-erroneous-use-fixtures-on-fixture,PT026	pytest-use-fixtures-without-parameters,PT027	pytest-unittest-raises-assertion,Q000	bad-quotes-inline-string,Q001	bad-quotes-multiline-string,Q002	bad-quotes-docstring,Q003	avoidable-escaped-quote,Q004	unnecessary-escaped-quote,RSE102	unnecessary-paren-on-raise-exception,RET501	unnecessary-return-none,RET502	implicit-return-value,RET503	implicit-return,RET504	unnecessary-assign,RET505	superfluous-else-return,RET506	superfluous-else-raise,RET507	superfluous-else-continue,RET508	superfluous-else-break,SLF001	private-member-access,SIM101	duplicate-isinstance-call,SIM102	collapsible-if,SIM103	needless-bool,SIM105	suppressible-exception,SIM107	return-in-try-except-finally,SIM108	if-else-block-instead-of-if-exp,SIM109	compare-with-tuple,SIM110	reimplemented-builtin,SIM112	uncapitalized-environment-variables,SIM113	enumerate-for-loop,SIM114	if-with-same-arms,SIM115	open-file-with-context-handler,SIM116	if-else-block-instead-of-dict-lookup,SIM117	multiple-with-statements,SIM118	in-dict-keys,SIM201	negate-equal-op,SIM202	negate-not-equal-op,SIM208	double-negation,SIM210	if-expr-with-true-false,SIM211	if-expr-with-false-true,SIM212	if-expr-with-twisted-arms,SIM220	expr-and-not-expr,SIM221	expr-or-not-expr,SIM222	expr-or-true,SIM223	expr-and-false,SIM300	yoda-conditions,SIM401	if-else-block-instead-of-dict-get,SIM910	dict-get-with-none-default,SIM911	zip-dict-keys-and-values,SLOT000	no-slots-in-str-subclass,SLOT001	no-slots-in-tuple-subclass,SLOT002	no-slots-in-namedtuple-subclass,TID251	banned-api,TID252	relative-imports,TID253	banned-module-level-imports,TD001	invalid-todo-tag,TD002	missing-todo-author,TD003	missing-todo-link,TD004	missing-todo-colon,TD005	missing-todo-description,TD006	invalid-todo-capitalization,TD007	missing-space-after-todo-colon,TRIO100	trio-timeout-without-await,TRIO105	trio-sync-call,TRIO109	trio-async-function-with-timeout,TRIO110	trio-unneeded-sleep,TRIO115	trio-zero-sleep-call,TCH001	typing-only-first-party-import,TCH002	typing-only-third-party-import,TCH003	typing-only-standard-library-import,TCH004	runtime-import-in-type-checking-block,TCH005	empty-type-checking-block,TCH006	runtime-string-union,ARG001	unused-function-argument,ARG002	unused-method-argument,ARG003	unused-class-method-argument,ARG004	unused-static-method-argument,ARG005	unused-lambda-argument,PTH100	os-path-abspath,PTH101	os-chmod,PTH102	os-mkdir,PTH103	os-makedirs,PTH104	os-rename,PTH105	os-replace,PTH106	os-rmdir,PTH107	os-remove,PTH108	os-unlink,PTH109	os-getcwd,PTH110	os-path-exists,PTH111	os-path-expanduser,PTH112	os-path-isdir,PTH113	os-path-isfile,PTH114	os-path-islink,PTH115	os-readlink,PTH116	os-stat,PTH117	os-path-isabs,PTH118	os-path-join,PTH119	os-path-basename,PTH120	os-path-dirname,PTH121	os-path-samefile,PTH122	os-path-splitext,PTH123	builtin-open,PTH124	py-path,PTH201	path-constructor-current-directory,PTH202	os-path-getsize,PTH203	os-path-getatime,PTH204	os-path-getmtime,PTH205	os-path-getctime,PTH206	os-sep-split,PTH207	glob,FLY002	static-join-to-f-string,I001	unsorted-imports,I002	missing-required-import,C901	complex-structure,NPY001	numpy-deprecated-type-alias,NPY002	numpy-legacy-random,NPY003	numpy-deprecated-function,NPY201	numpy2-deprecation,N801	invalid-class-name,N802	invalid-function-name,N803	invalid-argument-name,N804	invalid-first-argument-name-for-class-method,N805	invalid-first-argument-name-for-method,N806	non-lowercase-variable-in-function,N807	dunder-function-name,N811	constant-imported-as-non-constant,N812	lowercase-imported-as-non-lowercase,N813	camelcase-imported-as-lowercase,N814	camelcase-imported-as-constant,N815	mixed-case-variable-in-class-scope,N816	mixed-case-variable-in-global-scope,N817	camelcase-imported-as-acronym,N818	error-suffix-on-exception-name,N999	invalid-module-name,PD002	pandas-use-of-inplace-argument,PD003	pandas-use-of-dot-is-null,PD004	pandas-use-of-dot-not-null,PD007	pandas-use-of-dot-ix,PD008	pandas-use-of-dot-at,PD009	pandas-use-of-dot-iat,PD010	pandas-use-of-dot-pivot-or-unstack,PD011	pandas-use-of-dot-values,PD012	pandas-use-of-dot-read-table,PD013	pandas-use-of-dot-stack,PD015	pandas-use-of-pd-merge,PD101	pandas-nunique-constant-series-check,PD901	pandas-df-variable-name,PERF101	unnecessary-list-cast,PERF102	incorrect-dict-iterator,PERF203	try-except-in-loop,PERF401	manual-list-comprehension,PERF402	manual-list-copy,PERF403	manual-dict-comprehension,E101	mixed-spaces-and-tabs,E111	indentation-with-invalid-multiple,E112	no-indented-block,E113	unexpected-indentation,E114	indentation-with-invalid-multiple-comment,E115	no-indented-block-comment,E116	unexpected-indentation-comment,E117	over-indented,E201	whitespace-after-open-bracket,E202	whitespace-before-close-bracket,E203	whitespace-before-punctuation,E211	whitespace-before-parameters,E221	multiple-spaces-before-operator,E222	multiple-spaces-after-operator,E223	tab-before-operator,E224	tab-after-operator,E225	missing-whitespace-around-operator,E226	missing-whitespace-around-arithmetic-operator,E227	missing-whitespace-around-bitwise-or-shift-operator,E228	missing-whitespace-around-modulo-operator,E231	missing-whitespace,E241	multiple-spaces-after-comma,E242	tab-after-comma,E251	unexpected-spaces-around-keyword-parameter-equals,E252	missing-whitespace-around-parameter-equals,E261	too-few-spaces-before-inline-comment,E262	no-space-after-inline-comment,E265	no-space-after-block-comment,E266	multiple-leading-hashes-for-block-comment,E271	multiple-spaces-after-keyword,E272	multiple-spaces-before-keyword,E273	tab-after-keyword,E274	tab-before-keyword,E275	missing-whitespace-after-keyword,E401	multiple-imports-on-one-line,E402	module-import-not-at-top-of-file,E501	line-too-long,E701	multiple-statements-on-one-line-colon,E702	multiple-statements-on-one-line-semicolon,E703	useless-semicolon,E711	none-comparison,E712	true-false-comparison,E713	not-in-test,E714	not-is-test,E721	type-comparison,E722	bare-except,E731	lambda-assignment,E741	ambiguous-variable-name,E742	ambiguous-class-name,E743	ambiguous-function-name,E902	io-error,E999	syntax-error,W191	tab-indentation,W291	trailing-whitespace,W292	missing-newline-at-end-of-file,W293	blank-line-with-whitespace,W505	doc-line-too-long,W605	invalid-escape-sequence,D100	undocumented-public-module,D101	undocumented-public-class,D102	undocumented-public-method,D103	undocumented-public-function,D104	undocumented-public-package,D105	undocumented-magic-method,D106	undocumented-public-nested-class,D107	undocumented-public-init,D200	fits-on-one-line,D201	no-blank-line-before-function,D202	no-blank-line-after-function,D203	one-blank-line-before-class,D204	one-blank-line-after-class,D205	blank-line-after-summary,D206	indent-with-spaces,D207	under-indentation,D208	over-indentation,D209	new-line-after-last-paragraph,D210	surrounding-whitespace,D211	blank-line-before-class,D212	multi-line-summary-first-line,D213	multi-line-summary-second-line,D214	section-not-over-indented,D215	section-underline-not-over-indented,D300	triple-single-quotes,D301	escape-sequence-in-docstring,D400	ends-in-period,D401	non-imperative-mood,D402	no-signature,D403	first-line-capitalized,D404	docstring-starts-with-this,D405	capitalize-section-name,D406	new-line-after-section-name,D407	dashed-underline-after-section,D408	section-underline-after-name,D409	section-underline-matches-section-length,D410	no-blank-line-after-section,D411	no-blank-line-before-section,D412	blank-lines-between-header-and-content,D413	blank-line-after-last-section,D414	empty-docstring-section,D415	ends-in-punctuation,D416	section-name-ends-in-colon,D417	undocumented-param,D418	overload-with-docstring,D419	empty-docstring,F401	unused-import,F402	import-shadowed-by-loop-var,F403	undefined-local-with-import-star,F404	late-future-import,F405	undefined-local-with-import-star-usage,F406	undefined-local-with-nested-import-star-usage,F407	future-feature-not-defined,F501	percent-format-invalid-format,F502	percent-format-expected-mapping,F503	percent-format-expected-sequence,F504	percent-format-extra-named-arguments,F505	percent-format-missing-argument,F506	percent-format-mixed-positional-and-named,F507	percent-format-positional-count-mismatch,F508	percent-format-star-requires-sequence,F509	percent-format-unsupported-format-character,F521	string-dot-format-invalid-format,F522	string-dot-format-extra-named-arguments,F523	string-dot-format-extra-positional-arguments,F524	string-dot-format-missing-arguments,F525	string-dot-format-mixing-automatic,F541	f-string-missing-placeholders,F601	multi-value-repeated-key-literal,F602	multi-value-repeated-key-variable,F621	expressions-in-star-assignment,F622	multiple-starred-expressions,F631	assert-tuple,F632	is-literal,F633	invalid-print-syntax,F634	if-tuple,F701	break-outside-loop,F702	continue-outside-loop,F704	yield-outside-function,F706	return-outside-function,F707	default-except-not-last,F722	forward-annotation-syntax-error,F811	redefined-while-unused,F821	undefined-name,F822	undefined-export,F823	undefined-local,F841	unused-variable,F842	unused-annotation,F901	raise-not-implemented,PGH001	eval,PGH002	deprecated-log-warn,PGH003	blanket-type-ignore,PGH004	blanket-noqa,PGH005	invalid-mock-access,PLC0105	type-name-incorrect-variance,PLC0131	type-bivariance,PLC0132	type-param-name-mismatch,PLC0205	single-string-slots,PLC0208	iteration-over-set,PLC0414	useless-import-alias,PLC0415	import-outside-top-level,PLC1901	compare-to-empty-string,PLC2401	non-ascii-name,PLC2403	non-ascii-import-name,PLC2701	import-private-name,PLC2801	unnecessary-dunder-call,PLC3002	unnecessary-direct-lambda-call,PLE0100	yield-in-init,PLE0101	return-in-init,PLE0116	continue-in-finally,PLE0117	nonlocal-without-binding,PLE0118	load-before-global-declaration,PLE0241	duplicate-bases,PLE0302	unexpected-special-method-signature,PLE0307	invalid-str-return-type,PLE0604	invalid-all-object,PLE0605	invalid-all-format,PLE0704	misplaced-bare-raise,PLE1132	repeated-keyword-argument,PLE1142	await-outside-async,PLE1205	logging-too-many-args,PLE1206	logging-too-few-args,PLE1300	bad-string-format-character,PLE1307	bad-string-format-type,PLE1310	bad-str-strip-call,PLE1507	invalid-envvar-value,PLE1700	yield-from-in-async-function,PLE2502	bidirectional-unicode,PLE2510	invalid-character-backspace,PLE2512	invalid-character-sub,PLE2513	invalid-character-esc,PLE2514	invalid-character-nul,PLE2515	invalid-character-zero-width-space,PLR0124	comparison-with-itself,PLR0133	comparison-of-constant,PLR0202	no-classmethod-decorator,PLR0203	no-staticmethod-decorator,PLR0206	property-with-parameters,PLR0402	manual-from-import,PLR0904	too-many-public-methods,PLR0911	too-many-return-statements,PLR0912	too-many-branches,PLR0913	too-many-arguments,PLR0914	too-many-locals,PLR0915	too-many-statements,PLR0916	too-many-boolean-expressions,PLR0917	too-many-positional,PLR1701	repeated-isinstance-calls,PLR1704	redefined-argument-from-local,PLR1706	and-or-ternary,PLR1711	useless-return,PLR1714	repeated-equality-comparison,PLR1722	sys-exit-alias,PLR1733	unnecessary-dict-index-lookup,PLR1736	unnecessary-list-index-lookup,PLR2004	magic-value-comparison,PLR2044	empty-comment,PLR5501	collapsible-else-if,PLR6201	literal-membership,PLR6301	no-self-use,PLW0108	unnecessary-lambda,PLW0120	useless-else-on-loop,PLW0127	self-assigning-variable,PLW0129	assert-on-string-literal,PLW0131	named-expr-without-context,PLW0245	super-without-brackets,PLW0406	import-self,PLW0602	global-variable-not-assigned,PLW0603	global-statement,PLW0604	global-at-module-level,PLW0711	binary-op-exception,PLW1501	bad-open-mode,PLW1508	invalid-envvar-default,PLW1509	subprocess-popen-preexec-fn,PLW1510	subprocess-run-without-check,PLW1514	unspecified-encoding,PLW1641	eq-without-hash,PLW2101	useless-with-lock,PLW2901	redefined-loop-name,PLW3201	bad-dunder-method-name,PLW3301	nested-min-max,UP001	useless-metaclass-type,UP003	type-of-primitive,UP004	useless-object-inheritance,UP005	deprecated-unittest-alias,UP006	non-pep585-annotation,UP007	non-pep604-annotation,UP008	super-call-with-parameters,UP009	utf8-encoding-declaration,UP010	unnecessary-future-import,UP011	lru-cache-without-parameters,UP012	unnecessary-encode-utf8,UP013	convert-typed-dict-functional-to-class,UP014	convert-named-tuple-functional-to-class,UP015	redundant-open-modes,UP017	datetime-timezone-utc,UP018	native-literals,UP019	typing-text-str-alias,UP020	open-alias,UP021	replace-universal-newlines,UP022	replace-stdout-stderr,UP023	deprecated-c-element-tree,UP024	os-error-alias,UP025	unicode-kind-prefix,UP026	deprecated-mock-import,UP027	unpacked-list-comprehension,UP028	yield-in-for-loop,UP029	unnecessary-builtin-import,UP030	format-literals,UP031	printf-string-formatting,UP032	f-string,UP033	lru-cache-with-maxsize-none,UP034	extraneous-parentheses,UP035	deprecated-import,UP036	outdated-version-block,UP037	quoted-annotation,UP038	non-pep604-isinstance,UP039	unnecessary-class-parentheses,UP040	non-pep695-type-alias,UP041	timeout-error-alias,FURB101	read-whole-file,FURB105	print-empty-string,FURB113	repeated-append,FURB118	reimplemented-operator,FURB131	delete-full-slice,FURB132	check-and-remove-from-set,FURB136	if-expr-min-max,FURB140	reimplemented-starmap,FURB145	slice-copy,FURB148	unnecessary-enumerate,FURB152	math-constant,FURB161	bit-count,FURB163	redundant-log-base,FURB167	regex-flag-alias,FURB168	isinstance-type-none,FURB169	type-none-comparison,FURB171	single-item-membership-test,FURB177	implicit-cwd,FURB181	hashlib-digest-hex,RUF001	ambiguous-unicode-character-string,RUF002	ambiguous-unicode-character-docstring,RUF003	ambiguous-unicode-character-comment,RUF005	collection-literal-concatenation,RUF006	asyncio-dangling-task,RUF007	pairwise-over-zipped,RUF008	mutable-dataclass-default,RUF009	function-call-in-dataclass-default-argument,RUF010	explicit-f-string-type-conversion,RUF011	static-key-dict-comprehension,RUF012	mutable-class-default,RUF013	implicit-optional,RUF015	unnecessary-iterable-allocation-for-first-element,RUF016	invalid-index-type,RUF017	quadratic-list-summation,RUF018	assignment-in-assert,RUF019	unnecessary-key-check,RUF020	never-union,RUF021	parenthesize-chained-operators,RUF022	unsorted-dunder-all,RUF100	unused-noqa,RUF200	invalid-pyproject-toml,TRY002	raise-vanilla-class,TRY003	raise-vanilla-args,TRY004	type-check-without-type-error,TRY200	reraise-no-cause,TRY201	verbose-raise,TRY300	try-consider-else,TRY301	raise-within-try,TRY302	useless-try-except,TRY400	error-instead-of-exception,TRY401	verbose-log-message}"
complete -c ruff -n "__fish_seen_subcommand_from check" -l extend-select -d 'Like --select, but adds additional rule codes on top of those already specified' -r -f -a "{ALL	all rules,F	Pyflakes,C90	mccabe,I	isort,N	pep8-naming,D	pydocstyle,UP	pyupgrade,YTT	flake8-2020,ANN	flake8-annotations,ASYNC	flake8-async,TRIO	flake8-trio,S	flake8-bandit,BLE	flake8-blind-except,FBT	flake8-boolean-trap,B	flake8-bugbear,A	flake8-builtins,COM	flake8-commas,CPY	flake8-copyright,C4	flake8-comprehensions,DTZ	flake8-datetimez,T10	flake8-debugger,DJ	flake8-django,EM	flake8-errmsg,EXE	flake8-executable,FA	flake8-future-annotations,ISC	flake8-implicit-str-concat,ICN	flake8-import-conventions,G	flake8-logging-format,INP	flake8-no-pep420,PIE	flake8-pie,T20	flake8-print,PYI	flake8-pyi,PT	flake8-pytest-style,Q	flake8-quotes,RSE	flake8-raise,RET	flake8-return,SLF	flake8-self,SLOT	flake8-slots,SIM	flake8-simplify,TID	flake8-tidy-imports,TCH	flake8-type-checking,INT	flake8-gettext,ARG	flake8-unused-arguments,PTH	flake8-use-pathlib,TD	flake8-todos,FIX	flake8-fixme,ERA	eradicate,PD	pandas-vet,PGH	pygrep-hooks,PL	Pylint,TRY	tryceratops,FLY	flynt,NPY	NumPy-specific rules,AIR	Airflow,PERF	Perflint,FURB	refurb,LOG	flake8-logging,RUF	Ruff-specific rules,AIR001	airflow-variable-name-task-id-mismatch,ERA001	commented-out-code,YTT101	sys-version-slice3,YTT102	sys-version2,YTT103	sys-version-cmp-str3,YTT201	sys-version-info0-eq3,YTT202	six-py3,YTT203	sys-version-info1-cmp-int,YTT204	sys-version-info-minor-cmp-int,YTT301	sys-version0,YTT302	sys-version-cmp-str10,YTT303	sys-version-slice1,ANN001	missing-type-function-argument,ANN002	missing-type-args,ANN003	missing-type-kwargs,ANN101	missing-type-self,ANN102	missing-type-cls,ANN201	missing-return-type-undocumented-public-function,ANN202	missing-return-type-private-function,ANN204	missing-return-type-special-method,ANN205	missing-return-type-static-method,ANN206	missing-return-type-class-method,ANN401	any-type,ASYNC100	blocking-http-call-in-async-function,ASYNC101	open-sleep-or-subprocess-in-async-function,ASYNC102	blocking-os-call-in-async-function,S101	assert,S102	exec-builtin,S103	bad-file-permissions,S104	hardcoded-bind-all-interfaces,S105	hardcoded-password-string,S106	hardcoded-password-func-arg,S107	hardcoded-password-default,S108	hardcoded-temp-file,S110	try-except-pass,S112	try-except-continue,S113	request-without-timeout,S201	flask-debug-true,S202	tarfile-unsafe-members,S301	suspicious-pickle-usage,S302	suspicious-marshal-usage,S303	suspicious-insecure-hash-usage,S304	suspicious-insecure-cipher-usage,S305	suspicious-insecure-cipher-mode-usage,S306	suspicious-mktemp-usage,S307	suspicious-eval-usage,S308	suspicious-mark-safe-usage,S310	suspicious-url-open-usage,S311	suspicious-non-cryptographic-random-usage,S312	suspicious-telnet-usage,S313	suspicious-xmlc-element-tree-usage,S314	suspicious-xml-element-tree-usage,S315	suspicious-xml-expat-reader-usage,S316	suspicious-xml-expat-builder-usage,S317	suspicious-xml-sax-usage,S318	suspicious-xml-mini-dom-usage,S319	suspicious-xml-pull-dom-usage,S320	suspicious-xmle-tree-usage,S321	suspicious-ftp-lib-usage,S323	suspicious-unverified-context-usage,S324	hashlib-insecure-hash-function,S401	suspicious-telnetlib-import,S402	suspicious-ftplib-import,S403	suspicious-pickle-import,S404	suspicious-subprocess-import,S405	suspicious-xml-etree-import,S406	suspicious-xml-sax-import,S407	suspicious-xml-expat-import,S408	suspicious-xml-minidom-import,S409	suspicious-xml-pulldom-import,S410	suspicious-lxml-import,S411	suspicious-xmlrpc-import,S412	suspicious-httpoxy-import,S413	suspicious-pycrypto-import,S415	suspicious-pyghmi-import,S501	request-with-no-cert-validation,S502	ssl-insecure-version,S503	ssl-with-bad-defaults,S504	ssl-with-no-version,S505	weak-cryptographic-key,S506	unsafe-yaml-load,S507	ssh-no-host-key-verification,S508	snmp-insecure-version,S509	snmp-weak-cryptography,S601	paramiko-call,S602	subprocess-popen-with-shell-equals-true,S603	subprocess-without-shell-equals-true,S604	call-with-shell-equals-true,S605	start-process-with-a-shell,S606	start-process-with-no-shell,S607	start-process-with-partial-path,S608	hardcoded-sql-expression,S609	unix-command-wildcard-injection,S611	django-raw-sql,S612	logging-config-insecure-listen,S701	jinja2-autoescape-false,S702	mako-templates,BLE001	blind-except,FBT001	boolean-type-hint-positional-argument,FBT002	boolean-default-value-positional-argument,FBT003	boolean-positional-value-in-call,B002	unary-prefix-increment-decrement,B003	assignment-to-os-environ,B004	unreliable-callable-check,B005	strip-with-multi-characters,B006	mutable-argument-default,B007	unused-loop-control-variable,B008	function-call-in-default-argument,B009	get-attr-with-constant,B010	set-attr-with-constant,B011	assert-false,B012	jump-statement-in-finally,B013	redundant-tuple-in-exception-handler,B014	duplicate-handler-exception,B015	useless-comparison,B016	raise-literal,B017	assert-raises-exception,B018	useless-expression,B019	cached-instance-method,B020	loop-variable-overrides-iterator,B021	f-string-docstring,B022	useless-contextlib-suppress,B023	function-uses-loop-variable,B024	abstract-base-class-without-abstract-method,B025	duplicate-try-block-exception,B026	star-arg-unpacking-after-keyword-arg,B027	empty-method-without-abstract-decorator,B028	no-explicit-stacklevel,B029	except-with-empty-tuple,B030	except-with-non-exception-classes,B031	reuse-of-groupby-generator,B032	unintentional-type-annotation,B033	duplicate-value,B034	re-sub-positional-args,B904	raise-without-from-inside-except,B905	zip-without-explicit-strict,A001	builtin-variable-shadowing,A002	builtin-argument-shadowing,A003	builtin-attribute-shadowing,COM812	missing-trailing-comma,COM818	trailing-comma-on-bare-tuple,COM819	prohibited-trailing-comma,C400	unnecessary-generator-list,C401	unnecessary-generator-set,C402	unnecessary-generator-dict,C403	unnecessary-list-comprehension-set,C404	unnecessary-list-comprehension-dict,C405	unnecessary-literal-set,C406	unnecessary-literal-dict,C408	unnecessary-collection-call,C409	unnecessary-literal-within-tuple-call,C410	unnecessary-literal-within-list-call,C411	unnecessary-list-call,C413	unnecessary-call-around-sorted,C414	unnecessary-double-cast-or-process,C415	unnecessary-subscript-reversal,C416	unnecessary-comprehension,C417	unnecessary-map,C418	unnecessary-literal-within-dict-call,C419	unnecessary-comprehension-any-all,CPY001	missing-copyright-notice,DTZ001	call-datetime-without-tzinfo,DTZ002	call-datetime-today,DTZ003	call-datetime-utcnow,DTZ004	call-datetime-utcfromtimestamp,DTZ005	call-datetime-now-without-tzinfo,DTZ006	call-datetime-fromtimestamp,DTZ007	call-datetime-strptime-without-zone,DTZ011	call-date-today,DTZ012	call-date-fromtimestamp,T100	debugger,DJ001	django-nullable-model-string-field,DJ003	django-locals-in-render-function,DJ006	django-exclude-with-model-form,DJ007	django-all-with-model-form,DJ008	django-model-without-dunder-str,DJ012	django-unordered-body-content-in-model,DJ013	django-non-leading-receiver-decorator,EM101	raw-string-in-exception,EM102	f-string-in-exception,EM103	dot-format-in-exception,EXE001	shebang-not-executable,EXE002	shebang-missing-executable-file,EXE003	shebang-missing-python,EXE004	shebang-leading-whitespace,EXE005	shebang-not-first-line,FIX001	line-contains-fixme,FIX002	line-contains-todo,FIX003	line-contains-xxx,FIX004	line-contains-hack,FA100	future-rewritable-type-annotation,FA102	future-required-type-annotation,INT001	f-string-in-get-text-func-call,INT002	format-in-get-text-func-call,INT003	printf-in-get-text-func-call,ISC001	single-line-implicit-string-concatenation,ISC002	multi-line-implicit-string-concatenation,ISC003	explicit-string-concatenation,ICN001	unconventional-import-alias,ICN002	banned-import-alias,ICN003	banned-import-from,LOG001	direct-logger-instantiation,LOG002	invalid-get-logger-argument,LOG007	exception-without-exc-info,LOG009	undocumented-warn,G001	logging-string-format,G002	logging-percent-format,G003	logging-string-concat,G004	logging-f-string,G010	logging-warn,G101	logging-extra-attr-clash,G201	logging-exc-info,G202	logging-redundant-exc-info,INP001	implicit-namespace-package,PIE790	unnecessary-placeholder,PIE794	duplicate-class-field-definition,PIE796	non-unique-enums,PIE800	unnecessary-spread,PIE804	unnecessary-dict-kwargs,PIE807	reimplemented-container-builtin,PIE808	unnecessary-range-start,PIE810	multiple-starts-ends-with,T201	print,T203	p-print,PYI001	unprefixed-type-param,PYI002	complex-if-statement-in-stub,PYI003	unrecognized-version-info-check,PYI004	patch-version-comparison,PYI005	wrong-tuple-length-version-comparison,PYI006	bad-version-info-comparison,PYI007	unrecognized-platform-check,PYI008	unrecognized-platform-name,PYI009	pass-statement-stub-body,PYI010	non-empty-stub-body,PYI011	typed-argument-default-in-stub,PYI012	pass-in-class-body,PYI013	ellipsis-in-non-empty-class-body,PYI014	argument-default-in-stub,PYI015	assignment-default-in-stub,PYI016	duplicate-union-member,PYI017	complex-assignment-in-stub,PYI018	unused-private-type-var,PYI019	custom-type-var-return-type,PYI020	quoted-annotation-in-stub,PYI021	docstring-in-stub,PYI024	collections-named-tuple,PYI025	unaliased-collections-abc-set-import,PYI026	type-alias-without-annotation,PYI029	str-or-repr-defined-in-stub,PYI030	unnecessary-literal-union,PYI032	any-eq-ne-annotation,PYI033	type-comment-in-stub,PYI034	non-self-return-type,PYI035	unassigned-special-variable-in-stub,PYI036	bad-exit-annotation,PYI041	redundant-numeric-union,PYI042	snake-case-type-alias,PYI043	t-suffixed-type-alias,PYI044	future-annotations-in-stub,PYI045	iter-method-return-iterable,PYI046	unused-private-protocol,PYI047	unused-private-type-alias,PYI048	stub-body-multiple-statements,PYI049	unused-private-typed-dict,PYI050	no-return-argument-annotation-in-stub,PYI051	redundant-literal-union,PYI052	unannotated-assignment-in-stub,PYI053	string-or-bytes-too-long,PYI054	numeric-literal-too-long,PYI055	unnecessary-type-union,PYI056	unsupported-method-call-on-all,PYI058	generator-return-from-iter-method,PT001	pytest-fixture-incorrect-parentheses-style,PT002	pytest-fixture-positional-args,PT003	pytest-extraneous-scope-function,PT004	pytest-missing-fixture-name-underscore,PT005	pytest-incorrect-fixture-name-underscore,PT006	pytest-parametrize-names-wrong-type,PT007	pytest-parametrize-values-wrong-type,PT008	pytest-patch-with-lambda,PT009	pytest-unittest-assertion,PT010	pytest-raises-without-exception,PT011	pytest-raises-too-broad,PT012	pytest-raises-with-multiple-statements,PT013	pytest-incorrect-pytest-import,PT014	pytest-duplicate-parametrize-test-cases,PT015	pytest-assert-always-false,PT016	pytest-fail-without-message,PT017	pytest-assert-in-except,PT018	pytest-composite-assertion,PT019	pytest-fixture-param-without-value,PT020	pytest-deprecated-yield-fixture,PT021	pytest-fixture-finalizer-callback,PT022	pytest-useless-yield-fixture,PT023	pytest-incorrect-mark-parentheses-style,PT024	pytest-unnecessary-asyncio-mark-on-fixture,PT025	pytest-erroneous-use-fixtures-on-fixture,PT026	pytest-use-fixtures-without-parameters,PT027	pytest-unittest-raises-assertion,Q000	bad-quotes-inline-string,Q001	bad-quotes-multiline-string,Q002	bad-quotes-docstring,Q003	avoidable-escaped-quote,Q004	unnecessary-escaped-quote,RSE102	unnecessary-paren-on-raise-exception,RET501	unnecessary-return-none,RET502	implicit-return-value,RET503	implicit-return,RET504	unnecessary-assign,RET505	superfluous-else-return,RET506	superfluous-else-raise,RET507	superfluous-else-continue,RET508	superfluous-else-break,SLF001	private-member-access,SIM101	duplicate-isinstance-call,SIM102	collapsible-if,SIM103	needless-bool,SIM105	suppressible-exception,SIM107	return-in-try-except-finally,SIM108	if-else-block-instead-of-if-exp,SIM109	compare-with-tuple,SIM110	reimplemented-builtin,SIM112	uncapitalized-environment-variables,SIM113	enumerate-for-loop,SIM114	if-with-same-arms,SIM115	open-file-with-context-handler,SIM116	if-else-block-instead-of-dict-lookup,SIM117	multiple-with-statements,SIM118	in-dict-keys,SIM201	negate-equal-op,SIM202	negate-not-equal-op,SIM208	double-negation,SIM210	if-expr-with-true-false,SIM211	if-expr-with-false-true,SIM212	if-expr-with-twisted-arms,SIM220	expr-and-not-expr,SIM221	expr-or-not-expr,SIM222	expr-or-true,SIM223	expr-and-false,SIM300	yoda-conditions,SIM401	if-else-block-instead-of-dict-get,SIM910	dict-get-with-none-default,SIM911	zip-dict-keys-and-values,SLOT000	no-slots-in-str-subclass,SLOT001	no-slots-in-tuple-subclass,SLOT002	no-slots-in-namedtuple-subclass,TID251	banned-api,TID252	relative-imports,TID253	banned-module-level-imports,TD001	invalid-todo-tag,TD002	missing-todo-author,TD003	missing-todo-link,TD004	missing-todo-colon,TD005	missing-todo-description,TD006	invalid-todo-capitalization,TD007	missing-space-after-todo-colon,TRIO100	trio-timeout-without-await,TRIO105	trio-sync-call,TRIO109	trio-async-function-with-timeout,TRIO110	trio-unneeded-sleep,TRIO115	trio-zero-sleep-call,TCH001	typing-only-first-party-import,TCH002	typing-only-third-party-import,TCH003	typing-only-standard-library-import,TCH004	runtime-import-in-type-checking-block,TCH005	empty-type-checking-block,TCH006	runtime-string-union,ARG001	unused-function-argument,ARG002	unused-method-argument,ARG003	unused-class-method-argument,ARG004	unused-static-method-argument,ARG005	unused-lambda-argument,PTH100	os-path-abspath,PTH101	os-chmod,PTH102	os-mkdir,PTH103	os-makedirs,PTH104	os-rename,PTH105	os-replace,PTH106	os-rmdir,PTH107	os-remove,PTH108	os-unlink,PTH109	os-getcwd,PTH110	os-path-exists,PTH111	os-path-expanduser,PTH112	os-path-isdir,PTH113	os-path-isfile,PTH114	os-path-islink,PTH115	os-readlink,PTH116	os-stat,PTH117	os-path-isabs,PTH118	os-path-join,PTH119	os-path-basename,PTH120	os-path-dirname,PTH121	os-path-samefile,PTH122	os-path-splitext,PTH123	builtin-open,PTH124	py-path,PTH201	path-constructor-current-directory,PTH202	os-path-getsize,PTH203	os-path-getatime,PTH204	os-path-getmtime,PTH205	os-path-getctime,PTH206	os-sep-split,PTH207	glob,FLY002	static-join-to-f-string,I001	unsorted-imports,I002	missing-required-import,C901	complex-structure,NPY001	numpy-deprecated-type-alias,NPY002	numpy-legacy-random,NPY003	numpy-deprecated-function,NPY201	numpy2-deprecation,N801	invalid-class-name,N802	invalid-function-name,N803	invalid-argument-name,N804	invalid-first-argument-name-for-class-method,N805	invalid-first-argument-name-for-method,N806	non-lowercase-variable-in-function,N807	dunder-function-name,N811	constant-imported-as-non-constant,N812	lowercase-imported-as-non-lowercase,N813	camelcase-imported-as-lowercase,N814	camelcase-imported-as-constant,N815	mixed-case-variable-in-class-scope,N816	mixed-case-variable-in-global-scope,N817	camelcase-imported-as-acronym,N818	error-suffix-on-exception-name,N999	invalid-module-name,PD002	pandas-use-of-inplace-argument,PD003	pandas-use-of-dot-is-null,PD004	pandas-use-of-dot-not-null,PD007	pandas-use-of-dot-ix,PD008	pandas-use-of-dot-at,PD009	pandas-use-of-dot-iat,PD010	pandas-use-of-dot-pivot-or-unstack,PD011	pandas-use-of-dot-values,PD012	pandas-use-of-dot-read-table,PD013	pandas-use-of-dot-stack,PD015	pandas-use-of-pd-merge,PD101	pandas-nunique-constant-series-check,PD901	pandas-df-variable-name,PERF101	unnecessary-list-cast,PERF102	incorrect-dict-iterator,PERF203	try-except-in-loop,PERF401	manual-list-comprehension,PERF402	manual-list-copy,PERF403	manual-dict-comprehension,E101	mixed-spaces-and-tabs,E111	indentation-with-invalid-multiple,E112	no-indented-block,E113	unexpected-indentation,E114	indentation-with-invalid-multiple-comment,E115	no-indented-block-comment,E116	unexpected-indentation-comment,E117	over-indented,E201	whitespace-after-open-bracket,E202	whitespace-before-close-bracket,E203	whitespace-before-punctuation,E211	whitespace-before-parameters,E221	multiple-spaces-before-operator,E222	multiple-spaces-after-operator,E223	tab-before-operator,E224	tab-after-operator,E225	missing-whitespace-around-operator,E226	missing-whitespace-around-arithmetic-operator,E227	missing-whitespace-around-bitwise-or-shift-operator,E228	missing-whitespace-around-modulo-operator,E231	missing-whitespace,E241	multiple-spaces-after-comma,E242	tab-after-comma,E251	unexpected-spaces-around-keyword-parameter-equals,E252	missing-whitespace-around-parameter-equals,E261	too-few-spaces-before-inline-comment,E262	no-space-after-inline-comment,E265	no-space-after-block-comment,E266	multiple-leading-hashes-for-block-comment,E271	multiple-spaces-after-keyword,E272	multiple-spaces-before-keyword,E273	tab-after-keyword,E274	tab-before-keyword,E275	missing-whitespace-after-keyword,E401	multiple-imports-on-one-line,E402	module-import-not-at-top-of-file,E501	line-too-long,E701	multiple-statements-on-one-line-colon,E702	multiple-statements-on-one-line-semicolon,E703	useless-semicolon,E711	none-comparison,E712	true-false-comparison,E713	not-in-test,E714	not-is-test,E721	type-comparison,E722	bare-except,E731	lambda-assignment,E741	ambiguous-variable-name,E742	ambiguous-class-name,E743	ambiguous-function-name,E902	io-error,E999	syntax-error,W191	tab-indentation,W291	trailing-whitespace,W292	missing-newline-at-end-of-file,W293	blank-line-with-whitespace,W505	doc-line-too-long,W605	invalid-escape-sequence,D100	undocumented-public-module,D101	undocumented-public-class,D102	undocumented-public-method,D103	undocumented-public-function,D104	undocumented-public-package,D105	undocumented-magic-method,D106	undocumented-public-nested-class,D107	undocumented-public-init,D200	fits-on-one-line,D201	no-blank-line-before-function,D202	no-blank-line-after-function,D203	one-blank-line-before-class,D204	one-blank-line-after-class,D205	blank-line-after-summary,D206	indent-with-spaces,D207	under-indentation,D208	over-indentation,D209	new-line-after-last-paragraph,D210	surrounding-whitespace,D211	blank-line-before-class,D212	multi-line-summary-first-line,D213	multi-line-summary-second-line,D214	section-not-over-indented,D215	section-underline-not-over-indented,D300	triple-single-quotes,D301	escape-sequence-in-docstring,D400	ends-in-period,D401	non-imperative-mood,D402	no-signature,D403	first-line-capitalized,D404	docstring-starts-with-this,D405	capitalize-section-name,D406	new-line-after-section-name,D407	dashed-underline-after-section,D408	section-underline-after-name,D409	section-underline-matches-section-length,D410	no-blank-line-after-section,D411	no-blank-line-before-section,D412	blank-lines-between-header-and-content,D413	blank-line-after-last-section,D414	empty-docstring-section,D415	ends-in-punctuation,D416	section-name-ends-in-colon,D417	undocumented-param,D418	overload-with-docstring,D419	empty-docstring,F401	unused-import,F402	import-shadowed-by-loop-var,F403	undefined-local-with-import-star,F404	late-future-import,F405	undefined-local-with-import-star-usage,F406	undefined-local-with-nested-import-star-usage,F407	future-feature-not-defined,F501	percent-format-invalid-format,F502	percent-format-expected-mapping,F503	percent-format-expected-sequence,F504	percent-format-extra-named-arguments,F505	percent-format-missing-argument,F506	percent-format-mixed-positional-and-named,F507	percent-format-positional-count-mismatch,F508	percent-format-star-requires-sequence,F509	percent-format-unsupported-format-character,F521	string-dot-format-invalid-format,F522	string-dot-format-extra-named-arguments,F523	string-dot-format-extra-positional-arguments,F524	string-dot-format-missing-arguments,F525	string-dot-format-mixing-automatic,F541	f-string-missing-placeholders,F601	multi-value-repeated-key-literal,F602	multi-value-repeated-key-variable,F621	expressions-in-star-assignment,F622	multiple-starred-expressions,F631	assert-tuple,F632	is-literal,F633	invalid-print-syntax,F634	if-tuple,F701	break-outside-loop,F702	continue-outside-loop,F704	yield-outside-function,F706	return-outside-function,F707	default-except-not-last,F722	forward-annotation-syntax-error,F811	redefined-while-unused,F821	undefined-name,F822	undefined-export,F823	undefined-local,F841	unused-variable,F842	unused-annotation,F901	raise-not-implemented,PGH001	eval,PGH002	deprecated-log-warn,PGH003	blanket-type-ignore,PGH004	blanket-noqa,PGH005	invalid-mock-access,PLC0105	type-name-incorrect-variance,PLC0131	type-bivariance,PLC0132	type-param-name-mismatch,PLC0205	single-string-slots,PLC0208	iteration-over-set,PLC0414	useless-import-alias,PLC0415	import-outside-top-level,PLC1901	compare-to-empty-string,PLC2401	non-ascii-name,PLC2403	non-ascii-import-name,PLC2701	import-private-name,PLC2801	unnecessary-dunder-call,PLC3002	unnecessary-direct-lambda-call,PLE0100	yield-in-init,PLE0101	return-in-init,PLE0116	continue-in-finally,PLE0117	nonlocal-without-binding,PLE0118	load-before-global-declaration,PLE0241	duplicate-bases,PLE0302	unexpected-special-method-signature,PLE0307	invalid-str-return-type,PLE0604	invalid-all-object,PLE0605	invalid-all-format,PLE0704	misplaced-bare-raise,PLE1132	repeated-keyword-argument,PLE1142	await-outside-async,PLE1205	logging-too-many-args,PLE1206	logging-too-few-args,PLE1300	bad-string-format-character,PLE1307	bad-string-format-type,PLE1310	bad-str-strip-call,PLE1507	invalid-envvar-value,PLE1700	yield-from-in-async-function,PLE2502	bidirectional-unicode,PLE2510	invalid-character-backspace,PLE2512	invalid-character-sub,PLE2513	invalid-character-esc,PLE2514	invalid-character-nul,PLE2515	invalid-character-zero-width-space,PLR0124	comparison-with-itself,PLR0133	comparison-of-constant,PLR0202	no-classmethod-decorator,PLR0203	no-staticmethod-decorator,PLR0206	property-with-parameters,PLR0402	manual-from-import,PLR0904	too-many-public-methods,PLR0911	too-many-return-statements,PLR0912	too-many-branches,PLR0913	too-many-arguments,PLR0914	too-many-locals,PLR0915	too-many-statements,PLR0916	too-many-boolean-expressions,PLR0917	too-many-positional,PLR1701	repeated-isinstance-calls,PLR1704	redefined-argument-from-local,PLR1706	and-or-ternary,PLR1711	useless-return,PLR1714	repeated-equality-comparison,PLR1722	sys-exit-alias,PLR1733	unnecessary-dict-index-lookup,PLR1736	unnecessary-list-index-lookup,PLR2004	magic-value-comparison,PLR2044	empty-comment,PLR5501	collapsible-else-if,PLR6201	literal-membership,PLR6301	no-self-use,PLW0108	unnecessary-lambda,PLW0120	useless-else-on-loop,PLW0127	self-assigning-variable,PLW0129	assert-on-string-literal,PLW0131	named-expr-without-context,PLW0245	super-without-brackets,PLW0406	import-self,PLW0602	global-variable-not-assigned,PLW0603	global-statement,PLW0604	global-at-module-level,PLW0711	binary-op-exception,PLW1501	bad-open-mode,PLW1508	invalid-envvar-default,PLW1509	subprocess-popen-preexec-fn,PLW1510	subprocess-run-without-check,PLW1514	unspecified-encoding,PLW1641	eq-without-hash,PLW2101	useless-with-lock,PLW2901	redefined-loop-name,PLW3201	bad-dunder-method-name,PLW3301	nested-min-max,UP001	useless-metaclass-type,UP003	type-of-primitive,UP004	useless-object-inheritance,UP005	deprecated-unittest-alias,UP006	non-pep585-annotation,UP007	non-pep604-annotation,UP008	super-call-with-parameters,UP009	utf8-encoding-declaration,UP010	unnecessary-future-import,UP011	lru-cache-without-parameters,UP012	unnecessary-encode-utf8,UP013	convert-typed-dict-functional-to-class,UP014	convert-named-tuple-functional-to-class,UP015	redundant-open-modes,UP017	datetime-timezone-utc,UP018	native-literals,UP019	typing-text-str-alias,UP020	open-alias,UP021	replace-universal-newlines,UP022	replace-stdout-stderr,UP023	deprecated-c-element-tree,UP024	os-error-alias,UP025	unicode-kind-prefix,UP026	deprecated-mock-import,UP027	unpacked-list-comprehension,UP028	yield-in-for-loop,UP029	unnecessary-builtin-import,UP030	format-literals,UP031	printf-string-formatting,UP032	f-string,UP033	lru-cache-with-maxsize-none,UP034	extraneous-parentheses,UP035	deprecated-import,UP036	outdated-version-block,UP037	quoted-annotation,UP038	non-pep604-isinstance,UP039	unnecessary-class-parentheses,UP040	non-pep695-type-alias,UP041	timeout-error-alias,FURB101	read-whole-file,FURB105	print-empty-string,FURB113	repeated-append,FURB118	reimplemented-operator,FURB131	delete-full-slice,FURB132	check-and-remove-from-set,FURB136	if-expr-min-max,FURB140	reimplemented-starmap,FURB145	slice-copy,FURB148	unnecessary-enumerate,FURB152	math-constant,FURB161	bit-count,FURB163	redundant-log-base,FURB167	regex-flag-alias,FURB168	isinstance-type-none,FURB169	type-none-comparison,FURB171	single-item-membership-test,FURB177	implicit-cwd,FURB181	hashlib-digest-hex,RUF001	ambiguous-unicode-character-string,RUF002	ambiguous-unicode-character-docstring,RUF003	ambiguous-unicode-character-comment,RUF005	collection-literal-concatenation,RUF006	asyncio-dangling-task,RUF007	pairwise-over-zipped,RUF008	mutable-dataclass-default,RUF009	function-call-in-dataclass-default-argument,RUF010	explicit-f-string-type-conversion,RUF011	static-key-dict-comprehension,RUF012	mutable-class-default,RUF013	implicit-optional,RUF015	unnecessary-iterable-allocation-for-first-element,RUF016	invalid-index-type,RUF017	quadratic-list-summation,RUF018	assignment-in-assert,RUF019	unnecessary-key-check,RUF020	never-union,RUF021	parenthesize-chained-operators,RUF022	unsorted-dunder-all,RUF100	unused-noqa,RUF200	invalid-pyproject-toml,TRY002	raise-vanilla-class,TRY003	raise-vanilla-args,TRY004	type-check-without-type-error,TRY200	reraise-no-cause,TRY201	verbose-raise,TRY300	try-consider-else,TRY301	raise-within-try,TRY302	useless-try-except,TRY400	error-instead-of-exception,TRY401	verbose-log-message}"
complete -c ruff -n "__fish_seen_subcommand_from check" -l extend-ignore -d 'Like --ignore. (Deprecated: You can just use --ignore instead.)' -r -f -a "{ALL	all rules,F	Pyflakes,C90	mccabe,I	isort,N	pep8-naming,D	pydocstyle,UP	pyupgrade,YTT	flake8-2020,ANN	flake8-annotations,ASYNC	flake8-async,TRIO	flake8-trio,S	flake8-bandit,BLE	flake8-blind-except,FBT	flake8-boolean-trap,B	flake8-bugbear,A	flake8-builtins,COM	flake8-commas,CPY	flake8-copyright,C4	flake8-comprehensions,DTZ	flake8-datetimez,T10	flake8-debugger,DJ	flake8-django,EM	flake8-errmsg,EXE	flake8-executable,FA	flake8-future-annotations,ISC	flake8-implicit-str-concat,ICN	flake8-import-conventions,G	flake8-logging-format,INP	flake8-no-pep420,PIE	flake8-pie,T20	flake8-print,PYI	flake8-pyi,PT	flake8-pytest-style,Q	flake8-quotes,RSE	flake8-raise,RET	flake8-return,SLF	flake8-self,SLOT	flake8-slots,SIM	flake8-simplify,TID	flake8-tidy-imports,TCH	flake8-type-checking,INT	flake8-gettext,ARG	flake8-unused-arguments,PTH	flake8-use-pathlib,TD	flake8-todos,FIX	flake8-fixme,ERA	eradicate,PD	pandas-vet,PGH	pygrep-hooks,PL	Pylint,TRY	tryceratops,FLY	flynt,NPY	NumPy-specific rules,AIR	Airflow,PERF	Perflint,FURB	refurb,LOG	flake8-logging,RUF	Ruff-specific rules,AIR001	airflow-variable-name-task-id-mismatch,ERA001	commented-out-code,YTT101	sys-version-slice3,YTT102	sys-version2,YTT103	sys-version-cmp-str3,YTT201	sys-version-info0-eq3,YTT202	six-py3,YTT203	sys-version-info1-cmp-int,YTT204	sys-version-info-minor-cmp-int,YTT301	sys-version0,YTT302	sys-version-cmp-str10,YTT303	sys-version-slice1,ANN001	missing-type-function-argument,ANN002	missing-type-args,ANN003	missing-type-kwargs,ANN101	missing-type-self,ANN102	missing-type-cls,ANN201	missing-return-type-undocumented-public-function,ANN202	missing-return-type-private-function,ANN204	missing-return-type-special-method,ANN205	missing-return-type-static-method,ANN206	missing-return-type-class-method,ANN401	any-type,ASYNC100	blocking-http-call-in-async-function,ASYNC101	open-sleep-or-subprocess-in-async-function,ASYNC102	blocking-os-call-in-async-function,S101	assert,S102	exec-builtin,S103	bad-file-permissions,S104	hardcoded-bind-all-interfaces,S105	hardcoded-password-string,S106	hardcoded-password-func-arg,S107	hardcoded-password-default,S108	hardcoded-temp-file,S110	try-except-pass,S112	try-except-continue,S113	request-without-timeout,S201	flask-debug-true,S202	tarfile-unsafe-members,S301	suspicious-pickle-usage,S302	suspicious-marshal-usage,S303	suspicious-insecure-hash-usage,S304	suspicious-insecure-cipher-usage,S305	suspicious-insecure-cipher-mode-usage,S306	suspicious-mktemp-usage,S307	suspicious-eval-usage,S308	suspicious-mark-safe-usage,S310	suspicious-url-open-usage,S311	suspicious-non-cryptographic-random-usage,S312	suspicious-telnet-usage,S313	suspicious-xmlc-element-tree-usage,S314	suspicious-xml-element-tree-usage,S315	suspicious-xml-expat-reader-usage,S316	suspicious-xml-expat-builder-usage,S317	suspicious-xml-sax-usage,S318	suspicious-xml-mini-dom-usage,S319	suspicious-xml-pull-dom-usage,S320	suspicious-xmle-tree-usage,S321	suspicious-ftp-lib-usage,S323	suspicious-unverified-context-usage,S324	hashlib-insecure-hash-function,S401	suspicious-telnetlib-import,S402	suspicious-ftplib-import,S403	suspicious-pickle-import,S404	suspicious-subprocess-import,S405	suspicious-xml-etree-import,S406	suspicious-xml-sax-import,S407	suspicious-xml-expat-import,S408	suspicious-xml-minidom-import,S409	suspicious-xml-pulldom-import,S410	suspicious-lxml-import,S411	suspicious-xmlrpc-import,S412	suspicious-httpoxy-import,S413	suspicious-pycrypto-import,S415	suspicious-pyghmi-import,S501	request-with-no-cert-validation,S502	ssl-insecure-version,S503	ssl-with-bad-defaults,S504	ssl-with-no-version,S505	weak-cryptographic-key,S506	unsafe-yaml-load,S507	ssh-no-host-key-verification,S508	snmp-insecure-version,S509	snmp-weak-cryptography,S601	paramiko-call,S602	subprocess-popen-with-shell-equals-true,S603	subprocess-without-shell-equals-true,S604	call-with-shell-equals-true,S605	start-process-with-a-shell,S606	start-process-with-no-shell,S607	start-process-with-partial-path,S608	hardcoded-sql-expression,S609	unix-command-wildcard-injection,S611	django-raw-sql,S612	logging-config-insecure-listen,S701	jinja2-autoescape-false,S702	mako-templates,BLE001	blind-except,FBT001	boolean-type-hint-positional-argument,FBT002	boolean-default-value-positional-argument,FBT003	boolean-positional-value-in-call,B002	unary-prefix-increment-decrement,B003	assignment-to-os-environ,B004	unreliable-callable-check,B005	strip-with-multi-characters,B006	mutable-argument-default,B007	unused-loop-control-variable,B008	function-call-in-default-argument,B009	get-attr-with-constant,B010	set-attr-with-constant,B011	assert-false,B012	jump-statement-in-finally,B013	redundant-tuple-in-exception-handler,B014	duplicate-handler-exception,B015	useless-comparison,B016	raise-literal,B017	assert-raises-exception,B018	useless-expression,B019	cached-instance-method,B020	loop-variable-overrides-iterator,B021	f-string-docstring,B022	useless-contextlib-suppress,B023	function-uses-loop-variable,B024	abstract-base-class-without-abstract-method,B025	duplicate-try-block-exception,B026	star-arg-unpacking-after-keyword-arg,B027	empty-method-without-abstract-decorator,B028	no-explicit-stacklevel,B029	except-with-empty-tuple,B030	except-with-non-exception-classes,B031	reuse-of-groupby-generator,B032	unintentional-type-annotation,B033	duplicate-value,B034	re-sub-positional-args,B904	raise-without-from-inside-except,B905	zip-without-explicit-strict,A001	builtin-variable-shadowing,A002	builtin-argument-shadowing,A003	builtin-attribute-shadowing,COM812	missing-trailing-comma,COM818	trailing-comma-on-bare-tuple,COM819	prohibited-trailing-comma,C400	unnecessary-generator-list,C401	unnecessary-generator-set,C402	unnecessary-generator-dict,C403	unnecessary-list-comprehension-set,C404	unnecessary-list-comprehension-dict,C405	unnecessary-literal-set,C406	unnecessary-literal-dict,C408	unnecessary-collection-call,C409	unnecessary-literal-within-tuple-call,C410	unnecessary-literal-within-list-call,C411	unnecessary-list-call,C413	unnecessary-call-around-sorted,C414	unnecessary-double-cast-or-process,C415	unnecessary-subscript-reversal,C416	unnecessary-comprehension,C417	unnecessary-map,C418	unnecessary-literal-within-dict-call,C419	unnecessary-comprehension-any-all,CPY001	missing-copyright-notice,DTZ001	call-datetime-without-tzinfo,DTZ002	call-datetime-today,DTZ003	call-datetime-utcnow,DTZ004	call-datetime-utcfromtimestamp,DTZ005	call-datetime-now-without-tzinfo,DTZ006	call-datetime-fromtimestamp,DTZ007	call-datetime-strptime-without-zone,DTZ011	call-date-today,DTZ012	call-date-fromtimestamp,T100	debugger,DJ001	django-nullable-model-string-field,DJ003	django-locals-in-render-function,DJ006	django-exclude-with-model-form,DJ007	django-all-with-model-form,DJ008	django-model-without-dunder-str,DJ012	django-unordered-body-content-in-model,DJ013	django-non-leading-receiver-decorator,EM101	raw-string-in-exception,EM102	f-string-in-exception,EM103	dot-format-in-exception,EXE001	shebang-not-executable,EXE002	shebang-missing-executable-file,EXE003	shebang-missing-python,EXE004	shebang-leading-whitespace,EXE005	shebang-not-first-line,FIX001	line-contains-fixme,FIX002	line-contains-todo,FIX003	line-contains-xxx,FIX004	line-contains-hack,FA100	future-rewritable-type-annotation,FA102	future-required-type-annotation,INT001	f-string-in-get-text-func-call,INT002	format-in-get-text-func-call,INT003	printf-in-get-text-func-call,ISC001	single-line-implicit-string-concatenation,ISC002	multi-line-implicit-string-concatenation,ISC003	explicit-string-concatenation,ICN001	unconventional-import-alias,ICN002	banned-import-alias,ICN003	banned-import-from,LOG001	direct-logger-instantiation,LOG002	invalid-get-logger-argument,LOG007	exception-without-exc-info,LOG009	undocumented-warn,G001	logging-string-format,G002	logging-percent-format,G003	logging-string-concat,G004	logging-f-string,G010	logging-warn,G101	logging-extra-attr-clash,G201	logging-exc-info,G202	logging-redundant-exc-info,INP001	implicit-namespace-package,PIE790	unnecessary-placeholder,PIE794	duplicate-class-field-definition,PIE796	non-unique-enums,PIE800	unnecessary-spread,PIE804	unnecessary-dict-kwargs,PIE807	reimplemented-container-builtin,PIE808	unnecessary-range-start,PIE810	multiple-starts-ends-with,T201	print,T203	p-print,PYI001	unprefixed-type-param,PYI002	complex-if-statement-in-stub,PYI003	unrecognized-version-info-check,PYI004	patch-version-comparison,PYI005	wrong-tuple-length-version-comparison,PYI006	bad-version-info-comparison,PYI007	unrecognized-platform-check,PYI008	unrecognized-platform-name,PYI009	pass-statement-stub-body,PYI010	non-empty-stub-body,PYI011	typed-argument-default-in-stub,PYI012	pass-in-class-body,PYI013	ellipsis-in-non-empty-class-body,PYI014	argument-default-in-stub,PYI015	assignment-default-in-stub,PYI016	duplicate-union-member,PYI017	complex-assignment-in-stub,PYI018	unused-private-type-var,PYI019	custom-type-var-return-type,PYI020	quoted-annotation-in-stub,PYI021	docstring-in-stub,PYI024	collections-named-tuple,PYI025	unaliased-collections-abc-set-import,PYI026	type-alias-without-annotation,PYI029	str-or-repr-defined-in-stub,PYI030	unnecessary-literal-union,PYI032	any-eq-ne-annotation,PYI033	type-comment-in-stub,PYI034	non-self-return-type,PYI035	unassigned-special-variable-in-stub,PYI036	bad-exit-annotation,PYI041	redundant-numeric-union,PYI042	snake-case-type-alias,PYI043	t-suffixed-type-alias,PYI044	future-annotations-in-stub,PYI045	iter-method-return-iterable,PYI046	unused-private-protocol,PYI047	unused-private-type-alias,PYI048	stub-body-multiple-statements,PYI049	unused-private-typed-dict,PYI050	no-return-argument-annotation-in-stub,PYI051	redundant-literal-union,PYI052	unannotated-assignment-in-stub,PYI053	string-or-bytes-too-long,PYI054	numeric-literal-too-long,PYI055	unnecessary-type-union,PYI056	unsupported-method-call-on-all,PYI058	generator-return-from-iter-method,PT001	pytest-fixture-incorrect-parentheses-style,PT002	pytest-fixture-positional-args,PT003	pytest-extraneous-scope-function,PT004	pytest-missing-fixture-name-underscore,PT005	pytest-incorrect-fixture-name-underscore,PT006	pytest-parametrize-names-wrong-type,PT007	pytest-parametrize-values-wrong-type,PT008	pytest-patch-with-lambda,PT009	pytest-unittest-assertion,PT010	pytest-raises-without-exception,PT011	pytest-raises-too-broad,PT012	pytest-raises-with-multiple-statements,PT013	pytest-incorrect-pytest-import,PT014	pytest-duplicate-parametrize-test-cases,PT015	pytest-assert-always-false,PT016	pytest-fail-without-message,PT017	pytest-assert-in-except,PT018	pytest-composite-assertion,PT019	pytest-fixture-param-without-value,PT020	pytest-deprecated-yield-fixture,PT021	pytest-fixture-finalizer-callback,PT022	pytest-useless-yield-fixture,PT023	pytest-incorrect-mark-parentheses-style,PT024	pytest-unnecessary-asyncio-mark-on-fixture,PT025	pytest-erroneous-use-fixtures-on-fixture,PT026	pytest-use-fixtures-without-parameters,PT027	pytest-unittest-raises-assertion,Q000	bad-quotes-inline-string,Q001	bad-quotes-multiline-string,Q002	bad-quotes-docstring,Q003	avoidable-escaped-quote,Q004	unnecessary-escaped-quote,RSE102	unnecessary-paren-on-raise-exception,RET501	unnecessary-return-none,RET502	implicit-return-value,RET503	implicit-return,RET504	unnecessary-assign,RET505	superfluous-else-return,RET506	superfluous-else-raise,RET507	superfluous-else-continue,RET508	superfluous-else-break,SLF001	private-member-access,SIM101	duplicate-isinstance-call,SIM102	collapsible-if,SIM103	needless-bool,SIM105	suppressible-exception,SIM107	return-in-try-except-finally,SIM108	if-else-block-instead-of-if-exp,SIM109	compare-with-tuple,SIM110	reimplemented-builtin,SIM112	uncapitalized-environment-variables,SIM113	enumerate-for-loop,SIM114	if-with-same-arms,SIM115	open-file-with-context-handler,SIM116	if-else-block-instead-of-dict-lookup,SIM117	multiple-with-statements,SIM118	in-dict-keys,SIM201	negate-equal-op,SIM202	negate-not-equal-op,SIM208	double-negation,SIM210	if-expr-with-true-false,SIM211	if-expr-with-false-true,SIM212	if-expr-with-twisted-arms,SIM220	expr-and-not-expr,SIM221	expr-or-not-expr,SIM222	expr-or-true,SIM223	expr-and-false,SIM300	yoda-conditions,SIM401	if-else-block-instead-of-dict-get,SIM910	dict-get-with-none-default,SIM911	zip-dict-keys-and-values,SLOT000	no-slots-in-str-subclass,SLOT001	no-slots-in-tuple-subclass,SLOT002	no-slots-in-namedtuple-subclass,TID251	banned-api,TID252	relative-imports,TID253	banned-module-level-imports,TD001	invalid-todo-tag,TD002	missing-todo-author,TD003	missing-todo-link,TD004	missing-todo-colon,TD005	missing-todo-description,TD006	invalid-todo-capitalization,TD007	missing-space-after-todo-colon,TRIO100	trio-timeout-without-await,TRIO105	trio-sync-call,TRIO109	trio-async-function-with-timeout,TRIO110	trio-unneeded-sleep,TRIO115	trio-zero-sleep-call,TCH001	typing-only-first-party-import,TCH002	typing-only-third-party-import,TCH003	typing-only-standard-library-import,TCH004	runtime-import-in-type-checking-block,TCH005	empty-type-checking-block,TCH006	runtime-string-union,ARG001	unused-function-argument,ARG002	unused-method-argument,ARG003	unused-class-method-argument,ARG004	unused-static-method-argument,ARG005	unused-lambda-argument,PTH100	os-path-abspath,PTH101	os-chmod,PTH102	os-mkdir,PTH103	os-makedirs,PTH104	os-rename,PTH105	os-replace,PTH106	os-rmdir,PTH107	os-remove,PTH108	os-unlink,PTH109	os-getcwd,PTH110	os-path-exists,PTH111	os-path-expanduser,PTH112	os-path-isdir,PTH113	os-path-isfile,PTH114	os-path-islink,PTH115	os-readlink,PTH116	os-stat,PTH117	os-path-isabs,PTH118	os-path-join,PTH119	os-path-basename,PTH120	os-path-dirname,PTH121	os-path-samefile,PTH122	os-path-splitext,PTH123	builtin-open,PTH124	py-path,PTH201	path-constructor-current-directory,PTH202	os-path-getsize,PTH203	os-path-getatime,PTH204	os-path-getmtime,PTH205	os-path-getctime,PTH206	os-sep-split,PTH207	glob,FLY002	static-join-to-f-string,I001	unsorted-imports,I002	missing-required-import,C901	complex-structure,NPY001	numpy-deprecated-type-alias,NPY002	numpy-legacy-random,NPY003	numpy-deprecated-function,NPY201	numpy2-deprecation,N801	invalid-class-name,N802	invalid-function-name,N803	invalid-argument-name,N804	invalid-first-argument-name-for-class-method,N805	invalid-first-argument-name-for-method,N806	non-lowercase-variable-in-function,N807	dunder-function-name,N811	constant-imported-as-non-constant,N812	lowercase-imported-as-non-lowercase,N813	camelcase-imported-as-lowercase,N814	camelcase-imported-as-constant,N815	mixed-case-variable-in-class-scope,N816	mixed-case-variable-in-global-scope,N817	camelcase-imported-as-acronym,N818	error-suffix-on-exception-name,N999	invalid-module-name,PD002	pandas-use-of-inplace-argument,PD003	pandas-use-of-dot-is-null,PD004	pandas-use-of-dot-not-null,PD007	pandas-use-of-dot-ix,PD008	pandas-use-of-dot-at,PD009	pandas-use-of-dot-iat,PD010	pandas-use-of-dot-pivot-or-unstack,PD011	pandas-use-of-dot-values,PD012	pandas-use-of-dot-read-table,PD013	pandas-use-of-dot-stack,PD015	pandas-use-of-pd-merge,PD101	pandas-nunique-constant-series-check,PD901	pandas-df-variable-name,PERF101	unnecessary-list-cast,PERF102	incorrect-dict-iterator,PERF203	try-except-in-loop,PERF401	manual-list-comprehension,PERF402	manual-list-copy,PERF403	manual-dict-comprehension,E101	mixed-spaces-and-tabs,E111	indentation-with-invalid-multiple,E112	no-indented-block,E113	unexpected-indentation,E114	indentation-with-invalid-multiple-comment,E115	no-indented-block-comment,E116	unexpected-indentation-comment,E117	over-indented,E201	whitespace-after-open-bracket,E202	whitespace-before-close-bracket,E203	whitespace-before-punctuation,E211	whitespace-before-parameters,E221	multiple-spaces-before-operator,E222	multiple-spaces-after-operator,E223	tab-before-operator,E224	tab-after-operator,E225	missing-whitespace-around-operator,E226	missing-whitespace-around-arithmetic-operator,E227	missing-whitespace-around-bitwise-or-shift-operator,E228	missing-whitespace-around-modulo-operator,E231	missing-whitespace,E241	multiple-spaces-after-comma,E242	tab-after-comma,E251	unexpected-spaces-around-keyword-parameter-equals,E252	missing-whitespace-around-parameter-equals,E261	too-few-spaces-before-inline-comment,E262	no-space-after-inline-comment,E265	no-space-after-block-comment,E266	multiple-leading-hashes-for-block-comment,E271	multiple-spaces-after-keyword,E272	multiple-spaces-before-keyword,E273	tab-after-keyword,E274	tab-before-keyword,E275	missing-whitespace-after-keyword,E401	multiple-imports-on-one-line,E402	module-import-not-at-top-of-file,E501	line-too-long,E701	multiple-statements-on-one-line-colon,E702	multiple-statements-on-one-line-semicolon,E703	useless-semicolon,E711	none-comparison,E712	true-false-comparison,E713	not-in-test,E714	not-is-test,E721	type-comparison,E722	bare-except,E731	lambda-assignment,E741	ambiguous-variable-name,E742	ambiguous-class-name,E743	ambiguous-function-name,E902	io-error,E999	syntax-error,W191	tab-indentation,W291	trailing-whitespace,W292	missing-newline-at-end-of-file,W293	blank-line-with-whitespace,W505	doc-line-too-long,W605	invalid-escape-sequence,D100	undocumented-public-module,D101	undocumented-public-class,D102	undocumented-public-method,D103	undocumented-public-function,D104	undocumented-public-package,D105	undocumented-magic-method,D106	undocumented-public-nested-class,D107	undocumented-public-init,D200	fits-on-one-line,D201	no-blank-line-before-function,D202	no-blank-line-after-function,D203	one-blank-line-before-class,D204	one-blank-line-after-class,D205	blank-line-after-summary,D206	indent-with-spaces,D207	under-indentation,D208	over-indentation,D209	new-line-after-last-paragraph,D210	surrounding-whitespace,D211	blank-line-before-class,D212	multi-line-summary-first-line,D213	multi-line-summary-second-line,D214	section-not-over-indented,D215	section-underline-not-over-indented,D300	triple-single-quotes,D301	escape-sequence-in-docstring,D400	ends-in-period,D401	non-imperative-mood,D402	no-signature,D403	first-line-capitalized,D404	docstring-starts-with-this,D405	capitalize-section-name,D406	new-line-after-section-name,D407	dashed-underline-after-section,D408	section-underline-after-name,D409	section-underline-matches-section-length,D410	no-blank-line-after-section,D411	no-blank-line-before-section,D412	blank-lines-between-header-and-content,D413	blank-line-after-last-section,D414	empty-docstring-section,D415	ends-in-punctuation,D416	section-name-ends-in-colon,D417	undocumented-param,D418	overload-with-docstring,D419	empty-docstring,F401	unused-import,F402	import-shadowed-by-loop-var,F403	undefined-local-with-import-star,F404	late-future-import,F405	undefined-local-with-import-star-usage,F406	undefined-local-with-nested-import-star-usage,F407	future-feature-not-defined,F501	percent-format-invalid-format,F502	percent-format-expected-mapping,F503	percent-format-expected-sequence,F504	percent-format-extra-named-arguments,F505	percent-format-missing-argument,F506	percent-format-mixed-positional-and-named,F507	percent-format-positional-count-mismatch,F508	percent-format-star-requires-sequence,F509	percent-format-unsupported-format-character,F521	string-dot-format-invalid-format,F522	string-dot-format-extra-named-arguments,F523	string-dot-format-extra-positional-arguments,F524	string-dot-format-missing-arguments,F525	string-dot-format-mixing-automatic,F541	f-string-missing-placeholders,F601	multi-value-repeated-key-literal,F602	multi-value-repeated-key-variable,F621	expressions-in-star-assignment,F622	multiple-starred-expressions,F631	assert-tuple,F632	is-literal,F633	invalid-print-syntax,F634	if-tuple,F701	break-outside-loop,F702	continue-outside-loop,F704	yield-outside-function,F706	return-outside-function,F707	default-except-not-last,F722	forward-annotation-syntax-error,F811	redefined-while-unused,F821	undefined-name,F822	undefined-export,F823	undefined-local,F841	unused-variable,F842	unused-annotation,F901	raise-not-implemented,PGH001	eval,PGH002	deprecated-log-warn,PGH003	blanket-type-ignore,PGH004	blanket-noqa,PGH005	invalid-mock-access,PLC0105	type-name-incorrect-variance,PLC0131	type-bivariance,PLC0132	type-param-name-mismatch,PLC0205	single-string-slots,PLC0208	iteration-over-set,PLC0414	useless-import-alias,PLC0415	import-outside-top-level,PLC1901	compare-to-empty-string,PLC2401	non-ascii-name,PLC2403	non-ascii-import-name,PLC2701	import-private-name,PLC2801	unnecessary-dunder-call,PLC3002	unnecessary-direct-lambda-call,PLE0100	yield-in-init,PLE0101	return-in-init,PLE0116	continue-in-finally,PLE0117	nonlocal-without-binding,PLE0118	load-before-global-declaration,PLE0241	duplicate-bases,PLE0302	unexpected-special-method-signature,PLE0307	invalid-str-return-type,PLE0604	invalid-all-object,PLE0605	invalid-all-format,PLE0704	misplaced-bare-raise,PLE1132	repeated-keyword-argument,PLE1142	await-outside-async,PLE1205	logging-too-many-args,PLE1206	logging-too-few-args,PLE1300	bad-string-format-character,PLE1307	bad-string-format-type,PLE1310	bad-str-strip-call,PLE1507	invalid-envvar-value,PLE1700	yield-from-in-async-function,PLE2502	bidirectional-unicode,PLE2510	invalid-character-backspace,PLE2512	invalid-character-sub,PLE2513	invalid-character-esc,PLE2514	invalid-character-nul,PLE2515	invalid-character-zero-width-space,PLR0124	comparison-with-itself,PLR0133	comparison-of-constant,PLR0202	no-classmethod-decorator,PLR0203	no-staticmethod-decorator,PLR0206	property-with-parameters,PLR0402	manual-from-import,PLR0904	too-many-public-methods,PLR0911	too-many-return-statements,PLR0912	too-many-branches,PLR0913	too-many-arguments,PLR0914	too-many-locals,PLR0915	too-many-statements,PLR0916	too-many-boolean-expressions,PLR0917	too-many-positional,PLR1701	repeated-isinstance-calls,PLR1704	redefined-argument-from-local,PLR1706	and-or-ternary,PLR1711	useless-return,PLR1714	repeated-equality-comparison,PLR1722	sys-exit-alias,PLR1733	unnecessary-dict-index-lookup,PLR1736	unnecessary-list-index-lookup,PLR2004	magic-value-comparison,PLR2044	empty-comment,PLR5501	collapsible-else-if,PLR6201	literal-membership,PLR6301	no-self-use,PLW0108	unnecessary-lambda,PLW0120	useless-else-on-loop,PLW0127	self-assigning-variable,PLW0129	assert-on-string-literal,PLW0131	named-expr-without-context,PLW0245	super-without-brackets,PLW0406	import-self,PLW0602	global-variable-not-assigned,PLW0603	global-statement,PLW0604	global-at-module-level,PLW0711	binary-op-exception,PLW1501	bad-open-mode,PLW1508	invalid-envvar-default,PLW1509	subprocess-popen-preexec-fn,PLW1510	subprocess-run-without-check,PLW1514	unspecified-encoding,PLW1641	eq-without-hash,PLW2101	useless-with-lock,PLW2901	redefined-loop-name,PLW3201	bad-dunder-method-name,PLW3301	nested-min-max,UP001	useless-metaclass-type,UP003	type-of-primitive,UP004	useless-object-inheritance,UP005	deprecated-unittest-alias,UP006	non-pep585-annotation,UP007	non-pep604-annotation,UP008	super-call-with-parameters,UP009	utf8-encoding-declaration,UP010	unnecessary-future-import,UP011	lru-cache-without-parameters,UP012	unnecessary-encode-utf8,UP013	convert-typed-dict-functional-to-class,UP014	convert-named-tuple-functional-to-class,UP015	redundant-open-modes,UP017	datetime-timezone-utc,UP018	native-literals,UP019	typing-text-str-alias,UP020	open-alias,UP021	replace-universal-newlines,UP022	replace-stdout-stderr,UP023	deprecated-c-element-tree,UP024	os-error-alias,UP025	unicode-kind-prefix,UP026	deprecated-mock-import,UP027	unpacked-list-comprehension,UP028	yield-in-for-loop,UP029	unnecessary-builtin-import,UP030	format-literals,UP031	printf-string-formatting,UP032	f-string,UP033	lru-cache-with-maxsize-none,UP034	extraneous-parentheses,UP035	deprecated-import,UP036	outdated-version-block,UP037	quoted-annotation,UP038	non-pep604-isinstance,UP039	unnecessary-class-parentheses,UP040	non-pep695-type-alias,UP041	timeout-error-alias,FURB101	read-whole-file,FURB105	print-empty-string,FURB113	repeated-append,FURB118	reimplemented-operator,FURB131	delete-full-slice,FURB132	check-and-remove-from-set,FURB136	if-expr-min-max,FURB140	reimplemented-starmap,FURB145	slice-copy,FURB148	unnecessary-enumerate,FURB152	math-constant,FURB161	bit-count,FURB163	redundant-log-base,FURB167	regex-flag-alias,FURB168	isinstance-type-none,FURB169	type-none-comparison,FURB171	single-item-membership-test,FURB177	implicit-cwd,FURB181	hashlib-digest-hex,RUF001	ambiguous-unicode-character-string,RUF002	ambiguous-unicode-character-docstring,RUF003	ambiguous-unicode-character-comment,RUF005	collection-literal-concatenation,RUF006	asyncio-dangling-task,RUF007	pairwise-over-zipped,RUF008	mutable-dataclass-default,RUF009	function-call-in-dataclass-default-argument,RUF010	explicit-f-string-type-conversion,RUF011	static-key-dict-comprehension,RUF012	mutable-class-default,RUF013	implicit-optional,RUF015	unnecessary-iterable-allocation-for-first-element,RUF016	invalid-index-type,RUF017	quadratic-list-summation,RUF018	assignment-in-assert,RUF019	unnecessary-key-check,RUF020	never-union,RUF021	parenthesize-chained-operators,RUF022	unsorted-dunder-all,RUF100	unused-noqa,RUF200	invalid-pyproject-toml,TRY002	raise-vanilla-class,TRY003	raise-vanilla-args,TRY004	type-check-without-type-error,TRY200	reraise-no-cause,TRY201	verbose-raise,TRY300	try-consider-else,TRY301	raise-within-try,TRY302	useless-try-except,TRY400	error-instead-of-exception,TRY401	verbose-log-message}"
complete -c ruff -n "__fish_seen_subcommand_from check" -l per-file-ignores -d 'List of mappings from file pattern to code to exclude' -r
complete -c ruff -n "__fish_seen_subcommand_from check" -l extend-per-file-ignores -d 'Like `--per-file-ignores`, but adds additional ignores on top of those already specified' -r
complete -c ruff -n "__fish_seen_subcommand_from check" -l exclude -d 'List of paths, used to omit files and/or directories from analysis' -r
complete -c ruff -n "__fish_seen_subcommand_from check" -l extend-exclude -d 'Like --exclude, but adds additional files and directories on top of those already excluded' -r
complete -c ruff -n "__fish_seen_subcommand_from check" -l fixable -d 'List of rule codes to treat as eligible for fix. Only applicable when fix itself is enabled (e.g., via `--fix`)' -r -f -a "{ALL	all rules,F	Pyflakes,C90	mccabe,I	isort,N	pep8-naming,D	pydocstyle,UP	pyupgrade,YTT	flake8-2020,ANN	flake8-annotations,ASYNC	flake8-async,TRIO	flake8-trio,S	flake8-bandit,BLE	flake8-blind-except,FBT	flake8-boolean-trap,B	flake8-bugbear,A	flake8-builtins,COM	flake8-commas,CPY	flake8-copyright,C4	flake8-comprehensions,DTZ	flake8-datetimez,T10	flake8-debugger,DJ	flake8-django,EM	flake8-errmsg,EXE	flake8-executable,FA	flake8-future-annotations,ISC	flake8-implicit-str-concat,ICN	flake8-import-conventions,G	flake8-logging-format,INP	flake8-no-pep420,PIE	flake8-pie,T20	flake8-print,PYI	flake8-pyi,PT	flake8-pytest-style,Q	flake8-quotes,RSE	flake8-raise,RET	flake8-return,SLF	flake8-self,SLOT	flake8-slots,SIM	flake8-simplify,TID	flake8-tidy-imports,TCH	flake8-type-checking,INT	flake8-gettext,ARG	flake8-unused-arguments,PTH	flake8-use-pathlib,TD	flake8-todos,FIX	flake8-fixme,ERA	eradicate,PD	pandas-vet,PGH	pygrep-hooks,PL	Pylint,TRY	tryceratops,FLY	flynt,NPY	NumPy-specific rules,AIR	Airflow,PERF	Perflint,FURB	refurb,LOG	flake8-logging,RUF	Ruff-specific rules,AIR001	airflow-variable-name-task-id-mismatch,ERA001	commented-out-code,YTT101	sys-version-slice3,YTT102	sys-version2,YTT103	sys-version-cmp-str3,YTT201	sys-version-info0-eq3,YTT202	six-py3,YTT203	sys-version-info1-cmp-int,YTT204	sys-version-info-minor-cmp-int,YTT301	sys-version0,YTT302	sys-version-cmp-str10,YTT303	sys-version-slice1,ANN001	missing-type-function-argument,ANN002	missing-type-args,ANN003	missing-type-kwargs,ANN101	missing-type-self,ANN102	missing-type-cls,ANN201	missing-return-type-undocumented-public-function,ANN202	missing-return-type-private-function,ANN204	missing-return-type-special-method,ANN205	missing-return-type-static-method,ANN206	missing-return-type-class-method,ANN401	any-type,ASYNC100	blocking-http-call-in-async-function,ASYNC101	open-sleep-or-subprocess-in-async-function,ASYNC102	blocking-os-call-in-async-function,S101	assert,S102	exec-builtin,S103	bad-file-permissions,S104	hardcoded-bind-all-interfaces,S105	hardcoded-password-string,S106	hardcoded-password-func-arg,S107	hardcoded-password-default,S108	hardcoded-temp-file,S110	try-except-pass,S112	try-except-continue,S113	request-without-timeout,S201	flask-debug-true,S202	tarfile-unsafe-members,S301	suspicious-pickle-usage,S302	suspicious-marshal-usage,S303	suspicious-insecure-hash-usage,S304	suspicious-insecure-cipher-usage,S305	suspicious-insecure-cipher-mode-usage,S306	suspicious-mktemp-usage,S307	suspicious-eval-usage,S308	suspicious-mark-safe-usage,S310	suspicious-url-open-usage,S311	suspicious-non-cryptographic-random-usage,S312	suspicious-telnet-usage,S313	suspicious-xmlc-element-tree-usage,S314	suspicious-xml-element-tree-usage,S315	suspicious-xml-expat-reader-usage,S316	suspicious-xml-expat-builder-usage,S317	suspicious-xml-sax-usage,S318	suspicious-xml-mini-dom-usage,S319	suspicious-xml-pull-dom-usage,S320	suspicious-xmle-tree-usage,S321	suspicious-ftp-lib-usage,S323	suspicious-unverified-context-usage,S324	hashlib-insecure-hash-function,S401	suspicious-telnetlib-import,S402	suspicious-ftplib-import,S403	suspicious-pickle-import,S404	suspicious-subprocess-import,S405	suspicious-xml-etree-import,S406	suspicious-xml-sax-import,S407	suspicious-xml-expat-import,S408	suspicious-xml-minidom-import,S409	suspicious-xml-pulldom-import,S410	suspicious-lxml-import,S411	suspicious-xmlrpc-import,S412	suspicious-httpoxy-import,S413	suspicious-pycrypto-import,S415	suspicious-pyghmi-import,S501	request-with-no-cert-validation,S502	ssl-insecure-version,S503	ssl-with-bad-defaults,S504	ssl-with-no-version,S505	weak-cryptographic-key,S506	unsafe-yaml-load,S507	ssh-no-host-key-verification,S508	snmp-insecure-version,S509	snmp-weak-cryptography,S601	paramiko-call,S602	subprocess-popen-with-shell-equals-true,S603	subprocess-without-shell-equals-true,S604	call-with-shell-equals-true,S605	start-process-with-a-shell,S606	start-process-with-no-shell,S607	start-process-with-partial-path,S608	hardcoded-sql-expression,S609	unix-command-wildcard-injection,S611	django-raw-sql,S612	logging-config-insecure-listen,S701	jinja2-autoescape-false,S702	mako-templates,BLE001	blind-except,FBT001	boolean-type-hint-positional-argument,FBT002	boolean-default-value-positional-argument,FBT003	boolean-positional-value-in-call,B002	unary-prefix-increment-decrement,B003	assignment-to-os-environ,B004	unreliable-callable-check,B005	strip-with-multi-characters,B006	mutable-argument-default,B007	unused-loop-control-variable,B008	function-call-in-default-argument,B009	get-attr-with-constant,B010	set-attr-with-constant,B011	assert-false,B012	jump-statement-in-finally,B013	redundant-tuple-in-exception-handler,B014	duplicate-handler-exception,B015	useless-comparison,B016	raise-literal,B017	assert-raises-exception,B018	useless-expression,B019	cached-instance-method,B020	loop-variable-overrides-iterator,B021	f-string-docstring,B022	useless-contextlib-suppress,B023	function-uses-loop-variable,B024	abstract-base-class-without-abstract-method,B025	duplicate-try-block-exception,B026	star-arg-unpacking-after-keyword-arg,B027	empty-method-without-abstract-decorator,B028	no-explicit-stacklevel,B029	except-with-empty-tuple,B030	except-with-non-exception-classes,B031	reuse-of-groupby-generator,B032	unintentional-type-annotation,B033	duplicate-value,B034	re-sub-positional-args,B904	raise-without-from-inside-except,B905	zip-without-explicit-strict,A001	builtin-variable-shadowing,A002	builtin-argument-shadowing,A003	builtin-attribute-shadowing,COM812	missing-trailing-comma,COM818	trailing-comma-on-bare-tuple,COM819	prohibited-trailing-comma,C400	unnecessary-generator-list,C401	unnecessary-generator-set,C402	unnecessary-generator-dict,C403	unnecessary-list-comprehension-set,C404	unnecessary-list-comprehension-dict,C405	unnecessary-literal-set,C406	unnecessary-literal-dict,C408	unnecessary-collection-call,C409	unnecessary-literal-within-tuple-call,C410	unnecessary-literal-within-list-call,C411	unnecessary-list-call,C413	unnecessary-call-around-sorted,C414	unnecessary-double-cast-or-process,C415	unnecessary-subscript-reversal,C416	unnecessary-comprehension,C417	unnecessary-map,C418	unnecessary-literal-within-dict-call,C419	unnecessary-comprehension-any-all,CPY001	missing-copyright-notice,DTZ001	call-datetime-without-tzinfo,DTZ002	call-datetime-today,DTZ003	call-datetime-utcnow,DTZ004	call-datetime-utcfromtimestamp,DTZ005	call-datetime-now-without-tzinfo,DTZ006	call-datetime-fromtimestamp,DTZ007	call-datetime-strptime-without-zone,DTZ011	call-date-today,DTZ012	call-date-fromtimestamp,T100	debugger,DJ001	django-nullable-model-string-field,DJ003	django-locals-in-render-function,DJ006	django-exclude-with-model-form,DJ007	django-all-with-model-form,DJ008	django-model-without-dunder-str,DJ012	django-unordered-body-content-in-model,DJ013	django-non-leading-receiver-decorator,EM101	raw-string-in-exception,EM102	f-string-in-exception,EM103	dot-format-in-exception,EXE001	shebang-not-executable,EXE002	shebang-missing-executable-file,EXE003	shebang-missing-python,EXE004	shebang-leading-whitespace,EXE005	shebang-not-first-line,FIX001	line-contains-fixme,FIX002	line-contains-todo,FIX003	line-contains-xxx,FIX004	line-contains-hack,FA100	future-rewritable-type-annotation,FA102	future-required-type-annotation,INT001	f-string-in-get-text-func-call,INT002	format-in-get-text-func-call,INT003	printf-in-get-text-func-call,ISC001	single-line-implicit-string-concatenation,ISC002	multi-line-implicit-string-concatenation,ISC003	explicit-string-concatenation,ICN001	unconventional-import-alias,ICN002	banned-import-alias,ICN003	banned-import-from,LOG001	direct-logger-instantiation,LOG002	invalid-get-logger-argument,LOG007	exception-without-exc-info,LOG009	undocumented-warn,G001	logging-string-format,G002	logging-percent-format,G003	logging-string-concat,G004	logging-f-string,G010	logging-warn,G101	logging-extra-attr-clash,G201	logging-exc-info,G202	logging-redundant-exc-info,INP001	implicit-namespace-package,PIE790	unnecessary-placeholder,PIE794	duplicate-class-field-definition,PIE796	non-unique-enums,PIE800	unnecessary-spread,PIE804	unnecessary-dict-kwargs,PIE807	reimplemented-container-builtin,PIE808	unnecessary-range-start,PIE810	multiple-starts-ends-with,T201	print,T203	p-print,PYI001	unprefixed-type-param,PYI002	complex-if-statement-in-stub,PYI003	unrecognized-version-info-check,PYI004	patch-version-comparison,PYI005	wrong-tuple-length-version-comparison,PYI006	bad-version-info-comparison,PYI007	unrecognized-platform-check,PYI008	unrecognized-platform-name,PYI009	pass-statement-stub-body,PYI010	non-empty-stub-body,PYI011	typed-argument-default-in-stub,PYI012	pass-in-class-body,PYI013	ellipsis-in-non-empty-class-body,PYI014	argument-default-in-stub,PYI015	assignment-default-in-stub,PYI016	duplicate-union-member,PYI017	complex-assignment-in-stub,PYI018	unused-private-type-var,PYI019	custom-type-var-return-type,PYI020	quoted-annotation-in-stub,PYI021	docstring-in-stub,PYI024	collections-named-tuple,PYI025	unaliased-collections-abc-set-import,PYI026	type-alias-without-annotation,PYI029	str-or-repr-defined-in-stub,PYI030	unnecessary-literal-union,PYI032	any-eq-ne-annotation,PYI033	type-comment-in-stub,PYI034	non-self-return-type,PYI035	unassigned-special-variable-in-stub,PYI036	bad-exit-annotation,PYI041	redundant-numeric-union,PYI042	snake-case-type-alias,PYI043	t-suffixed-type-alias,PYI044	future-annotations-in-stub,PYI045	iter-method-return-iterable,PYI046	unused-private-protocol,PYI047	unused-private-type-alias,PYI048	stub-body-multiple-statements,PYI049	unused-private-typed-dict,PYI050	no-return-argument-annotation-in-stub,PYI051	redundant-literal-union,PYI052	unannotated-assignment-in-stub,PYI053	string-or-bytes-too-long,PYI054	numeric-literal-too-long,PYI055	unnecessary-type-union,PYI056	unsupported-method-call-on-all,PYI058	generator-return-from-iter-method,PT001	pytest-fixture-incorrect-parentheses-style,PT002	pytest-fixture-positional-args,PT003	pytest-extraneous-scope-function,PT004	pytest-missing-fixture-name-underscore,PT005	pytest-incorrect-fixture-name-underscore,PT006	pytest-parametrize-names-wrong-type,PT007	pytest-parametrize-values-wrong-type,PT008	pytest-patch-with-lambda,PT009	pytest-unittest-assertion,PT010	pytest-raises-without-exception,PT011	pytest-raises-too-broad,PT012	pytest-raises-with-multiple-statements,PT013	pytest-incorrect-pytest-import,PT014	pytest-duplicate-parametrize-test-cases,PT015	pytest-assert-always-false,PT016	pytest-fail-without-message,PT017	pytest-assert-in-except,PT018	pytest-composite-assertion,PT019	pytest-fixture-param-without-value,PT020	pytest-deprecated-yield-fixture,PT021	pytest-fixture-finalizer-callback,PT022	pytest-useless-yield-fixture,PT023	pytest-incorrect-mark-parentheses-style,PT024	pytest-unnecessary-asyncio-mark-on-fixture,PT025	pytest-erroneous-use-fixtures-on-fixture,PT026	pytest-use-fixtures-without-parameters,PT027	pytest-unittest-raises-assertion,Q000	bad-quotes-inline-string,Q001	bad-quotes-multiline-string,Q002	bad-quotes-docstring,Q003	avoidable-escaped-quote,Q004	unnecessary-escaped-quote,RSE102	unnecessary-paren-on-raise-exception,RET501	unnecessary-return-none,RET502	implicit-return-value,RET503	implicit-return,RET504	unnecessary-assign,RET505	superfluous-else-return,RET506	superfluous-else-raise,RET507	superfluous-else-continue,RET508	superfluous-else-break,SLF001	private-member-access,SIM101	duplicate-isinstance-call,SIM102	collapsible-if,SIM103	needless-bool,SIM105	suppressible-exception,SIM107	return-in-try-except-finally,SIM108	if-else-block-instead-of-if-exp,SIM109	compare-with-tuple,SIM110	reimplemented-builtin,SIM112	uncapitalized-environment-variables,SIM113	enumerate-for-loop,SIM114	if-with-same-arms,SIM115	open-file-with-context-handler,SIM116	if-else-block-instead-of-dict-lookup,SIM117	multiple-with-statements,SIM118	in-dict-keys,SIM201	negate-equal-op,SIM202	negate-not-equal-op,SIM208	double-negation,SIM210	if-expr-with-true-false,SIM211	if-expr-with-false-true,SIM212	if-expr-with-twisted-arms,SIM220	expr-and-not-expr,SIM221	expr-or-not-expr,SIM222	expr-or-true,SIM223	expr-and-false,SIM300	yoda-conditions,SIM401	if-else-block-instead-of-dict-get,SIM910	dict-get-with-none-default,SIM911	zip-dict-keys-and-values,SLOT000	no-slots-in-str-subclass,SLOT001	no-slots-in-tuple-subclass,SLOT002	no-slots-in-namedtuple-subclass,TID251	banned-api,TID252	relative-imports,TID253	banned-module-level-imports,TD001	invalid-todo-tag,TD002	missing-todo-author,TD003	missing-todo-link,TD004	missing-todo-colon,TD005	missing-todo-description,TD006	invalid-todo-capitalization,TD007	missing-space-after-todo-colon,TRIO100	trio-timeout-without-await,TRIO105	trio-sync-call,TRIO109	trio-async-function-with-timeout,TRIO110	trio-unneeded-sleep,TRIO115	trio-zero-sleep-call,TCH001	typing-only-first-party-import,TCH002	typing-only-third-party-import,TCH003	typing-only-standard-library-import,TCH004	runtime-import-in-type-checking-block,TCH005	empty-type-checking-block,TCH006	runtime-string-union,ARG001	unused-function-argument,ARG002	unused-method-argument,ARG003	unused-class-method-argument,ARG004	unused-static-method-argument,ARG005	unused-lambda-argument,PTH100	os-path-abspath,PTH101	os-chmod,PTH102	os-mkdir,PTH103	os-makedirs,PTH104	os-rename,PTH105	os-replace,PTH106	os-rmdir,PTH107	os-remove,PTH108	os-unlink,PTH109	os-getcwd,PTH110	os-path-exists,PTH111	os-path-expanduser,PTH112	os-path-isdir,PTH113	os-path-isfile,PTH114	os-path-islink,PTH115	os-readlink,PTH116	os-stat,PTH117	os-path-isabs,PTH118	os-path-join,PTH119	os-path-basename,PTH120	os-path-dirname,PTH121	os-path-samefile,PTH122	os-path-splitext,PTH123	builtin-open,PTH124	py-path,PTH201	path-constructor-current-directory,PTH202	os-path-getsize,PTH203	os-path-getatime,PTH204	os-path-getmtime,PTH205	os-path-getctime,PTH206	os-sep-split,PTH207	glob,FLY002	static-join-to-f-string,I001	unsorted-imports,I002	missing-required-import,C901	complex-structure,NPY001	numpy-deprecated-type-alias,NPY002	numpy-legacy-random,NPY003	numpy-deprecated-function,NPY201	numpy2-deprecation,N801	invalid-class-name,N802	invalid-function-name,N803	invalid-argument-name,N804	invalid-first-argument-name-for-class-method,N805	invalid-first-argument-name-for-method,N806	non-lowercase-variable-in-function,N807	dunder-function-name,N811	constant-imported-as-non-constant,N812	lowercase-imported-as-non-lowercase,N813	camelcase-imported-as-lowercase,N814	camelcase-imported-as-constant,N815	mixed-case-variable-in-class-scope,N816	mixed-case-variable-in-global-scope,N817	camelcase-imported-as-acronym,N818	error-suffix-on-exception-name,N999	invalid-module-name,PD002	pandas-use-of-inplace-argument,PD003	pandas-use-of-dot-is-null,PD004	pandas-use-of-dot-not-null,PD007	pandas-use-of-dot-ix,PD008	pandas-use-of-dot-at,PD009	pandas-use-of-dot-iat,PD010	pandas-use-of-dot-pivot-or-unstack,PD011	pandas-use-of-dot-values,PD012	pandas-use-of-dot-read-table,PD013	pandas-use-of-dot-stack,PD015	pandas-use-of-pd-merge,PD101	pandas-nunique-constant-series-check,PD901	pandas-df-variable-name,PERF101	unnecessary-list-cast,PERF102	incorrect-dict-iterator,PERF203	try-except-in-loop,PERF401	manual-list-comprehension,PERF402	manual-list-copy,PERF403	manual-dict-comprehension,E101	mixed-spaces-and-tabs,E111	indentation-with-invalid-multiple,E112	no-indented-block,E113	unexpected-indentation,E114	indentation-with-invalid-multiple-comment,E115	no-indented-block-comment,E116	unexpected-indentation-comment,E117	over-indented,E201	whitespace-after-open-bracket,E202	whitespace-before-close-bracket,E203	whitespace-before-punctuation,E211	whitespace-before-parameters,E221	multiple-spaces-before-operator,E222	multiple-spaces-after-operator,E223	tab-before-operator,E224	tab-after-operator,E225	missing-whitespace-around-operator,E226	missing-whitespace-around-arithmetic-operator,E227	missing-whitespace-around-bitwise-or-shift-operator,E228	missing-whitespace-around-modulo-operator,E231	missing-whitespace,E241	multiple-spaces-after-comma,E242	tab-after-comma,E251	unexpected-spaces-around-keyword-parameter-equals,E252	missing-whitespace-around-parameter-equals,E261	too-few-spaces-before-inline-comment,E262	no-space-after-inline-comment,E265	no-space-after-block-comment,E266	multiple-leading-hashes-for-block-comment,E271	multiple-spaces-after-keyword,E272	multiple-spaces-before-keyword,E273	tab-after-keyword,E274	tab-before-keyword,E275	missing-whitespace-after-keyword,E401	multiple-imports-on-one-line,E402	module-import-not-at-top-of-file,E501	line-too-long,E701	multiple-statements-on-one-line-colon,E702	multiple-statements-on-one-line-semicolon,E703	useless-semicolon,E711	none-comparison,E712	true-false-comparison,E713	not-in-test,E714	not-is-test,E721	type-comparison,E722	bare-except,E731	lambda-assignment,E741	ambiguous-variable-name,E742	ambiguous-class-name,E743	ambiguous-function-name,E902	io-error,E999	syntax-error,W191	tab-indentation,W291	trailing-whitespace,W292	missing-newline-at-end-of-file,W293	blank-line-with-whitespace,W505	doc-line-too-long,W605	invalid-escape-sequence,D100	undocumented-public-module,D101	undocumented-public-class,D102	undocumented-public-method,D103	undocumented-public-function,D104	undocumented-public-package,D105	undocumented-magic-method,D106	undocumented-public-nested-class,D107	undocumented-public-init,D200	fits-on-one-line,D201	no-blank-line-before-function,D202	no-blank-line-after-function,D203	one-blank-line-before-class,D204	one-blank-line-after-class,D205	blank-line-after-summary,D206	indent-with-spaces,D207	under-indentation,D208	over-indentation,D209	new-line-after-last-paragraph,D210	surrounding-whitespace,D211	blank-line-before-class,D212	multi-line-summary-first-line,D213	multi-line-summary-second-line,D214	section-not-over-indented,D215	section-underline-not-over-indented,D300	triple-single-quotes,D301	escape-sequence-in-docstring,D400	ends-in-period,D401	non-imperative-mood,D402	no-signature,D403	first-line-capitalized,D404	docstring-starts-with-this,D405	capitalize-section-name,D406	new-line-after-section-name,D407	dashed-underline-after-section,D408	section-underline-after-name,D409	section-underline-matches-section-length,D410	no-blank-line-after-section,D411	no-blank-line-before-section,D412	blank-lines-between-header-and-content,D413	blank-line-after-last-section,D414	empty-docstring-section,D415	ends-in-punctuation,D416	section-name-ends-in-colon,D417	undocumented-param,D418	overload-with-docstring,D419	empty-docstring,F401	unused-import,F402	import-shadowed-by-loop-var,F403	undefined-local-with-import-star,F404	late-future-import,F405	undefined-local-with-import-star-usage,F406	undefined-local-with-nested-import-star-usage,F407	future-feature-not-defined,F501	percent-format-invalid-format,F502	percent-format-expected-mapping,F503	percent-format-expected-sequence,F504	percent-format-extra-named-arguments,F505	percent-format-missing-argument,F506	percent-format-mixed-positional-and-named,F507	percent-format-positional-count-mismatch,F508	percent-format-star-requires-sequence,F509	percent-format-unsupported-format-character,F521	string-dot-format-invalid-format,F522	string-dot-format-extra-named-arguments,F523	string-dot-format-extra-positional-arguments,F524	string-dot-format-missing-arguments,F525	string-dot-format-mixing-automatic,F541	f-string-missing-placeholders,F601	multi-value-repeated-key-literal,F602	multi-value-repeated-key-variable,F621	expressions-in-star-assignment,F622	multiple-starred-expressions,F631	assert-tuple,F632	is-literal,F633	invalid-print-syntax,F634	if-tuple,F701	break-outside-loop,F702	continue-outside-loop,F704	yield-outside-function,F706	return-outside-function,F707	default-except-not-last,F722	forward-annotation-syntax-error,F811	redefined-while-unused,F821	undefined-name,F822	undefined-export,F823	undefined-local,F841	unused-variable,F842	unused-annotation,F901	raise-not-implemented,PGH001	eval,PGH002	deprecated-log-warn,PGH003	blanket-type-ignore,PGH004	blanket-noqa,PGH005	invalid-mock-access,PLC0105	type-name-incorrect-variance,PLC0131	type-bivariance,PLC0132	type-param-name-mismatch,PLC0205	single-string-slots,PLC0208	iteration-over-set,PLC0414	useless-import-alias,PLC0415	import-outside-top-level,PLC1901	compare-to-empty-string,PLC2401	non-ascii-name,PLC2403	non-ascii-import-name,PLC2701	import-private-name,PLC2801	unnecessary-dunder-call,PLC3002	unnecessary-direct-lambda-call,PLE0100	yield-in-init,PLE0101	return-in-init,PLE0116	continue-in-finally,PLE0117	nonlocal-without-binding,PLE0118	load-before-global-declaration,PLE0241	duplicate-bases,PLE0302	unexpected-special-method-signature,PLE0307	invalid-str-return-type,PLE0604	invalid-all-object,PLE0605	invalid-all-format,PLE0704	misplaced-bare-raise,PLE1132	repeated-keyword-argument,PLE1142	await-outside-async,PLE1205	logging-too-many-args,PLE1206	logging-too-few-args,PLE1300	bad-string-format-character,PLE1307	bad-string-format-type,PLE1310	bad-str-strip-call,PLE1507	invalid-envvar-value,PLE1700	yield-from-in-async-function,PLE2502	bidirectional-unicode,PLE2510	invalid-character-backspace,PLE2512	invalid-character-sub,PLE2513	invalid-character-esc,PLE2514	invalid-character-nul,PLE2515	invalid-character-zero-width-space,PLR0124	comparison-with-itself,PLR0133	comparison-of-constant,PLR0202	no-classmethod-decorator,PLR0203	no-staticmethod-decorator,PLR0206	property-with-parameters,PLR0402	manual-from-import,PLR0904	too-many-public-methods,PLR0911	too-many-return-statements,PLR0912	too-many-branches,PLR0913	too-many-arguments,PLR0914	too-many-locals,PLR0915	too-many-statements,PLR0916	too-many-boolean-expressions,PLR0917	too-many-positional,PLR1701	repeated-isinstance-calls,PLR1704	redefined-argument-from-local,PLR1706	and-or-ternary,PLR1711	useless-return,PLR1714	repeated-equality-comparison,PLR1722	sys-exit-alias,PLR1733	unnecessary-dict-index-lookup,PLR1736	unnecessary-list-index-lookup,PLR2004	magic-value-comparison,PLR2044	empty-comment,PLR5501	collapsible-else-if,PLR6201	literal-membership,PLR6301	no-self-use,PLW0108	unnecessary-lambda,PLW0120	useless-else-on-loop,PLW0127	self-assigning-variable,PLW0129	assert-on-string-literal,PLW0131	named-expr-without-context,PLW0245	super-without-brackets,PLW0406	import-self,PLW0602	global-variable-not-assigned,PLW0603	global-statement,PLW0604	global-at-module-level,PLW0711	binary-op-exception,PLW1501	bad-open-mode,PLW1508	invalid-envvar-default,PLW1509	subprocess-popen-preexec-fn,PLW1510	subprocess-run-without-check,PLW1514	unspecified-encoding,PLW1641	eq-without-hash,PLW2101	useless-with-lock,PLW2901	redefined-loop-name,PLW3201	bad-dunder-method-name,PLW3301	nested-min-max,UP001	useless-metaclass-type,UP003	type-of-primitive,UP004	useless-object-inheritance,UP005	deprecated-unittest-alias,UP006	non-pep585-annotation,UP007	non-pep604-annotation,UP008	super-call-with-parameters,UP009	utf8-encoding-declaration,UP010	unnecessary-future-import,UP011	lru-cache-without-parameters,UP012	unnecessary-encode-utf8,UP013	convert-typed-dict-functional-to-class,UP014	convert-named-tuple-functional-to-class,UP015	redundant-open-modes,UP017	datetime-timezone-utc,UP018	native-literals,UP019	typing-text-str-alias,UP020	open-alias,UP021	replace-universal-newlines,UP022	replace-stdout-stderr,UP023	deprecated-c-element-tree,UP024	os-error-alias,UP025	unicode-kind-prefix,UP026	deprecated-mock-import,UP027	unpacked-list-comprehension,UP028	yield-in-for-loop,UP029	unnecessary-builtin-import,UP030	format-literals,UP031	printf-string-formatting,UP032	f-string,UP033	lru-cache-with-maxsize-none,UP034	extraneous-parentheses,UP035	deprecated-import,UP036	outdated-version-block,UP037	quoted-annotation,UP038	non-pep604-isinstance,UP039	unnecessary-class-parentheses,UP040	non-pep695-type-alias,UP041	timeout-error-alias,FURB101	read-whole-file,FURB105	print-empty-string,FURB113	repeated-append,FURB118	reimplemented-operator,FURB131	delete-full-slice,FURB132	check-and-remove-from-set,FURB136	if-expr-min-max,FURB140	reimplemented-starmap,FURB145	slice-copy,FURB148	unnecessary-enumerate,FURB152	math-constant,FURB161	bit-count,FURB163	redundant-log-base,FURB167	regex-flag-alias,FURB168	isinstance-type-none,FURB169	type-none-comparison,FURB171	single-item-membership-test,FURB177	implicit-cwd,FURB181	hashlib-digest-hex,RUF001	ambiguous-unicode-character-string,RUF002	ambiguous-unicode-character-docstring,RUF003	ambiguous-unicode-character-comment,RUF005	collection-literal-concatenation,RUF006	asyncio-dangling-task,RUF007	pairwise-over-zipped,RUF008	mutable-dataclass-default,RUF009	function-call-in-dataclass-default-argument,RUF010	explicit-f-string-type-conversion,RUF011	static-key-dict-comprehension,RUF012	mutable-class-default,RUF013	implicit-optional,RUF015	unnecessary-iterable-allocation-for-first-element,RUF016	invalid-index-type,RUF017	quadratic-list-summation,RUF018	assignment-in-assert,RUF019	unnecessary-key-check,RUF020	never-union,RUF021	parenthesize-chained-operators,RUF022	unsorted-dunder-all,RUF100	unused-noqa,RUF200	invalid-pyproject-toml,TRY002	raise-vanilla-class,TRY003	raise-vanilla-args,TRY004	type-check-without-type-error,TRY200	reraise-no-cause,TRY201	verbose-raise,TRY300	try-consider-else,TRY301	raise-within-try,TRY302	useless-try-except,TRY400	error-instead-of-exception,TRY401	verbose-log-message}"
complete -c ruff -n "__fish_seen_subcommand_from check" -l unfixable -d 'List of rule codes to treat as ineligible for fix. Only applicable when fix itself is enabled (e.g., via `--fix`)' -r -f -a "{ALL	all rules,F	Pyflakes,C90	mccabe,I	isort,N	pep8-naming,D	pydocstyle,UP	pyupgrade,YTT	flake8-2020,ANN	flake8-annotations,ASYNC	flake8-async,TRIO	flake8-trio,S	flake8-bandit,BLE	flake8-blind-except,FBT	flake8-boolean-trap,B	flake8-bugbear,A	flake8-builtins,COM	flake8-commas,CPY	flake8-copyright,C4	flake8-comprehensions,DTZ	flake8-datetimez,T10	flake8-debugger,DJ	flake8-django,EM	flake8-errmsg,EXE	flake8-executable,FA	flake8-future-annotations,ISC	flake8-implicit-str-concat,ICN	flake8-import-conventions,G	flake8-logging-format,INP	flake8-no-pep420,PIE	flake8-pie,T20	flake8-print,PYI	flake8-pyi,PT	flake8-pytest-style,Q	flake8-quotes,RSE	flake8-raise,RET	flake8-return,SLF	flake8-self,SLOT	flake8-slots,SIM	flake8-simplify,TID	flake8-tidy-imports,TCH	flake8-type-checking,INT	flake8-gettext,ARG	flake8-unused-arguments,PTH	flake8-use-pathlib,TD	flake8-todos,FIX	flake8-fixme,ERA	eradicate,PD	pandas-vet,PGH	pygrep-hooks,PL	Pylint,TRY	tryceratops,FLY	flynt,NPY	NumPy-specific rules,AIR	Airflow,PERF	Perflint,FURB	refurb,LOG	flake8-logging,RUF	Ruff-specific rules,AIR001	airflow-variable-name-task-id-mismatch,ERA001	commented-out-code,YTT101	sys-version-slice3,YTT102	sys-version2,YTT103	sys-version-cmp-str3,YTT201	sys-version-info0-eq3,YTT202	six-py3,YTT203	sys-version-info1-cmp-int,YTT204	sys-version-info-minor-cmp-int,YTT301	sys-version0,YTT302	sys-version-cmp-str10,YTT303	sys-version-slice1,ANN001	missing-type-function-argument,ANN002	missing-type-args,ANN003	missing-type-kwargs,ANN101	missing-type-self,ANN102	missing-type-cls,ANN201	missing-return-type-undocumented-public-function,ANN202	missing-return-type-private-function,ANN204	missing-return-type-special-method,ANN205	missing-return-type-static-method,ANN206	missing-return-type-class-method,ANN401	any-type,ASYNC100	blocking-http-call-in-async-function,ASYNC101	open-sleep-or-subprocess-in-async-function,ASYNC102	blocking-os-call-in-async-function,S101	assert,S102	exec-builtin,S103	bad-file-permissions,S104	hardcoded-bind-all-interfaces,S105	hardcoded-password-string,S106	hardcoded-password-func-arg,S107	hardcoded-password-default,S108	hardcoded-temp-file,S110	try-except-pass,S112	try-except-continue,S113	request-without-timeout,S201	flask-debug-true,S202	tarfile-unsafe-members,S301	suspicious-pickle-usage,S302	suspicious-marshal-usage,S303	suspicious-insecure-hash-usage,S304	suspicious-insecure-cipher-usage,S305	suspicious-insecure-cipher-mode-usage,S306	suspicious-mktemp-usage,S307	suspicious-eval-usage,S308	suspicious-mark-safe-usage,S310	suspicious-url-open-usage,S311	suspicious-non-cryptographic-random-usage,S312	suspicious-telnet-usage,S313	suspicious-xmlc-element-tree-usage,S314	suspicious-xml-element-tree-usage,S315	suspicious-xml-expat-reader-usage,S316	suspicious-xml-expat-builder-usage,S317	suspicious-xml-sax-usage,S318	suspicious-xml-mini-dom-usage,S319	suspicious-xml-pull-dom-usage,S320	suspicious-xmle-tree-usage,S321	suspicious-ftp-lib-usage,S323	suspicious-unverified-context-usage,S324	hashlib-insecure-hash-function,S401	suspicious-telnetlib-import,S402	suspicious-ftplib-import,S403	suspicious-pickle-import,S404	suspicious-subprocess-import,S405	suspicious-xml-etree-import,S406	suspicious-xml-sax-import,S407	suspicious-xml-expat-import,S408	suspicious-xml-minidom-import,S409	suspicious-xml-pulldom-import,S410	suspicious-lxml-import,S411	suspicious-xmlrpc-import,S412	suspicious-httpoxy-import,S413	suspicious-pycrypto-import,S415	suspicious-pyghmi-import,S501	request-with-no-cert-validation,S502	ssl-insecure-version,S503	ssl-with-bad-defaults,S504	ssl-with-no-version,S505	weak-cryptographic-key,S506	unsafe-yaml-load,S507	ssh-no-host-key-verification,S508	snmp-insecure-version,S509	snmp-weak-cryptography,S601	paramiko-call,S602	subprocess-popen-with-shell-equals-true,S603	subprocess-without-shell-equals-true,S604	call-with-shell-equals-true,S605	start-process-with-a-shell,S606	start-process-with-no-shell,S607	start-process-with-partial-path,S608	hardcoded-sql-expression,S609	unix-command-wildcard-injection,S611	django-raw-sql,S612	logging-config-insecure-listen,S701	jinja2-autoescape-false,S702	mako-templates,BLE001	blind-except,FBT001	boolean-type-hint-positional-argument,FBT002	boolean-default-value-positional-argument,FBT003	boolean-positional-value-in-call,B002	unary-prefix-increment-decrement,B003	assignment-to-os-environ,B004	unreliable-callable-check,B005	strip-with-multi-characters,B006	mutable-argument-default,B007	unused-loop-control-variable,B008	function-call-in-default-argument,B009	get-attr-with-constant,B010	set-attr-with-constant,B011	assert-false,B012	jump-statement-in-finally,B013	redundant-tuple-in-exception-handler,B014	duplicate-handler-exception,B015	useless-comparison,B016	raise-literal,B017	assert-raises-exception,B018	useless-expression,B019	cached-instance-method,B020	loop-variable-overrides-iterator,B021	f-string-docstring,B022	useless-contextlib-suppress,B023	function-uses-loop-variable,B024	abstract-base-class-without-abstract-method,B025	duplicate-try-block-exception,B026	star-arg-unpacking-after-keyword-arg,B027	empty-method-without-abstract-decorator,B028	no-explicit-stacklevel,B029	except-with-empty-tuple,B030	except-with-non-exception-classes,B031	reuse-of-groupby-generator,B032	unintentional-type-annotation,B033	duplicate-value,B034	re-sub-positional-args,B904	raise-without-from-inside-except,B905	zip-without-explicit-strict,A001	builtin-variable-shadowing,A002	builtin-argument-shadowing,A003	builtin-attribute-shadowing,COM812	missing-trailing-comma,COM818	trailing-comma-on-bare-tuple,COM819	prohibited-trailing-comma,C400	unnecessary-generator-list,C401	unnecessary-generator-set,C402	unnecessary-generator-dict,C403	unnecessary-list-comprehension-set,C404	unnecessary-list-comprehension-dict,C405	unnecessary-literal-set,C406	unnecessary-literal-dict,C408	unnecessary-collection-call,C409	unnecessary-literal-within-tuple-call,C410	unnecessary-literal-within-list-call,C411	unnecessary-list-call,C413	unnecessary-call-around-sorted,C414	unnecessary-double-cast-or-process,C415	unnecessary-subscript-reversal,C416	unnecessary-comprehension,C417	unnecessary-map,C418	unnecessary-literal-within-dict-call,C419	unnecessary-comprehension-any-all,CPY001	missing-copyright-notice,DTZ001	call-datetime-without-tzinfo,DTZ002	call-datetime-today,DTZ003	call-datetime-utcnow,DTZ004	call-datetime-utcfromtimestamp,DTZ005	call-datetime-now-without-tzinfo,DTZ006	call-datetime-fromtimestamp,DTZ007	call-datetime-strptime-without-zone,DTZ011	call-date-today,DTZ012	call-date-fromtimestamp,T100	debugger,DJ001	django-nullable-model-string-field,DJ003	django-locals-in-render-function,DJ006	django-exclude-with-model-form,DJ007	django-all-with-model-form,DJ008	django-model-without-dunder-str,DJ012	django-unordered-body-content-in-model,DJ013	django-non-leading-receiver-decorator,EM101	raw-string-in-exception,EM102	f-string-in-exception,EM103	dot-format-in-exception,EXE001	shebang-not-executable,EXE002	shebang-missing-executable-file,EXE003	shebang-missing-python,EXE004	shebang-leading-whitespace,EXE005	shebang-not-first-line,FIX001	line-contains-fixme,FIX002	line-contains-todo,FIX003	line-contains-xxx,FIX004	line-contains-hack,FA100	future-rewritable-type-annotation,FA102	future-required-type-annotation,INT001	f-string-in-get-text-func-call,INT002	format-in-get-text-func-call,INT003	printf-in-get-text-func-call,ISC001	single-line-implicit-string-concatenation,ISC002	multi-line-implicit-string-concatenation,ISC003	explicit-string-concatenation,ICN001	unconventional-import-alias,ICN002	banned-import-alias,ICN003	banned-import-from,LOG001	direct-logger-instantiation,LOG002	invalid-get-logger-argument,LOG007	exception-without-exc-info,LOG009	undocumented-warn,G001	logging-string-format,G002	logging-percent-format,G003	logging-string-concat,G004	logging-f-string,G010	logging-warn,G101	logging-extra-attr-clash,G201	logging-exc-info,G202	logging-redundant-exc-info,INP001	implicit-namespace-package,PIE790	unnecessary-placeholder,PIE794	duplicate-class-field-definition,PIE796	non-unique-enums,PIE800	unnecessary-spread,PIE804	unnecessary-dict-kwargs,PIE807	reimplemented-container-builtin,PIE808	unnecessary-range-start,PIE810	multiple-starts-ends-with,T201	print,T203	p-print,PYI001	unprefixed-type-param,PYI002	complex-if-statement-in-stub,PYI003	unrecognized-version-info-check,PYI004	patch-version-comparison,PYI005	wrong-tuple-length-version-comparison,PYI006	bad-version-info-comparison,PYI007	unrecognized-platform-check,PYI008	unrecognized-platform-name,PYI009	pass-statement-stub-body,PYI010	non-empty-stub-body,PYI011	typed-argument-default-in-stub,PYI012	pass-in-class-body,PYI013	ellipsis-in-non-empty-class-body,PYI014	argument-default-in-stub,PYI015	assignment-default-in-stub,PYI016	duplicate-union-member,PYI017	complex-assignment-in-stub,PYI018	unused-private-type-var,PYI019	custom-type-var-return-type,PYI020	quoted-annotation-in-stub,PYI021	docstring-in-stub,PYI024	collections-named-tuple,PYI025	unaliased-collections-abc-set-import,PYI026	type-alias-without-annotation,PYI029	str-or-repr-defined-in-stub,PYI030	unnecessary-literal-union,PYI032	any-eq-ne-annotation,PYI033	type-comment-in-stub,PYI034	non-self-return-type,PYI035	unassigned-special-variable-in-stub,PYI036	bad-exit-annotation,PYI041	redundant-numeric-union,PYI042	snake-case-type-alias,PYI043	t-suffixed-type-alias,PYI044	future-annotations-in-stub,PYI045	iter-method-return-iterable,PYI046	unused-private-protocol,PYI047	unused-private-type-alias,PYI048	stub-body-multiple-statements,PYI049	unused-private-typed-dict,PYI050	no-return-argument-annotation-in-stub,PYI051	redundant-literal-union,PYI052	unannotated-assignment-in-stub,PYI053	string-or-bytes-too-long,PYI054	numeric-literal-too-long,PYI055	unnecessary-type-union,PYI056	unsupported-method-call-on-all,PYI058	generator-return-from-iter-method,PT001	pytest-fixture-incorrect-parentheses-style,PT002	pytest-fixture-positional-args,PT003	pytest-extraneous-scope-function,PT004	pytest-missing-fixture-name-underscore,PT005	pytest-incorrect-fixture-name-underscore,PT006	pytest-parametrize-names-wrong-type,PT007	pytest-parametrize-values-wrong-type,PT008	pytest-patch-with-lambda,PT009	pytest-unittest-assertion,PT010	pytest-raises-without-exception,PT011	pytest-raises-too-broad,PT012	pytest-raises-with-multiple-statements,PT013	pytest-incorrect-pytest-import,PT014	pytest-duplicate-parametrize-test-cases,PT015	pytest-assert-always-false,PT016	pytest-fail-without-message,PT017	pytest-assert-in-except,PT018	pytest-composite-assertion,PT019	pytest-fixture-param-without-value,PT020	pytest-deprecated-yield-fixture,PT021	pytest-fixture-finalizer-callback,PT022	pytest-useless-yield-fixture,PT023	pytest-incorrect-mark-parentheses-style,PT024	pytest-unnecessary-asyncio-mark-on-fixture,PT025	pytest-erroneous-use-fixtures-on-fixture,PT026	pytest-use-fixtures-without-parameters,PT027	pytest-unittest-raises-assertion,Q000	bad-quotes-inline-string,Q001	bad-quotes-multiline-string,Q002	bad-quotes-docstring,Q003	avoidable-escaped-quote,Q004	unnecessary-escaped-quote,RSE102	unnecessary-paren-on-raise-exception,RET501	unnecessary-return-none,RET502	implicit-return-value,RET503	implicit-return,RET504	unnecessary-assign,RET505	superfluous-else-return,RET506	superfluous-else-raise,RET507	superfluous-else-continue,RET508	superfluous-else-break,SLF001	private-member-access,SIM101	duplicate-isinstance-call,SIM102	collapsible-if,SIM103	needless-bool,SIM105	suppressible-exception,SIM107	return-in-try-except-finally,SIM108	if-else-block-instead-of-if-exp,SIM109	compare-with-tuple,SIM110	reimplemented-builtin,SIM112	uncapitalized-environment-variables,SIM113	enumerate-for-loop,SIM114	if-with-same-arms,SIM115	open-file-with-context-handler,SIM116	if-else-block-instead-of-dict-lookup,SIM117	multiple-with-statements,SIM118	in-dict-keys,SIM201	negate-equal-op,SIM202	negate-not-equal-op,SIM208	double-negation,SIM210	if-expr-with-true-false,SIM211	if-expr-with-false-true,SIM212	if-expr-with-twisted-arms,SIM220	expr-and-not-expr,SIM221	expr-or-not-expr,SIM222	expr-or-true,SIM223	expr-and-false,SIM300	yoda-conditions,SIM401	if-else-block-instead-of-dict-get,SIM910	dict-get-with-none-default,SIM911	zip-dict-keys-and-values,SLOT000	no-slots-in-str-subclass,SLOT001	no-slots-in-tuple-subclass,SLOT002	no-slots-in-namedtuple-subclass,TID251	banned-api,TID252	relative-imports,TID253	banned-module-level-imports,TD001	invalid-todo-tag,TD002	missing-todo-author,TD003	missing-todo-link,TD004	missing-todo-colon,TD005	missing-todo-description,TD006	invalid-todo-capitalization,TD007	missing-space-after-todo-colon,TRIO100	trio-timeout-without-await,TRIO105	trio-sync-call,TRIO109	trio-async-function-with-timeout,TRIO110	trio-unneeded-sleep,TRIO115	trio-zero-sleep-call,TCH001	typing-only-first-party-import,TCH002	typing-only-third-party-import,TCH003	typing-only-standard-library-import,TCH004	runtime-import-in-type-checking-block,TCH005	empty-type-checking-block,TCH006	runtime-string-union,ARG001	unused-function-argument,ARG002	unused-method-argument,ARG003	unused-class-method-argument,ARG004	unused-static-method-argument,ARG005	unused-lambda-argument,PTH100	os-path-abspath,PTH101	os-chmod,PTH102	os-mkdir,PTH103	os-makedirs,PTH104	os-rename,PTH105	os-replace,PTH106	os-rmdir,PTH107	os-remove,PTH108	os-unlink,PTH109	os-getcwd,PTH110	os-path-exists,PTH111	os-path-expanduser,PTH112	os-path-isdir,PTH113	os-path-isfile,PTH114	os-path-islink,PTH115	os-readlink,PTH116	os-stat,PTH117	os-path-isabs,PTH118	os-path-join,PTH119	os-path-basename,PTH120	os-path-dirname,PTH121	os-path-samefile,PTH122	os-path-splitext,PTH123	builtin-open,PTH124	py-path,PTH201	path-constructor-current-directory,PTH202	os-path-getsize,PTH203	os-path-getatime,PTH204	os-path-getmtime,PTH205	os-path-getctime,PTH206	os-sep-split,PTH207	glob,FLY002	static-join-to-f-string,I001	unsorted-imports,I002	missing-required-import,C901	complex-structure,NPY001	numpy-deprecated-type-alias,NPY002	numpy-legacy-random,NPY003	numpy-deprecated-function,NPY201	numpy2-deprecation,N801	invalid-class-name,N802	invalid-function-name,N803	invalid-argument-name,N804	invalid-first-argument-name-for-class-method,N805	invalid-first-argument-name-for-method,N806	non-lowercase-variable-in-function,N807	dunder-function-name,N811	constant-imported-as-non-constant,N812	lowercase-imported-as-non-lowercase,N813	camelcase-imported-as-lowercase,N814	camelcase-imported-as-constant,N815	mixed-case-variable-in-class-scope,N816	mixed-case-variable-in-global-scope,N817	camelcase-imported-as-acronym,N818	error-suffix-on-exception-name,N999	invalid-module-name,PD002	pandas-use-of-inplace-argument,PD003	pandas-use-of-dot-is-null,PD004	pandas-use-of-dot-not-null,PD007	pandas-use-of-dot-ix,PD008	pandas-use-of-dot-at,PD009	pandas-use-of-dot-iat,PD010	pandas-use-of-dot-pivot-or-unstack,PD011	pandas-use-of-dot-values,PD012	pandas-use-of-dot-read-table,PD013	pandas-use-of-dot-stack,PD015	pandas-use-of-pd-merge,PD101	pandas-nunique-constant-series-check,PD901	pandas-df-variable-name,PERF101	unnecessary-list-cast,PERF102	incorrect-dict-iterator,PERF203	try-except-in-loop,PERF401	manual-list-comprehension,PERF402	manual-list-copy,PERF403	manual-dict-comprehension,E101	mixed-spaces-and-tabs,E111	indentation-with-invalid-multiple,E112	no-indented-block,E113	unexpected-indentation,E114	indentation-with-invalid-multiple-comment,E115	no-indented-block-comment,E116	unexpected-indentation-comment,E117	over-indented,E201	whitespace-after-open-bracket,E202	whitespace-before-close-bracket,E203	whitespace-before-punctuation,E211	whitespace-before-parameters,E221	multiple-spaces-before-operator,E222	multiple-spaces-after-operator,E223	tab-before-operator,E224	tab-after-operator,E225	missing-whitespace-around-operator,E226	missing-whitespace-around-arithmetic-operator,E227	missing-whitespace-around-bitwise-or-shift-operator,E228	missing-whitespace-around-modulo-operator,E231	missing-whitespace,E241	multiple-spaces-after-comma,E242	tab-after-comma,E251	unexpected-spaces-around-keyword-parameter-equals,E252	missing-whitespace-around-parameter-equals,E261	too-few-spaces-before-inline-comment,E262	no-space-after-inline-comment,E265	no-space-after-block-comment,E266	multiple-leading-hashes-for-block-comment,E271	multiple-spaces-after-keyword,E272	multiple-spaces-before-keyword,E273	tab-after-keyword,E274	tab-before-keyword,E275	missing-whitespace-after-keyword,E401	multiple-imports-on-one-line,E402	module-import-not-at-top-of-file,E501	line-too-long,E701	multiple-statements-on-one-line-colon,E702	multiple-statements-on-one-line-semicolon,E703	useless-semicolon,E711	none-comparison,E712	true-false-comparison,E713	not-in-test,E714	not-is-test,E721	type-comparison,E722	bare-except,E731	lambda-assignment,E741	ambiguous-variable-name,E742	ambiguous-class-name,E743	ambiguous-function-name,E902	io-error,E999	syntax-error,W191	tab-indentation,W291	trailing-whitespace,W292	missing-newline-at-end-of-file,W293	blank-line-with-whitespace,W505	doc-line-too-long,W605	invalid-escape-sequence,D100	undocumented-public-module,D101	undocumented-public-class,D102	undocumented-public-method,D103	undocumented-public-function,D104	undocumented-public-package,D105	undocumented-magic-method,D106	undocumented-public-nested-class,D107	undocumented-public-init,D200	fits-on-one-line,D201	no-blank-line-before-function,D202	no-blank-line-after-function,D203	one-blank-line-before-class,D204	one-blank-line-after-class,D205	blank-line-after-summary,D206	indent-with-spaces,D207	under-indentation,D208	over-indentation,D209	new-line-after-last-paragraph,D210	surrounding-whitespace,D211	blank-line-before-class,D212	multi-line-summary-first-line,D213	multi-line-summary-second-line,D214	section-not-over-indented,D215	section-underline-not-over-indented,D300	triple-single-quotes,D301	escape-sequence-in-docstring,D400	ends-in-period,D401	non-imperative-mood,D402	no-signature,D403	first-line-capitalized,D404	docstring-starts-with-this,D405	capitalize-section-name,D406	new-line-after-section-name,D407	dashed-underline-after-section,D408	section-underline-after-name,D409	section-underline-matches-section-length,D410	no-blank-line-after-section,D411	no-blank-line-before-section,D412	blank-lines-between-header-and-content,D413	blank-line-after-last-section,D414	empty-docstring-section,D415	ends-in-punctuation,D416	section-name-ends-in-colon,D417	undocumented-param,D418	overload-with-docstring,D419	empty-docstring,F401	unused-import,F402	import-shadowed-by-loop-var,F403	undefined-local-with-import-star,F404	late-future-import,F405	undefined-local-with-import-star-usage,F406	undefined-local-with-nested-import-star-usage,F407	future-feature-not-defined,F501	percent-format-invalid-format,F502	percent-format-expected-mapping,F503	percent-format-expected-sequence,F504	percent-format-extra-named-arguments,F505	percent-format-missing-argument,F506	percent-format-mixed-positional-and-named,F507	percent-format-positional-count-mismatch,F508	percent-format-star-requires-sequence,F509	percent-format-unsupported-format-character,F521	string-dot-format-invalid-format,F522	string-dot-format-extra-named-arguments,F523	string-dot-format-extra-positional-arguments,F524	string-dot-format-missing-arguments,F525	string-dot-format-mixing-automatic,F541	f-string-missing-placeholders,F601	multi-value-repeated-key-literal,F602	multi-value-repeated-key-variable,F621	expressions-in-star-assignment,F622	multiple-starred-expressions,F631	assert-tuple,F632	is-literal,F633	invalid-print-syntax,F634	if-tuple,F701	break-outside-loop,F702	continue-outside-loop,F704	yield-outside-function,F706	return-outside-function,F707	default-except-not-last,F722	forward-annotation-syntax-error,F811	redefined-while-unused,F821	undefined-name,F822	undefined-export,F823	undefined-local,F841	unused-variable,F842	unused-annotation,F901	raise-not-implemented,PGH001	eval,PGH002	deprecated-log-warn,PGH003	blanket-type-ignore,PGH004	blanket-noqa,PGH005	invalid-mock-access,PLC0105	type-name-incorrect-variance,PLC0131	type-bivariance,PLC0132	type-param-name-mismatch,PLC0205	single-string-slots,PLC0208	iteration-over-set,PLC0414	useless-import-alias,PLC0415	import-outside-top-level,PLC1901	compare-to-empty-string,PLC2401	non-ascii-name,PLC2403	non-ascii-import-name,PLC2701	import-private-name,PLC2801	unnecessary-dunder-call,PLC3002	unnecessary-direct-lambda-call,PLE0100	yield-in-init,PLE0101	return-in-init,PLE0116	continue-in-finally,PLE0117	nonlocal-without-binding,PLE0118	load-before-global-declaration,PLE0241	duplicate-bases,PLE0302	unexpected-special-method-signature,PLE0307	invalid-str-return-type,PLE0604	invalid-all-object,PLE0605	invalid-all-format,PLE0704	misplaced-bare-raise,PLE1132	repeated-keyword-argument,PLE1142	await-outside-async,PLE1205	logging-too-many-args,PLE1206	logging-too-few-args,PLE1300	bad-string-format-character,PLE1307	bad-string-format-type,PLE1310	bad-str-strip-call,PLE1507	invalid-envvar-value,PLE1700	yield-from-in-async-function,PLE2502	bidirectional-unicode,PLE2510	invalid-character-backspace,PLE2512	invalid-character-sub,PLE2513	invalid-character-esc,PLE2514	invalid-character-nul,PLE2515	invalid-character-zero-width-space,PLR0124	comparison-with-itself,PLR0133	comparison-of-constant,PLR0202	no-classmethod-decorator,PLR0203	no-staticmethod-decorator,PLR0206	property-with-parameters,PLR0402	manual-from-import,PLR0904	too-many-public-methods,PLR0911	too-many-return-statements,PLR0912	too-many-branches,PLR0913	too-many-arguments,PLR0914	too-many-locals,PLR0915	too-many-statements,PLR0916	too-many-boolean-expressions,PLR0917	too-many-positional,PLR1701	repeated-isinstance-calls,PLR1704	redefined-argument-from-local,PLR1706	and-or-ternary,PLR1711	useless-return,PLR1714	repeated-equality-comparison,PLR1722	sys-exit-alias,PLR1733	unnecessary-dict-index-lookup,PLR1736	unnecessary-list-index-lookup,PLR2004	magic-value-comparison,PLR2044	empty-comment,PLR5501	collapsible-else-if,PLR6201	literal-membership,PLR6301	no-self-use,PLW0108	unnecessary-lambda,PLW0120	useless-else-on-loop,PLW0127	self-assigning-variable,PLW0129	assert-on-string-literal,PLW0131	named-expr-without-context,PLW0245	super-without-brackets,PLW0406	import-self,PLW0602	global-variable-not-assigned,PLW0603	global-statement,PLW0604	global-at-module-level,PLW0711	binary-op-exception,PLW1501	bad-open-mode,PLW1508	invalid-envvar-default,PLW1509	subprocess-popen-preexec-fn,PLW1510	subprocess-run-without-check,PLW1514	unspecified-encoding,PLW1641	eq-without-hash,PLW2101	useless-with-lock,PLW2901	redefined-loop-name,PLW3201	bad-dunder-method-name,PLW3301	nested-min-max,UP001	useless-metaclass-type,UP003	type-of-primitive,UP004	useless-object-inheritance,UP005	deprecated-unittest-alias,UP006	non-pep585-annotation,UP007	non-pep604-annotation,UP008	super-call-with-parameters,UP009	utf8-encoding-declaration,UP010	unnecessary-future-import,UP011	lru-cache-without-parameters,UP012	unnecessary-encode-utf8,UP013	convert-typed-dict-functional-to-class,UP014	convert-named-tuple-functional-to-class,UP015	redundant-open-modes,UP017	datetime-timezone-utc,UP018	native-literals,UP019	typing-text-str-alias,UP020	open-alias,UP021	replace-universal-newlines,UP022	replace-stdout-stderr,UP023	deprecated-c-element-tree,UP024	os-error-alias,UP025	unicode-kind-prefix,UP026	deprecated-mock-import,UP027	unpacked-list-comprehension,UP028	yield-in-for-loop,UP029	unnecessary-builtin-import,UP030	format-literals,UP031	printf-string-formatting,UP032	f-string,UP033	lru-cache-with-maxsize-none,UP034	extraneous-parentheses,UP035	deprecated-import,UP036	outdated-version-block,UP037	quoted-annotation,UP038	non-pep604-isinstance,UP039	unnecessary-class-parentheses,UP040	non-pep695-type-alias,UP041	timeout-error-alias,FURB101	read-whole-file,FURB105	print-empty-string,FURB113	repeated-append,FURB118	reimplemented-operator,FURB131	delete-full-slice,FURB132	check-and-remove-from-set,FURB136	if-expr-min-max,FURB140	reimplemented-starmap,FURB145	slice-copy,FURB148	unnecessary-enumerate,FURB152	math-constant,FURB161	bit-count,FURB163	redundant-log-base,FURB167	regex-flag-alias,FURB168	isinstance-type-none,FURB169	type-none-comparison,FURB171	single-item-membership-test,FURB177	implicit-cwd,FURB181	hashlib-digest-hex,RUF001	ambiguous-unicode-character-string,RUF002	ambiguous-unicode-character-docstring,RUF003	ambiguous-unicode-character-comment,RUF005	collection-literal-concatenation,RUF006	asyncio-dangling-task,RUF007	pairwise-over-zipped,RUF008	mutable-dataclass-default,RUF009	function-call-in-dataclass-default-argument,RUF010	explicit-f-string-type-conversion,RUF011	static-key-dict-comprehension,RUF012	mutable-class-default,RUF013	implicit-optional,RUF015	unnecessary-iterable-allocation-for-first-element,RUF016	invalid-index-type,RUF017	quadratic-list-summation,RUF018	assignment-in-assert,RUF019	unnecessary-key-check,RUF020	never-union,RUF021	parenthesize-chained-operators,RUF022	unsorted-dunder-all,RUF100	unused-noqa,RUF200	invalid-pyproject-toml,TRY002	raise-vanilla-class,TRY003	raise-vanilla-args,TRY004	type-check-without-type-error,TRY200	reraise-no-cause,TRY201	verbose-raise,TRY300	try-consider-else,TRY301	raise-within-try,TRY302	useless-try-except,TRY400	error-instead-of-exception,TRY401	verbose-log-message}"
complete -c ruff -n "__fish_seen_subcommand_from check" -l extend-fixable -d 'Like --fixable, but adds additional rule codes on top of those already specified' -r -f -a "{ALL	all rules,F	Pyflakes,C90	mccabe,I	isort,N	pep8-naming,D	pydocstyle,UP	pyupgrade,YTT	flake8-2020,ANN	flake8-annotations,ASYNC	flake8-async,TRIO	flake8-trio,S	flake8-bandit,BLE	flake8-blind-except,FBT	flake8-boolean-trap,B	flake8-bugbear,A	flake8-builtins,COM	flake8-commas,CPY	flake8-copyright,C4	flake8-comprehensions,DTZ	flake8-datetimez,T10	flake8-debugger,DJ	flake8-django,EM	flake8-errmsg,EXE	flake8-executable,FA	flake8-future-annotations,ISC	flake8-implicit-str-concat,ICN	flake8-import-conventions,G	flake8-logging-format,INP	flake8-no-pep420,PIE	flake8-pie,T20	flake8-print,PYI	flake8-pyi,PT	flake8-pytest-style,Q	flake8-quotes,RSE	flake8-raise,RET	flake8-return,SLF	flake8-self,SLOT	flake8-slots,SIM	flake8-simplify,TID	flake8-tidy-imports,TCH	flake8-type-checking,INT	flake8-gettext,ARG	flake8-unused-arguments,PTH	flake8-use-pathlib,TD	flake8-todos,FIX	flake8-fixme,ERA	eradicate,PD	pandas-vet,PGH	pygrep-hooks,PL	Pylint,TRY	tryceratops,FLY	flynt,NPY	NumPy-specific rules,AIR	Airflow,PERF	Perflint,FURB	refurb,LOG	flake8-logging,RUF	Ruff-specific rules,AIR001	airflow-variable-name-task-id-mismatch,ERA001	commented-out-code,YTT101	sys-version-slice3,YTT102	sys-version2,YTT103	sys-version-cmp-str3,YTT201	sys-version-info0-eq3,YTT202	six-py3,YTT203	sys-version-info1-cmp-int,YTT204	sys-version-info-minor-cmp-int,YTT301	sys-version0,YTT302	sys-version-cmp-str10,YTT303	sys-version-slice1,ANN001	missing-type-function-argument,ANN002	missing-type-args,ANN003	missing-type-kwargs,ANN101	missing-type-self,ANN102	missing-type-cls,ANN201	missing-return-type-undocumented-public-function,ANN202	missing-return-type-private-function,ANN204	missing-return-type-special-method,ANN205	missing-return-type-static-method,ANN206	missing-return-type-class-method,ANN401	any-type,ASYNC100	blocking-http-call-in-async-function,ASYNC101	open-sleep-or-subprocess-in-async-function,ASYNC102	blocking-os-call-in-async-function,S101	assert,S102	exec-builtin,S103	bad-file-permissions,S104	hardcoded-bind-all-interfaces,S105	hardcoded-password-string,S106	hardcoded-password-func-arg,S107	hardcoded-password-default,S108	hardcoded-temp-file,S110	try-except-pass,S112	try-except-continue,S113	request-without-timeout,S201	flask-debug-true,S202	tarfile-unsafe-members,S301	suspicious-pickle-usage,S302	suspicious-marshal-usage,S303	suspicious-insecure-hash-usage,S304	suspicious-insecure-cipher-usage,S305	suspicious-insecure-cipher-mode-usage,S306	suspicious-mktemp-usage,S307	suspicious-eval-usage,S308	suspicious-mark-safe-usage,S310	suspicious-url-open-usage,S311	suspicious-non-cryptographic-random-usage,S312	suspicious-telnet-usage,S313	suspicious-xmlc-element-tree-usage,S314	suspicious-xml-element-tree-usage,S315	suspicious-xml-expat-reader-usage,S316	suspicious-xml-expat-builder-usage,S317	suspicious-xml-sax-usage,S318	suspicious-xml-mini-dom-usage,S319	suspicious-xml-pull-dom-usage,S320	suspicious-xmle-tree-usage,S321	suspicious-ftp-lib-usage,S323	suspicious-unverified-context-usage,S324	hashlib-insecure-hash-function,S401	suspicious-telnetlib-import,S402	suspicious-ftplib-import,S403	suspicious-pickle-import,S404	suspicious-subprocess-import,S405	suspicious-xml-etree-import,S406	suspicious-xml-sax-import,S407	suspicious-xml-expat-import,S408	suspicious-xml-minidom-import,S409	suspicious-xml-pulldom-import,S410	suspicious-lxml-import,S411	suspicious-xmlrpc-import,S412	suspicious-httpoxy-import,S413	suspicious-pycrypto-import,S415	suspicious-pyghmi-import,S501	request-with-no-cert-validation,S502	ssl-insecure-version,S503	ssl-with-bad-defaults,S504	ssl-with-no-version,S505	weak-cryptographic-key,S506	unsafe-yaml-load,S507	ssh-no-host-key-verification,S508	snmp-insecure-version,S509	snmp-weak-cryptography,S601	paramiko-call,S602	subprocess-popen-with-shell-equals-true,S603	subprocess-without-shell-equals-true,S604	call-with-shell-equals-true,S605	start-process-with-a-shell,S606	start-process-with-no-shell,S607	start-process-with-partial-path,S608	hardcoded-sql-expression,S609	unix-command-wildcard-injection,S611	django-raw-sql,S612	logging-config-insecure-listen,S701	jinja2-autoescape-false,S702	mako-templates,BLE001	blind-except,FBT001	boolean-type-hint-positional-argument,FBT002	boolean-default-value-positional-argument,FBT003	boolean-positional-value-in-call,B002	unary-prefix-increment-decrement,B003	assignment-to-os-environ,B004	unreliable-callable-check,B005	strip-with-multi-characters,B006	mutable-argument-default,B007	unused-loop-control-variable,B008	function-call-in-default-argument,B009	get-attr-with-constant,B010	set-attr-with-constant,B011	assert-false,B012	jump-statement-in-finally,B013	redundant-tuple-in-exception-handler,B014	duplicate-handler-exception,B015	useless-comparison,B016	raise-literal,B017	assert-raises-exception,B018	useless-expression,B019	cached-instance-method,B020	loop-variable-overrides-iterator,B021	f-string-docstring,B022	useless-contextlib-suppress,B023	function-uses-loop-variable,B024	abstract-base-class-without-abstract-method,B025	duplicate-try-block-exception,B026	star-arg-unpacking-after-keyword-arg,B027	empty-method-without-abstract-decorator,B028	no-explicit-stacklevel,B029	except-with-empty-tuple,B030	except-with-non-exception-classes,B031	reuse-of-groupby-generator,B032	unintentional-type-annotation,B033	duplicate-value,B034	re-sub-positional-args,B904	raise-without-from-inside-except,B905	zip-without-explicit-strict,A001	builtin-variable-shadowing,A002	builtin-argument-shadowing,A003	builtin-attribute-shadowing,COM812	missing-trailing-comma,COM818	trailing-comma-on-bare-tuple,COM819	prohibited-trailing-comma,C400	unnecessary-generator-list,C401	unnecessary-generator-set,C402	unnecessary-generator-dict,C403	unnecessary-list-comprehension-set,C404	unnecessary-list-comprehension-dict,C405	unnecessary-literal-set,C406	unnecessary-literal-dict,C408	unnecessary-collection-call,C409	unnecessary-literal-within-tuple-call,C410	unnecessary-literal-within-list-call,C411	unnecessary-list-call,C413	unnecessary-call-around-sorted,C414	unnecessary-double-cast-or-process,C415	unnecessary-subscript-reversal,C416	unnecessary-comprehension,C417	unnecessary-map,C418	unnecessary-literal-within-dict-call,C419	unnecessary-comprehension-any-all,CPY001	missing-copyright-notice,DTZ001	call-datetime-without-tzinfo,DTZ002	call-datetime-today,DTZ003	call-datetime-utcnow,DTZ004	call-datetime-utcfromtimestamp,DTZ005	call-datetime-now-without-tzinfo,DTZ006	call-datetime-fromtimestamp,DTZ007	call-datetime-strptime-without-zone,DTZ011	call-date-today,DTZ012	call-date-fromtimestamp,T100	debugger,DJ001	django-nullable-model-string-field,DJ003	django-locals-in-render-function,DJ006	django-exclude-with-model-form,DJ007	django-all-with-model-form,DJ008	django-model-without-dunder-str,DJ012	django-unordered-body-content-in-model,DJ013	django-non-leading-receiver-decorator,EM101	raw-string-in-exception,EM102	f-string-in-exception,EM103	dot-format-in-exception,EXE001	shebang-not-executable,EXE002	shebang-missing-executable-file,EXE003	shebang-missing-python,EXE004	shebang-leading-whitespace,EXE005	shebang-not-first-line,FIX001	line-contains-fixme,FIX002	line-contains-todo,FIX003	line-contains-xxx,FIX004	line-contains-hack,FA100	future-rewritable-type-annotation,FA102	future-required-type-annotation,INT001	f-string-in-get-text-func-call,INT002	format-in-get-text-func-call,INT003	printf-in-get-text-func-call,ISC001	single-line-implicit-string-concatenation,ISC002	multi-line-implicit-string-concatenation,ISC003	explicit-string-concatenation,ICN001	unconventional-import-alias,ICN002	banned-import-alias,ICN003	banned-import-from,LOG001	direct-logger-instantiation,LOG002	invalid-get-logger-argument,LOG007	exception-without-exc-info,LOG009	undocumented-warn,G001	logging-string-format,G002	logging-percent-format,G003	logging-string-concat,G004	logging-f-string,G010	logging-warn,G101	logging-extra-attr-clash,G201	logging-exc-info,G202	logging-redundant-exc-info,INP001	implicit-namespace-package,PIE790	unnecessary-placeholder,PIE794	duplicate-class-field-definition,PIE796	non-unique-enums,PIE800	unnecessary-spread,PIE804	unnecessary-dict-kwargs,PIE807	reimplemented-container-builtin,PIE808	unnecessary-range-start,PIE810	multiple-starts-ends-with,T201	print,T203	p-print,PYI001	unprefixed-type-param,PYI002	complex-if-statement-in-stub,PYI003	unrecognized-version-info-check,PYI004	patch-version-comparison,PYI005	wrong-tuple-length-version-comparison,PYI006	bad-version-info-comparison,PYI007	unrecognized-platform-check,PYI008	unrecognized-platform-name,PYI009	pass-statement-stub-body,PYI010	non-empty-stub-body,PYI011	typed-argument-default-in-stub,PYI012	pass-in-class-body,PYI013	ellipsis-in-non-empty-class-body,PYI014	argument-default-in-stub,PYI015	assignment-default-in-stub,PYI016	duplicate-union-member,PYI017	complex-assignment-in-stub,PYI018	unused-private-type-var,PYI019	custom-type-var-return-type,PYI020	quoted-annotation-in-stub,PYI021	docstring-in-stub,PYI024	collections-named-tuple,PYI025	unaliased-collections-abc-set-import,PYI026	type-alias-without-annotation,PYI029	str-or-repr-defined-in-stub,PYI030	unnecessary-literal-union,PYI032	any-eq-ne-annotation,PYI033	type-comment-in-stub,PYI034	non-self-return-type,PYI035	unassigned-special-variable-in-stub,PYI036	bad-exit-annotation,PYI041	redundant-numeric-union,PYI042	snake-case-type-alias,PYI043	t-suffixed-type-alias,PYI044	future-annotations-in-stub,PYI045	iter-method-return-iterable,PYI046	unused-private-protocol,PYI047	unused-private-type-alias,PYI048	stub-body-multiple-statements,PYI049	unused-private-typed-dict,PYI050	no-return-argument-annotation-in-stub,PYI051	redundant-literal-union,PYI052	unannotated-assignment-in-stub,PYI053	string-or-bytes-too-long,PYI054	numeric-literal-too-long,PYI055	unnecessary-type-union,PYI056	unsupported-method-call-on-all,PYI058	generator-return-from-iter-method,PT001	pytest-fixture-incorrect-parentheses-style,PT002	pytest-fixture-positional-args,PT003	pytest-extraneous-scope-function,PT004	pytest-missing-fixture-name-underscore,PT005	pytest-incorrect-fixture-name-underscore,PT006	pytest-parametrize-names-wrong-type,PT007	pytest-parametrize-values-wrong-type,PT008	pytest-patch-with-lambda,PT009	pytest-unittest-assertion,PT010	pytest-raises-without-exception,PT011	pytest-raises-too-broad,PT012	pytest-raises-with-multiple-statements,PT013	pytest-incorrect-pytest-import,PT014	pytest-duplicate-parametrize-test-cases,PT015	pytest-assert-always-false,PT016	pytest-fail-without-message,PT017	pytest-assert-in-except,PT018	pytest-composite-assertion,PT019	pytest-fixture-param-without-value,PT020	pytest-deprecated-yield-fixture,PT021	pytest-fixture-finalizer-callback,PT022	pytest-useless-yield-fixture,PT023	pytest-incorrect-mark-parentheses-style,PT024	pytest-unnecessary-asyncio-mark-on-fixture,PT025	pytest-erroneous-use-fixtures-on-fixture,PT026	pytest-use-fixtures-without-parameters,PT027	pytest-unittest-raises-assertion,Q000	bad-quotes-inline-string,Q001	bad-quotes-multiline-string,Q002	bad-quotes-docstring,Q003	avoidable-escaped-quote,Q004	unnecessary-escaped-quote,RSE102	unnecessary-paren-on-raise-exception,RET501	unnecessary-return-none,RET502	implicit-return-value,RET503	implicit-return,RET504	unnecessary-assign,RET505	superfluous-else-return,RET506	superfluous-else-raise,RET507	superfluous-else-continue,RET508	superfluous-else-break,SLF001	private-member-access,SIM101	duplicate-isinstance-call,SIM102	collapsible-if,SIM103	needless-bool,SIM105	suppressible-exception,SIM107	return-in-try-except-finally,SIM108	if-else-block-instead-of-if-exp,SIM109	compare-with-tuple,SIM110	reimplemented-builtin,SIM112	uncapitalized-environment-variables,SIM113	enumerate-for-loop,SIM114	if-with-same-arms,SIM115	open-file-with-context-handler,SIM116	if-else-block-instead-of-dict-lookup,SIM117	multiple-with-statements,SIM118	in-dict-keys,SIM201	negate-equal-op,SIM202	negate-not-equal-op,SIM208	double-negation,SIM210	if-expr-with-true-false,SIM211	if-expr-with-false-true,SIM212	if-expr-with-twisted-arms,SIM220	expr-and-not-expr,SIM221	expr-or-not-expr,SIM222	expr-or-true,SIM223	expr-and-false,SIM300	yoda-conditions,SIM401	if-else-block-instead-of-dict-get,SIM910	dict-get-with-none-default,SIM911	zip-dict-keys-and-values,SLOT000	no-slots-in-str-subclass,SLOT001	no-slots-in-tuple-subclass,SLOT002	no-slots-in-namedtuple-subclass,TID251	banned-api,TID252	relative-imports,TID253	banned-module-level-imports,TD001	invalid-todo-tag,TD002	missing-todo-author,TD003	missing-todo-link,TD004	missing-todo-colon,TD005	missing-todo-description,TD006	invalid-todo-capitalization,TD007	missing-space-after-todo-colon,TRIO100	trio-timeout-without-await,TRIO105	trio-sync-call,TRIO109	trio-async-function-with-timeout,TRIO110	trio-unneeded-sleep,TRIO115	trio-zero-sleep-call,TCH001	typing-only-first-party-import,TCH002	typing-only-third-party-import,TCH003	typing-only-standard-library-import,TCH004	runtime-import-in-type-checking-block,TCH005	empty-type-checking-block,TCH006	runtime-string-union,ARG001	unused-function-argument,ARG002	unused-method-argument,ARG003	unused-class-method-argument,ARG004	unused-static-method-argument,ARG005	unused-lambda-argument,PTH100	os-path-abspath,PTH101	os-chmod,PTH102	os-mkdir,PTH103	os-makedirs,PTH104	os-rename,PTH105	os-replace,PTH106	os-rmdir,PTH107	os-remove,PTH108	os-unlink,PTH109	os-getcwd,PTH110	os-path-exists,PTH111	os-path-expanduser,PTH112	os-path-isdir,PTH113	os-path-isfile,PTH114	os-path-islink,PTH115	os-readlink,PTH116	os-stat,PTH117	os-path-isabs,PTH118	os-path-join,PTH119	os-path-basename,PTH120	os-path-dirname,PTH121	os-path-samefile,PTH122	os-path-splitext,PTH123	builtin-open,PTH124	py-path,PTH201	path-constructor-current-directory,PTH202	os-path-getsize,PTH203	os-path-getatime,PTH204	os-path-getmtime,PTH205	os-path-getctime,PTH206	os-sep-split,PTH207	glob,FLY002	static-join-to-f-string,I001	unsorted-imports,I002	missing-required-import,C901	complex-structure,NPY001	numpy-deprecated-type-alias,NPY002	numpy-legacy-random,NPY003	numpy-deprecated-function,NPY201	numpy2-deprecation,N801	invalid-class-name,N802	invalid-function-name,N803	invalid-argument-name,N804	invalid-first-argument-name-for-class-method,N805	invalid-first-argument-name-for-method,N806	non-lowercase-variable-in-function,N807	dunder-function-name,N811	constant-imported-as-non-constant,N812	lowercase-imported-as-non-lowercase,N813	camelcase-imported-as-lowercase,N814	camelcase-imported-as-constant,N815	mixed-case-variable-in-class-scope,N816	mixed-case-variable-in-global-scope,N817	camelcase-imported-as-acronym,N818	error-suffix-on-exception-name,N999	invalid-module-name,PD002	pandas-use-of-inplace-argument,PD003	pandas-use-of-dot-is-null,PD004	pandas-use-of-dot-not-null,PD007	pandas-use-of-dot-ix,PD008	pandas-use-of-dot-at,PD009	pandas-use-of-dot-iat,PD010	pandas-use-of-dot-pivot-or-unstack,PD011	pandas-use-of-dot-values,PD012	pandas-use-of-dot-read-table,PD013	pandas-use-of-dot-stack,PD015	pandas-use-of-pd-merge,PD101	pandas-nunique-constant-series-check,PD901	pandas-df-variable-name,PERF101	unnecessary-list-cast,PERF102	incorrect-dict-iterator,PERF203	try-except-in-loop,PERF401	manual-list-comprehension,PERF402	manual-list-copy,PERF403	manual-dict-comprehension,E101	mixed-spaces-and-tabs,E111	indentation-with-invalid-multiple,E112	no-indented-block,E113	unexpected-indentation,E114	indentation-with-invalid-multiple-comment,E115	no-indented-block-comment,E116	unexpected-indentation-comment,E117	over-indented,E201	whitespace-after-open-bracket,E202	whitespace-before-close-bracket,E203	whitespace-before-punctuation,E211	whitespace-before-parameters,E221	multiple-spaces-before-operator,E222	multiple-spaces-after-operator,E223	tab-before-operator,E224	tab-after-operator,E225	missing-whitespace-around-operator,E226	missing-whitespace-around-arithmetic-operator,E227	missing-whitespace-around-bitwise-or-shift-operator,E228	missing-whitespace-around-modulo-operator,E231	missing-whitespace,E241	multiple-spaces-after-comma,E242	tab-after-comma,E251	unexpected-spaces-around-keyword-parameter-equals,E252	missing-whitespace-around-parameter-equals,E261	too-few-spaces-before-inline-comment,E262	no-space-after-inline-comment,E265	no-space-after-block-comment,E266	multiple-leading-hashes-for-block-comment,E271	multiple-spaces-after-keyword,E272	multiple-spaces-before-keyword,E273	tab-after-keyword,E274	tab-before-keyword,E275	missing-whitespace-after-keyword,E401	multiple-imports-on-one-line,E402	module-import-not-at-top-of-file,E501	line-too-long,E701	multiple-statements-on-one-line-colon,E702	multiple-statements-on-one-line-semicolon,E703	useless-semicolon,E711	none-comparison,E712	true-false-comparison,E713	not-in-test,E714	not-is-test,E721	type-comparison,E722	bare-except,E731	lambda-assignment,E741	ambiguous-variable-name,E742	ambiguous-class-name,E743	ambiguous-function-name,E902	io-error,E999	syntax-error,W191	tab-indentation,W291	trailing-whitespace,W292	missing-newline-at-end-of-file,W293	blank-line-with-whitespace,W505	doc-line-too-long,W605	invalid-escape-sequence,D100	undocumented-public-module,D101	undocumented-public-class,D102	undocumented-public-method,D103	undocumented-public-function,D104	undocumented-public-package,D105	undocumented-magic-method,D106	undocumented-public-nested-class,D107	undocumented-public-init,D200	fits-on-one-line,D201	no-blank-line-before-function,D202	no-blank-line-after-function,D203	one-blank-line-before-class,D204	one-blank-line-after-class,D205	blank-line-after-summary,D206	indent-with-spaces,D207	under-indentation,D208	over-indentation,D209	new-line-after-last-paragraph,D210	surrounding-whitespace,D211	blank-line-before-class,D212	multi-line-summary-first-line,D213	multi-line-summary-second-line,D214	section-not-over-indented,D215	section-underline-not-over-indented,D300	triple-single-quotes,D301	escape-sequence-in-docstring,D400	ends-in-period,D401	non-imperative-mood,D402	no-signature,D403	first-line-capitalized,D404	docstring-starts-with-this,D405	capitalize-section-name,D406	new-line-after-section-name,D407	dashed-underline-after-section,D408	section-underline-after-name,D409	section-underline-matches-section-length,D410	no-blank-line-after-section,D411	no-blank-line-before-section,D412	blank-lines-between-header-and-content,D413	blank-line-after-last-section,D414	empty-docstring-section,D415	ends-in-punctuation,D416	section-name-ends-in-colon,D417	undocumented-param,D418	overload-with-docstring,D419	empty-docstring,F401	unused-import,F402	import-shadowed-by-loop-var,F403	undefined-local-with-import-star,F404	late-future-import,F405	undefined-local-with-import-star-usage,F406	undefined-local-with-nested-import-star-usage,F407	future-feature-not-defined,F501	percent-format-invalid-format,F502	percent-format-expected-mapping,F503	percent-format-expected-sequence,F504	percent-format-extra-named-arguments,F505	percent-format-missing-argument,F506	percent-format-mixed-positional-and-named,F507	percent-format-positional-count-mismatch,F508	percent-format-star-requires-sequence,F509	percent-format-unsupported-format-character,F521	string-dot-format-invalid-format,F522	string-dot-format-extra-named-arguments,F523	string-dot-format-extra-positional-arguments,F524	string-dot-format-missing-arguments,F525	string-dot-format-mixing-automatic,F541	f-string-missing-placeholders,F601	multi-value-repeated-key-literal,F602	multi-value-repeated-key-variable,F621	expressions-in-star-assignment,F622	multiple-starred-expressions,F631	assert-tuple,F632	is-literal,F633	invalid-print-syntax,F634	if-tuple,F701	break-outside-loop,F702	continue-outside-loop,F704	yield-outside-function,F706	return-outside-function,F707	default-except-not-last,F722	forward-annotation-syntax-error,F811	redefined-while-unused,F821	undefined-name,F822	undefined-export,F823	undefined-local,F841	unused-variable,F842	unused-annotation,F901	raise-not-implemented,PGH001	eval,PGH002	deprecated-log-warn,PGH003	blanket-type-ignore,PGH004	blanket-noqa,PGH005	invalid-mock-access,PLC0105	type-name-incorrect-variance,PLC0131	type-bivariance,PLC0132	type-param-name-mismatch,PLC0205	single-string-slots,PLC0208	iteration-over-set,PLC0414	useless-import-alias,PLC0415	import-outside-top-level,PLC1901	compare-to-empty-string,PLC2401	non-ascii-name,PLC2403	non-ascii-import-name,PLC2701	import-private-name,PLC2801	unnecessary-dunder-call,PLC3002	unnecessary-direct-lambda-call,PLE0100	yield-in-init,PLE0101	return-in-init,PLE0116	continue-in-finally,PLE0117	nonlocal-without-binding,PLE0118	load-before-global-declaration,PLE0241	duplicate-bases,PLE0302	unexpected-special-method-signature,PLE0307	invalid-str-return-type,PLE0604	invalid-all-object,PLE0605	invalid-all-format,PLE0704	misplaced-bare-raise,PLE1132	repeated-keyword-argument,PLE1142	await-outside-async,PLE1205	logging-too-many-args,PLE1206	logging-too-few-args,PLE1300	bad-string-format-character,PLE1307	bad-string-format-type,PLE1310	bad-str-strip-call,PLE1507	invalid-envvar-value,PLE1700	yield-from-in-async-function,PLE2502	bidirectional-unicode,PLE2510	invalid-character-backspace,PLE2512	invalid-character-sub,PLE2513	invalid-character-esc,PLE2514	invalid-character-nul,PLE2515	invalid-character-zero-width-space,PLR0124	comparison-with-itself,PLR0133	comparison-of-constant,PLR0202	no-classmethod-decorator,PLR0203	no-staticmethod-decorator,PLR0206	property-with-parameters,PLR0402	manual-from-import,PLR0904	too-many-public-methods,PLR0911	too-many-return-statements,PLR0912	too-many-branches,PLR0913	too-many-arguments,PLR0914	too-many-locals,PLR0915	too-many-statements,PLR0916	too-many-boolean-expressions,PLR0917	too-many-positional,PLR1701	repeated-isinstance-calls,PLR1704	redefined-argument-from-local,PLR1706	and-or-ternary,PLR1711	useless-return,PLR1714	repeated-equality-comparison,PLR1722	sys-exit-alias,PLR1733	unnecessary-dict-index-lookup,PLR1736	unnecessary-list-index-lookup,PLR2004	magic-value-comparison,PLR2044	empty-comment,PLR5501	collapsible-else-if,PLR6201	literal-membership,PLR6301	no-self-use,PLW0108	unnecessary-lambda,PLW0120	useless-else-on-loop,PLW0127	self-assigning-variable,PLW0129	assert-on-string-literal,PLW0131	named-expr-without-context,PLW0245	super-without-brackets,PLW0406	import-self,PLW0602	global-variable-not-assigned,PLW0603	global-statement,PLW0604	global-at-module-level,PLW0711	binary-op-exception,PLW1501	bad-open-mode,PLW1508	invalid-envvar-default,PLW1509	subprocess-popen-preexec-fn,PLW1510	subprocess-run-without-check,PLW1514	unspecified-encoding,PLW1641	eq-without-hash,PLW2101	useless-with-lock,PLW2901	redefined-loop-name,PLW3201	bad-dunder-method-name,PLW3301	nested-min-max,UP001	useless-metaclass-type,UP003	type-of-primitive,UP004	useless-object-inheritance,UP005	deprecated-unittest-alias,UP006	non-pep585-annotation,UP007	non-pep604-annotation,UP008	super-call-with-parameters,UP009	utf8-encoding-declaration,UP010	unnecessary-future-import,UP011	lru-cache-without-parameters,UP012	unnecessary-encode-utf8,UP013	convert-typed-dict-functional-to-class,UP014	convert-named-tuple-functional-to-class,UP015	redundant-open-modes,UP017	datetime-timezone-utc,UP018	native-literals,UP019	typing-text-str-alias,UP020	open-alias,UP021	replace-universal-newlines,UP022	replace-stdout-stderr,UP023	deprecated-c-element-tree,UP024	os-error-alias,UP025	unicode-kind-prefix,UP026	deprecated-mock-import,UP027	unpacked-list-comprehension,UP028	yield-in-for-loop,UP029	unnecessary-builtin-import,UP030	format-literals,UP031	printf-string-formatting,UP032	f-string,UP033	lru-cache-with-maxsize-none,UP034	extraneous-parentheses,UP035	deprecated-import,UP036	outdated-version-block,UP037	quoted-annotation,UP038	non-pep604-isinstance,UP039	unnecessary-class-parentheses,UP040	non-pep695-type-alias,UP041	timeout-error-alias,FURB101	read-whole-file,FURB105	print-empty-string,FURB113	repeated-append,FURB118	reimplemented-operator,FURB131	delete-full-slice,FURB132	check-and-remove-from-set,FURB136	if-expr-min-max,FURB140	reimplemented-starmap,FURB145	slice-copy,FURB148	unnecessary-enumerate,FURB152	math-constant,FURB161	bit-count,FURB163	redundant-log-base,FURB167	regex-flag-alias,FURB168	isinstance-type-none,FURB169	type-none-comparison,FURB171	single-item-membership-test,FURB177	implicit-cwd,FURB181	hashlib-digest-hex,RUF001	ambiguous-unicode-character-string,RUF002	ambiguous-unicode-character-docstring,RUF003	ambiguous-unicode-character-comment,RUF005	collection-literal-concatenation,RUF006	asyncio-dangling-task,RUF007	pairwise-over-zipped,RUF008	mutable-dataclass-default,RUF009	function-call-in-dataclass-default-argument,RUF010	explicit-f-string-type-conversion,RUF011	static-key-dict-comprehension,RUF012	mutable-class-default,RUF013	implicit-optional,RUF015	unnecessary-iterable-allocation-for-first-element,RUF016	invalid-index-type,RUF017	quadratic-list-summation,RUF018	assignment-in-assert,RUF019	unnecessary-key-check,RUF020	never-union,RUF021	parenthesize-chained-operators,RUF022	unsorted-dunder-all,RUF100	unused-noqa,RUF200	invalid-pyproject-toml,TRY002	raise-vanilla-class,TRY003	raise-vanilla-args,TRY004	type-check-without-type-error,TRY200	reraise-no-cause,TRY201	verbose-raise,TRY300	try-consider-else,TRY301	raise-within-try,TRY302	useless-try-except,TRY400	error-instead-of-exception,TRY401	verbose-log-message}"
complete -c ruff -n "__fish_seen_subcommand_from check" -l extend-unfixable -d 'Like --unfixable. (Deprecated: You can just use --unfixable instead.)' -r -f -a "{ALL	all rules,F	Pyflakes,C90	mccabe,I	isort,N	pep8-naming,D	pydocstyle,UP	pyupgrade,YTT	flake8-2020,ANN	flake8-annotations,ASYNC	flake8-async,TRIO	flake8-trio,S	flake8-bandit,BLE	flake8-blind-except,FBT	flake8-boolean-trap,B	flake8-bugbear,A	flake8-builtins,COM	flake8-commas,CPY	flake8-copyright,C4	flake8-comprehensions,DTZ	flake8-datetimez,T10	flake8-debugger,DJ	flake8-django,EM	flake8-errmsg,EXE	flake8-executable,FA	flake8-future-annotations,ISC	flake8-implicit-str-concat,ICN	flake8-import-conventions,G	flake8-logging-format,INP	flake8-no-pep420,PIE	flake8-pie,T20	flake8-print,PYI	flake8-pyi,PT	flake8-pytest-style,Q	flake8-quotes,RSE	flake8-raise,RET	flake8-return,SLF	flake8-self,SLOT	flake8-slots,SIM	flake8-simplify,TID	flake8-tidy-imports,TCH	flake8-type-checking,INT	flake8-gettext,ARG	flake8-unused-arguments,PTH	flake8-use-pathlib,TD	flake8-todos,FIX	flake8-fixme,ERA	eradicate,PD	pandas-vet,PGH	pygrep-hooks,PL	Pylint,TRY	tryceratops,FLY	flynt,NPY	NumPy-specific rules,AIR	Airflow,PERF	Perflint,FURB	refurb,LOG	flake8-logging,RUF	Ruff-specific rules,AIR001	airflow-variable-name-task-id-mismatch,ERA001	commented-out-code,YTT101	sys-version-slice3,YTT102	sys-version2,YTT103	sys-version-cmp-str3,YTT201	sys-version-info0-eq3,YTT202	six-py3,YTT203	sys-version-info1-cmp-int,YTT204	sys-version-info-minor-cmp-int,YTT301	sys-version0,YTT302	sys-version-cmp-str10,YTT303	sys-version-slice1,ANN001	missing-type-function-argument,ANN002	missing-type-args,ANN003	missing-type-kwargs,ANN101	missing-type-self,ANN102	missing-type-cls,ANN201	missing-return-type-undocumented-public-function,ANN202	missing-return-type-private-function,ANN204	missing-return-type-special-method,ANN205	missing-return-type-static-method,ANN206	missing-return-type-class-method,ANN401	any-type,ASYNC100	blocking-http-call-in-async-function,ASYNC101	open-sleep-or-subprocess-in-async-function,ASYNC102	blocking-os-call-in-async-function,S101	assert,S102	exec-builtin,S103	bad-file-permissions,S104	hardcoded-bind-all-interfaces,S105	hardcoded-password-string,S106	hardcoded-password-func-arg,S107	hardcoded-password-default,S108	hardcoded-temp-file,S110	try-except-pass,S112	try-except-continue,S113	request-without-timeout,S201	flask-debug-true,S202	tarfile-unsafe-members,S301	suspicious-pickle-usage,S302	suspicious-marshal-usage,S303	suspicious-insecure-hash-usage,S304	suspicious-insecure-cipher-usage,S305	suspicious-insecure-cipher-mode-usage,S306	suspicious-mktemp-usage,S307	suspicious-eval-usage,S308	suspicious-mark-safe-usage,S310	suspicious-url-open-usage,S311	suspicious-non-cryptographic-random-usage,S312	suspicious-telnet-usage,S313	suspicious-xmlc-element-tree-usage,S314	suspicious-xml-element-tree-usage,S315	suspicious-xml-expat-reader-usage,S316	suspicious-xml-expat-builder-usage,S317	suspicious-xml-sax-usage,S318	suspicious-xml-mini-dom-usage,S319	suspicious-xml-pull-dom-usage,S320	suspicious-xmle-tree-usage,S321	suspicious-ftp-lib-usage,S323	suspicious-unverified-context-usage,S324	hashlib-insecure-hash-function,S401	suspicious-telnetlib-import,S402	suspicious-ftplib-import,S403	suspicious-pickle-import,S404	suspicious-subprocess-import,S405	suspicious-xml-etree-import,S406	suspicious-xml-sax-import,S407	suspicious-xml-expat-import,S408	suspicious-xml-minidom-import,S409	suspicious-xml-pulldom-import,S410	suspicious-lxml-import,S411	suspicious-xmlrpc-import,S412	suspicious-httpoxy-import,S413	suspicious-pycrypto-import,S415	suspicious-pyghmi-import,S501	request-with-no-cert-validation,S502	ssl-insecure-version,S503	ssl-with-bad-defaults,S504	ssl-with-no-version,S505	weak-cryptographic-key,S506	unsafe-yaml-load,S507	ssh-no-host-key-verification,S508	snmp-insecure-version,S509	snmp-weak-cryptography,S601	paramiko-call,S602	subprocess-popen-with-shell-equals-true,S603	subprocess-without-shell-equals-true,S604	call-with-shell-equals-true,S605	start-process-with-a-shell,S606	start-process-with-no-shell,S607	start-process-with-partial-path,S608	hardcoded-sql-expression,S609	unix-command-wildcard-injection,S611	django-raw-sql,S612	logging-config-insecure-listen,S701	jinja2-autoescape-false,S702	mako-templates,BLE001	blind-except,FBT001	boolean-type-hint-positional-argument,FBT002	boolean-default-value-positional-argument,FBT003	boolean-positional-value-in-call,B002	unary-prefix-increment-decrement,B003	assignment-to-os-environ,B004	unreliable-callable-check,B005	strip-with-multi-characters,B006	mutable-argument-default,B007	unused-loop-control-variable,B008	function-call-in-default-argument,B009	get-attr-with-constant,B010	set-attr-with-constant,B011	assert-false,B012	jump-statement-in-finally,B013	redundant-tuple-in-exception-handler,B014	duplicate-handler-exception,B015	useless-comparison,B016	raise-literal,B017	assert-raises-exception,B018	useless-expression,B019	cached-instance-method,B020	loop-variable-overrides-iterator,B021	f-string-docstring,B022	useless-contextlib-suppress,B023	function-uses-loop-variable,B024	abstract-base-class-without-abstract-method,B025	duplicate-try-block-exception,B026	star-arg-unpacking-after-keyword-arg,B027	empty-method-without-abstract-decorator,B028	no-explicit-stacklevel,B029	except-with-empty-tuple,B030	except-with-non-exception-classes,B031	reuse-of-groupby-generator,B032	unintentional-type-annotation,B033	duplicate-value,B034	re-sub-positional-args,B904	raise-without-from-inside-except,B905	zip-without-explicit-strict,A001	builtin-variable-shadowing,A002	builtin-argument-shadowing,A003	builtin-attribute-shadowing,COM812	missing-trailing-comma,COM818	trailing-comma-on-bare-tuple,COM819	prohibited-trailing-comma,C400	unnecessary-generator-list,C401	unnecessary-generator-set,C402	unnecessary-generator-dict,C403	unnecessary-list-comprehension-set,C404	unnecessary-list-comprehension-dict,C405	unnecessary-literal-set,C406	unnecessary-literal-dict,C408	unnecessary-collection-call,C409	unnecessary-literal-within-tuple-call,C410	unnecessary-literal-within-list-call,C411	unnecessary-list-call,C413	unnecessary-call-around-sorted,C414	unnecessary-double-cast-or-process,C415	unnecessary-subscript-reversal,C416	unnecessary-comprehension,C417	unnecessary-map,C418	unnecessary-literal-within-dict-call,C419	unnecessary-comprehension-any-all,CPY001	missing-copyright-notice,DTZ001	call-datetime-without-tzinfo,DTZ002	call-datetime-today,DTZ003	call-datetime-utcnow,DTZ004	call-datetime-utcfromtimestamp,DTZ005	call-datetime-now-without-tzinfo,DTZ006	call-datetime-fromtimestamp,DTZ007	call-datetime-strptime-without-zone,DTZ011	call-date-today,DTZ012	call-date-fromtimestamp,T100	debugger,DJ001	django-nullable-model-string-field,DJ003	django-locals-in-render-function,DJ006	django-exclude-with-model-form,DJ007	django-all-with-model-form,DJ008	django-model-without-dunder-str,DJ012	django-unordered-body-content-in-model,DJ013	django-non-leading-receiver-decorator,EM101	raw-string-in-exception,EM102	f-string-in-exception,EM103	dot-format-in-exception,EXE001	shebang-not-executable,EXE002	shebang-missing-executable-file,EXE003	shebang-missing-python,EXE004	shebang-leading-whitespace,EXE005	shebang-not-first-line,FIX001	line-contains-fixme,FIX002	line-contains-todo,FIX003	line-contains-xxx,FIX004	line-contains-hack,FA100	future-rewritable-type-annotation,FA102	future-required-type-annotation,INT001	f-string-in-get-text-func-call,INT002	format-in-get-text-func-call,INT003	printf-in-get-text-func-call,ISC001	single-line-implicit-string-concatenation,ISC002	multi-line-implicit-string-concatenation,ISC003	explicit-string-concatenation,ICN001	unconventional-import-alias,ICN002	banned-import-alias,ICN003	banned-import-from,LOG001	direct-logger-instantiation,LOG002	invalid-get-logger-argument,LOG007	exception-without-exc-info,LOG009	undocumented-warn,G001	logging-string-format,G002	logging-percent-format,G003	logging-string-concat,G004	logging-f-string,G010	logging-warn,G101	logging-extra-attr-clash,G201	logging-exc-info,G202	logging-redundant-exc-info,INP001	implicit-namespace-package,PIE790	unnecessary-placeholder,PIE794	duplicate-class-field-definition,PIE796	non-unique-enums,PIE800	unnecessary-spread,PIE804	unnecessary-dict-kwargs,PIE807	reimplemented-container-builtin,PIE808	unnecessary-range-start,PIE810	multiple-starts-ends-with,T201	print,T203	p-print,PYI001	unprefixed-type-param,PYI002	complex-if-statement-in-stub,PYI003	unrecognized-version-info-check,PYI004	patch-version-comparison,PYI005	wrong-tuple-length-version-comparison,PYI006	bad-version-info-comparison,PYI007	unrecognized-platform-check,PYI008	unrecognized-platform-name,PYI009	pass-statement-stub-body,PYI010	non-empty-stub-body,PYI011	typed-argument-default-in-stub,PYI012	pass-in-class-body,PYI013	ellipsis-in-non-empty-class-body,PYI014	argument-default-in-stub,PYI015	assignment-default-in-stub,PYI016	duplicate-union-member,PYI017	complex-assignment-in-stub,PYI018	unused-private-type-var,PYI019	custom-type-var-return-type,PYI020	quoted-annotation-in-stub,PYI021	docstring-in-stub,PYI024	collections-named-tuple,PYI025	unaliased-collections-abc-set-import,PYI026	type-alias-without-annotation,PYI029	str-or-repr-defined-in-stub,PYI030	unnecessary-literal-union,PYI032	any-eq-ne-annotation,PYI033	type-comment-in-stub,PYI034	non-self-return-type,PYI035	unassigned-special-variable-in-stub,PYI036	bad-exit-annotation,PYI041	redundant-numeric-union,PYI042	snake-case-type-alias,PYI043	t-suffixed-type-alias,PYI044	future-annotations-in-stub,PYI045	iter-method-return-iterable,PYI046	unused-private-protocol,PYI047	unused-private-type-alias,PYI048	stub-body-multiple-statements,PYI049	unused-private-typed-dict,PYI050	no-return-argument-annotation-in-stub,PYI051	redundant-literal-union,PYI052	unannotated-assignment-in-stub,PYI053	string-or-bytes-too-long,PYI054	numeric-literal-too-long,PYI055	unnecessary-type-union,PYI056	unsupported-method-call-on-all,PYI058	generator-return-from-iter-method,PT001	pytest-fixture-incorrect-parentheses-style,PT002	pytest-fixture-positional-args,PT003	pytest-extraneous-scope-function,PT004	pytest-missing-fixture-name-underscore,PT005	pytest-incorrect-fixture-name-underscore,PT006	pytest-parametrize-names-wrong-type,PT007	pytest-parametrize-values-wrong-type,PT008	pytest-patch-with-lambda,PT009	pytest-unittest-assertion,PT010	pytest-raises-without-exception,PT011	pytest-raises-too-broad,PT012	pytest-raises-with-multiple-statements,PT013	pytest-incorrect-pytest-import,PT014	pytest-duplicate-parametrize-test-cases,PT015	pytest-assert-always-false,PT016	pytest-fail-without-message,PT017	pytest-assert-in-except,PT018	pytest-composite-assertion,PT019	pytest-fixture-param-without-value,PT020	pytest-deprecated-yield-fixture,PT021	pytest-fixture-finalizer-callback,PT022	pytest-useless-yield-fixture,PT023	pytest-incorrect-mark-parentheses-style,PT024	pytest-unnecessary-asyncio-mark-on-fixture,PT025	pytest-erroneous-use-fixtures-on-fixture,PT026	pytest-use-fixtures-without-parameters,PT027	pytest-unittest-raises-assertion,Q000	bad-quotes-inline-string,Q001	bad-quotes-multiline-string,Q002	bad-quotes-docstring,Q003	avoidable-escaped-quote,Q004	unnecessary-escaped-quote,RSE102	unnecessary-paren-on-raise-exception,RET501	unnecessary-return-none,RET502	implicit-return-value,RET503	implicit-return,RET504	unnecessary-assign,RET505	superfluous-else-return,RET506	superfluous-else-raise,RET507	superfluous-else-continue,RET508	superfluous-else-break,SLF001	private-member-access,SIM101	duplicate-isinstance-call,SIM102	collapsible-if,SIM103	needless-bool,SIM105	suppressible-exception,SIM107	return-in-try-except-finally,SIM108	if-else-block-instead-of-if-exp,SIM109	compare-with-tuple,SIM110	reimplemented-builtin,SIM112	uncapitalized-environment-variables,SIM113	enumerate-for-loop,SIM114	if-with-same-arms,SIM115	open-file-with-context-handler,SIM116	if-else-block-instead-of-dict-lookup,SIM117	multiple-with-statements,SIM118	in-dict-keys,SIM201	negate-equal-op,SIM202	negate-not-equal-op,SIM208	double-negation,SIM210	if-expr-with-true-false,SIM211	if-expr-with-false-true,SIM212	if-expr-with-twisted-arms,SIM220	expr-and-not-expr,SIM221	expr-or-not-expr,SIM222	expr-or-true,SIM223	expr-and-false,SIM300	yoda-conditions,SIM401	if-else-block-instead-of-dict-get,SIM910	dict-get-with-none-default,SIM911	zip-dict-keys-and-values,SLOT000	no-slots-in-str-subclass,SLOT001	no-slots-in-tuple-subclass,SLOT002	no-slots-in-namedtuple-subclass,TID251	banned-api,TID252	relative-imports,TID253	banned-module-level-imports,TD001	invalid-todo-tag,TD002	missing-todo-author,TD003	missing-todo-link,TD004	missing-todo-colon,TD005	missing-todo-description,TD006	invalid-todo-capitalization,TD007	missing-space-after-todo-colon,TRIO100	trio-timeout-without-await,TRIO105	trio-sync-call,TRIO109	trio-async-function-with-timeout,TRIO110	trio-unneeded-sleep,TRIO115	trio-zero-sleep-call,TCH001	typing-only-first-party-import,TCH002	typing-only-third-party-import,TCH003	typing-only-standard-library-import,TCH004	runtime-import-in-type-checking-block,TCH005	empty-type-checking-block,TCH006	runtime-string-union,ARG001	unused-function-argument,ARG002	unused-method-argument,ARG003	unused-class-method-argument,ARG004	unused-static-method-argument,ARG005	unused-lambda-argument,PTH100	os-path-abspath,PTH101	os-chmod,PTH102	os-mkdir,PTH103	os-makedirs,PTH104	os-rename,PTH105	os-replace,PTH106	os-rmdir,PTH107	os-remove,PTH108	os-unlink,PTH109	os-getcwd,PTH110	os-path-exists,PTH111	os-path-expanduser,PTH112	os-path-isdir,PTH113	os-path-isfile,PTH114	os-path-islink,PTH115	os-readlink,PTH116	os-stat,PTH117	os-path-isabs,PTH118	os-path-join,PTH119	os-path-basename,PTH120	os-path-dirname,PTH121	os-path-samefile,PTH122	os-path-splitext,PTH123	builtin-open,PTH124	py-path,PTH201	path-constructor-current-directory,PTH202	os-path-getsize,PTH203	os-path-getatime,PTH204	os-path-getmtime,PTH205	os-path-getctime,PTH206	os-sep-split,PTH207	glob,FLY002	static-join-to-f-string,I001	unsorted-imports,I002	missing-required-import,C901	complex-structure,NPY001	numpy-deprecated-type-alias,NPY002	numpy-legacy-random,NPY003	numpy-deprecated-function,NPY201	numpy2-deprecation,N801	invalid-class-name,N802	invalid-function-name,N803	invalid-argument-name,N804	invalid-first-argument-name-for-class-method,N805	invalid-first-argument-name-for-method,N806	non-lowercase-variable-in-function,N807	dunder-function-name,N811	constant-imported-as-non-constant,N812	lowercase-imported-as-non-lowercase,N813	camelcase-imported-as-lowercase,N814	camelcase-imported-as-constant,N815	mixed-case-variable-in-class-scope,N816	mixed-case-variable-in-global-scope,N817	camelcase-imported-as-acronym,N818	error-suffix-on-exception-name,N999	invalid-module-name,PD002	pandas-use-of-inplace-argument,PD003	pandas-use-of-dot-is-null,PD004	pandas-use-of-dot-not-null,PD007	pandas-use-of-dot-ix,PD008	pandas-use-of-dot-at,PD009	pandas-use-of-dot-iat,PD010	pandas-use-of-dot-pivot-or-unstack,PD011	pandas-use-of-dot-values,PD012	pandas-use-of-dot-read-table,PD013	pandas-use-of-dot-stack,PD015	pandas-use-of-pd-merge,PD101	pandas-nunique-constant-series-check,PD901	pandas-df-variable-name,PERF101	unnecessary-list-cast,PERF102	incorrect-dict-iterator,PERF203	try-except-in-loop,PERF401	manual-list-comprehension,PERF402	manual-list-copy,PERF403	manual-dict-comprehension,E101	mixed-spaces-and-tabs,E111	indentation-with-invalid-multiple,E112	no-indented-block,E113	unexpected-indentation,E114	indentation-with-invalid-multiple-comment,E115	no-indented-block-comment,E116	unexpected-indentation-comment,E117	over-indented,E201	whitespace-after-open-bracket,E202	whitespace-before-close-bracket,E203	whitespace-before-punctuation,E211	whitespace-before-parameters,E221	multiple-spaces-before-operator,E222	multiple-spaces-after-operator,E223	tab-before-operator,E224	tab-after-operator,E225	missing-whitespace-around-operator,E226	missing-whitespace-around-arithmetic-operator,E227	missing-whitespace-around-bitwise-or-shift-operator,E228	missing-whitespace-around-modulo-operator,E231	missing-whitespace,E241	multiple-spaces-after-comma,E242	tab-after-comma,E251	unexpected-spaces-around-keyword-parameter-equals,E252	missing-whitespace-around-parameter-equals,E261	too-few-spaces-before-inline-comment,E262	no-space-after-inline-comment,E265	no-space-after-block-comment,E266	multiple-leading-hashes-for-block-comment,E271	multiple-spaces-after-keyword,E272	multiple-spaces-before-keyword,E273	tab-after-keyword,E274	tab-before-keyword,E275	missing-whitespace-after-keyword,E401	multiple-imports-on-one-line,E402	module-import-not-at-top-of-file,E501	line-too-long,E701	multiple-statements-on-one-line-colon,E702	multiple-statements-on-one-line-semicolon,E703	useless-semicolon,E711	none-comparison,E712	true-false-comparison,E713	not-in-test,E714	not-is-test,E721	type-comparison,E722	bare-except,E731	lambda-assignment,E741	ambiguous-variable-name,E742	ambiguous-class-name,E743	ambiguous-function-name,E902	io-error,E999	syntax-error,W191	tab-indentation,W291	trailing-whitespace,W292	missing-newline-at-end-of-file,W293	blank-line-with-whitespace,W505	doc-line-too-long,W605	invalid-escape-sequence,D100	undocumented-public-module,D101	undocumented-public-class,D102	undocumented-public-method,D103	undocumented-public-function,D104	undocumented-public-package,D105	undocumented-magic-method,D106	undocumented-public-nested-class,D107	undocumented-public-init,D200	fits-on-one-line,D201	no-blank-line-before-function,D202	no-blank-line-after-function,D203	one-blank-line-before-class,D204	one-blank-line-after-class,D205	blank-line-after-summary,D206	indent-with-spaces,D207	under-indentation,D208	over-indentation,D209	new-line-after-last-paragraph,D210	surrounding-whitespace,D211	blank-line-before-class,D212	multi-line-summary-first-line,D213	multi-line-summary-second-line,D214	section-not-over-indented,D215	section-underline-not-over-indented,D300	triple-single-quotes,D301	escape-sequence-in-docstring,D400	ends-in-period,D401	non-imperative-mood,D402	no-signature,D403	first-line-capitalized,D404	docstring-starts-with-this,D405	capitalize-section-name,D406	new-line-after-section-name,D407	dashed-underline-after-section,D408	section-underline-after-name,D409	section-underline-matches-section-length,D410	no-blank-line-after-section,D411	no-blank-line-before-section,D412	blank-lines-between-header-and-content,D413	blank-line-after-last-section,D414	empty-docstring-section,D415	ends-in-punctuation,D416	section-name-ends-in-colon,D417	undocumented-param,D418	overload-with-docstring,D419	empty-docstring,F401	unused-import,F402	import-shadowed-by-loop-var,F403	undefined-local-with-import-star,F404	late-future-import,F405	undefined-local-with-import-star-usage,F406	undefined-local-with-nested-import-star-usage,F407	future-feature-not-defined,F501	percent-format-invalid-format,F502	percent-format-expected-mapping,F503	percent-format-expected-sequence,F504	percent-format-extra-named-arguments,F505	percent-format-missing-argument,F506	percent-format-mixed-positional-and-named,F507	percent-format-positional-count-mismatch,F508	percent-format-star-requires-sequence,F509	percent-format-unsupported-format-character,F521	string-dot-format-invalid-format,F522	string-dot-format-extra-named-arguments,F523	string-dot-format-extra-positional-arguments,F524	string-dot-format-missing-arguments,F525	string-dot-format-mixing-automatic,F541	f-string-missing-placeholders,F601	multi-value-repeated-key-literal,F602	multi-value-repeated-key-variable,F621	expressions-in-star-assignment,F622	multiple-starred-expressions,F631	assert-tuple,F632	is-literal,F633	invalid-print-syntax,F634	if-tuple,F701	break-outside-loop,F702	continue-outside-loop,F704	yield-outside-function,F706	return-outside-function,F707	default-except-not-last,F722	forward-annotation-syntax-error,F811	redefined-while-unused,F821	undefined-name,F822	undefined-export,F823	undefined-local,F841	unused-variable,F842	unused-annotation,F901	raise-not-implemented,PGH001	eval,PGH002	deprecated-log-warn,PGH003	blanket-type-ignore,PGH004	blanket-noqa,PGH005	invalid-mock-access,PLC0105	type-name-incorrect-variance,PLC0131	type-bivariance,PLC0132	type-param-name-mismatch,PLC0205	single-string-slots,PLC0208	iteration-over-set,PLC0414	useless-import-alias,PLC0415	import-outside-top-level,PLC1901	compare-to-empty-string,PLC2401	non-ascii-name,PLC2403	non-ascii-import-name,PLC2701	import-private-name,PLC2801	unnecessary-dunder-call,PLC3002	unnecessary-direct-lambda-call,PLE0100	yield-in-init,PLE0101	return-in-init,PLE0116	continue-in-finally,PLE0117	nonlocal-without-binding,PLE0118	load-before-global-declaration,PLE0241	duplicate-bases,PLE0302	unexpected-special-method-signature,PLE0307	invalid-str-return-type,PLE0604	invalid-all-object,PLE0605	invalid-all-format,PLE0704	misplaced-bare-raise,PLE1132	repeated-keyword-argument,PLE1142	await-outside-async,PLE1205	logging-too-many-args,PLE1206	logging-too-few-args,PLE1300	bad-string-format-character,PLE1307	bad-string-format-type,PLE1310	bad-str-strip-call,PLE1507	invalid-envvar-value,PLE1700	yield-from-in-async-function,PLE2502	bidirectional-unicode,PLE2510	invalid-character-backspace,PLE2512	invalid-character-sub,PLE2513	invalid-character-esc,PLE2514	invalid-character-nul,PLE2515	invalid-character-zero-width-space,PLR0124	comparison-with-itself,PLR0133	comparison-of-constant,PLR0202	no-classmethod-decorator,PLR0203	no-staticmethod-decorator,PLR0206	property-with-parameters,PLR0402	manual-from-import,PLR0904	too-many-public-methods,PLR0911	too-many-return-statements,PLR0912	too-many-branches,PLR0913	too-many-arguments,PLR0914	too-many-locals,PLR0915	too-many-statements,PLR0916	too-many-boolean-expressions,PLR0917	too-many-positional,PLR1701	repeated-isinstance-calls,PLR1704	redefined-argument-from-local,PLR1706	and-or-ternary,PLR1711	useless-return,PLR1714	repeated-equality-comparison,PLR1722	sys-exit-alias,PLR1733	unnecessary-dict-index-lookup,PLR1736	unnecessary-list-index-lookup,PLR2004	magic-value-comparison,PLR2044	empty-comment,PLR5501	collapsible-else-if,PLR6201	literal-membership,PLR6301	no-self-use,PLW0108	unnecessary-lambda,PLW0120	useless-else-on-loop,PLW0127	self-assigning-variable,PLW0129	assert-on-string-literal,PLW0131	named-expr-without-context,PLW0245	super-without-brackets,PLW0406	import-self,PLW0602	global-variable-not-assigned,PLW0603	global-statement,PLW0604	global-at-module-level,PLW0711	binary-op-exception,PLW1501	bad-open-mode,PLW1508	invalid-envvar-default,PLW1509	subprocess-popen-preexec-fn,PLW1510	subprocess-run-without-check,PLW1514	unspecified-encoding,PLW1641	eq-without-hash,PLW2101	useless-with-lock,PLW2901	redefined-loop-name,PLW3201	bad-dunder-method-name,PLW3301	nested-min-max,UP001	useless-metaclass-type,UP003	type-of-primitive,UP004	useless-object-inheritance,UP005	deprecated-unittest-alias,UP006	non-pep585-annotation,UP007	non-pep604-annotation,UP008	super-call-with-parameters,UP009	utf8-encoding-declaration,UP010	unnecessary-future-import,UP011	lru-cache-without-parameters,UP012	unnecessary-encode-utf8,UP013	convert-typed-dict-functional-to-class,UP014	convert-named-tuple-functional-to-class,UP015	redundant-open-modes,UP017	datetime-timezone-utc,UP018	native-literals,UP019	typing-text-str-alias,UP020	open-alias,UP021	replace-universal-newlines,UP022	replace-stdout-stderr,UP023	deprecated-c-element-tree,UP024	os-error-alias,UP025	unicode-kind-prefix,UP026	deprecated-mock-import,UP027	unpacked-list-comprehension,UP028	yield-in-for-loop,UP029	unnecessary-builtin-import,UP030	format-literals,UP031	printf-string-formatting,UP032	f-string,UP033	lru-cache-with-maxsize-none,UP034	extraneous-parentheses,UP035	deprecated-import,UP036	outdated-version-block,UP037	quoted-annotation,UP038	non-pep604-isinstance,UP039	unnecessary-class-parentheses,UP040	non-pep695-type-alias,UP041	timeout-error-alias,FURB101	read-whole-file,FURB105	print-empty-string,FURB113	repeated-append,FURB118	reimplemented-operator,FURB131	delete-full-slice,FURB132	check-and-remove-from-set,FURB136	if-expr-min-max,FURB140	reimplemented-starmap,FURB145	slice-copy,FURB148	unnecessary-enumerate,FURB152	math-constant,FURB161	bit-count,FURB163	redundant-log-base,FURB167	regex-flag-alias,FURB168	isinstance-type-none,FURB169	type-none-comparison,FURB171	single-item-membership-test,FURB177	implicit-cwd,FURB181	hashlib-digest-hex,RUF001	ambiguous-unicode-character-string,RUF002	ambiguous-unicode-character-docstring,RUF003	ambiguous-unicode-character-comment,RUF005	collection-literal-concatenation,RUF006	asyncio-dangling-task,RUF007	pairwise-over-zipped,RUF008	mutable-dataclass-default,RUF009	function-call-in-dataclass-default-argument,RUF010	explicit-f-string-type-conversion,RUF011	static-key-dict-comprehension,RUF012	mutable-class-default,RUF013	implicit-optional,RUF015	unnecessary-iterable-allocation-for-first-element,RUF016	invalid-index-type,RUF017	quadratic-list-summation,RUF018	assignment-in-assert,RUF019	unnecessary-key-check,RUF020	never-union,RUF021	parenthesize-chained-operators,RUF022	unsorted-dunder-all,RUF100	unused-noqa,RUF200	invalid-pyproject-toml,TRY002	raise-vanilla-class,TRY003	raise-vanilla-args,TRY004	type-check-without-type-error,TRY200	reraise-no-cause,TRY201	verbose-raise,TRY300	try-consider-else,TRY301	raise-within-try,TRY302	useless-try-except,TRY400	error-instead-of-exception,TRY401	verbose-log-message}"
complete -c ruff -n "__fish_seen_subcommand_from check" -l line-length -d 'Set the line-length for length-associated rules and automatic formatting' -r
complete -c ruff -n "__fish_seen_subcommand_from check" -l dummy-variable-rgx -d 'Regular expression matching the name of dummy variables' -r
complete -c ruff -n "__fish_seen_subcommand_from check" -l cache-dir -d 'Path to the cache directory' -r -F
complete -c ruff -n "__fish_seen_subcommand_from check" -l stdin-filename -d 'The name of the file when passing it through stdin' -r -F
complete -c ruff -n "__fish_seen_subcommand_from check" -l extension -d 'List of mappings from file extension to language (one of ["python", "ipynb", "pyi"]). For example, to treat `.ipy` files as IPython notebooks, use `--extension ipy:ipynb`' -r
complete -c ruff -n "__fish_seen_subcommand_from check" -l fix -d 'Apply fixes to resolve lint violations. Use `--no-fix` to disable or `--unsafe-fixes` to include unsafe fixes'
complete -c ruff -n "__fish_seen_subcommand_from check" -l no-fix
complete -c ruff -n "__fish_seen_subcommand_from check" -l unsafe-fixes -d 'Include fixes that may not retain the original intent of the code. Use `--no-unsafe-fixes` to disable'
complete -c ruff -n "__fish_seen_subcommand_from check" -l no-unsafe-fixes
complete -c ruff -n "__fish_seen_subcommand_from check" -l show-source -d 'Show violations with source code. Use `--no-show-source` to disable'
complete -c ruff -n "__fish_seen_subcommand_from check" -l no-show-source
complete -c ruff -n "__fish_seen_subcommand_from check" -l show-fixes -d 'Show an enumeration of all fixed lint violations. Use `--no-show-fixes` to disable'
complete -c ruff -n "__fish_seen_subcommand_from check" -l no-show-fixes
complete -c ruff -n "__fish_seen_subcommand_from check" -l diff -d 'Avoid writing any fixed files back; instead, output a diff for each changed file to stdout. Implies `--fix-only`'
complete -c ruff -n "__fish_seen_subcommand_from check" -s w -l watch -d 'Run in watch mode by re-running whenever files change'
complete -c ruff -n "__fish_seen_subcommand_from check" -l fix-only -d 'Apply fixes to resolve lint violations, but don\'t report on leftover violations. Implies `--fix`. Use `--no-fix-only` to disable or `--unsafe-fixes` to include unsafe fixes'
complete -c ruff -n "__fish_seen_subcommand_from check" -l no-fix-only
complete -c ruff -n "__fish_seen_subcommand_from check" -l ignore-noqa -d 'Ignore any `# noqa` comments'
complete -c ruff -n "__fish_seen_subcommand_from check" -l preview -d 'Enable preview mode; checks will include unstable rules and fixes. Use `--no-preview` to disable'
complete -c ruff -n "__fish_seen_subcommand_from check" -l no-preview
complete -c ruff -n "__fish_seen_subcommand_from check" -l respect-gitignore -d 'Respect file exclusions via `.gitignore` and other standard ignore files. Use `--no-respect-gitignore` to disable'
complete -c ruff -n "__fish_seen_subcommand_from check" -l no-respect-gitignore
complete -c ruff -n "__fish_seen_subcommand_from check" -l force-exclude -d 'Enforce exclusions, even for paths passed to Ruff directly on the command-line. Use `--no-force-exclude` to disable'
complete -c ruff -n "__fish_seen_subcommand_from check" -l no-force-exclude
complete -c ruff -n "__fish_seen_subcommand_from check" -s n -l no-cache -d 'Disable cache reads'
complete -c ruff -n "__fish_seen_subcommand_from check" -l isolated -d 'Ignore all configuration files'
complete -c ruff -n "__fish_seen_subcommand_from check" -s e -l exit-zero -d 'Exit with status code "0", even upon detecting lint violations'
complete -c ruff -n "__fish_seen_subcommand_from check" -l exit-non-zero-on-fix -d 'Exit with a non-zero status code if any files were modified via fix, even if no lint violations remain'
complete -c ruff -n "__fish_seen_subcommand_from check" -l statistics -d 'Show counts for every rule with at least one violation'
complete -c ruff -n "__fish_seen_subcommand_from check" -l add-noqa -d 'Enable automatic additions of `noqa` directives to failing lines'
complete -c ruff -n "__fish_seen_subcommand_from check" -l show-files -d 'See the files Ruff will be run against with the current settings'
complete -c ruff -n "__fish_seen_subcommand_from check" -l show-settings -d 'See the settings Ruff will use to lint a given Python file'
complete -c ruff -n "__fish_seen_subcommand_from check" -l ecosystem-ci -d 'Dev-only argument to show fixes'
complete -c ruff -n "__fish_seen_subcommand_from check" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_seen_subcommand_from check" -s q -l quiet -d 'Print diagnostics, but nothing else'
complete -c ruff -n "__fish_seen_subcommand_from check" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
complete -c ruff -n "__fish_seen_subcommand_from check" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_seen_subcommand_from rule" -l output-format -d 'Output format' -r -f -a "{text	,json	}"
complete -c ruff -n "__fish_seen_subcommand_from rule" -l format -d 'Output format (Deprecated: Use `--output-format` instead)' -r -f -a "{text	,json	}"
complete -c ruff -n "__fish_seen_subcommand_from rule" -l all -d 'Explain all rules'
complete -c ruff -n "__fish_seen_subcommand_from rule" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_seen_subcommand_from rule" -s q -l quiet -d 'Print diagnostics, but nothing else'
complete -c ruff -n "__fish_seen_subcommand_from rule" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
complete -c ruff -n "__fish_seen_subcommand_from rule" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_seen_subcommand_from config" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_seen_subcommand_from config" -s q -l quiet -d 'Print diagnostics, but nothing else'
complete -c ruff -n "__fish_seen_subcommand_from config" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
complete -c ruff -n "__fish_seen_subcommand_from config" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_seen_subcommand_from linter" -l output-format -d 'Output format' -r -f -a "{text	,json	}"
complete -c ruff -n "__fish_seen_subcommand_from linter" -l format -d 'Output format (Deprecated: Use `--output-format` instead)' -r -f -a "{text	,json	}"
complete -c ruff -n "__fish_seen_subcommand_from linter" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_seen_subcommand_from linter" -s q -l quiet -d 'Print diagnostics, but nothing else'
complete -c ruff -n "__fish_seen_subcommand_from linter" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
complete -c ruff -n "__fish_seen_subcommand_from linter" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_seen_subcommand_from clean" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_seen_subcommand_from clean" -s q -l quiet -d 'Print diagnostics, but nothing else'
complete -c ruff -n "__fish_seen_subcommand_from clean" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
complete -c ruff -n "__fish_seen_subcommand_from clean" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_seen_subcommand_from generate-shell-completion" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_seen_subcommand_from generate-shell-completion" -s q -l quiet -d 'Print diagnostics, but nothing else'
complete -c ruff -n "__fish_seen_subcommand_from generate-shell-completion" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
complete -c ruff -n "__fish_seen_subcommand_from generate-shell-completion" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_seen_subcommand_from format" -l config -d 'Path to the `pyproject.toml` or `ruff.toml` file to use for configuration' -r -F
complete -c ruff -n "__fish_seen_subcommand_from format" -l cache-dir -d 'Path to the cache directory' -r -F
complete -c ruff -n "__fish_seen_subcommand_from format" -l exclude -d 'List of paths, used to omit files and/or directories from analysis' -r
complete -c ruff -n "__fish_seen_subcommand_from format" -l line-length -d 'Set the line-length' -r
complete -c ruff -n "__fish_seen_subcommand_from format" -l stdin-filename -d 'The name of the file when passing it through stdin' -r -F
complete -c ruff -n "__fish_seen_subcommand_from format" -l extension -d 'List of mappings from file extension to language (one of ["python", "ipynb", "pyi"]). For example, to treat `.ipy` files as IPython notebooks, use `--extension ipy:ipynb`' -r
complete -c ruff -n "__fish_seen_subcommand_from format" -l target-version -d 'The minimum Python version that should be supported' -r -f -a "{py37	,py38	,py39	,py310	,py311	,py312	}"
complete -c ruff -n "__fish_seen_subcommand_from format" -l check -d 'Avoid writing any formatted files back; instead, exit with a non-zero status code if any files would have been modified, and zero otherwise'
complete -c ruff -n "__fish_seen_subcommand_from format" -l diff -d 'Avoid writing any formatted files back; instead, exit with a non-zero status code and the difference between the current file and how the formatted file would look like'
complete -c ruff -n "__fish_seen_subcommand_from format" -s n -l no-cache -d 'Disable cache reads'
complete -c ruff -n "__fish_seen_subcommand_from format" -l respect-gitignore -d 'Respect file exclusions via `.gitignore` and other standard ignore files. Use `--no-respect-gitignore` to disable'
complete -c ruff -n "__fish_seen_subcommand_from format" -l no-respect-gitignore
complete -c ruff -n "__fish_seen_subcommand_from format" -l force-exclude -d 'Enforce exclusions, even for paths passed to Ruff directly on the command-line. Use `--no-force-exclude` to disable'
complete -c ruff -n "__fish_seen_subcommand_from format" -l no-force-exclude
complete -c ruff -n "__fish_seen_subcommand_from format" -l isolated -d 'Ignore all configuration files'
complete -c ruff -n "__fish_seen_subcommand_from format" -l preview -d 'Enable preview mode; enables unstable formatting. Use `--no-preview` to disable'
complete -c ruff -n "__fish_seen_subcommand_from format" -l no-preview
complete -c ruff -n "__fish_seen_subcommand_from format" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_seen_subcommand_from format" -s q -l quiet -d 'Print diagnostics, but nothing else'
complete -c ruff -n "__fish_seen_subcommand_from format" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
complete -c ruff -n "__fish_seen_subcommand_from format" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_seen_subcommand_from version" -l output-format -r -f -a "{text	,json	}"
complete -c ruff -n "__fish_seen_subcommand_from version" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_seen_subcommand_from version" -s q -l quiet -d 'Print diagnostics, but nothing else'
complete -c ruff -n "__fish_seen_subcommand_from version" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting diagnostics)'
complete -c ruff -n "__fish_seen_subcommand_from version" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from rule; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from linter; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from generate-shell-completion; and not __fish_seen_subcommand_from format; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "check" -d 'Run Ruff on the given files or directories (default)'
complete -c ruff -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from rule; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from linter; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from generate-shell-completion; and not __fish_seen_subcommand_from format; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "rule" -d 'Explain a rule (or all rules)'
complete -c ruff -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from rule; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from linter; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from generate-shell-completion; and not __fish_seen_subcommand_from format; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "config" -d 'List or describe the available configuration options'
complete -c ruff -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from rule; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from linter; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from generate-shell-completion; and not __fish_seen_subcommand_from format; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "linter" -d 'List all supported upstream linters'
complete -c ruff -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from rule; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from linter; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from generate-shell-completion; and not __fish_seen_subcommand_from format; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "clean" -d 'Clear any caches in the current directory and any subdirectories'
complete -c ruff -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from rule; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from linter; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from generate-shell-completion; and not __fish_seen_subcommand_from format; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "generate-shell-completion" -d 'Generate shell completion'
complete -c ruff -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from rule; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from linter; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from generate-shell-completion; and not __fish_seen_subcommand_from format; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "format" -d 'Run the Ruff formatter on the given files or directories'
complete -c ruff -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from rule; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from linter; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from generate-shell-completion; and not __fish_seen_subcommand_from format; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "version" -d 'Display Ruff\'s version'
complete -c ruff -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from rule; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from linter; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from generate-shell-completion; and not __fish_seen_subcommand_from format; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
