info = {
    "name": "sw",
    "date_order": "DMY",
    "january": [
        "jan",
        "januari"
    ],
    "february": [
        "feb",
        "februari"
    ],
    "march": [
        "mac",
        "machi"
    ],
    "april": [
        "apr",
        "aprili"
    ],
    "may": [
        "mei"
    ],
    "june": [
        "jun",
        "juni"
    ],
    "july": [
        "jul",
        "julai"
    ],
    "august": [
        "ago",
        "agosti"
    ],
    "september": [
        "sep",
        "septemba"
    ],
    "october": [
        "okt",
        "oktoba"
    ],
    "november": [
        "nov",
        "novemba"
    ],
    "december": [
        "des",
        "desemba"
    ],
    "monday": [
        "jumatatu"
    ],
    "tuesday": [
        "jumanne"
    ],
    "wednesday": [
        "jumatano"
    ],
    "thursday": [
        "alhamisi"
    ],
    "friday": [
        "ijumaa"
    ],
    "saturday": [
        "jumamosi"
    ],
    "sunday": [
        "jumapili"
    ],
    "am": [
        "am",
        "asubuhi"
    ],
    "pm": [
        "mchana",
        "pm"
    ],
    "year": [
        "mwaka"
    ],
    "month": [
        "mwezi"
    ],
    "week": [
        "wiki"
    ],
    "day": [
        "siku"
    ],
    "hour": [
        "saa"
    ],
    "minute": [
        "dak",
        "dakika"
    ],
    "second": [
        "sek",
        "sekunde"
    ],
    "relative-type": {
        "0 day ago": [
            "leo"
        ],
        "0 hour ago": [
            "saa hii"
        ],
        "0 minute ago": [
            "dakika hii"
        ],
        "0 month ago": [
            "mwezi huu"
        ],
        "0 second ago": [
            "sasa hivi"
        ],
        "0 week ago": [
            "wiki hii"
        ],
        "0 year ago": [
            "mwaka huu"
        ],
        "1 day ago": [
            "jana"
        ],
        "1 month ago": [
            "mwezi uliopita"
        ],
        "1 week ago": [
            "wiki iliyopita"
        ],
        "1 year ago": [
            "mwaka uliopita"
        ],
        "in 1 day": [
            "kesho"
        ],
        "in 1 month": [
            "mwezi ujao"
        ],
        "in 1 week": [
            "wiki ijayo"
        ],
        "in 1 year": [
            "mwaka ujao"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "siku (\\d+) iliyopita",
            "siku (\\d+) zilizopita"
        ],
        "\\1 hour ago": [
            "saa (\\d+) iliyopita",
            "saa (\\d+) zilizopita"
        ],
        "\\1 minute ago": [
            "dakika (\\d+) iliyopita",
            "dakika (\\d+) zilizopita"
        ],
        "\\1 month ago": [
            "miezi (\\d+) iliyopita",
            "mwezi (\\d+) uliopita"
        ],
        "\\1 second ago": [
            "sekunde (\\d+) iliyopita",
            "sekunde (\\d+) zilizopita"
        ],
        "\\1 week ago": [
            "wiki (\\d+) iliyopita",
            "wiki (\\d+) zilizopita"
        ],
        "\\1 year ago": [
            "miaka (\\d+) iliyopita",
            "mwaka (\\d+) uliopita"
        ],
        "in \\1 day": [
            "baada ya siku (\\d+)"
        ],
        "in \\1 hour": [
            "baada ya saa (\\d+)"
        ],
        "in \\1 minute": [
            "baada ya dakika (\\d+)"
        ],
        "in \\1 month": [
            "baada ya miezi (\\d+)",
            "baada ya mwezi (\\d+)"
        ],
        "in \\1 second": [
            "baada ya sekunde (\\d+)"
        ],
        "in \\1 week": [
            "baada ya wiki (\\d+)"
        ],
        "in \\1 year": [
            "baada ya miaka (\\d+)",
            "baada ya mwaka (\\d+)"
        ]
    },
    "locale_specific": {
        "sw-CD": {
            "name": "sw-CD",
            "week": [
                "juma"
            ]
        },
        "sw-KE": {
            "name": "sw-KE"
        },
        "sw-UG": {
            "name": "sw-UG"
        }
    },
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
