/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.transport;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.knn.plugin.stats.StatNames;

public class KNNStatsRequest
extends BaseNodesRequest<KNNStatsRequest> {
    public static final String ALL_STATS_KEY = "_all";
    private final Set<String> validStats;
    private final Set<String> statsToBeRetrieved;

    public KNNStatsRequest() {
        super((String[])null);
        this.validStats = StatNames.getNames();
        this.statsToBeRetrieved = new HashSet<String>();
    }

    public KNNStatsRequest(StreamInput in) throws IOException {
        super(in);
        this.validStats = in.readSet(StreamInput::readString);
        this.statsToBeRetrieved = in.readSet(StreamInput::readString);
    }

    public KNNStatsRequest(String ... nodeIds) {
        super(nodeIds);
        this.validStats = StatNames.getNames();
        this.statsToBeRetrieved = new HashSet<String>();
    }

    public void all() {
        this.statsToBeRetrieved.addAll(this.validStats);
    }

    public void clear() {
        this.statsToBeRetrieved.clear();
    }

    public boolean addStat(String stat) {
        if (this.validStats.contains(stat)) {
            this.statsToBeRetrieved.add(stat);
            return true;
        }
        return false;
    }

    public Set<String> getStatsToBeRetrieved() {
        return this.statsToBeRetrieved;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringCollection(this.validStats);
        out.writeStringCollection(this.statsToBeRetrieved);
    }
}

