/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import org.freehep.graphicsio.font.truetype.TTFInput;

public class TTFMemoryInput
extends TTFInput {
    private byte[] data;
    private int pointer;

    public TTFMemoryInput(byte[] data) {
        this.data = data;
    }

    @Override
    public void seek(long offset) {
        this.pointer = (int)offset;
    }

    @Override
    long getPointer() {
        return this.pointer;
    }

    @Override
    public byte readChar() {
        return this.data[this.pointer++];
    }

    @Override
    public int readRawByte() {
        return this.data[this.pointer++] & 0xFF;
    }

    @Override
    public int readByte() {
        return this.data[this.pointer++] & 0xFF;
    }

    @Override
    public short readShort() {
        byte result = this.data[this.pointer++];
        return (short)(result << 8 | this.data[this.pointer++]);
    }

    @Override
    public int readUShort() {
        return this.data[this.pointer++] << 8 | this.data[this.pointer++];
    }

    @Override
    public int readLong() {
        byte result = this.data[this.pointer++];
        return (short)(result << 24 | this.data[this.pointer++] << 16 | this.data[this.pointer++] << 8 | this.data[this.pointer++]);
    }

    @Override
    public long readULong() {
        byte[] temp = new byte[4];
        this.readFully(temp);
        long l = 0L;
        for (int i = 0; i < temp.length; ++i) {
            l |= (long)((temp[3 - i] & 0xFF) << 8 * i);
        }
        return l;
    }

    @Override
    public void readFully(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            b[i] = this.data[this.pointer++];
        }
    }
}

