/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.CmapFormat;

public class CmapFormat12
extends CmapFormat {
    private final int _length;
    private final int _language;
    private final int _nGroups;
    private final int[] _startCharCode;
    private final int[] _endCharCode;
    private final int[] _startGlyphId;

    CmapFormat12(DataInput dataInput) throws IOException {
        dataInput.readUnsignedShort();
        this._length = dataInput.readInt();
        this._language = dataInput.readInt();
        this._nGroups = dataInput.readInt();
        this._startCharCode = new int[this._nGroups];
        this._endCharCode = new int[this._nGroups];
        this._startGlyphId = new int[this._nGroups];
        for (int i = 0; i < this._nGroups; ++i) {
            this._startCharCode[i] = dataInput.readInt();
            this._endCharCode[i] = dataInput.readInt();
            this._startGlyphId[i] = dataInput.readInt();
        }
    }

    @Override
    public int getFormat() {
        return 12;
    }

    @Override
    public int getLength() {
        return this._length;
    }

    @Override
    public int getLanguage() {
        return this._language;
    }

    @Override
    public int getRangeCount() {
        return this._nGroups;
    }

    @Override
    public CmapFormat.Range getRange(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this._nGroups) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new CmapFormat.Range(this._startCharCode[n], this._endCharCode[n]);
    }

    @Override
    public int mapCharCode(int n) {
        try {
            for (int i = 0; i < this._nGroups; ++i) {
                if (this._endCharCode[i] < n) continue;
                if (this._startCharCode[i] <= n) {
                    return n - this._startCharCode[i] + this._startGlyphId[i];
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("error: Array out of bounds - " + arrayIndexOutOfBoundsException.getMessage());
        }
        return 0;
    }

    @Override
    public String toString() {
        return super.toString() + ", nGroups: " + this._nGroups;
    }
}

