/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.JSJSONParser;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.symmetry.UnitCell;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class WyckoffFinder {
    private static final Map<String, WyckoffFinder> helpers = new Hashtable<String, WyckoffFinder>();
    private Lst<Object> positions;
    int npos;
    int ncent;
    protected P3[] centerings;
    protected String[] centeringStr;
    private static WyckoffFinder nullHelper;
    public static final int WYCKOFF_RET_LABEL = -1;
    public static final int WYCKOFF_RET_COORD = -2;
    public static final int WYCKOFF_RET_COORDS = -3;
    public static final int WYCKOFF_RET_COORDS_ALL = 42;

    public WyckoffFinder() {
    }

    WyckoffFinder getWyckoffFinder(Viewer vwr, String sgname) {
        Lst its;
        Map<String, Object> resource;
        int itno;
        WyckoffFinder helper = helpers.get(sgname);
        if (helper == null && (itno = PT.parseInt(PT.split(sgname, ":")[0])) >= 1 && itno <= 230 && (resource = this.getResource(vwr, "ita_" + itno + ".json")) != null && (its = (Lst)resource.get("its")) != null) {
            int i = its.size();
            while (--i >= 0) {
                Map map = (Map)its.get(i);
                if (!sgname.equals(map.get("itaFull"))) continue;
                helper = new WyckoffFinder(map);
                helpers.put(sgname, helper);
                return helper;
            }
        }
        if (helper == null) {
            if (nullHelper == null) {
                nullHelper = new WyckoffFinder(null);
            }
            helpers.put(sgname, nullHelper);
        }
        return helper;
    }

    private WyckoffFinder(Map<String, Object> map) {
        if (map != null) {
            Map wpos = (Map)map.get("wpos");
            this.positions = (Lst)wpos.get("pos");
            this.npos = this.positions.size();
            Lst cent = (Lst)wpos.get("cent");
            if (cent != null) {
                this.ncent = cent.size();
                this.centeringStr = new String[this.ncent];
                this.centerings = new P3[this.ncent];
                int i = this.ncent;
                while (--i >= 0) {
                    String s;
                    this.centeringStr[i] = s = (String)cent.get(i);
                    this.centerings[i] = WyckoffFinder.toPoint(s);
                }
            }
        }
    }

    String getWyckoffPosition(UnitCell uc, P3 p, int returnType) {
        switch (returnType) {
            case 42: {
                SB sb = new SB();
                this.getCenteringStr(-1, sb);
                int i = this.npos;
                while (--i >= 0) {
                    Map map = (Map)this.positions.get(i);
                    String label = (String)map.get("label");
                    sb.appendC('\n').append(label);
                    if (i == 0) {
                        sb.append(" (x,y,z)");
                        continue;
                    }
                    WyckoffFinder.getList((Lst)map.get("coord"), label, sb);
                }
                return sb.toString();
            }
            case -3: 
            case -2: 
            case -1: {
                int i = this.positions.size();
                while (--i >= 0) {
                    Map map = (Map)this.positions.get(i);
                    String label = (String)map.get("label");
                    if (i == 0) {
                        switch (returnType) {
                            case -1: {
                                return label;
                            }
                            case -2: {
                                return "(x,y,z)";
                            }
                            case -3: {
                                return map.get("label") + "  (x,y,z)";
                            }
                        }
                    }
                    Lst coords = (Lst)map.get("coord");
                    int n = coords.size();
                    for (int c = 0; c < n; ++c) {
                        WyckoffPos coord = WyckoffFinder.getWyckoffCoord(coords, c, label);
                        if (!coord.contains(uc, p, this)) continue;
                        switch (returnType) {
                            case -1: {
                                return label;
                            }
                            case -2: {
                                return coord.asString(null, true).toString();
                            }
                            case -3: {
                                SB sbc = new SB();
                                sbc.append(label).appendC(' ');
                                this.getCenteringStr(-1, sbc).appendC(' ');
                                WyckoffFinder.getList(coords, label, sbc);
                                return sbc.toString();
                            }
                        }
                    }
                }
                break;
            }
            default: {
                String letter = "" + (char)returnType;
                int i = this.npos;
                while (--i >= 0) {
                    Map map = (Map)this.positions.get(i);
                    if (!map.get("label").equals(letter)) continue;
                    return i == 0 ? "(x,y,z)" : WyckoffFinder.getList((Lst)map.get("coord"), letter, null).toString();
                }
                break block0;
            }
        }
        return "?";
    }

    private SB getCenteringStr(int n, SB sb) {
        if (sb == null) {
            sb = new SB();
        }
        if (this.ncent == 0) {
            return sb;
        }
        if (n >= 0) {
            sb.appendC('+');
            return WyckoffFinder.wrap(this.centeringStr[n], sb);
        }
        for (int i = 0; i < this.ncent; ++i) {
            sb.appendC('+');
            WyckoffFinder.wrap(this.centeringStr[i], sb);
        }
        return sb;
    }

    protected static SB wrap(String xyz, SB sb) {
        return sb.appendC('(').append(xyz).appendC(')');
    }

    private static SB getList(Lst<Object> coords, String letter, SB sb) {
        if (sb == null) {
            sb = new SB();
        }
        int n = coords.size();
        for (int c = 0; c < n; ++c) {
            WyckoffPos coord = WyckoffFinder.getWyckoffCoord(coords, c, letter);
            sb.append(" ");
            coord.asString(sb, false);
        }
        return sb;
    }

    public P3 findPositionFor(P3 p, String letter) {
        if (this.positions == null) {
            return null;
        }
        int i = this.npos;
        while (--i >= 0) {
            Map map = (Map)this.positions.get(i);
            if (!map.get("label").equals(letter)) continue;
            Lst coords = (Lst)map.get("coord");
            if (coords != null) {
                WyckoffFinder.getWyckoffCoord(coords, 0, letter).set(p);
            }
            return p;
        }
        return null;
    }

    private static WyckoffPos getWyckoffCoord(Lst<Object> coords, int c, String label) {
        Object coord = coords.get(c);
        if (coord instanceof String) {
            coord = new WyckoffPos((String)coord, label);
            coords.set(c, coord);
        }
        return (WyckoffPos)coord;
    }

    private Map<String, Object> getResource(Viewer vwr, String resource) {
        try {
            BufferedReader r = FileManager.getBufferedReaderForResource(vwr, this, "org/jmol/symmetry/", "sg/json/" + resource);
            String[] data = new String[1];
            if (Rdr.readAllAsString(r, Integer.MAX_VALUE, false, data, 0)) {
                return (Map)new JSJSONParser().parse(data[0], true);
            }
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
        }
        return null;
    }

    static P3 toPoint(String xyz) {
        String[] s = PT.split(xyz, ",");
        return P3.new3(PT.parseFloatFraction(s[0]), PT.parseFloatFraction(s[1]), PT.parseFloatFraction(s[2]));
    }

    static class WyckoffPos {
        static final int TYPE_POINT = 1;
        static final int TYPE_LINE = 2;
        static final int TYPE_PLANE = 3;
        private P3 point;
        private V3 line;
        private P4 plane;
        private int type;
        private String label;
        String xyz;
        private static final P3 p1 = new P3();
        private static final P3 p2 = new P3();
        private static final P3 p3 = new P3();
        private static final P3 pc = new P3();
        private static final V3 vt = new V3();
        String thisCentering = "";
        private static final int X = 1;
        private static final int Y = 2;
        private static final int Z = 4;
        private String[][] parts = new String[3][];

        public WyckoffPos(String xyz, String label) {
            this.xyz = xyz;
            this.label = label;
            this.create(xyz);
        }

        private void create(String p) {
            String[] xyz = PT.split(p, ",");
            int nxyz = 0;
            for (int i = 0; i < 3; ++i) {
                if (xyz[i].indexOf(120) >= 0) {
                    nxyz |= 1;
                }
                if (xyz[i].indexOf(121) >= 0) {
                    nxyz |= 2;
                }
                if (xyz[i].indexOf(122) < 0) continue;
                nxyz |= 4;
            }
            switch (nxyz) {
                case 0: {
                    this.type = 1;
                    this.point = WyckoffFinder.toPoint(p);
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    this.type = 2;
                    this.ptFor(0.19f, 0.53f, 0.71f, p1);
                    this.ptFor(0.51f, 0.27f, 0.64f, p2);
                    p2.sub2(p2, p1);
                    p2.normalize();
                    this.point = P3.newP(p1);
                    this.line = V3.newV(p2);
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    this.type = 3;
                    this.ptFor(0.19f, 0.51f, 0.73f, p1);
                    this.ptFor(0.23f, 0.47f, 0.86f, p2);
                    this.ptFor(0.1f, 0.2f, 0.3f, p3);
                    this.plane = Measure.getPlaneThroughPoints(p1, p2, p3, null, null, new P4());
                    break;
                }
            }
        }

        private void ptFor(float x, float y, float z, T3 p) {
            String[] v = PT.split(this.xyz, ",");
            if (this.parts != null) {
                this.parts[0] = this.getParts(v[0]);
                this.parts[1] = this.getParts(v[1]);
                this.parts[2] = this.getParts(v[2]);
            }
            p.set(WyckoffPos.decodeXYZ(this.parts[0], x, y, z), WyckoffPos.decodeXYZ(this.parts[1], x, y, z), WyckoffPos.decodeXYZ(this.parts[2], x, y, z));
        }

        private String[] getParts(String s) {
            s = PT.rep(s, "-", "+-");
            s = PT.rep(s, "x", "*x");
            s = PT.rep(s, "y", "*y");
            s = PT.rep(s, "z", "*z");
            s = PT.rep(s, "-*", "-");
            s = PT.rep(s, "+*", "+");
            return PT.split(s, "+");
        }

        private static float decodeXYZ(String[] parts, float x, float y, float z) {
            float r = 0.0f;
            int p = parts.length;
            while (--p >= 0) {
                String s = parts[p];
                if (s.length() == 0) continue;
                if (s.indexOf(46) >= 0) {
                    r += PT.parseFloat(s);
                    continue;
                }
                float v = 0.0f;
                int f2 = 0;
                int i0 = 0;
                float f = 1.0f;
                switch (s.charAt(0)) {
                    case '-': {
                        f = -1.0f;
                    }
                    case '*': {
                        ++i0;
                    }
                }
                int i = s.length();
                block12: while (--i >= i0) {
                    char c = s.charAt(i);
                    switch (c) {
                        case 'x': {
                            v = x;
                            continue block12;
                        }
                        case 'y': {
                            v = y;
                            continue block12;
                        }
                        case 'z': {
                            v = z;
                            continue block12;
                        }
                        case '/': {
                            f2 = 1;
                            v = 1.0f / v;
                        }
                        case '*': {
                            f *= v;
                            v = 0.0f;
                            continue block12;
                        }
                    }
                    int u = "0123456789".indexOf(c);
                    if (u < 0) {
                        System.err.println("WH ????");
                    }
                    if (v == 0.0f) {
                        v = u;
                        continue;
                    }
                    f2 = f2 == 0 ? 10 : f2 * 10;
                    v += (float)(f2 * u);
                }
                r += f * v;
            }
            return r;
        }

        boolean contains(UnitCell uc, P3 p, WyckoffFinder w) {
            float slop = uc.getPrecision();
            this.thisCentering = null;
            if (this.containsPt(uc, p, slop, true)) {
                return true;
            }
            if (w.centerings != null) {
                int i = w.centerings.length;
                while (--i >= 0) {
                    pc.add2(p, w.centerings[i]);
                    uc.unitize(pc);
                    if (!this.containsPt(uc, pc, slop, true)) continue;
                    this.thisCentering = w.centeringStr[i];
                    return true;
                }
            }
            return false;
        }

        private boolean containsPt(UnitCell uc, P3 p, float slop, boolean doLatticeCheck) {
            if (doLatticeCheck) {
                for (int i = -2; i < 3; ++i) {
                    for (int j = -2; j < 3; ++j) {
                        for (int k = -2; k < 3; ++k) {
                            p3.set(i, j, k);
                            p3.add(p);
                            if (!this.containsPt(uc, p3, slop, false)) continue;
                            System.out.println(this.label + " " + this.xyz + " found for " + i + " " + j + " " + k);
                            return true;
                        }
                    }
                }
                return false;
            }
            float d = 1.0f;
            switch (this.type) {
                case 1: {
                    d = this.point.distance(p);
                    p1.setT(this.point);
                    break;
                }
                case 2: {
                    p1.setT(p);
                    Measure.projectOntoAxis(p1, this.point, this.line, vt);
                    p2.sub2(p1, p);
                    d = p1.distance(p);
                    break;
                }
                case 3: {
                    p1.setT(p);
                    d = Math.abs(Measure.getPlaneProjection(p1, this.plane, vt, vt));
                }
            }
            return d < slop;
        }

        void set(P3 p) {
            switch (this.type) {
                case 1: {
                    p.setT(this.point);
                    break;
                }
                case 2: {
                    Measure.projectOntoAxis(p, this.point, this.line, vt);
                    break;
                }
                case 3: {
                    Measure.getPlaneProjection(p, this.plane, vt, vt);
                    p.setT(vt);
                }
            }
        }

        SB asString(SB sb, boolean withCentering) {
            if (sb == null) {
                sb = new SB();
            }
            WyckoffFinder.wrap(this.xyz, sb);
            if (withCentering && this.thisCentering != null) {
                sb.appendC('+');
                WyckoffFinder.wrap(this.thisCentering, sb);
            }
            return sb;
        }

        public String toString() {
            return this.asString(null, false).toString();
        }
    }
}

