/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.IJavadocTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ModuleReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class JavadocModuleReference
extends Expression
implements IJavadocTypeReference {
    public int tagSourceStart;
    public int tagSourceEnd;
    public TypeReference typeReference;
    public ModuleReference moduleReference;

    public JavadocModuleReference(char[][] cArray, long[] lArray, int n, int n2) {
        this.moduleReference = new ModuleReference(cArray, lArray);
        this.tagSourceStart = n;
        this.tagSourceEnd = n2;
        this.sourceStart = this.moduleReference.sourceStart;
        this.sourceEnd = this.moduleReference.sourceEnd;
        this.bits |= 0x8000;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public int getTagSourceStart() {
        return this.tagSourceStart;
    }

    @Override
    public int getTagSourceEnd() {
        return this.tagSourceEnd;
    }

    public TypeReference getTypeReference() {
        return this.typeReference;
    }

    public void setTypeReference(TypeReference typeReference) {
        this.typeReference = typeReference;
        if (this.typeReference != null) {
            this.sourceEnd = this.typeReference.sourceEnd;
        }
    }

    public ModuleReference getModuleReference() {
        return this.moduleReference;
    }

    public void setModuleReference(ModuleReference moduleReference) {
        this.moduleReference = moduleReference;
        this.sourceStart = this.moduleReference.sourceStart;
        this.sourceStart = this.moduleReference.sourceEnd;
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        if (this.moduleReference != null) {
            stringBuffer.append(this.moduleReference.moduleName);
        }
        stringBuffer.append('/');
        if (this.typeReference != null) {
            this.typeReference.printExpression(n, stringBuffer);
        }
        return stringBuffer;
    }

    public ModuleBinding resolve(Scope scope) {
        return this.moduleReference.resolve(scope);
    }

    private ModuleBinding resolveModule(BlockScope blockScope) {
        return this.moduleReference.resolve(blockScope);
    }

    private ModuleBinding resolveModule(ClassScope classScope) {
        return this.moduleReference.resolve(classScope);
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        this.resolveModule(blockScope);
        if (this.moduleReference.binding != null && this.typeReference != null) {
            return this.typeReference.resolveType(blockScope);
        }
        return null;
    }

    @Override
    public TypeBinding resolveType(ClassScope classScope) {
        this.resolveModule(classScope);
        assert (this.moduleReference.binding != null);
        if (this.typeReference != null) {
            return this.typeReference.resolveType(classScope, -1);
        }
        return null;
    }
}

