/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.ui.components.JColorButton;
import org.gephi.visualization.VizController;
import org.gephi.visualization.VizModel;
import org.gephi.visualization.apiimpl.GraphIO;
import org.openide.util.NbBundle;

public class GlobalSettingsPanel
extends JPanel {
    private JCheckBox autoSelectNeigborCheckbox;
    private JButton backgroundColorButton;
    private JCheckBox hightlightCheckBox;
    private JLabel labelBackgroundColor;
    private JLabel labelZoom;
    private JPanel zoomPanel;
    private JSlider zoomSlider;

    public GlobalSettingsPanel() {
        this.initComponents();
    }

    public void setup() {
        VizModel vizModel = VizController.getInstance().getVizModel();
        vizModel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("init")) {
                    GlobalSettingsPanel.this.refreshSharedConfig();
                } else if (evt.getPropertyName().equals("backgroundColor")) {
                    GlobalSettingsPanel.this.refreshSharedConfig();
                } else if (evt.getPropertyName().equals("autoSelectNeighbor")) {
                    GlobalSettingsPanel.this.refreshSharedConfig();
                } else if (evt.getPropertyName().equals("lightenNonSelectedAuto")) {
                    GlobalSettingsPanel.this.refreshSharedConfig();
                } else if (evt.getPropertyName().equals("use3d")) {
                    GlobalSettingsPanel.this.refreshSharedConfig();
                }
            }
        });
        this.refreshSharedConfig();
        this.hightlightCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VizModel vizModel = VizController.getInstance().getVizModel();
                vizModel.setLightenNonSelectedAuto(GlobalSettingsPanel.this.hightlightCheckBox.isSelected());
            }
        });
        ((JColorButton)this.backgroundColorButton).addPropertyChangeListener(JColorButton.EVENT_COLOR, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                VizModel vizModel = VizController.getInstance().getVizModel();
                vizModel.setBackgroundColor(((JColorButton)GlobalSettingsPanel.this.backgroundColorButton).getColor());
            }
        });
        this.autoSelectNeigborCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VizModel vizModel = VizController.getInstance().getVizModel();
                vizModel.setAutoSelectNeighbor(GlobalSettingsPanel.this.autoSelectNeigborCheckbox.isSelected());
            }
        });
        this.zoomSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int cam = (int)VizController.getInstance().getVizModel().getCameraDistance();
                if (GlobalSettingsPanel.this.zoomSlider.getValue() != cam && cam < GlobalSettingsPanel.this.zoomSlider.getMaximum()) {
                    GraphIO io = VizController.getInstance().getGraphIO();
                    io.setCameraDistance(GlobalSettingsPanel.this.zoomSlider.getValue());
                }
            }
        });
    }

    private void refreshSharedConfig() {
        VizModel vizModel = VizController.getInstance().getVizModel();
        this.setEnable(!vizModel.isDefaultModel());
        if (vizModel.isDefaultModel()) {
            return;
        }
        if (this.autoSelectNeigborCheckbox.isSelected() != vizModel.isAutoSelectNeighbor()) {
            this.autoSelectNeigborCheckbox.setSelected(vizModel.isAutoSelectNeighbor());
        }
        ((JColorButton)this.backgroundColorButton).setColor(vizModel.getBackgroundColor());
        if (this.hightlightCheckBox.isSelected() != vizModel.isLightenNonSelectedAuto()) {
            this.hightlightCheckBox.setSelected(vizModel.isLightenNonSelectedAuto());
        }
    }

    private void setEnable(boolean enable) {
        this.autoSelectNeigborCheckbox.setEnabled(enable);
        this.backgroundColorButton.setEnabled(enable);
        this.hightlightCheckBox.setEnabled(enable);
        this.labelBackgroundColor.setEnabled(enable);
        this.labelZoom.setEnabled(enable);
        this.zoomSlider.setEnabled(enable);
    }

    private void refreshZoom() {
        int zoomValue = (int)VizController.getInstance().getVizModel().getCameraDistance();
        if (this.zoomSlider.getValue() != zoomValue) {
            this.zoomSlider.setValue(zoomValue);
        }
    }

    private void initComponents() {
        this.labelBackgroundColor = new JLabel();
        this.backgroundColorButton = new JColorButton(Color.BLACK);
        this.hightlightCheckBox = new JCheckBox();
        this.autoSelectNeigborCheckbox = new JCheckBox();
        this.zoomPanel = new JPanel();
        this.labelZoom = new JLabel();
        this.zoomSlider = new JSlider();
        this.labelBackgroundColor.setText(NbBundle.getMessage(GlobalSettingsPanel.class, (String)"GlobalSettingsPanel.labelBackgroundColor.text"));
        this.backgroundColorButton.setText(NbBundle.getMessage(GlobalSettingsPanel.class, (String)"GlobalSettingsPanel.backgroundColorButton.text"));
        this.hightlightCheckBox.setText(NbBundle.getMessage(GlobalSettingsPanel.class, (String)"GlobalSettingsPanel.hightlightCheckBox.text"));
        this.hightlightCheckBox.setBorder(null);
        this.hightlightCheckBox.setHorizontalTextPosition(2);
        this.hightlightCheckBox.setMargin(new Insets(2, 0, 2, 2));
        this.autoSelectNeigborCheckbox.setText(NbBundle.getMessage(GlobalSettingsPanel.class, (String)"GlobalSettingsPanel.autoSelectNeigborCheckbox.text"));
        this.autoSelectNeigborCheckbox.setBorder(null);
        this.autoSelectNeigborCheckbox.setHorizontalTextPosition(2);
        this.autoSelectNeigborCheckbox.setMargin(new Insets(2, 0, 2, 2));
        this.zoomPanel.setOpaque(true);
        this.zoomPanel.setLayout(new GridBagLayout());
        this.labelZoom.setText(NbBundle.getMessage(GlobalSettingsPanel.class, (String)"GlobalSettingsPanel.labelZoom.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 2, 0);
        this.zoomPanel.add((Component)this.labelZoom, gridBagConstraints);
        this.zoomSlider.setMaximum(10000);
        this.zoomSlider.setValue(5000);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.zoomPanel.add((Component)this.zoomSlider, gridBagConstraints);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.labelBackgroundColor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.backgroundColorButton, -2, 24, -2)).addComponent(this.autoSelectNeigborCheckbox)).addGap(27, 27, 27).addComponent(this.zoomPanel, -2, 147, -2).addGap(28, 28, 28).addComponent(this.hightlightCheckBox).addGap(32, 32, 32)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hightlightCheckBox, -2, 25, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.zoomPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelBackgroundColor, GroupLayout.Alignment.LEADING, -2, 24, -2).addComponent(this.backgroundColorButton, GroupLayout.Alignment.LEADING, -2, 24, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoSelectNeigborCheckbox, -2, 26, -2)))).addContainerGap()));
    }
}

