/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.security.SecureRandom;
import javax.swing.JOptionPane;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ContextAPI;
import org.zaproxy.zap.extension.api.CoreAPI;
import org.zaproxy.zap.extension.api.OptionsApiPanel;
import org.zaproxy.zap.utils.DesktopUtils;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionAPI
extends ExtensionAdaptor {
    public static final String NAME = "ExtensionAPI";
    @Deprecated
    public static final String API_URL = "http://zap/";
    private OptionsApiPanel optionsApiPanel = null;
    private ZapMenuItem menuAPI = null;
    private CoreAPI coreApi = null;

    public ExtensionAPI() {
        super(NAME);
        this.setOrder(10);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("api.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookView().addOptionPanel(this.getOptionsAPIPanel());
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuAPI());
        }
        this.coreApi = new CoreAPI(extensionHook.getModel().getOptionsParam().getConnectionParam());
        extensionHook.addApiImplementor(this.coreApi);
        extensionHook.addApiImplementor(new ContextAPI());
    }

    private OptionsApiPanel getOptionsAPIPanel() {
        if (this.optionsApiPanel == null) {
            this.optionsApiPanel = new OptionsApiPanel();
        }
        return this.optionsApiPanel;
    }

    public static String generateApiKey() {
        SecureRandom random = new SecureRandom();
        return new BigInteger(130, random).toString(32);
    }

    private ZapMenuItem getMenuAPI() {
        if (this.menuAPI == null) {
            this.menuAPI = new ZapMenuItem("api.menu.tools.url");
            this.menuAPI.setEnabled(DesktopUtils.canOpenUrlInBrowser());
            this.menuAPI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!API.getInstance().isEnabled()) {
                        String title = Constant.messages.getString("api.dialogue.browseApiNotEnabled.title");
                        String message = Constant.messages.getString("api.dialogue.browseApiNotEnabled.message");
                        String confirmButtonLabel = Constant.messages.getString("api.dialogue.browseApiNotEnabled.button.confirm.label");
                        String cancelButtonLabel = Constant.messages.getString("api.dialogue.browseApiNotEnabled.button.cancel.label");
                        int option = JOptionPane.showOptionDialog(ExtensionAPI.this.getView().getMainFrame(), message, title, 0, 3, null, new String[]{confirmButtonLabel, cancelButtonLabel}, null);
                        if (option != 0) {
                            return;
                        }
                        Model.getSingleton().getOptionsParam().getApiParam().setEnabled(true);
                    }
                    DesktopUtils.openUrlInBrowser(API.getInstance().getBaseURL(false));
                }
            });
        }
        return this.menuAPI;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("api.desc");
    }

    public CoreAPI getCoreAPI() {
        return this.coreApi;
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    @Override
    public boolean supportsLowMemory() {
        return true;
    }
}

