/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Role;

public class IfElseStatement
extends Statement {
    public static final TokenRole IF_KEYWORD_ROLE = new TokenRole("if", 1);
    public static final TokenRole ELSE_KEYWORD_ROLE = new TokenRole("else", 1);
    public static final Role<Expression> CONDITION_ROLE = Roles.CONDITION;
    public static final Role<Statement> TRUE_ROLE = new Role<Statement>("True", Statement.class, Statement.NULL);
    public static final Role<Statement> FALSE_ROLE = new Role<Statement>("False", Statement.class, Statement.NULL);

    public IfElseStatement(Expression condition, Statement trueStatement) {
        this(-34, condition, trueStatement, null);
    }

    public IfElseStatement(Expression condition, Statement trueStatement, Statement falseStatement) {
        this(-34, condition, trueStatement, falseStatement);
    }

    public IfElseStatement(int offset, Expression condition, Statement trueStatement) {
        this(offset, condition, trueStatement, null);
    }

    public IfElseStatement(int offset, Expression condition, Statement trueStatement, Statement falseStatement) {
        super(offset);
        this.setCondition(condition);
        this.setTrueStatement(trueStatement);
        this.setFalseStatement(falseStatement);
    }

    public final JavaTokenNode getIfToken() {
        return this.getChildByRole(IF_KEYWORD_ROLE);
    }

    public final JavaTokenNode getElseToken() {
        return this.getChildByRole(IF_KEYWORD_ROLE);
    }

    public final JavaTokenNode getLeftParenthesisToken() {
        return this.getChildByRole(Roles.LEFT_PARENTHESIS);
    }

    public final JavaTokenNode getRightParenthesisToken() {
        return this.getChildByRole(Roles.RIGHT_PARENTHESIS);
    }

    public final Expression getCondition() {
        return this.getChildByRole(CONDITION_ROLE);
    }

    public final void setCondition(Expression value) {
        this.setChildByRole(CONDITION_ROLE, value);
    }

    public final Statement getTrueStatement() {
        return this.getChildByRole(TRUE_ROLE);
    }

    public final void setTrueStatement(Statement value) {
        this.setChildByRole(TRUE_ROLE, value);
    }

    public final Statement getFalseStatement() {
        return this.getChildByRole(FALSE_ROLE);
    }

    public final void setFalseStatement(Statement value) {
        this.setChildByRole(FALSE_ROLE, value);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitIfElseStatement(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof IfElseStatement) {
            IfElseStatement otherStatement = (IfElseStatement)other;
            return !other.isNull() && this.getCondition().matches(otherStatement.getCondition(), match) && this.getTrueStatement().matches(otherStatement.getTrueStatement(), match) && this.getFalseStatement().matches(otherStatement.getFalseStatement(), match);
        }
        return false;
    }
}

