# This file has been autogenerated by the pywayland scanner

# Copyright © 2018 Ilia Bozhinov
# Copyright © 2020 Isaac Freund
# Copyright © 2022 wb9688
# Copyright © 2023 i509VCB
#
# Permission to use, copy, modify, distribute, and sell this
# software and its documentation for any purpose is hereby granted
# without fee, provided that the above copyright notice appear in
# all copies and that both that copyright notice and this permission
# notice appear in supporting documentation, and that the name of
# the copyright holders not be used in advertising or publicity
# pertaining to distribution of the software without specific,
# written prior permission.  The copyright holders make no
# representations about the suitability of this software for any
# purpose.  It is provided "as is" without express or implied
# warranty.
#
# THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
# SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
# SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
# THIS SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)


class ExtForeignToplevelHandleV1(Interface):
    """A mapped toplevel

    A :class:`ExtForeignToplevelHandleV1` object represents a mapped toplevel
    window. A single app may have multiple mapped toplevels.
    """

    name = "ext_foreign_toplevel_handle_v1"
    version = 1


class ExtForeignToplevelHandleV1Proxy(Proxy[ExtForeignToplevelHandleV1]):
    interface = ExtForeignToplevelHandleV1

    @ExtForeignToplevelHandleV1.request()
    def destroy(self) -> None:
        """Destroy the :class:`ExtForeignToplevelHandleV1` object

        This request should be used when the client will no longer use the
        handle or after the closed event has been received to allow destruction
        of the object.

        When a handle is destroyed, a new handle may not be created by the
        server until the toplevel is unmapped and then remapped. Destroying a
        toplevel handle is not recommended unless the client is cleaning up
        child objects before destroying the
        :class:`~pywayland.protocol.ext_foreign_toplevel_list_v1.ExtForeignToplevelListV1`
        object, the toplevel was closed or the toplevel handle will not be used
        in the future.

        Other protocols which extend the :class:`ExtForeignToplevelHandleV1`
        interface should require destructors for extension interfaces be called
        before allowing the toplevel handle to be destroyed.
        """
        self._marshal(0)
        self._destroy()


class ExtForeignToplevelHandleV1Resource(Resource):
    interface = ExtForeignToplevelHandleV1

    @ExtForeignToplevelHandleV1.event()
    def closed(self) -> None:
        """The toplevel has been closed

        The server will emit no further events on the
        :class:`ExtForeignToplevelHandleV1` after this event. Any requests
        received aside from the destroy request must be ignored. Upon receiving
        this event, the client should destroy the handle.

        Other protocols which extend the :class:`ExtForeignToplevelHandleV1`
        interface must also ignore requests other than destructors.
        """
        self._post_event(0)

    @ExtForeignToplevelHandleV1.event()
    def done(self) -> None:
        """All information about the toplevel has been sent

        This event is sent after all changes in the toplevel state have been
        sent.

        This allows changes to the :class:`ExtForeignToplevelHandleV1`
        properties to be atomically applied. Other protocols which extend the
        :class:`ExtForeignToplevelHandleV1` interface may use this event to
        also atomically apply any pending state.

        This event must not be sent after the
        :func:`ExtForeignToplevelHandleV1.closed()` event.
        """
        self._post_event(1)

    @ExtForeignToplevelHandleV1.event(
        Argument(ArgumentType.String),
    )
    def title(self, title: str) -> None:
        """Title change

        The title of the toplevel has changed.

        The configured state must not be applied immediately. See
        :func:`ExtForeignToplevelHandleV1.done()` for details.

        :param title:
        :type title:
            `ArgumentType.String`
        """
        self._post_event(2, title)

    @ExtForeignToplevelHandleV1.event(
        Argument(ArgumentType.String),
    )
    def app_id(self, app_id: str) -> None:
        """App_id change

        The app id of the toplevel has changed.

        The configured state must not be applied immediately. See
        :func:`ExtForeignToplevelHandleV1.done()` for details.

        :param app_id:
        :type app_id:
            `ArgumentType.String`
        """
        self._post_event(3, app_id)

    @ExtForeignToplevelHandleV1.event(
        Argument(ArgumentType.String),
    )
    def identifier(self, identifier: str) -> None:
        """A stable identifier for a toplevel

        This identifier is used to check if two or more toplevel handles belong
        to the same toplevel.

        The identifier is useful for command line tools or privileged clients
        which may need to reference an exact toplevel across processes or
        instances of the
        :class:`~pywayland.protocol.ext_foreign_toplevel_list_v1.ExtForeignToplevelListV1`
        global.

        The compositor must only send this event when the handle is created.

        The identifier must be unique per toplevel and it's handles. Two
        different toplevels must not have the same identifier. The identifier
        is only valid as long as the toplevel is mapped. If the toplevel is
        unmapped the identifier must not be reused. An identifier must not be
        reused by the compositor to ensure there are no races when sharing
        identifiers between processes.

        An identifier is a string that contains up to 32 printable ASCII bytes.
        An identifier must not be an empty string. It is recommended that a
        compositor includes an opaque generation value in identifiers. How the
        generation value is used when generating the identifier is
        implementation dependent.

        :param identifier:
        :type identifier:
            `ArgumentType.String`
        """
        self._post_event(4, identifier)


class ExtForeignToplevelHandleV1Global(Global):
    interface = ExtForeignToplevelHandleV1


ExtForeignToplevelHandleV1._gen_c()
ExtForeignToplevelHandleV1.proxy_class = ExtForeignToplevelHandleV1Proxy
ExtForeignToplevelHandleV1.resource_class = ExtForeignToplevelHandleV1Resource
ExtForeignToplevelHandleV1.global_class = ExtForeignToplevelHandleV1Global
