# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
IMeshData module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_imeshdata.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _IMeshData
else:
    import _IMeshData

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _IMeshData.delete_SwigPyIterator

    def value(self):
        return _IMeshData.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _IMeshData.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _IMeshData.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _IMeshData.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _IMeshData.SwigPyIterator_equal(self, x)

    def copy(self):
        return _IMeshData.SwigPyIterator_copy(self)

    def next(self):
        return _IMeshData.SwigPyIterator_next(self)

    def __next__(self):
        return _IMeshData.SwigPyIterator___next__(self)

    def previous(self):
        return _IMeshData.SwigPyIterator_previous(self)

    def advance(self, n):
        return _IMeshData.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _IMeshData.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _IMeshData.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _IMeshData.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _IMeshData.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _IMeshData.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _IMeshData.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _IMeshData:
_IMeshData.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _IMeshData.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TopoDS
import OCC.Core.Message
import OCC.Core.TCollection
import OCC.Core.OSD
import OCC.Core.TColStd
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.gp
import OCC.Core.BRepAdaptor
import OCC.Core.Adaptor3d
import OCC.Core.Geom
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.Adaptor2d
import OCC.Core.Geom2d
import OCC.Core.math
import OCC.Core.GeomAdaptor
import OCC.Core.Geom2dAdaptor

from enum import IntEnum
from OCC.Core.Exception import *

IMeshData_NoError = _IMeshData.IMeshData_NoError
IMeshData_OpenWire = _IMeshData.IMeshData_OpenWire
IMeshData_SelfIntersectingWire = _IMeshData.IMeshData_SelfIntersectingWire
IMeshData_Failure = _IMeshData.IMeshData_Failure
IMeshData_ReMesh = _IMeshData.IMeshData_ReMesh
IMeshData_UnorientedWire = _IMeshData.IMeshData_UnorientedWire
IMeshData_TooFewPoints = _IMeshData.IMeshData_TooFewPoints
IMeshData_Outdated = _IMeshData.IMeshData_Outdated
IMeshData_Reused = _IMeshData.IMeshData_Reused
IMeshData_UserBreak = _IMeshData.IMeshData_UserBreak


class IMeshData_Status(IntEnum):
	IMeshData_NoError = 0
	IMeshData_OpenWire = 1
	IMeshData_SelfIntersectingWire = 2
	IMeshData_Failure = 4
	IMeshData_ReMesh = 8
	IMeshData_UnorientedWire = 16
	IMeshData_TooFewPoints = 32
	IMeshData_Outdated = 64
	IMeshData_Reused = 128
	IMeshData_UserBreak = 256
IMeshData_NoError = IMeshData_Status.IMeshData_NoError
IMeshData_OpenWire = IMeshData_Status.IMeshData_OpenWire
IMeshData_SelfIntersectingWire = IMeshData_Status.IMeshData_SelfIntersectingWire
IMeshData_Failure = IMeshData_Status.IMeshData_Failure
IMeshData_ReMesh = IMeshData_Status.IMeshData_ReMesh
IMeshData_UnorientedWire = IMeshData_Status.IMeshData_UnorientedWire
IMeshData_TooFewPoints = IMeshData_Status.IMeshData_TooFewPoints
IMeshData_Outdated = IMeshData_Status.IMeshData_Outdated
IMeshData_Reused = IMeshData_Status.IMeshData_Reused
IMeshData_UserBreak = IMeshData_Status.IMeshData_UserBreak


def Handle_IMeshData_ParametersList_Create():
    return _IMeshData.Handle_IMeshData_ParametersList_Create()

def Handle_IMeshData_ParametersList_DownCast(t):
    return _IMeshData.Handle_IMeshData_ParametersList_DownCast(t)

def Handle_IMeshData_ParametersList_IsNull(t):
    return _IMeshData.Handle_IMeshData_ParametersList_IsNull(t)

def Handle_IMeshData_Shape_Create():
    return _IMeshData.Handle_IMeshData_Shape_Create()

def Handle_IMeshData_Shape_DownCast(t):
    return _IMeshData.Handle_IMeshData_Shape_DownCast(t)

def Handle_IMeshData_Shape_IsNull(t):
    return _IMeshData.Handle_IMeshData_Shape_IsNull(t)

def Handle_IMeshData_Curve_Create():
    return _IMeshData.Handle_IMeshData_Curve_Create()

def Handle_IMeshData_Curve_DownCast(t):
    return _IMeshData.Handle_IMeshData_Curve_DownCast(t)

def Handle_IMeshData_Curve_IsNull(t):
    return _IMeshData.Handle_IMeshData_Curve_IsNull(t)

def Handle_IMeshData_Model_Create():
    return _IMeshData.Handle_IMeshData_Model_Create()

def Handle_IMeshData_Model_DownCast(t):
    return _IMeshData.Handle_IMeshData_Model_DownCast(t)

def Handle_IMeshData_Model_IsNull(t):
    return _IMeshData.Handle_IMeshData_Model_IsNull(t)

def Handle_IMeshData_PCurve_Create():
    return _IMeshData.Handle_IMeshData_PCurve_Create()

def Handle_IMeshData_PCurve_DownCast(t):
    return _IMeshData.Handle_IMeshData_PCurve_DownCast(t)

def Handle_IMeshData_PCurve_IsNull(t):
    return _IMeshData.Handle_IMeshData_PCurve_IsNull(t)

def Handle_IMeshData_TessellatedShape_Create():
    return _IMeshData.Handle_IMeshData_TessellatedShape_Create()

def Handle_IMeshData_TessellatedShape_DownCast(t):
    return _IMeshData.Handle_IMeshData_TessellatedShape_DownCast(t)

def Handle_IMeshData_TessellatedShape_IsNull(t):
    return _IMeshData.Handle_IMeshData_TessellatedShape_IsNull(t)

def Handle_IMeshData_Edge_Create():
    return _IMeshData.Handle_IMeshData_Edge_Create()

def Handle_IMeshData_Edge_DownCast(t):
    return _IMeshData.Handle_IMeshData_Edge_DownCast(t)

def Handle_IMeshData_Edge_IsNull(t):
    return _IMeshData.Handle_IMeshData_Edge_IsNull(t)

def Handle_IMeshData_Face_Create():
    return _IMeshData.Handle_IMeshData_Face_Create()

def Handle_IMeshData_Face_DownCast(t):
    return _IMeshData.Handle_IMeshData_Face_DownCast(t)

def Handle_IMeshData_Face_IsNull(t):
    return _IMeshData.Handle_IMeshData_Face_IsNull(t)

def Handle_IMeshData_Wire_Create():
    return _IMeshData.Handle_IMeshData_Wire_Create()

def Handle_IMeshData_Wire_DownCast(t):
    return _IMeshData.Handle_IMeshData_Wire_DownCast(t)

def Handle_IMeshData_Wire_IsNull(t):
    return _IMeshData.Handle_IMeshData_Wire_IsNull(t)
class IMeshData_ParametersList(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Clear(self, *args):
        r"""

        Parameters
        ----------
        isKeepEndPoints: bool

        Return
        -------
        None

        Description
        -----------
        Clears parameters list.

        """
        return _IMeshData.IMeshData_ParametersList_Clear(self, *args)

    def GetParameter(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns parameter with the given index.

        """
        return _IMeshData.IMeshData_ParametersList_GetParameter(self, *args)

    def ParametersNb(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns number of parameters.

        """
        return _IMeshData.IMeshData_ParametersList_ParametersNb(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IMeshData_ParametersList_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IMeshData.delete_IMeshData_ParametersList

# Register IMeshData_ParametersList in _IMeshData:
_IMeshData.IMeshData_ParametersList_swigregister(IMeshData_ParametersList)
class IMeshData_Shape(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def GetShape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns shape assigned to discrete shape.

        """
        return _IMeshData.IMeshData_Shape_GetShape(self, *args)

    def SetShape(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Assigns shape to discrete shape.

        """
        return _IMeshData.IMeshData_Shape_SetShape(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IMeshData_Shape_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IMeshData.delete_IMeshData_Shape

# Register IMeshData_Shape in _IMeshData:
_IMeshData.IMeshData_Shape_swigregister(IMeshData_Shape)
class IMeshData_StatusOwner(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def GetStatusMask(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns complete status mask.

        """
        return _IMeshData.IMeshData_StatusOwner_GetStatusMask(self, *args)

    def IsEqual(self, *args):
        r"""

        Parameters
        ----------
        theValue: IMeshData_Status

        Return
        -------
        bool

        Description
        -----------
        Returns true in case if status is strictly equal to the given value.

        """
        return _IMeshData.IMeshData_StatusOwner_IsEqual(self, *args)

    def IsSet(self, *args):
        r"""

        Parameters
        ----------
        theValue: IMeshData_Status

        Return
        -------
        bool

        Description
        -----------
        Returns true in case if status is set.

        """
        return _IMeshData.IMeshData_StatusOwner_IsSet(self, *args)

    def SetStatus(self, *args):
        r"""

        Parameters
        ----------
        theValue: IMeshData_Status

        Return
        -------
        None

        Description
        -----------
        Adds status to status flags of a face.

        """
        return _IMeshData.IMeshData_StatusOwner_SetStatus(self, *args)

    def UnsetStatus(self, *args):
        r"""

        Parameters
        ----------
        theValue: IMeshData_Status

        Return
        -------
        None

        Description
        -----------
        Adds status to status flags of a face.

        """
        return _IMeshData.IMeshData_StatusOwner_UnsetStatus(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IMeshData.delete_IMeshData_StatusOwner

# Register IMeshData_StatusOwner in _IMeshData:
_IMeshData.IMeshData_StatusOwner_swigregister(IMeshData_StatusOwner)
class IMeshData_Curve(IMeshData_ParametersList):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def AddPoint(self, *args):
        r"""

        Parameters
        ----------
        thePoint: gp_Pnt
        theParamOnCurve: float

        Return
        -------
        None

        Description
        -----------
        Adds new discretization point to curve.

        """
        return _IMeshData.IMeshData_Curve_AddPoint(self, *args)

    def GetPoint(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns discretization point with the given index.

        """
        return _IMeshData.IMeshData_Curve_GetPoint(self, *args)

    def InsertPoint(self, *args):
        r"""

        Parameters
        ----------
        thePosition: int
        thePoint: gp_Pnt
        theParamOnPCurve: float

        Return
        -------
        None

        Description
        -----------
        Inserts new discretization point at the given position.

        """
        return _IMeshData.IMeshData_Curve_InsertPoint(self, *args)

    def RemovePoint(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        None

        Description
        -----------
        Removes point with the given index.

        """
        return _IMeshData.IMeshData_Curve_RemovePoint(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IMeshData_Curve_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IMeshData.delete_IMeshData_Curve

# Register IMeshData_Curve in _IMeshData:
_IMeshData.IMeshData_Curve_swigregister(IMeshData_Curve)
class IMeshData_Model(IMeshData_Shape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def AddEdge(self, *args):
        r"""

        Parameters
        ----------
        theEdge: TopoDS_Edge

        Return
        -------
        IMeshData::IEdgeHandle

        Description
        -----------
        Adds new edge to shape model.

        """
        return _IMeshData.IMeshData_Model_AddEdge(self, *args)

    def AddFace(self, *args):
        r"""

        Parameters
        ----------
        theFace: TopoDS_Face

        Return
        -------
        IMeshData::IFaceHandle

        Description
        -----------
        Adds new face to shape model.

        """
        return _IMeshData.IMeshData_Model_AddFace(self, *args)

    def EdgesNb(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns number of edges in discrete model.

        """
        return _IMeshData.IMeshData_Model_EdgesNb(self, *args)

    def FacesNb(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns number of faces in discrete model.

        """
        return _IMeshData.IMeshData_Model_FacesNb(self, *args)

    def GetEdge(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        IMeshData::IEdgeHandle

        Description
        -----------
        Gets model's edge with the given index.

        """
        return _IMeshData.IMeshData_Model_GetEdge(self, *args)

    def GetFace(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        IMeshData::IFaceHandle

        Description
        -----------
        Gets model's face with the given index.

        """
        return _IMeshData.IMeshData_Model_GetFace(self, *args)

    def GetMaxSize(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns maximum size of shape model.

        """
        return _IMeshData.IMeshData_Model_GetMaxSize(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IMeshData_Model_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IMeshData.delete_IMeshData_Model

# Register IMeshData_Model in _IMeshData:
_IMeshData.IMeshData_Model_swigregister(IMeshData_Model)
class IMeshData_PCurve(IMeshData_ParametersList):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def AddPoint(self, *args):
        r"""

        Parameters
        ----------
        thePoint: gp_Pnt2d
        theParamOnPCurve: float

        Return
        -------
        None

        Description
        -----------
        Adds new discretization point to pcurve.

        """
        return _IMeshData.IMeshData_PCurve_AddPoint(self, *args)

    def GetFace(self, *args):
        r"""
        Return
        -------
        IMeshData::IFacePtr

        Description
        -----------
        Returns discrete face pcurve is associated to.

        """
        return _IMeshData.IMeshData_PCurve_GetFace(self, *args)

    def GetIndex(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        int

        Description
        -----------
        Returns index in mesh corresponded to discretization point with the given index.

        """
        return _IMeshData.IMeshData_PCurve_GetIndex(self, *args)

    def GetOrientation(self, *args):
        r"""
        Return
        -------
        TopAbs_Orientation

        Description
        -----------
        Returns orientation of the edge associated with current pcurve.

        """
        return _IMeshData.IMeshData_PCurve_GetOrientation(self, *args)

    def GetPoint(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns discretization point with the given index.

        """
        return _IMeshData.IMeshData_PCurve_GetPoint(self, *args)

    def InsertPoint(self, *args):
        r"""

        Parameters
        ----------
        thePosition: int
        thePoint: gp_Pnt2d
        theParamOnPCurve: float

        Return
        -------
        None

        Description
        -----------
        Inserts new discretization point at the given position.

        """
        return _IMeshData.IMeshData_PCurve_InsertPoint(self, *args)

    def IsForward(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns forward flag of this pcurve.

        """
        return _IMeshData.IMeshData_PCurve_IsForward(self, *args)

    def IsInternal(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns internal flag of this pcurve.

        """
        return _IMeshData.IMeshData_PCurve_IsInternal(self, *args)

    def RemovePoint(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        None

        Description
        -----------
        Removes point with the given index.

        """
        return _IMeshData.IMeshData_PCurve_RemovePoint(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IMeshData_PCurve_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IMeshData.delete_IMeshData_PCurve

# Register IMeshData_PCurve in _IMeshData:
_IMeshData.IMeshData_PCurve_swigregister(IMeshData_PCurve)
class IMeshData_TessellatedShape(IMeshData_Shape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def GetDeflection(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Gets deflection value for the discrete model.

        """
        return _IMeshData.IMeshData_TessellatedShape_GetDeflection(self, *args)

    def SetDeflection(self, *args):
        r"""

        Parameters
        ----------
        theValue: float

        Return
        -------
        None

        Description
        -----------
        Sets deflection value for the discrete model.

        """
        return _IMeshData.IMeshData_TessellatedShape_SetDeflection(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IMeshData_TessellatedShape_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IMeshData.delete_IMeshData_TessellatedShape

# Register IMeshData_TessellatedShape in _IMeshData:
_IMeshData.IMeshData_TessellatedShape_swigregister(IMeshData_TessellatedShape)
class IMeshData_Edge(IMeshData_TessellatedShape, IMeshData_StatusOwner):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def AddPCurve(self, *args):
        r"""

        Parameters
        ----------
        theDFace: IMeshData::IFacePtr
        theOrientation: TopAbs_Orientation

        Return
        -------
        IMeshData::IPCurveHandle

        Description
        -----------
        Adds discrete pcurve for the specified discrete face.

        """
        return _IMeshData.IMeshData_Edge_AddPCurve(self, *args)

    def Clear(self, *args):
        r"""

        Parameters
        ----------
        isKeepEndPoints: bool

        Return
        -------
        None

        Description
        -----------
        Clears curve and all pcurves assigned to the edge from discretization.

        """
        return _IMeshData.IMeshData_Edge_Clear(self, *args)

    def GetAngularDeflection(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Gets value of angular deflection for the discrete model.

        """
        return _IMeshData.IMeshData_Edge_GetAngularDeflection(self, *args)

    def GetCurve(self, *args):
        r"""
        Return
        -------
        IMeshData::ICurveHandle

        Description
        -----------
        Returns 3d curve associated with current edge.

        """
        return _IMeshData.IMeshData_Edge_GetCurve(self, *args)

    def GetDegenerated(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns degenerative flag. by default equals to flag stored in topological shape.

        """
        return _IMeshData.IMeshData_Edge_GetDegenerated(self, *args)

    def GetEdge(self, *args):
        r"""
        Return
        -------
        TopoDS_Edge

        Description
        -----------
        Returns topods_edge attached to model.

        """
        return _IMeshData.IMeshData_Edge_GetEdge(self, *args)

    def GetPCurve(self, *args):
        r"""

        Parameters
        ----------
        theDFace: IMeshData::IFacePtr
        theOrientation: TopAbs_Orientation

        Return
        -------
        IMeshData::IPCurveHandle

        Description
        -----------
        Returns pcurve for the specified discrete face.

        Parameters
        ----------
        theIndex: int

        Return
        -------
        IMeshData::IPCurveHandle

        Description
        -----------
        Returns pcurve with the given index.

        """
        return _IMeshData.IMeshData_Edge_GetPCurve(self, *args)

    def GetSameParam(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns same param flag. by default equals to flag stored in topological shape.

        """
        return _IMeshData.IMeshData_Edge_GetSameParam(self, *args)

    def GetSameRange(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns same range flag. by default equals to flag stored in topological shape.

        """
        return _IMeshData.IMeshData_Edge_GetSameRange(self, *args)

    def IsFree(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true in case if the edge is free one, i.e. it does not have pcurves.

        """
        return _IMeshData.IMeshData_Edge_IsFree(self, *args)

    def PCurvesNb(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns number of pcurves assigned to current edge.

        """
        return _IMeshData.IMeshData_Edge_PCurvesNb(self, *args)

    def SetAngularDeflection(self, *args):
        r"""

        Parameters
        ----------
        theValue: float

        Return
        -------
        None

        Description
        -----------
        Sets value of angular deflection for the discrete model.

        """
        return _IMeshData.IMeshData_Edge_SetAngularDeflection(self, *args)

    def SetCurve(self, *args):
        r"""

        Parameters
        ----------
        theCurve: IMeshData::ICurveHandle

        Return
        -------
        None

        Description
        -----------
        Sets 3d curve associated with current edge.

        """
        return _IMeshData.IMeshData_Edge_SetCurve(self, *args)

    def SetDegenerated(self, *args):
        r"""

        Parameters
        ----------
        theValue: bool

        Return
        -------
        None

        Description
        -----------
        Updates degenerative flag.

        """
        return _IMeshData.IMeshData_Edge_SetDegenerated(self, *args)

    def SetSameParam(self, *args):
        r"""

        Parameters
        ----------
        theValue: bool

        Return
        -------
        None

        Description
        -----------
        Updates same param flag.

        """
        return _IMeshData.IMeshData_Edge_SetSameParam(self, *args)

    def SetSameRange(self, *args):
        r"""

        Parameters
        ----------
        theValue: bool

        Return
        -------
        None

        Description
        -----------
        Updates same range flag.

        """
        return _IMeshData.IMeshData_Edge_SetSameRange(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IMeshData_Edge_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IMeshData.delete_IMeshData_Edge

# Register IMeshData_Edge in _IMeshData:
_IMeshData.IMeshData_Edge_swigregister(IMeshData_Edge)
class IMeshData_Face(IMeshData_TessellatedShape, IMeshData_StatusOwner):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def AddWire(self, *args):
        r"""

        Parameters
        ----------
        theWire: TopoDS_Wire
        theEdgeNb: int (optional, default to 0)

        Return
        -------
        IMeshData::IWireHandle

        Description
        -----------
        Adds wire to discrete model of face.

        """
        return _IMeshData.IMeshData_Face_AddWire(self, *args)

    def GetFace(self, *args):
        r"""
        Return
        -------
        TopoDS_Face

        Description
        -----------
        Returns topods_face attached to model.

        """
        return _IMeshData.IMeshData_Face_GetFace(self, *args)

    def GetSurface(self, *args):
        r"""
        Return
        -------
        opencascade::handle<BRepAdaptor_Surface>

        Description
        -----------
        Returns face's surface.

        """
        return _IMeshData.IMeshData_Face_GetSurface(self, *args)

    def GetWire(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        IMeshData::IWireHandle

        Description
        -----------
        Returns discrete edge with the given index.

        """
        return _IMeshData.IMeshData_Face_GetWire(self, *args)

    def IsValid(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns whether the face discrete model is valid.

        """
        return _IMeshData.IMeshData_Face_IsValid(self, *args)

    def WiresNb(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns number of wires.

        """
        return _IMeshData.IMeshData_Face_WiresNb(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IMeshData_Face_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IMeshData.delete_IMeshData_Face

# Register IMeshData_Face in _IMeshData:
_IMeshData.IMeshData_Face_swigregister(IMeshData_Face)
class IMeshData_Wire(IMeshData_TessellatedShape, IMeshData_StatusOwner):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def AddEdge(self, *args):
        r"""

        Parameters
        ----------
        theDEdge: IMeshData::IEdgePtr
        theOrientation: TopAbs_Orientation

        Return
        -------
        int

        Description
        -----------
        Adds new discrete edge with specified orientation to wire chain. return index of added edge in wire chain.

        """
        return _IMeshData.IMeshData_Wire_AddEdge(self, *args)

    def EdgesNb(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns number of edges.

        """
        return _IMeshData.IMeshData_Wire_EdgesNb(self, *args)

    def GetEdge(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        IMeshData::IEdgePtr

        Description
        -----------
        Returns discrete edge with the given index.

        """
        return _IMeshData.IMeshData_Wire_GetEdge(self, *args)

    def GetEdgeOrientation(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        TopAbs_Orientation

        Description
        -----------
        Returns true if orientation of discrete edge with the given index is forward.

        """
        return _IMeshData.IMeshData_Wire_GetEdgeOrientation(self, *args)

    def GetWire(self, *args):
        r"""
        Return
        -------
        TopoDS_Wire

        Description
        -----------
        Returns topods_face attached to model.

        """
        return _IMeshData.IMeshData_Wire_GetWire(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IMeshData_Wire_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IMeshData.delete_IMeshData_Wire

# Register IMeshData_Wire in _IMeshData:
_IMeshData.IMeshData_Wire_swigregister(IMeshData_Wire)



