/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.gamma.transactionalobjects;

import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.LockMode;
import org.multiverse.api.Txn;
import org.multiverse.api.exceptions.LockedException;
import org.multiverse.api.functions.Function;
import org.multiverse.api.functions.Functions;
import org.multiverse.api.functions.LongFunction;
import org.multiverse.api.predicates.LongPredicate;
import org.multiverse.api.references.TxnLong;
import org.multiverse.stms.gamma.GammaStm;
import org.multiverse.stms.gamma.GammaStmUtils;
import org.multiverse.stms.gamma.Listeners;
import org.multiverse.stms.gamma.ThreadLocalGammaObjectPool;
import org.multiverse.stms.gamma.transactionalobjects.BaseGammaTxnRef;
import org.multiverse.stms.gamma.transactionalobjects.Tranlocal;
import org.multiverse.stms.gamma.transactions.GammaTxn;

public class GammaTxnLong
extends BaseGammaTxnRef
implements TxnLong {
    public GammaTxnLong(long value) {
        this((GammaStm)GlobalStmInstance.getGlobalStmInstance(), value);
    }

    public GammaTxnLong(GammaStm stm) {
        this(stm, 0L);
    }

    public GammaTxnLong(GammaStm stm, long initialValue) {
        super(stm, 2);
        this.long_value = initialValue;
        this.version = 1L;
    }

    public GammaTxnLong(GammaTxn tx) {
        this(tx, 0L);
    }

    public GammaTxnLong(GammaTxn tx, long value) {
        super(tx.getConfig().stm, 2);
        this.arriveAndLock(1, 3);
        Tranlocal tranlocal = this.openForConstruction(tx);
        tranlocal.long_value = value;
    }

    @Override
    public final long get() {
        return this.get(GammaStmUtils.getRequiredThreadLocalGammaTxn());
    }

    @Override
    public final long get(Txn tx) {
        return this.get(GammaStmUtils.asGammaTxn(tx));
    }

    public final long get(GammaTxn tx) {
        return this.openForRead((GammaTxn)tx, (int)0).long_value;
    }

    @Override
    public final long getAndLock(LockMode lockMode) {
        return this.getAndLock(GammaStmUtils.getRequiredThreadLocalGammaTxn(), lockMode);
    }

    @Override
    public final long getAndLock(Txn tx, LockMode lockMode) {
        return this.getAndLock(GammaStmUtils.asGammaTxn(tx), lockMode);
    }

    public final long getAndLock(GammaTxn tx, LockMode lockMode) {
        return this.getLong(tx, lockMode);
    }

    @Override
    public final long set(long value) {
        return this.set(GammaStmUtils.getRequiredThreadLocalGammaTxn(), value);
    }

    @Override
    public final long set(Txn tx, long value) {
        return this.set(GammaStmUtils.asGammaTxn(tx), value);
    }

    public final long set(GammaTxn tx, long value) {
        this.openForWrite((GammaTxn)tx, (int)0).long_value = value;
        return value;
    }

    @Override
    public final long setAndLock(long value, LockMode lockMode) {
        return this.setAndLock(GammaStmUtils.getRequiredThreadLocalGammaTxn(), value, lockMode);
    }

    @Override
    public final long setAndLock(Txn tx, long value, LockMode lockMode) {
        return this.setAndLock(GammaStmUtils.asGammaTxn(tx), value, lockMode);
    }

    public final long setAndLock(GammaTxn tx, long value, LockMode lockMode) {
        return this.setLong(tx, lockMode, value, false);
    }

    @Override
    public final long getAndSet(long value) {
        return this.getAndSet(GammaStmUtils.getRequiredThreadLocalGammaTxn(), value);
    }

    @Override
    public final long getAndSet(Txn tx, long value) {
        return this.getAndSet(GammaStmUtils.asGammaTxn(tx), value);
    }

    public final long getAndSet(GammaTxn tx, long value) {
        Tranlocal tranlocal = this.openForWrite(tx, 0);
        long oldValue = tranlocal.long_value;
        tranlocal.long_value = value;
        return oldValue;
    }

    @Override
    public final long getAndSetAndLock(long value, LockMode lockMode) {
        return this.getAndSetAndLock(GammaStmUtils.getRequiredThreadLocalGammaTxn(), value, lockMode);
    }

    @Override
    public final long getAndSetAndLock(Txn tx, long value, LockMode lockMode) {
        return this.getAndSetLock(GammaStmUtils.asGammaTxn(tx), value, lockMode);
    }

    public final long getAndSetLock(GammaTxn tx, long value, LockMode lockMode) {
        return this.setLong(tx, lockMode, value, true);
    }

    @Override
    public final long atomicGet() {
        return this.atomicGetLong();
    }

    @Override
    public final long atomicWeakGet() {
        return this.long_value;
    }

    @Override
    public final long atomicSet(long newValue) {
        return this.atomicSetLong(newValue, false);
    }

    @Override
    public final long atomicGetAndSet(long newValue) {
        return this.atomicSetLong(newValue, true);
    }

    @Override
    public final void commute(LongFunction function) {
        this.commute(GammaStmUtils.getRequiredThreadLocalGammaTxn(), function);
    }

    @Override
    public final void commute(Txn tx, LongFunction function) {
        this.openForCommute(GammaStmUtils.asGammaTxn(tx), (Function)function);
    }

    public final void commute(GammaTxn tx, LongFunction function) {
        this.openForCommute(tx, (Function)function);
    }

    @Override
    public final long atomicAlterAndGet(LongFunction function) {
        return this.atomicAlter(function, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long atomicAlter(LongFunction function, boolean returnOld) {
        long newValue;
        if (function == null) {
            throw new NullPointerException("Function can't be null");
        }
        int arriveStatus = this.arriveAndExclusiveLockOrBackoff();
        if (arriveStatus == 0) {
            throw new LockedException();
        }
        long oldValue = this.long_value;
        boolean abort = true;
        try {
            newValue = function.call(oldValue);
            abort = false;
        }
        finally {
            if (abort) {
                this.departAfterFailureAndUnlock();
            }
        }
        if (oldValue == newValue) {
            if ((arriveStatus & 2) != 0) {
                this.unlockByUnregistered();
            } else {
                this.departAfterReadingAndUnlock();
            }
            return oldValue;
        }
        if ((arriveStatus & 4) != 0) {
            this.stm.globalConflictCounter.signalConflict();
        }
        this.long_value = newValue;
        ++this.version;
        Listeners listeners = this.___removeListenersAfterWrite();
        this.departAfterUpdateAndUnlock();
        if (listeners != null) {
            listeners.openAll(ThreadLocalGammaObjectPool.getThreadLocalGammaObjectPool());
        }
        return returnOld ? oldValue : newValue;
    }

    @Override
    public final long alterAndGet(LongFunction function) {
        return this.alterAndGet(GammaStmUtils.getRequiredThreadLocalGammaTxn(), function);
    }

    @Override
    public final long alterAndGet(Txn tx, LongFunction function) {
        return this.alterAndGet(GammaStmUtils.asGammaTxn(tx), function);
    }

    public final long alterAndGet(GammaTxn tx, LongFunction function) {
        return this.alter(tx, function, false);
    }

    @Override
    public final long atomicGetAndAlter(LongFunction function) {
        return this.atomicAlter(function, true);
    }

    @Override
    public final long getAndAlter(LongFunction function) {
        return this.getAndAlter(GammaStmUtils.getRequiredThreadLocalGammaTxn(), function);
    }

    @Override
    public final long getAndAlter(Txn tx, LongFunction function) {
        return this.getAndAlter(GammaStmUtils.asGammaTxn(tx), function);
    }

    public final long getAndAlter(GammaTxn tx, LongFunction function) {
        return this.alter(tx, function, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long alter(GammaTxn tx, LongFunction function, boolean returnOld) {
        if (tx == null) {
            throw new NullPointerException();
        }
        if (function == null) {
            tx.abort();
            throw new NullPointerException("Function can't be null");
        }
        Tranlocal write = this.openForWrite(tx, 0);
        boolean abort = true;
        try {
            long oldValue = write.long_value;
            write.long_value = function.call(oldValue);
            abort = false;
            long l = returnOld ? oldValue : write.long_value;
            return l;
        }
        finally {
            if (abort) {
                tx.abort();
            }
        }
    }

    @Override
    public final boolean atomicCompareAndSet(long expectedValue, long newValue) {
        return this.atomicCompareAndSetLong(expectedValue, newValue);
    }

    @Override
    public final long atomicGetAndIncrement(long amount) {
        long result = this.atomicIncrementAndGet(amount);
        return result - amount;
    }

    @Override
    public final long getAndIncrement(long amount) {
        return this.getAndIncrement(GammaStmUtils.getRequiredThreadLocalGammaTxn(), amount);
    }

    @Override
    public final long getAndIncrement(Txn tx, long amount) {
        return this.getAndIncrement((GammaTxn)tx, amount);
    }

    public final long getAndIncrement(GammaTxn tx, long amount) {
        Tranlocal tranlocal = this.openForWrite(tx, 0);
        long oldValue = tranlocal.long_value;
        tranlocal.long_value += amount;
        return oldValue;
    }

    @Override
    public final long atomicIncrementAndGet(long amount) {
        long newValue;
        int arriveStatus = this.arriveAndExclusiveLockOrBackoff();
        if (arriveStatus == 0) {
            throw new LockedException();
        }
        long oldValue = this.long_value;
        if (amount == 0L) {
            if ((arriveStatus & 2) != 0) {
                this.unlockByUnregistered();
            } else {
                this.departAfterReadingAndUnlock();
            }
            return oldValue;
        }
        if ((arriveStatus & 4) != 0) {
            this.stm.globalConflictCounter.signalConflict();
        }
        this.long_value = newValue = oldValue + amount;
        ++this.version;
        Listeners listeners = this.___removeListenersAfterWrite();
        this.departAfterUpdateAndUnlock();
        if (listeners != null) {
            listeners.openAll(ThreadLocalGammaObjectPool.getThreadLocalGammaObjectPool());
        }
        return newValue;
    }

    @Override
    public final long incrementAndGet(long amount) {
        return this.incrementAndGet(GammaStmUtils.getRequiredThreadLocalGammaTxn(), amount);
    }

    @Override
    public final long incrementAndGet(Txn tx, long amount) {
        return this.incrementAndGet(GammaStmUtils.asGammaTxn(tx), amount);
    }

    public final long incrementAndGet(GammaTxn tx, long amount) {
        Tranlocal tranlocal = this.openForWrite(tx, 0);
        tranlocal.long_value += amount;
        return tranlocal.long_value;
    }

    @Override
    public final void increment() {
        this.increment(GammaStmUtils.getRequiredThreadLocalGammaTxn());
    }

    @Override
    public final void increment(Txn tx) {
        this.commute(GammaStmUtils.asGammaTxn(tx), Functions.incLongFunction());
    }

    public final void increment(GammaTxn tx) {
        this.commute(tx, Functions.incLongFunction());
    }

    @Override
    public final void increment(long amount) {
        this.commute(GammaStmUtils.getRequiredThreadLocalGammaTxn(), Functions.incLongFunction(amount));
    }

    @Override
    public final void increment(Txn tx, long amount) {
        this.commute(GammaStmUtils.asGammaTxn(tx), Functions.incLongFunction(amount));
    }

    @Override
    public final void decrement() {
        this.commute(GammaStmUtils.getRequiredThreadLocalGammaTxn(), Functions.decLongFunction());
    }

    @Override
    public final void decrement(Txn tx) {
        this.commute(GammaStmUtils.asGammaTxn(tx), Functions.decLongFunction());
    }

    @Override
    public final void decrement(long amount) {
        this.commute(GammaStmUtils.getRequiredThreadLocalGammaTxn(), Functions.incLongFunction(-amount));
    }

    @Override
    public final void decrement(Txn tx, long amount) {
        this.commute(GammaStmUtils.asGammaTxn(tx), Functions.incLongFunction(-amount));
    }

    @Override
    public final void await(long value) {
        this.await(GammaStmUtils.getRequiredThreadLocalGammaTxn(), value);
    }

    @Override
    public final void await(Txn tx, long value) {
        this.await(GammaStmUtils.asGammaTxn(tx), value);
    }

    public final void await(GammaTxn tx, long value) {
        if (this.openForRead((GammaTxn)tx, (int)0).long_value != value) {
            tx.retry();
        }
    }

    @Override
    public final void await(LongPredicate predicate) {
        this.await(GammaStmUtils.getRequiredThreadLocalGammaTxn(), predicate);
    }

    @Override
    public final void await(Txn tx, LongPredicate predicate) {
        this.await(GammaStmUtils.asGammaTxn(tx), predicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void await(GammaTxn tx, LongPredicate predicate) {
        Tranlocal tranlocal = this.openForRead(tx, 0);
        boolean abort = true;
        try {
            if (!predicate.evaluate(tranlocal.long_value)) {
                tx.retry();
            }
            abort = false;
        }
        finally {
            if (abort) {
                tx.abort();
            }
        }
    }

    @Override
    public final String toDebugString() {
        return String.format("GammaTxnLong{orec=%s, version=%s, value=%s, hasListeners=%s)", this.___toOrecString(), this.version, this.long_value, this.listeners != null);
    }

    @Override
    public final String toString() {
        return this.toString(GammaStmUtils.getRequiredThreadLocalGammaTxn());
    }

    @Override
    public final String toString(Txn tx) {
        return this.toString(GammaStmUtils.asGammaTxn(tx));
    }

    public final String toString(GammaTxn tx) {
        return Long.toString(this.get(tx));
    }

    @Override
    public final String atomicToString() {
        return Long.toString(this.atomicGet());
    }
}

