import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@smithy/types";
import {
  CloudFormationClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../CloudFormationClient";
import {
  DetectStackSetDriftInput,
  DetectStackSetDriftOutput,
} from "../models/models_0";
export { __MetadataBearer, $Command };
export interface DetectStackSetDriftCommandInput
  extends DetectStackSetDriftInput {}
export interface DetectStackSetDriftCommandOutput
  extends DetectStackSetDriftOutput,
    __MetadataBearer {}
export declare class DetectStackSetDriftCommand extends $Command<
  DetectStackSetDriftCommandInput,
  DetectStackSetDriftCommandOutput,
  CloudFormationClientResolvedConfig
> {
  readonly input: DetectStackSetDriftCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DetectStackSetDriftCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: CloudFormationClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<DetectStackSetDriftCommandInput, DetectStackSetDriftCommandOutput>;
  private serialize;
  private deserialize;
}
