/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import java.util.Collections;
import java.util.IllegalFormatException;
import java.util.List;
import org.fibs.geotag.Settings;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.data.UpdateCityName;
import org.fibs.geotag.data.UpdateCountryName;
import org.fibs.geotag.data.UpdateLocationName;
import org.fibs.geotag.data.UpdateProvinceName;
import org.fibs.geotag.geonames.Location;
import org.fibs.geotag.geonames.LocationHandler;
import org.fibs.geotag.geonames.WikipediaHandler;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.tasks.UndoableBackgroundTask;
import org.fibs.geotag.util.Util;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class LocationNamesTask
extends UndoableBackgroundTask<ImageInfo> {
    private static final I18n i18n = I18nFactory.getI18n(LocationNamesTask.class);
    private ImagesTableModel imagesTableModel;
    private List<ImageInfo> imageInfos;
    private int currentProgress = 0;

    public LocationNamesTask(String group, String name, ImagesTableModel imagestableModel, List<ImageInfo> imageInfos) {
        super(group, name);
        this.imagesTableModel = imagestableModel;
        this.imageInfos = imageInfos;
    }

    @Override
    public int getCurrentProgress() {
        return this.currentProgress;
    }

    @Override
    public int getMaxProgress() {
        return this.imageInfos.size();
    }

    @Override
    public int getMinProgress() {
        return 1;
    }

    @Override
    protected String doInBackground() throws Exception {
        int namesFound = 0;
        for (ImageInfo imageInfo : this.imageInfos) {
            if (this.interruptRequested()) break;
            ++this.currentProgress;
            this.setProgressMessage();
            try {
                LocationHandler locationHandler = new LocationHandler(imageInfo.getGpsLatitude(), imageInfo.getGpsLongitude());
                List<Location> locations = locationHandler.getLocations();
                if (Settings.get(Settings.SETTING.GEONAMES_USE_WIKIPEDIA, false)) {
                    WikipediaHandler wikipediaHandler = new WikipediaHandler(imageInfo.getGpsLatitude(), imageInfo.getGpsLongitude());
                    locations.addAll(wikipediaHandler.getLocations());
                }
                if (locations.size() > 0) {
                    Collections.sort(locations);
                    imageInfo.setNearbyLocations(locations);
                    boolean locationNeeded = true;
                    boolean cityNeeded = true;
                    boolean provinceNeeded = true;
                    boolean countryNeeded = true;
                    boolean updated = false;
                    for (Location location : locations) {
                        if (cityNeeded && location.getName() != null && location.getName().length() > 0 && location.isPopulatedPlace()) {
                            if (!Util.sameContent(location.getName(), imageInfo.getCityName())) {
                                new UpdateCityName(imageInfo, location.getName(), ImageInfo.DATA_SOURCE.GEONAMES);
                                updated = true;
                            }
                            cityNeeded = false;
                            locationNeeded = false;
                        }
                        if (locationNeeded && location.getName() != null && location.getName().length() > 0) {
                            if (!Util.sameContent(location.getName(), imageInfo.getLocationName())) {
                                new UpdateLocationName(imageInfo, location.getName(), ImageInfo.DATA_SOURCE.GEONAMES);
                                updated = true;
                            }
                            locationNeeded = false;
                        }
                        if (provinceNeeded && location.getProvince() != null && location.getProvince().length() > 0) {
                            if (!Util.sameContent(location.getProvince(), imageInfo.getProvinceName())) {
                                new UpdateProvinceName(imageInfo, location.getProvince(), ImageInfo.DATA_SOURCE.GEONAMES);
                                updated = true;
                            }
                            provinceNeeded = false;
                        }
                        if (!countryNeeded || location.getCountryName() == null || location.getCountryName().length() <= 0) continue;
                        if (!Util.sameContent(location.getCountryName(), imageInfo.getCountryName())) {
                            new UpdateCountryName(imageInfo, location.getCountryName(), ImageInfo.DATA_SOURCE.GEONAMES);
                            updated = true;
                        }
                        countryNeeded = false;
                    }
                    if (updated) {
                        ++namesFound;
                    }
                }
                this.publish(imageInfo);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        String result = null;
        if (namesFound == 1) {
            result = i18n.tr("One location name found");
        } else {
            try {
                result = String.format(i18n.tr("%d location names found"), namesFound);
            }
            catch (IllegalFormatException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    protected void process(List<ImageInfo> chunks) {
        for (ImageInfo imageInfo : chunks) {
            int imageRow = this.imagesTableModel.getRow(imageInfo);
            this.imagesTableModel.fireTableRowsUpdated(imageRow, imageRow);
        }
    }
}

