/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.versionspecific;

import com.install4j.api.Util;
import com.install4j.api.launcher.StartupNotification;
import com.install4j.runtime.installer.helper.content.JavaHttpConnection;
import com.install4j.runtime.installer.helper.content.UrlConnectionWrapper;
import com.install4j.runtime.installer.helper.versionspecific.MacApiHelper;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelperInterface;
import com.install4j.runtime.launcher.util.LauncherUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Proxy;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import javafx.collections.ObservableList;
import javafx.stage.Stage;

public class NoHelper
implements VersionSpecificHelperInterface {
    @Override
    public boolean isJavaFxWindowShown() {
        try {
            Class<?> stageHelperClass = Class.forName("com.sun.javafx.stage.StageHelper");
            try {
                Field field = stageHelperClass.getDeclaredField("stageAccessor");
                field.setAccessible(true);
                if (field.get(null) == null) {
                    return false;
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
            Method getStagesMethod = stageHelperClass.getDeclaredMethod("getStages", new Class[0]);
            getStagesMethod.setAccessible(true);
            ObservableList stages = (ObservableList)getStagesMethod.invoke(null, new Object[0]);
            for (Stage stage : stages) {
                if (!stage.isShowing()) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void requestForeground() {
        if (Util.isMacOS()) {
            MacApiHelper.requestForeground();
        }
    }

    @Override
    public void setMacStartupListener(StartupNotification.Listener startupListener) {
        if (Util.isMacOS()) {
            MacApiHelper.setMacStartupListener(startupListener);
        }
    }

    @Override
    public void setMacHandleQuit(boolean handleQuit) {
        if (Util.isMacOS()) {
            MacApiHelper.setMacHandleQuit(handleQuit);
        }
    }

    @Override
    public void setMacQuitHandler(Runnable runnable2) {
        if (Util.isMacOS()) {
            MacApiHelper.setMacQuitHandler(runnable2);
        }
    }

    @Override
    public void setMacAboutHandler(Runnable runnable2) {
        if (Util.isMacOS()) {
            MacApiHelper.setMacAboutHandler(runnable2);
        }
    }

    @Override
    public void setMacPreferencesHandler(Runnable runnable2) {
        if (Util.isMacOS()) {
            MacApiHelper.setMacPreferencesHandler(runnable2);
        }
    }

    @Override
    public void addReads(String moduleName) {
    }

    @Override
    public long getPid() {
        return LauncherUtil.getPidFromMBean();
    }

    @Override
    public int waitFor(Process process, int timeoutSeconds, boolean terminate) throws InterruptedException {
        if (timeoutSeconds > 0) {
            if (process.waitFor(timeoutSeconds, TimeUnit.SECONDS)) {
                return process.exitValue();
            }
            if (terminate) {
                process.destroyForcibly();
            }
            return -10000;
        }
        return process.waitFor();
    }

    @Override
    public JavaHttpConnection createHttpConnection(URL url, Proxy proxy, boolean acceptAllCertificates) throws IOException {
        return new UrlConnectionWrapper(url, proxy, acceptAllCertificates);
    }

    @Override
    public void setSecurityManager(SecurityManager securityManager) {
        System.setSecurityManager(securityManager);
    }

    @Override
    public String getAccessibilityProviderName() {
        return EmptyAccessibility.class.getName();
    }

    public static class EmptyAccessibility {
    }
}

