/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mediathek.config.Konstanten;
import mediathek.daten.DatenFilm;
import mediathek.daten.FilmListMetaData;
import mediathek.daten.FilmResolution;
import mediathek.tool.GermanStringSorter;
import org.jetbrains.annotations.NotNull;

public class ListeFilme
extends ArrayList<DatenFilm> {
    public static final String FILMLISTE = "Filmliste";
    private static final String PCS_METADATA = "metaData";
    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    public boolean neueFilme;
    private FilmListMetaData metaData = new FilmListMetaData();

    public FilmListMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(FilmListMetaData meta) {
        FilmListMetaData oldValue = this.metaData;
        this.metaData = meta;
        this.pcs.firePropertyChange(PCS_METADATA, oldValue, this.metaData);
    }

    public void addMetaDataChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(PCS_METADATA, listener);
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public List<String> getThemen(String sender) {
        Stream<Object> mystream = this.parallelStream();
        if (!sender.isEmpty()) {
            mystream = mystream.filter(f -> f.getSender().equals(sender));
        }
        return mystream.map(DatenFilm::getThema).filter(ListeFilme.distinctByKey(String::toLowerCase)).sorted(GermanStringSorter.getInstance()).toList();
    }

    public synchronized void updateFromFilmList(@NotNull ListeFilme newFilmsList) {
        HashSet hashNewFilms = new HashSet(newFilmsList.size() + 1, 1.0f);
        newFilmsList.forEach((? super E newFilm) -> hashNewFilms.add(newFilm.getUniqueHash()));
        this.removeIf(currentFilm -> hashNewFilms.contains(currentFilm.getUniqueHash()));
        hashNewFilms.clear();
        newFilmsList.forEach((? super E film) -> {
            film.init();
            this.add(film);
        });
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.neueFilme = false;
    }

    public synchronized DatenFilm getFilmByUrlAndSender(String url, String sender) {
        return this.parallelStream().filter(f -> f.getUrlNormalQuality().equalsIgnoreCase(url) && f.getSender().equalsIgnoreCase(sender)).findAny().orElse(null);
    }

    public synchronized DatenFilm getFilmByUrl_klein_hoch_hd(String url) {
        DatenFilm ret = null;
        for (DatenFilm f : this) {
            if (f.getUrlNormalQuality().equals(url)) {
                ret = f;
                break;
            }
            if (f.getUrlFuerAufloesung(FilmResolution.Enum.HIGH_QUALITY).equals(url)) {
                ret = f;
                break;
            }
            if (!f.getUrlFuerAufloesung(FilmResolution.Enum.LOW).equals(url)) continue;
            ret = f;
            break;
        }
        return ret;
    }

    public boolean needsUpdate() {
        return this.isEmpty() || this.getMetaData().isOlderThan(Konstanten.ALTER_FILMLISTE_SEKUNDEN_FUER_AUTOUPDATE);
    }

    public synchronized long countNewFilms() {
        return this.stream().filter(DatenFilm::isNew).count();
    }
}

