/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import mediathek.config.Daten;
import mediathek.daten.DatenPset;
import mediathek.gui.messages.ProgramSetChangedEvent;
import mediathek.gui.tabs.tab_film.GuiFilme;
import mediathek.tool.MessageBus;
import net.engio.mbassy.listener.Handler;
import org.jdesktop.swingx.WrapLayout;
import org.jetbrains.annotations.NotNull;

public class PsetButtonsPanel
extends JPanel {
    private static final int DEFAULT_HEIGHT = 90;
    private final JPanel btnPanel = new JPanel();
    private final GuiFilme guiFilme;

    public PsetButtonsPanel(@NotNull GuiFilme guiFilme) {
        this.guiFilme = guiFilme;
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(Integer.MAX_VALUE, 90));
        this.setMinimumSize(new Dimension(100, 90));
        this.btnPanel.setLayout(new WrapLayout(0, 5, 5));
        JScrollPane sp = new JScrollPane();
        this.add((Component)sp, "Center");
        sp.setViewportView(this.btnPanel);
        this.setupButtonLayout();
        MessageBus.getMessageBus().subscribe(this);
    }

    public void install(@NotNull JTabbedPane tabbedPane) {
        tabbedPane.add("Buttons", this);
    }

    @Handler
    private void handleProgramSetChangedEvent(ProgramSetChangedEvent e) {
        System.out.println("Handle PSET CHANGE");
        SwingUtilities.invokeLater(this::setupButtonLayout);
    }

    protected void setupButtonLayout() {
        this.btnPanel.removeAll();
        for (DatenPset pset : Daten.listePset.getListeButton()) {
            String psetName = pset.arr[0];
            Color psetColor = pset.getFarbe();
            if (!pset.isFreeLine()) {
                if (pset.isLabel()) {
                    JLabel l2 = new JLabel(psetName);
                    if (psetColor != null) {
                        l2.setForeground(psetColor);
                    }
                    this.btnPanel.add(l2);
                    continue;
                }
                JButton b = new JButton(psetName);
                if (psetColor != null) {
                    b.setBackground(psetColor);
                }
                b.addActionListener(l -> this.guiFilme.playerStarten(pset));
                this.btnPanel.add(b);
                continue;
            }
            this.btnPanel.add(new JLabel(""));
        }
        this.validate();
        this.repaint();
    }
}

