/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.conversation;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.search.SearchHit;

public class ConversationMeta
implements Writeable,
ToXContentObject {
    private String id;
    private Instant createdTime;
    private String name;
    private String user;

    public static ConversationMeta fromSearchHit(SearchHit hit) {
        String id = hit.getId();
        return ConversationMeta.fromMap(id, hit.getSourceAsMap());
    }

    public static ConversationMeta fromMap(String id, Map<String, Object> docFields) {
        Instant created = Instant.parse((String)docFields.get("create_time"));
        String name = (String)docFields.get("name");
        String user = (String)docFields.get("user");
        return new ConversationMeta(id, created, name, user);
    }

    public static ConversationMeta fromStream(StreamInput in) throws IOException {
        String id = in.readString();
        Instant created = in.readInstant();
        String name = in.readString();
        String user = in.readOptionalString();
        return new ConversationMeta(id, created, name, user);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeInstant(this.createdTime);
        out.writeString(this.name);
        out.writeOptionalString(this.user);
    }

    public IndexRequest toIndexRequest(String index) {
        IndexRequest request = new IndexRequest(index);
        return request.id(this.id).source(new Object[]{"create_time", this.createdTime, "name", this.name});
    }

    public String toString() {
        return "{id=" + this.id + ", name=" + this.name + ", created=" + this.createdTime.toString() + ", user=" + this.user + "}";
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("conversation_id", this.id);
        builder.field("create_time", (Object)this.createdTime);
        builder.field("name", this.name);
        if (this.user != null) {
            builder.field("user", this.user);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ConversationMeta)) {
            return false;
        }
        ConversationMeta otherConversation = (ConversationMeta)other;
        return Objects.equals(this.id, otherConversation.id) && Objects.equals(this.user, otherConversation.user) && Objects.equals(this.createdTime, otherConversation.createdTime) && Objects.equals(this.name, otherConversation.name);
    }

    @Generated
    public ConversationMeta(String id, Instant createdTime, String name, String user) {
        this.id = id;
        this.createdTime = createdTime;
        this.name = name;
        this.user = user;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Instant getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getUser() {
        return this.user;
    }
}

