# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
RWMesh module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_rwmesh.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _RWMesh
else:
    import _RWMesh

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _RWMesh.delete_SwigPyIterator

    def value(self):
        return _RWMesh.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _RWMesh.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _RWMesh.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _RWMesh.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _RWMesh.SwigPyIterator_equal(self, x)

    def copy(self):
        return _RWMesh.SwigPyIterator_copy(self)

    def next(self):
        return _RWMesh.SwigPyIterator_next(self)

    def __next__(self):
        return _RWMesh.SwigPyIterator___next__(self)

    def previous(self):
        return _RWMesh.SwigPyIterator_previous(self)

    def advance(self, n):
        return _RWMesh.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _RWMesh.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _RWMesh.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _RWMesh.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _RWMesh.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _RWMesh.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _RWMesh.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _RWMesh:
_RWMesh.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _RWMesh.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TDF
import OCC.Core.TCollection
import OCC.Core.TColStd
import OCC.Core.TDocStd
import OCC.Core.CDF
import OCC.Core.CDM
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.Resource
import OCC.Core.PCDM
import OCC.Core.Storage
import OCC.Core.gp
import OCC.Core.TopoDS
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.Graphic3d
import OCC.Core.BVH
import OCC.Core.Quantity
import OCC.Core.Aspect
import OCC.Core.Image
import OCC.Core.Bnd
import OCC.Core.TColgp
import OCC.Core.Media
import OCC.Core.XCAFPrs
import OCC.Core.AIS
import OCC.Core.SelectMgr
import OCC.Core.Select3D
import OCC.Core.SelectBasics
import OCC.Core.Geom
import OCC.Core.GeomAbs
import OCC.Core.PrsMgr
import OCC.Core.Prs3d
import OCC.Core.Poly
import OCC.Core.TShort
import OCC.Core.V3d
import OCC.Core.StdSelect
import OCC.Core.TopTools
import OCC.Core.XCAFDoc
import OCC.Core.TDataStd
import OCC.Core.XCAFDimTolObjects
import OCC.Core.UnitsMethods
import OCC.Core.XCAFNoteObjects
import OCC.Core.XCAFView
import OCC.Core.TPrsStd
import OCC.Core.TDataXtd
import OCC.Core.TNaming

from enum import IntEnum
from OCC.Core.Exception import *

RWMesh_CafReaderStatusEx_NONE = _RWMesh.RWMesh_CafReaderStatusEx_NONE
RWMesh_CafReaderStatusEx_Partial = _RWMesh.RWMesh_CafReaderStatusEx_Partial
RWMesh_CoordinateSystem_Undefined = _RWMesh.RWMesh_CoordinateSystem_Undefined
RWMesh_CoordinateSystem_posYfwd_posZup = _RWMesh.RWMesh_CoordinateSystem_posYfwd_posZup
RWMesh_CoordinateSystem_negZfwd_posYup = _RWMesh.RWMesh_CoordinateSystem_negZfwd_posYup
RWMesh_CoordinateSystem_Blender = _RWMesh.RWMesh_CoordinateSystem_Blender
RWMesh_CoordinateSystem_glTF = _RWMesh.RWMesh_CoordinateSystem_glTF
RWMesh_CoordinateSystem_Zup = _RWMesh.RWMesh_CoordinateSystem_Zup
RWMesh_CoordinateSystem_Yup = _RWMesh.RWMesh_CoordinateSystem_Yup
RWMesh_NameFormat_Empty = _RWMesh.RWMesh_NameFormat_Empty
RWMesh_NameFormat_Product = _RWMesh.RWMesh_NameFormat_Product
RWMesh_NameFormat_Instance = _RWMesh.RWMesh_NameFormat_Instance
RWMesh_NameFormat_InstanceOrProduct = _RWMesh.RWMesh_NameFormat_InstanceOrProduct
RWMesh_NameFormat_ProductOrInstance = _RWMesh.RWMesh_NameFormat_ProductOrInstance
RWMesh_NameFormat_ProductAndInstance = _RWMesh.RWMesh_NameFormat_ProductAndInstance
RWMesh_NameFormat_ProductAndInstanceAndOcaf = _RWMesh.RWMesh_NameFormat_ProductAndInstanceAndOcaf


class RWMesh_CafReaderStatusEx(IntEnum):
	RWMesh_CafReaderStatusEx_NONE = 0
	RWMesh_CafReaderStatusEx_Partial = 1
RWMesh_CafReaderStatusEx_NONE = RWMesh_CafReaderStatusEx.RWMesh_CafReaderStatusEx_NONE
RWMesh_CafReaderStatusEx_Partial = RWMesh_CafReaderStatusEx.RWMesh_CafReaderStatusEx_Partial

class RWMesh_CoordinateSystem(IntEnum):
	RWMesh_CoordinateSystem_Undefined = - 1
	RWMesh_CoordinateSystem_posYfwd_posZup = 0
	RWMesh_CoordinateSystem_negZfwd_posYup = 1
	RWMesh_CoordinateSystem_Blender = RWMesh_CoordinateSystem_posYfwd_posZup
	RWMesh_CoordinateSystem_glTF = RWMesh_CoordinateSystem_negZfwd_posYup
	RWMesh_CoordinateSystem_Zup = RWMesh_CoordinateSystem_Blender
	RWMesh_CoordinateSystem_Yup = RWMesh_CoordinateSystem_glTF
RWMesh_CoordinateSystem_Undefined = RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_Undefined
RWMesh_CoordinateSystem_posYfwd_posZup = RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_posYfwd_posZup
RWMesh_CoordinateSystem_negZfwd_posYup = RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_negZfwd_posYup
RWMesh_CoordinateSystem_Blender = RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_Blender
RWMesh_CoordinateSystem_glTF = RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_glTF
RWMesh_CoordinateSystem_Zup = RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_Zup
RWMesh_CoordinateSystem_Yup = RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_Yup

class RWMesh_NameFormat(IntEnum):
	RWMesh_NameFormat_Empty = 0
	RWMesh_NameFormat_Product = 1
	RWMesh_NameFormat_Instance = 2
	RWMesh_NameFormat_InstanceOrProduct = 3
	RWMesh_NameFormat_ProductOrInstance = 4
	RWMesh_NameFormat_ProductAndInstance = 5
	RWMesh_NameFormat_ProductAndInstanceAndOcaf = 6
RWMesh_NameFormat_Empty = RWMesh_NameFormat.RWMesh_NameFormat_Empty
RWMesh_NameFormat_Product = RWMesh_NameFormat.RWMesh_NameFormat_Product
RWMesh_NameFormat_Instance = RWMesh_NameFormat.RWMesh_NameFormat_Instance
RWMesh_NameFormat_InstanceOrProduct = RWMesh_NameFormat.RWMesh_NameFormat_InstanceOrProduct
RWMesh_NameFormat_ProductOrInstance = RWMesh_NameFormat.RWMesh_NameFormat_ProductOrInstance
RWMesh_NameFormat_ProductAndInstance = RWMesh_NameFormat.RWMesh_NameFormat_ProductAndInstance
RWMesh_NameFormat_ProductAndInstanceAndOcaf = RWMesh_NameFormat.RWMesh_NameFormat_ProductAndInstanceAndOcaf


def Handle_RWMesh_CafReader_Create():
    return _RWMesh.Handle_RWMesh_CafReader_Create()

def Handle_RWMesh_CafReader_DownCast(t):
    return _RWMesh.Handle_RWMesh_CafReader_DownCast(t)

def Handle_RWMesh_CafReader_IsNull(t):
    return _RWMesh.Handle_RWMesh_CafReader_IsNull(t)

def Handle_RWMesh_MaterialMap_Create():
    return _RWMesh.Handle_RWMesh_MaterialMap_Create()

def Handle_RWMesh_MaterialMap_DownCast(t):
    return _RWMesh.Handle_RWMesh_MaterialMap_DownCast(t)

def Handle_RWMesh_MaterialMap_IsNull(t):
    return _RWMesh.Handle_RWMesh_MaterialMap_IsNull(t)

def Handle_RWMesh_TriangulationReader_Create():
    return _RWMesh.Handle_RWMesh_TriangulationReader_Create()

def Handle_RWMesh_TriangulationReader_DownCast(t):
    return _RWMesh.Handle_RWMesh_TriangulationReader_DownCast(t)

def Handle_RWMesh_TriangulationReader_IsNull(t):
    return _RWMesh.Handle_RWMesh_TriangulationReader_IsNull(t)

def Handle_RWMesh_TriangulationSource_Create():
    return _RWMesh.Handle_RWMesh_TriangulationSource_Create()

def Handle_RWMesh_TriangulationSource_DownCast(t):
    return _RWMesh.Handle_RWMesh_TriangulationSource_DownCast(t)

def Handle_RWMesh_TriangulationSource_IsNull(t):
    return _RWMesh.Handle_RWMesh_TriangulationSource_IsNull(t)
class RWMesh_NodeAttributeMap(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _RWMesh.RWMesh_NodeAttributeMap_begin(self)

    def end(self):
        return _RWMesh.RWMesh_NodeAttributeMap_end(self)

    def cbegin(self):
        return _RWMesh.RWMesh_NodeAttributeMap_cbegin(self)

    def cend(self):
        return _RWMesh.RWMesh_NodeAttributeMap_cend(self)

    def __init__(self, *args):
        _RWMesh.RWMesh_NodeAttributeMap_swiginit(self, _RWMesh.new_RWMesh_NodeAttributeMap(*args))

    def Exchange(self, theOther):
        return _RWMesh.RWMesh_NodeAttributeMap_Exchange(self, theOther)

    def Assign(self, theOther):
        return _RWMesh.RWMesh_NodeAttributeMap_Assign(self, theOther)

    def Set(self, theOther):
        return _RWMesh.RWMesh_NodeAttributeMap_Set(self, theOther)

    def ReSize(self, N):
        return _RWMesh.RWMesh_NodeAttributeMap_ReSize(self, N)

    def Bind(self, theKey, theItem):
        return _RWMesh.RWMesh_NodeAttributeMap_Bind(self, theKey, theItem)

    def Bound(self, theKey, theItem):
        return _RWMesh.RWMesh_NodeAttributeMap_Bound(self, theKey, theItem)

    def IsBound(self, theKey):
        return _RWMesh.RWMesh_NodeAttributeMap_IsBound(self, theKey)

    def UnBind(self, theKey):
        return _RWMesh.RWMesh_NodeAttributeMap_UnBind(self, theKey)

    def Seek(self, theKey):
        return _RWMesh.RWMesh_NodeAttributeMap_Seek(self, theKey)

    def Find(self, *args):
        return _RWMesh.RWMesh_NodeAttributeMap_Find(self, *args)

    def ChangeSeek(self, theKey):
        return _RWMesh.RWMesh_NodeAttributeMap_ChangeSeek(self, theKey)

    def ChangeFind(self, theKey):
        return _RWMesh.RWMesh_NodeAttributeMap_ChangeFind(self, theKey)

    def __call__(self, *args):
        return _RWMesh.RWMesh_NodeAttributeMap___call__(self, *args)

    def Clear(self, *args):
        return _RWMesh.RWMesh_NodeAttributeMap_Clear(self, *args)
    __swig_destroy__ = _RWMesh.delete_RWMesh_NodeAttributeMap

    def Size(self):
        return _RWMesh.RWMesh_NodeAttributeMap_Size(self)

# Register RWMesh_NodeAttributeMap in _RWMesh:
_RWMesh.RWMesh_NodeAttributeMap_swigregister(RWMesh_NodeAttributeMap)
class rwmesh(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def FormatName(*args):
        r"""

        Parameters
        ----------
        theFormat: RWMesh_NameFormat
        theLabel: TDF_Label
        theRefLabel: TDF_Label

        Return
        -------
        TCollection_AsciiString

        Description
        -----------
        Generate name for specified labels. @param[in] theformat name format to apply @param[in] thelabel instance label @param[in] thereflabel product label.

        """
        return _RWMesh.rwmesh_FormatName(*args)

    @staticmethod
    def ReadNameAttribute(*args):
        r"""

        Parameters
        ----------
        theLabel: TDF_Label

        Return
        -------
        TCollection_AsciiString

        Description
        -----------
        Read name attribute from label.

        """
        return _RWMesh.rwmesh_ReadNameAttribute(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _RWMesh.rwmesh_swiginit(self, _RWMesh.new_rwmesh())
    __swig_destroy__ = _RWMesh.delete_rwmesh

# Register rwmesh in _RWMesh:
_RWMesh.rwmesh_swigregister(rwmesh)
class RWMesh_CafReader(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def CoordinateSystemConverter(self, *args):
        r"""
        Return
        -------
        RWMesh_CoordinateSystemConverter

        Description
        -----------
        Return coordinate system converter.

        """
        return _RWMesh.RWMesh_CafReader_CoordinateSystemConverter(self, *args)

    def Document(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TDocStd_Document>

        Description
        -----------
        Return target document.

        """
        return _RWMesh.RWMesh_CafReader_Document(self, *args)

    def ExternalFiles(self, *args):
        r"""
        Return
        -------
        NCollection_IndexedMap<TCollection_AsciiString>

        Description
        -----------
        Return the list of complementary files - external references (textures, data, etc.).

        """
        return _RWMesh.RWMesh_CafReader_ExternalFiles(self, *args)

    def ExtraStatus(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Return extended status flags. @sa rwmesh_cafreaderstatusex enumeration.

        """
        return _RWMesh.RWMesh_CafReader_ExtraStatus(self, *args)

    def FileCoordinateSystem(self, *args):
        r"""
        Return
        -------
        gp_Ax3

        Description
        -----------
        Return file origin coordinate system; can be undefined, which means no conversion will be done.

        """
        return _RWMesh.RWMesh_CafReader_FileCoordinateSystem(self, *args)

    def FileLengthUnit(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Return the length unit to convert from while reading the file, defined as scale factor for m (meters). can be undefined (-1.0) if file format is unitless.

        """
        return _RWMesh.RWMesh_CafReader_FileLengthUnit(self, *args)

    def HasFileCoordinateSystem(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if file origin coordinate system has been defined.

        """
        return _RWMesh.RWMesh_CafReader_HasFileCoordinateSystem(self, *args)

    def HasSystemCoordinateSystem(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if system coordinate system has been defined; false by default.

        """
        return _RWMesh.RWMesh_CafReader_HasSystemCoordinateSystem(self, *args)

    def MemoryLimitMiB(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Return memory usage limit in mib, -1 by default which means no limit.

        """
        return _RWMesh.RWMesh_CafReader_MemoryLimitMiB(self, *args)

    def Metadata(self, *args):
        r"""
        Return
        -------
        TColStd_IndexedDataMapOfStringString

        Description
        -----------
        Return metadata map.

        """
        return _RWMesh.RWMesh_CafReader_Metadata(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        theFile: str
        theProgress: Message_ProgressRange

        Return
        -------
        bool

        Description
        -----------
        Read the data from specified file. the document instance should be set beforehand.

        """
        return _RWMesh.RWMesh_CafReader_Perform(self, *args)

    def ProbeHeader(self, *args):
        r"""

        Parameters
        ----------
        theFile: str
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        bool

        Description
        -----------
        Read the header data from specified file without reading entire model. the main purpose is collecting metadata and external references - for copying model into a new location, for example. can be not implemented (unsupported by format / reader).

        """
        return _RWMesh.RWMesh_CafReader_ProbeHeader(self, *args)

    def RootPrefix(self, *args):
        r"""
        Return
        -------
        TCollection_AsciiString

        Description
        -----------
        Return prefix for generating root labels names.

        """
        return _RWMesh.RWMesh_CafReader_RootPrefix(self, *args)

    def SetCoordinateSystemConverter(self, *args):
        r"""

        Parameters
        ----------
        theConverter: RWMesh_CoordinateSystemConverter

        Return
        -------
        None

        Description
        -----------
        Set coordinate system converter.

        """
        return _RWMesh.RWMesh_CafReader_SetCoordinateSystemConverter(self, *args)

    def SetDocument(self, *args):
        r"""

        Parameters
        ----------
        theDoc: TDocStd_Document

        Return
        -------
        None

        Description
        -----------
        Set target document. set system length unit according to the units of the document.

        """
        return _RWMesh.RWMesh_CafReader_SetDocument(self, *args)

    def SetFileCoordinateSystem(self, *args):
        r"""

        Parameters
        ----------
        theCS: gp_Ax3

        Return
        -------
        None

        Description
        -----------
        Set (override) file origin coordinate system to perform conversion during read.

        Parameters
        ----------
        theCS: RWMesh_CoordinateSystem

        Return
        -------
        None

        Description
        -----------
        Set (override) file origin coordinate system to perform conversion during read.

        """
        return _RWMesh.RWMesh_CafReader_SetFileCoordinateSystem(self, *args)

    def SetFileLengthUnit(self, *args):
        r"""

        Parameters
        ----------
        theUnits: float

        Return
        -------
        None

        Description
        -----------
        Set (override) file length units to convert from while reading the file, defined as scale factor for m (meters).

        """
        return _RWMesh.RWMesh_CafReader_SetFileLengthUnit(self, *args)

    def SetFillIncompleteDocument(self, *args):
        r"""

        Parameters
        ----------
        theToFillIncomplete: bool

        Return
        -------
        None

        Description
        -----------
        Set flag allowing partially read file content to be put into the xde document.

        """
        return _RWMesh.RWMesh_CafReader_SetFillIncompleteDocument(self, *args)

    def SetMemoryLimitMiB(self, *args):
        r"""

        Parameters
        ----------
        theLimitMiB: int

        Return
        -------
        None

        Description
        -----------
        Set memory usage limit in mib; can be ignored by reader implementation!.

        """
        return _RWMesh.RWMesh_CafReader_SetMemoryLimitMiB(self, *args)

    def SetRootPrefix(self, *args):
        r"""

        Parameters
        ----------
        theRootPrefix: str

        Return
        -------
        None

        Description
        -----------
        Set prefix for generating root labels names.

        """
        return _RWMesh.RWMesh_CafReader_SetRootPrefix(self, *args)

    def SetSystemCoordinateSystem(self, *args):
        r"""

        Parameters
        ----------
        theCS: gp_Ax3

        Return
        -------
        None

        Description
        -----------
        Set system origin coordinate system to perform conversion into during read.

        Parameters
        ----------
        theCS: RWMesh_CoordinateSystem

        Return
        -------
        None

        Description
        -----------
        Set system origin coordinate system to perform conversion into during read.

        """
        return _RWMesh.RWMesh_CafReader_SetSystemCoordinateSystem(self, *args)

    def SetSystemLengthUnit(self, *args):
        r"""

        Parameters
        ----------
        theUnits: float

        Return
        -------
        None

        Description
        -----------
        Set system length units to convert into while reading the file, defined as scale factor for m (meters).

        """
        return _RWMesh.RWMesh_CafReader_SetSystemLengthUnit(self, *args)

    def SingleShape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Return result as a single shape.

        """
        return _RWMesh.RWMesh_CafReader_SingleShape(self, *args)

    def SystemCoordinateSystem(self, *args):
        r"""
        Return
        -------
        gp_Ax3

        Description
        -----------
        Return system coordinate system; undefined by default, which means that no conversion will be done.

        """
        return _RWMesh.RWMesh_CafReader_SystemCoordinateSystem(self, *args)

    def SystemLengthUnit(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Return the length unit to convert into while reading the file, defined as scale factor for m (meters); -1.0 by default, which means that no conversion will be applied.

        """
        return _RWMesh.RWMesh_CafReader_SystemLengthUnit(self, *args)

    def ToFillIncompleteDocument(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Flag indicating if partially read file content should be put into the xde document, true by default. //! partial read means unexpected end of file, critical parsing syntax errors in the middle of file, or reached memory limit indicated by performmesh() returning false. partial read allows importing a model even in case of formal reading failure, so that it will be up to user to decide if processed data has any value. //! in case of partial read (performmesh() returns false, but there are some data that could be put into document), perform() will return true and result flag will have failure bit set. @sa memorylimitmib(), extrastatus().

        """
        return _RWMesh.RWMesh_CafReader_ToFillIncompleteDocument(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_RWMesh_CafReader_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _RWMesh.delete_RWMesh_CafReader

# Register RWMesh_CafReader in _RWMesh:
_RWMesh.RWMesh_CafReader_swigregister(RWMesh_CafReader)
class RWMesh_CoordinateSystemConverter(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _RWMesh.RWMesh_CoordinateSystemConverter_swiginit(self, _RWMesh.new_RWMesh_CoordinateSystemConverter(*args))

    def HasInputCoordinateSystem(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if source coordinate system has been set; false by default.

        """
        return _RWMesh.RWMesh_CoordinateSystemConverter_HasInputCoordinateSystem(self, *args)

    def HasOutputCoordinateSystem(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if destination coordinate system has been set; false by default.

        """
        return _RWMesh.RWMesh_CoordinateSystemConverter_HasOutputCoordinateSystem(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        theInputSystem: gp_Ax3
        theInputLengthUnit: float
        theOutputSystem: gp_Ax3
        theOutputLengthUnit: float

        Return
        -------
        None

        Description
        -----------
        Initialize transformation.

        """
        return _RWMesh.RWMesh_CoordinateSystemConverter_Init(self, *args)

    def InputCoordinateSystem(self, *args):
        r"""
        Return
        -------
        gp_Ax3

        Description
        -----------
        Source coordinate system; undefined by default.

        """
        return _RWMesh.RWMesh_CoordinateSystemConverter_InputCoordinateSystem(self, *args)

    def InputLengthUnit(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Return source length units, defined as scale factor to m (meters). -1.0 by default, which means that no conversion will be applied (regardless output length unit).

        """
        return _RWMesh.RWMesh_CoordinateSystemConverter_InputLengthUnit(self, *args)

    def IsEmpty(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if there is no transformation (target and current coordinates systems are same).

        """
        return _RWMesh.RWMesh_CoordinateSystemConverter_IsEmpty(self, *args)

    def OutputCoordinateSystem(self, *args):
        r"""
        Return
        -------
        gp_Ax3

        Description
        -----------
        Destination coordinate system; undefined by default.

        """
        return _RWMesh.RWMesh_CoordinateSystemConverter_OutputCoordinateSystem(self, *args)

    def OutputLengthUnit(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Return destination length units, defined as scale factor to m (meters). -1.0 by default, which means that no conversion will be applied (regardless input length unit).

        """
        return _RWMesh.RWMesh_CoordinateSystemConverter_OutputLengthUnit(self, *args)

    def SetInputCoordinateSystem(self, *args):
        r"""

        Parameters
        ----------
        theSysFrom: gp_Ax3

        Return
        -------
        None

        Description
        -----------
        Set source coordinate system.

        Parameters
        ----------
        theSysFrom: RWMesh_CoordinateSystem

        Return
        -------
        None

        Description
        -----------
        Set source coordinate system.

        """
        return _RWMesh.RWMesh_CoordinateSystemConverter_SetInputCoordinateSystem(self, *args)

    def SetInputLengthUnit(self, *args):
        r"""

        Parameters
        ----------
        theInputScale: float

        Return
        -------
        None

        Description
        -----------
        Set source length units as scale factor to m (meters).

        """
        return _RWMesh.RWMesh_CoordinateSystemConverter_SetInputLengthUnit(self, *args)

    def SetOutputCoordinateSystem(self, *args):
        r"""

        Parameters
        ----------
        theSysTo: gp_Ax3

        Return
        -------
        None

        Description
        -----------
        Set destination coordinate system.

        Parameters
        ----------
        theSysTo: RWMesh_CoordinateSystem

        Return
        -------
        None

        Description
        -----------
        Set destination coordinate system.

        """
        return _RWMesh.RWMesh_CoordinateSystemConverter_SetOutputCoordinateSystem(self, *args)

    def SetOutputLengthUnit(self, *args):
        r"""

        Parameters
        ----------
        theOutputScale: float

        Return
        -------
        None

        Description
        -----------
        Set destination length units as scale factor to m (meters).

        """
        return _RWMesh.RWMesh_CoordinateSystemConverter_SetOutputLengthUnit(self, *args)

    @staticmethod
    def StandardCoordinateSystem(*args):
        r"""

        Parameters
        ----------
        theSys: RWMesh_CoordinateSystem

        Return
        -------
        gp_Ax3

        Description
        -----------
        Return a standard coordinate system definition.

        """
        return _RWMesh.RWMesh_CoordinateSystemConverter_StandardCoordinateSystem(*args)

    def TransformNormal(self, *args):
        r"""

        Parameters
        ----------
        theNorm: Graphic3d_Vec3

        Return
        -------
        None

        Description
        -----------
        Transform normal (e.g. exclude translation/scale part of transformation).

        """
        return _RWMesh.RWMesh_CoordinateSystemConverter_TransformNormal(self, *args)

    def TransformPosition(self, *args):
        r"""

        Parameters
        ----------
        thePos: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Transform position.

        """
        return _RWMesh.RWMesh_CoordinateSystemConverter_TransformPosition(self, *args)

    def TransformTransformation(self, *args):
        r"""

        Parameters
        ----------
        theTrsf: gp_Trsf

        Return
        -------
        None

        Description
        -----------
        Transform transformation.

        """
        return _RWMesh.RWMesh_CoordinateSystemConverter_TransformTransformation(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _RWMesh.delete_RWMesh_CoordinateSystemConverter

# Register RWMesh_CoordinateSystemConverter in _RWMesh:
_RWMesh.RWMesh_CoordinateSystemConverter_swigregister(RWMesh_CoordinateSystemConverter)
class RWMesh_FaceIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theLabel: TDF_Label
        theLocation: TopLoc_Location
        theToMapColors: bool (optional, default to false)
        theStyle: XCAFPrs_Style (optional, default to XCAFPrs_Style())

        Return
        -------
        None

        Description
        -----------
        Main constructor.

        Parameters
        ----------
        theShape: TopoDS_Shape
        theStyle: XCAFPrs_Style (optional, default to XCAFPrs_Style())

        Return
        -------
        None

        Description
        -----------
        Auxiliary constructor.

        """
        _RWMesh.RWMesh_FaceIterator_swiginit(self, _RWMesh.new_RWMesh_FaceIterator(*args))

    def ElemLower(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Lower element index in current triangulation.

        """
        return _RWMesh.RWMesh_FaceIterator_ElemLower(self, *args)

    def ElemUpper(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Upper element index in current triangulation.

        """
        return _RWMesh.RWMesh_FaceIterator_ElemUpper(self, *args)

    def ExploredShape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Return explored shape.

        """
        return _RWMesh.RWMesh_FaceIterator_ExploredShape(self, *args)

    def Face(self, *args):
        r"""
        Return
        -------
        TopoDS_Face

        Description
        -----------
        Return current face.

        """
        return _RWMesh.RWMesh_FaceIterator_Face(self, *args)

    def FaceColor(self, *args):
        r"""
        Return
        -------
        Quantity_ColorRGBA

        Description
        -----------
        Return face color.

        """
        return _RWMesh.RWMesh_FaceIterator_FaceColor(self, *args)

    def FaceStyle(self, *args):
        r"""
        Return
        -------
        XCAFPrs_Style

        Description
        -----------
        Return face material.

        """
        return _RWMesh.RWMesh_FaceIterator_FaceStyle(self, *args)

    def HasFaceColor(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if face color is set.

        """
        return _RWMesh.RWMesh_FaceIterator_HasFaceColor(self, *args)

    def HasNormals(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if triangulation has defined normals.

        """
        return _RWMesh.RWMesh_FaceIterator_HasNormals(self, *args)

    def HasTexCoords(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if triangulation has defined normals.

        """
        return _RWMesh.RWMesh_FaceIterator_HasTexCoords(self, *args)

    def IsEmptyMesh(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if mesh data is defined.

        """
        return _RWMesh.RWMesh_FaceIterator_IsEmptyMesh(self, *args)

    def More(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if iterator points to the valid triangulation.

        """
        return _RWMesh.RWMesh_FaceIterator_More(self, *args)

    def NbNodes(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Return number of nodes for the current face.

        """
        return _RWMesh.RWMesh_FaceIterator_NbNodes(self, *args)

    def NbTriangles(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Return number of elements of specific type for the current face.

        """
        return _RWMesh.RWMesh_FaceIterator_NbTriangles(self, *args)

    def Next(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Find next value.

        """
        return _RWMesh.RWMesh_FaceIterator_Next(self, *args)

    def NodeLower(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Lower node index in current triangulation.

        """
        return _RWMesh.RWMesh_FaceIterator_NodeLower(self, *args)

    def NodeTexCoord(self, *args):
        r"""

        Parameters
        ----------
        theNode: int

        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Return texture coordinates for the node.

        """
        return _RWMesh.RWMesh_FaceIterator_NodeTexCoord(self, *args)

    def NodeTransformed(self, *args):
        r"""

        Parameters
        ----------
        theNode: int

        Return
        -------
        gp_Pnt

        Description
        -----------
        Return the node with specified index with applied transformation.

        """
        return _RWMesh.RWMesh_FaceIterator_NodeTransformed(self, *args)

    def NodeUpper(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Upper node index in current triangulation.

        """
        return _RWMesh.RWMesh_FaceIterator_NodeUpper(self, *args)

    def NormalTransformed(self, *args):
        r"""

        Parameters
        ----------
        theNode: int

        Return
        -------
        gp_Dir

        Description
        -----------
        Return normal at specified node index with face transformation applied and face orientation applied.

        """
        return _RWMesh.RWMesh_FaceIterator_NormalTransformed(self, *args)

    def TriangleOriented(self, *args):
        r"""

        Parameters
        ----------
        theElemIndex: int

        Return
        -------
        Poly_Triangle

        Description
        -----------
        Return triangle with specified index with applied face orientation.

        """
        return _RWMesh.RWMesh_FaceIterator_TriangleOriented(self, *args)

    def Triangulation(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Poly_Triangulation>

        Description
        -----------
        Return current face triangulation.

        """
        return _RWMesh.RWMesh_FaceIterator_Triangulation(self, *args)

    def node(self, *args):
        r"""

        Parameters
        ----------
        theNode: int

        Return
        -------
        gp_Pnt

        Description
        -----------
        Return the node with specified index with applied transformation.

        """
        return _RWMesh.RWMesh_FaceIterator_node(self, *args)

    def normal(self, *args):
        r"""

        Parameters
        ----------
        theNode: int

        Return
        -------
        gp_Dir

        Description
        -----------
        Return normal at specified node index without face transformation applied.

        """
        return _RWMesh.RWMesh_FaceIterator_normal(self, *args)

    def triangle(self, *args):
        r"""

        Parameters
        ----------
        theElemIndex: int

        Return
        -------
        Poly_Triangle

        Description
        -----------
        Return triangle with specified index.

        """
        return _RWMesh.RWMesh_FaceIterator_triangle(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _RWMesh.delete_RWMesh_FaceIterator

# Register RWMesh_FaceIterator in _RWMesh:
_RWMesh.RWMesh_FaceIterator_swigregister(RWMesh_FaceIterator)
class RWMesh_MaterialMap(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def AddMaterial(self, *args):
        r"""

        Parameters
        ----------
        theStyle: XCAFPrs_Style

        Return
        -------
        TCollection_AsciiString

        Description
        -----------
        Register material and return its name identifier.

        """
        return _RWMesh.RWMesh_MaterialMap_AddMaterial(self, *args)

    def CopyTexture(self, *args):
        r"""

        Parameters
        ----------
        theResTexture: str
        theTexture: Image_Texture
        theKey: str

        Return
        -------
        bool

        Description
        -----------
        Copy and rename texture file to the new location. @param therestexture [out] result texture file path (relative to the model) @param thetexture [in] original texture @param thekey [in] material key.

        """
        return _RWMesh.RWMesh_MaterialMap_CopyTexture(self, *args)

    def CreateTextureFolder(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Create texture folder 'modelname/textures'; for example: model: path/modelname.gltf images: path/modelname/textures/ warning! output folder is not cleared.

        """
        return _RWMesh.RWMesh_MaterialMap_CreateTextureFolder(self, *args)

    def DefaultStyle(self, *args):
        r"""
        Return
        -------
        XCAFPrs_Style

        Description
        -----------
        Return default material definition to be used for nodes with only color defined.

        """
        return _RWMesh.RWMesh_MaterialMap_DefaultStyle(self, *args)

    def DefineMaterial(self, *args):
        r"""

        Parameters
        ----------
        theStyle: XCAFPrs_Style
        theKey: str
        theName: str

        Return
        -------
        None

        Description
        -----------
        Virtual method actually defining the material (e.g. export to the file).

        """
        return _RWMesh.RWMesh_MaterialMap_DefineMaterial(self, *args)

    def FindMaterial(self, *args):
        r"""

        Parameters
        ----------
        theStyle: XCAFPrs_Style

        Return
        -------
        TCollection_AsciiString

        Description
        -----------
        Find already registered material.

        """
        return _RWMesh.RWMesh_MaterialMap_FindMaterial(self, *args)

    def IsFailed(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return failed flag.

        """
        return _RWMesh.RWMesh_MaterialMap_IsFailed(self, *args)

    def SetDefaultStyle(self, *args):
        r"""

        Parameters
        ----------
        theStyle: XCAFPrs_Style

        Return
        -------
        None

        Description
        -----------
        Set default material definition to be used for nodes with only color defined.

        """
        return _RWMesh.RWMesh_MaterialMap_SetDefaultStyle(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_RWMesh_MaterialMap_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _RWMesh.delete_RWMesh_MaterialMap

# Register RWMesh_MaterialMap in _RWMesh:
_RWMesh.RWMesh_MaterialMap_swigregister(RWMesh_MaterialMap)
class RWMesh_NodeAttributes(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    Name = property(_RWMesh.RWMesh_NodeAttributes_Name_get, _RWMesh.RWMesh_NodeAttributes_Name_set)
    RawName = property(_RWMesh.RWMesh_NodeAttributes_RawName_get, _RWMesh.RWMesh_NodeAttributes_RawName_set)
    NamedData = property(_RWMesh.RWMesh_NodeAttributes_NamedData_get, _RWMesh.RWMesh_NodeAttributes_NamedData_set)
    Style = property(_RWMesh.RWMesh_NodeAttributes_Style_get, _RWMesh.RWMesh_NodeAttributes_Style_set)

    __repr__ = _dumps_object


    def __init__(self):
        _RWMesh.RWMesh_NodeAttributes_swiginit(self, _RWMesh.new_RWMesh_NodeAttributes())
    __swig_destroy__ = _RWMesh.delete_RWMesh_NodeAttributes

# Register RWMesh_NodeAttributes in _RWMesh:
_RWMesh.RWMesh_NodeAttributes_swigregister(RWMesh_NodeAttributes)
class RWMesh_TriangulationReader(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def CoordinateSystemConverter(self, *args):
        r"""
        Return
        -------
        RWMesh_CoordinateSystemConverter

        Description
        -----------
        Returns coordinate system converter using for correct data loading.

        """
        return _RWMesh.RWMesh_TriangulationReader_CoordinateSystemConverter(self, *args)

    def FileName(self, *args):
        r"""
        Return
        -------
        TCollection_AsciiString

        Description
        -----------
        Returns file name for reporting issues.

        """
        return _RWMesh.RWMesh_TriangulationReader_FileName(self, *args)

    def IsDoublePrecision(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns flag to fill in triangulation using double or single precision; false by default.

        """
        return _RWMesh.RWMesh_TriangulationReader_IsDoublePrecision(self, *args)

    def Load(self, *args):
        r"""

        Parameters
        ----------
        theSourceMesh: RWMesh_TriangulationSource
        theDestMesh: Poly_Triangulation
        theFileSystem: OSD_FileSystem

        Return
        -------
        bool

        Description
        -----------
        Loads primitive array.

        """
        return _RWMesh.RWMesh_TriangulationReader_Load(self, *args)

    def PrintStatistic(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Prints loading statistic. this method should be used between startstatistic() and stopstatistic() calls for correct results.

        """
        return _RWMesh.RWMesh_TriangulationReader_PrintStatistic(self, *args)

    def SetCoordinateSystemConverter(self, *args):
        r"""

        Parameters
        ----------
        theConverter: RWMesh_CoordinateSystemConverter

        Return
        -------
        None

        Description
        -----------
        Sets coordinate system converter.

        """
        return _RWMesh.RWMesh_TriangulationReader_SetCoordinateSystemConverter(self, *args)

    def SetDoublePrecision(self, *args):
        r"""

        Parameters
        ----------
        theIsDouble: bool

        Return
        -------
        None

        Description
        -----------
        Sets flag to fill in triangulation using double or single precision.

        """
        return _RWMesh.RWMesh_TriangulationReader_SetDoublePrecision(self, *args)

    def SetFileName(self, *args):
        r"""

        Parameters
        ----------
        theFileName: str

        Return
        -------
        None

        Description
        -----------
        Sets file name for reporting issues.

        """
        return _RWMesh.RWMesh_TriangulationReader_SetFileName(self, *args)

    def SetToPrintDebugMessages(self, *args):
        r"""

        Parameters
        ----------
        theToPrint: bool

        Return
        -------
        None

        Description
        -----------
        Sets flag to print debug information.

        """
        return _RWMesh.RWMesh_TriangulationReader_SetToPrintDebugMessages(self, *args)

    def SetToSkipDegenerates(self, *args):
        r"""

        Parameters
        ----------
        theToSkip: bool

        Return
        -------
        None

        Description
        -----------
        Sets flag to skip degenerated triangles during mesh loading (only indexes will be checked).

        """
        return _RWMesh.RWMesh_TriangulationReader_SetToSkipDegenerates(self, *args)

    def StartStatistic(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Starts and reset internal object that accumulates nodes/triangles statistic during data reading.

        """
        return _RWMesh.RWMesh_TriangulationReader_StartStatistic(self, *args)

    def StopStatistic(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Stops and nullify internal object that accumulates nodes/triangles statistic during data reading.

        """
        return _RWMesh.RWMesh_TriangulationReader_StopStatistic(self, *args)

    def ToPrintDebugMessages(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if additional debug information should be print.

        """
        return _RWMesh.RWMesh_TriangulationReader_ToPrintDebugMessages(self, *args)

    def ToSkipDegenerates(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if degenerated triangles should be skipped during mesh loading (only indexes will be checked).

        """
        return _RWMesh.RWMesh_TriangulationReader_ToSkipDegenerates(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_RWMesh_TriangulationReader_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _RWMesh.delete_RWMesh_TriangulationReader

# Register RWMesh_TriangulationReader in _RWMesh:
_RWMesh.RWMesh_TriangulationReader_swigregister(RWMesh_TriangulationReader)
class RWMesh_TriangulationSource(OCC.Core.Poly.Poly_Triangulation):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructor.

        """
        _RWMesh.RWMesh_TriangulationSource_swiginit(self, _RWMesh.new_RWMesh_TriangulationSource(*args))

    def GetChangeDegeneratedTriNb(self):
        r"""GetChangeDegeneratedTriNb(RWMesh_TriangulationSource self) -> Standard_Integer"""
        return _RWMesh.RWMesh_TriangulationSource_GetChangeDegeneratedTriNb(self)

    def SetChangeDegeneratedTriNb(self, value):
        r"""SetChangeDegeneratedTriNb(RWMesh_TriangulationSource self, Standard_Integer value)"""
        return _RWMesh.RWMesh_TriangulationSource_SetChangeDegeneratedTriNb(self, value)

    def DegeneratedTriNb(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns number of degenerated triangles collected during data reading. used for debug statistic purpose.

        """
        return _RWMesh.RWMesh_TriangulationSource_DegeneratedTriNb(self, *args)

    def Reader(self, *args):
        r"""
        Return
        -------
        opencascade::handle<RWMesh_TriangulationReader>

        Description
        -----------
        Returns reader allowing to read data from the buffer.

        """
        return _RWMesh.RWMesh_TriangulationSource_Reader(self, *args)

    def SetNbDeferredNodes(self, *args):
        r"""

        Parameters
        ----------
        theNbNodes: int

        Return
        -------
        None

        Description
        -----------
        Sets number of nodes for deferred loading.

        """
        return _RWMesh.RWMesh_TriangulationSource_SetNbDeferredNodes(self, *args)

    def SetNbDeferredTriangles(self, *args):
        r"""

        Parameters
        ----------
        theNbTris: int

        Return
        -------
        None

        Description
        -----------
        Sets number of triangles for deferred loading.

        """
        return _RWMesh.RWMesh_TriangulationSource_SetNbDeferredTriangles(self, *args)

    def SetReader(self, *args):
        r"""

        Parameters
        ----------
        theReader: RWMesh_TriangulationReader

        Return
        -------
        None

        Description
        -----------
        Sets reader allowing to read data from the buffer.

        """
        return _RWMesh.RWMesh_TriangulationSource_SetReader(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_RWMesh_TriangulationSource_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _RWMesh.delete_RWMesh_TriangulationSource

# Register RWMesh_TriangulationSource in _RWMesh:
_RWMesh.RWMesh_TriangulationSource_swigregister(RWMesh_TriangulationSource)



@deprecated
def rwmesh_FormatName(*args):
	return rwmesh.FormatName(*args)

@deprecated
def rwmesh_ReadNameAttribute(*args):
	return rwmesh.ReadNameAttribute(*args)

@deprecated
def RWMesh_CoordinateSystemConverter_StandardCoordinateSystem(*args):
	return RWMesh_CoordinateSystemConverter.StandardCoordinateSystem(*args)



