# AvogadroLibs CMake configuration file - http://www.openchemistry.org/

# If this file was found, then OpenQube has been found
set(AvogadroLibs_FOUND 1)

set(AvogadroLibs_VERSION_MAJOR   "1")
set(AvogadroLibs_VERSION_MINOR   "98")
set(AvogadroLibs_VERSION_PATCH   "1")
set(AvogadroLibs_VERSION         "${AvogadroLibs_VERSION_MAJOR}.${AvogadroLibs_VERSION_MINOR}.${AvogadroLibs_VERSION_PATCH}")

set(AvogadroLibs_INSTALL_PREFIX  "/usr")
set(AvogadroLibs_INCLUDE_DIRS    "${AvogadroLibs_INSTALL_PREFIX}/include")
set(AvogadroLibs_LIBRARY_DIR     "${AvogadroLibs_INSTALL_PREFIX}/lib")
set(AvogadroLibs_RUNTIME_DIR     "${AvogadroLibs_INSTALL_PREFIX}/bin")
set(AvogadroLibs_DATA_DIR        "${AvogadroLibs_INSTALL_PREFIX}/share")
set(AvogadroLibs_CMAKE_DIR       "${AvogadroLibs_LIBRARY_DIR}/cmake/avogadrolibs")

# List of target names that are plugins:
set(AvogadroLibs_PLUGINS         "")
set(AvogadroLibs_STATIC_PLUGINS  "ThreeDMol;ApplyColors;AlignTool;BondCentric;Bonding;Cartoons;Centroid;CopyPaste;Crystal;CrystalScene;CustomElements;Editor;FetchPDB;Focus;Forcefield;Hydrogens;ImportPQR;NucleicInput;Label;LabelEditor;LineFormatInput;Manipulator;MeasureTool;Navigator;NetworkDatabases;OpenBabel;PlayerTool;PLY;POVRay;PropertyTables;ResetView;Select;Selection;SpaceGroup;Surfaces;LammpsInput;OpenMMInput;CoordinateEditor;InsertFragment;MolecularProperties;SVG;Spectra;TemplateTool;VRML;ColorOpacityMap;PlotPdf;PlotRmsd;PlotXrd;Yaehmop;apbs;Cp2kInput;GamessInput;commands;QuantumInput;ScriptCharges;ScriptFileFormats;PluginDownloader;Symmetry;SymmetryScene;BallStick;CloseContacts;Force;Licorice;Meshes;NonCovalent;VanDerWaals;Wireframe;OverlayAxes")

if(NOT TARGET AvogadroCore)
  include("${AvogadroLibs_CMAKE_DIR}/AvogadroLibsTargets.cmake")
endif()
