/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pull;

import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.lib.ActiveSource;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.PullPushCopier;
import net.sf.saxon.trans.XPathException;

public class PullSource
implements ActiveSource {
    private String systemId;
    private final PullProvider provider;

    public PullSource(PullProvider provider) {
        this.provider = provider;
        if (provider.getSourceLocator() != null) {
            this.systemId = provider.getSourceLocator().getSystemId();
        }
    }

    public PullProvider getPullProvider() {
        return this.provider;
    }

    @Override
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliver(Receiver receiver, ParseOptions options) throws XPathException {
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        boolean xInclude = options.isXIncludeAware();
        if (xInclude) {
            throw new XPathException("XInclude processing is not supported with a pull parser");
        }
        receiver = Sender.makeValidator(receiver, this.getSystemId(), options);
        PullProvider provider = this.getPullProvider();
        provider.setPipelineConfiguration(pipe);
        receiver.setPipelineConfiguration(pipe);
        PullPushCopier copier = new PullPushCopier(provider, receiver);
        try {
            copier.copy();
        }
        finally {
            if (options.isPleaseCloseAfterUse()) {
                provider.close();
            }
        }
    }
}

