/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.utils;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.PrintGraphics;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.print.PrinterGraphics;
import java.util.HashMap;
import java.util.Map;

public class RenderingUtils {
    private static final String PROP_DESKTOPHINTS = "awt.font.desktophints";

    public static Map installDesktopHints(Graphics2D g2) {
        HashMap<RenderingHints.Key, Object> oldRenderingHints = null;
        Map desktopHints = RenderingUtils.desktopHints(g2);
        if (desktopHints != null && !desktopHints.isEmpty()) {
            oldRenderingHints = new HashMap<RenderingHints.Key, Object>(desktopHints.size());
            for (RenderingHints.Key key : desktopHints.keySet()) {
                oldRenderingHints.put(key, g2.getRenderingHint(key));
            }
            g2.addRenderingHints(desktopHints);
        }
        return oldRenderingHints;
    }

    private static Map desktopHints(Graphics2D g2) {
        Object aaHint;
        if (RenderingUtils.isPrinting(g2)) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsDevice device = g2.getDeviceConfiguration().getDevice();
        Map desktopHints = (Map)toolkit.getDesktopProperty("awt.font.desktophints." + device.getIDstring());
        if (desktopHints == null) {
            desktopHints = (Map)toolkit.getDesktopProperty(PROP_DESKTOPHINTS);
        }
        if (desktopHints != null && ((aaHint = desktopHints.get(RenderingHints.KEY_TEXT_ANTIALIASING)) == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF || aaHint == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT)) {
            desktopHints = null;
        }
        return desktopHints;
    }

    private static boolean isPrinting(Graphics g) {
        return g instanceof PrintGraphics || g instanceof PrinterGraphics;
    }
}

