/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.filesystems;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.ImageDecorator;
import org.openide.filesystems.StatusDecorator;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class FileSystemStatus
implements StatusDecorator,
ImageDecorator {
    private static final Logger LOG = Logger.getLogger(FileSystemStatus.class.getName());

    public String annotateName(String s, Set<? extends FileObject> files) {
        for (FileObject fileObject : files) {
            String displayName = this.annotateName(fileObject);
            if (displayName == null) continue;
            return displayName;
        }
        return s;
    }

    private final String annotateName(FileObject fo) {
        String bundleName = (String)fo.getAttribute("SystemFileSystem.localizingBundle");
        if (bundleName != null) {
            try {
                bundleName = BaseUtilities.translate((String)bundleName);
                ResourceBundle b = NbBundle.getBundle((String)bundleName);
                try {
                    return b.getString(fo.getPath());
                }
                catch (MissingResourceException missingResourceException) {
                }
            }
            catch (MissingResourceException ex) {
                Exceptions.attachMessage((Throwable)ex, (String)this.warningMessage(bundleName, fo));
                LOG.log(Level.INFO, null, ex);
            }
        }
        return (String)fo.getAttribute("displayName");
    }

    private String warningMessage(String name, FileObject fo) {
        Object by = fo.getAttribute("layers");
        if (by instanceof Object[]) {
            by = Arrays.toString((Object[])by);
        }
        return "Cannot load " + name + " for " + fo + " defined by " + by;
    }

    @Override
    public Image annotateIcon(Image im, int type, Set<? extends FileObject> files) {
        for (FileObject fileObject : files) {
            Image img = this.annotateIcon(fileObject, type);
            if (img == null) continue;
            return img;
        }
        return im;
    }

    public String annotateNameHtml(String name, Set<? extends FileObject> files) {
        return null;
    }

    private Image annotateIcon(FileObject fo, int type) {
        String base;
        Object value;
        String attr = null;
        if (type == 1) {
            attr = "SystemFileSystem.icon";
        } else if (type == 2) {
            attr = "SystemFileSystem.icon32";
        }
        if (attr != null && (value = fo.getAttribute(attr)) != null) {
            if (value instanceof URL) {
                return Toolkit.getDefaultToolkit().getImage((URL)value);
            }
            if (value instanceof Image) {
                return (Image)value;
            }
            LOG.warning("Attribute " + attr + " on " + fo + " expected to be a URL or Image; was: " + value);
        }
        if ((base = (String)fo.getAttribute("iconBase")) != null) {
            if (type == 1) {
                return ImageUtilities.loadImage((String)base, (boolean)true);
            }
            if (type == 2) {
                return ImageUtilities.loadImage((String)this.insertBeforeSuffix(base, "_32"), (boolean)true);
            }
        }
        return null;
    }

    private String insertBeforeSuffix(String path, String toInsert) {
        String withoutSuffix = path;
        String suffix = "";
        if (path.lastIndexOf(46) >= 0) {
            withoutSuffix = path.substring(0, path.lastIndexOf(46));
            suffix = path.substring(path.lastIndexOf(46), path.length());
        }
        return withoutSuffix + toInsert + suffix;
    }
}

