/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.layout;

import java.util.HashMap;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutProperty;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;

public class LayoutNode
extends AbstractNode {
    private final Layout layout;
    private Node.PropertySet[] propertySets;

    public LayoutNode(Layout layout) {
        super(Children.LEAF);
        this.layout = layout;
        this.setName(layout.getBuilder().getName());
    }

    public Node.PropertySet[] getPropertySets() {
        if (this.propertySets == null) {
            try {
                HashMap<String, Sheet.Set> sheetMap = new HashMap<String, Sheet.Set>();
                for (LayoutProperty layoutProperty : this.layout.getProperties()) {
                    Sheet.Set set = (Sheet.Set)sheetMap.get(layoutProperty.getCategory());
                    if (set == null) {
                        set = Sheet.createPropertiesSet();
                        set.setDisplayName(layoutProperty.getCategory());
                        sheetMap.put(layoutProperty.getCategory(), set);
                    }
                    set.put(layoutProperty.getProperty());
                }
                this.propertySets = sheetMap.values().toArray(new Node.PropertySet[0]);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }
        return this.propertySets;
    }

    public Layout getLayout() {
        return this.layout;
    }
}

