/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.lib.gleem.linalg;

import org.gephi.lib.gleem.linalg.Mat2f;
import org.gephi.lib.gleem.linalg.Vec2f;
import org.gephi.lib.gleem.linalg.Vec3f;

public class Line {
    private Vec3f point;
    private Vec3f direction;
    private final Vec3f alongVec;

    public Line() {
        this.point = new Vec3f(0.0f, 0.0f, 0.0f);
        this.direction = new Vec3f(1.0f, 0.0f, 0.0f);
        this.alongVec = new Vec3f();
        this.recalc();
    }

    public Line(Vec3f direction, Vec3f point) {
        direction = new Vec3f(direction);
        direction.normalize();
        point = new Vec3f(point);
        this.alongVec = new Vec3f();
        this.recalc();
    }

    public Vec3f getDirection() {
        return this.direction;
    }

    public void setDirection(Vec3f direction) {
        this.direction.set(direction);
        this.direction.normalize();
        this.recalc();
    }

    public Vec3f getPoint() {
        return this.point;
    }

    public void setPoint(Vec3f point) {
        this.point.set(point);
        this.recalc();
    }

    public void projectPoint(Vec3f pt, Vec3f projPt) {
        float dotp = this.direction.dot(pt);
        projPt.set(this.direction);
        projPt.scale(dotp);
        projPt.add(this.alongVec);
    }

    public boolean closestPointToRay(Vec3f rayStart, Vec3f rayDirection, Vec3f closestPoint) {
        Mat2f A = new Mat2f();
        A.set(0, 0, -this.direction.lengthSquared());
        A.set(1, 1, -rayDirection.lengthSquared());
        A.set(0, 1, this.direction.dot(rayDirection));
        A.set(1, 0, A.get(0, 1));
        if (Math.abs(A.determinant()) == 0.0f) {
            return false;
        }
        if (!A.invert()) {
            return false;
        }
        Vec2f b = new Vec2f();
        b.setX(this.point.dot(this.direction) - rayStart.dot(this.direction));
        b.setY(rayStart.dot(rayDirection) - this.point.dot(rayDirection));
        Vec2f x = new Vec2f();
        A.xformVec(b, x);
        if (x.y() < 0.0f) {
            closestPoint.set(rayStart);
        } else {
            closestPoint.set(this.direction);
            closestPoint.scale(x.x());
            closestPoint.add(this.point);
        }
        return true;
    }

    private void recalc() {
        float denom = this.direction.lengthSquared();
        if (denom == 0.0f) {
            throw new RuntimeException("Line.recalc: ERROR: direction was the zero vector (not allowed)");
        }
        this.alongVec.set(this.point.minus(this.direction.times(this.point.dot(this.direction))));
    }
}

