/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.lib.gleem.linalg;

import org.gephi.lib.gleem.linalg.DimensionMismatchException;
import org.gephi.lib.gleem.linalg.Mat2f;
import org.gephi.lib.gleem.linalg.Mat3f;
import org.gephi.lib.gleem.linalg.Mat4f;
import org.gephi.lib.gleem.linalg.Vecf;

public class Matf {
    private final float[] data;
    private final int nCol;
    private final int nRow;

    public Matf(int nRow, int nCol) {
        this.data = new float[nRow * nCol];
        this.nCol = nCol;
        this.nRow = nRow;
    }

    public Matf(Matf arg) {
        this.nRow = arg.nRow;
        this.nCol = arg.nCol;
        this.data = new float[this.nRow * this.nCol];
        System.arraycopy(arg.data, 0, this.data, 0, this.data.length);
    }

    public int nRow() {
        return this.nRow;
    }

    public int nCol() {
        return this.nCol;
    }

    public float get(int i, int j) {
        return this.data[this.nCol * i + j];
    }

    public void set(int i, int j, float val) {
        this.data[this.nCol * i + j] = val;
    }

    public Matf transpose() {
        Matf tmp = new Matf(this.nCol, this.nRow);
        for (int i = 0; i < this.nRow; ++i) {
            for (int j = 0; j < this.nCol; ++j) {
                tmp.set(j, i, this.get(i, j));
            }
        }
        return tmp;
    }

    public Matf mul(Matf b) throws DimensionMismatchException {
        if (this.nCol() != b.nRow()) {
            throw new DimensionMismatchException();
        }
        Matf tmp = new Matf(this.nRow(), b.nCol());
        for (int i = 0; i < this.nRow(); ++i) {
            for (int j = 0; j < b.nCol(); ++j) {
                float val = 0.0f;
                for (int t = 0; t < this.nCol(); ++t) {
                    val += this.get(i, t) * b.get(t, j);
                }
                tmp.set(i, j, val);
            }
        }
        return tmp;
    }

    public Vecf mul(Vecf v) throws DimensionMismatchException {
        if (this.nCol() != v.length()) {
            throw new DimensionMismatchException();
        }
        Vecf out = new Vecf(this.nRow());
        for (int i = 0; i < this.nRow(); ++i) {
            float tmp = 0.0f;
            for (int j = 0; j < this.nCol(); ++j) {
                tmp += this.get(i, j) * v.get(j);
            }
            out.set(i, tmp);
        }
        return out;
    }

    public Mat2f toMat2f() throws DimensionMismatchException {
        if (this.nRow() != 2 || this.nCol() != 2) {
            throw new DimensionMismatchException();
        }
        Mat2f tmp = new Mat2f();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                tmp.set(i, j, this.get(i, j));
            }
        }
        return tmp;
    }

    public Mat3f toMat3f() throws DimensionMismatchException {
        if (this.nRow() != 3 || this.nCol() != 3) {
            throw new DimensionMismatchException();
        }
        Mat3f tmp = new Mat3f();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                tmp.set(i, j, this.get(i, j));
            }
        }
        return tmp;
    }

    public Mat4f toMat4f() throws DimensionMismatchException {
        if (this.nRow() != 4 || this.nCol() != 4) {
            throw new DimensionMismatchException();
        }
        Mat4f tmp = new Mat4f();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                tmp.set(i, j, this.get(i, j));
            }
        }
        return tmp;
    }
}

