/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.filters.library;

import java.util.HashSet;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.gephi.desktop.filters.FilterUIModel;
import org.gephi.desktop.filters.library.CategoryNode;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.api.FilterModel;
import org.gephi.filters.api.Query;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.CategoryBuilder;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterLibraryMask;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;

public class FiltersExplorer
extends BeanTreeView {
    public static final Category QUERIES = new Category(NbBundle.getMessage(FiltersExplorer.class, (String)"FiltersExplorer.Queries"), null, null);
    private final Category UNSORTED = new Category(NbBundle.getMessage(FiltersExplorer.class, (String)"FiltersExplorer.UnsortedCategory"), null, null);
    private ExplorerManager manager;
    private FilterLibrary filterLibrary;
    private FilterUIModel uiModel;

    public void setup(final ExplorerManager manager, FilterModel model, FilterUIModel uiModel) {
        this.manager = manager;
        this.uiModel = uiModel;
        if (model != null) {
            this.filterLibrary = model.getLibrary();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    manager.setRootContext((Node)new CategoryNode(new Utils(), null));
                }
            });
        } else {
            this.filterLibrary = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    manager.setRootContext((Node)new AbstractNode(Children.LEAF){

                        public Action[] getActions(boolean context) {
                            return new Action[0];
                        }
                    });
                }
            });
        }
        this.updateEnabled(model != null);
    }

    private void updateEnabled(final boolean enabled) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FiltersExplorer.this.setRootVisible(enabled);
                FiltersExplorer.this.setEnabled(enabled);
            }
        });
    }

    private void loadExpandStatus(CategoryNode node) {
        if (this.uiModel == null) {
            return;
        }
        if (this.uiModel.isExpanded(node.getCategory())) {
            this.expandNode((Node)node);
        }
        for (Node n : node.getChildren().getNodes()) {
            if (!(n instanceof CategoryNode)) continue;
            this.loadExpandStatus((CategoryNode)n);
        }
    }

    private void saveExpandStatus(CategoryNode node) {
        if (this.uiModel == null) {
            return;
        }
        this.uiModel.setExpand(node.getCategory(), this.isExpanded((Node)node));
        for (Node n : node.getChildren().getNodes()) {
            if (!(n instanceof CategoryNode)) continue;
            this.saveExpandStatus((CategoryNode)n);
        }
    }

    protected class Utils
    implements LookupListener {
        private final Lookup.Result<FilterBuilder> lookupResult;
        private final Lookup.Result<Query> lookupResult2;

        public Utils() {
            this.lookupResult = FiltersExplorer.this.filterLibrary.getLookup().lookupResult(FilterBuilder.class);
            this.lookupResult.addLookupListener((LookupListener)this);
            this.lookupResult2 = FiltersExplorer.this.filterLibrary.getLookup().lookupResult(Query.class);
            this.lookupResult2.addLookupListener((LookupListener)this);
        }

        public void resultChanged(LookupEvent ev) {
            FiltersExplorer.this.saveExpandStatus((CategoryNode)FiltersExplorer.this.manager.getRootContext());
            FiltersExplorer.this.manager.setRootContext((Node)new CategoryNode(this, null));
            FiltersExplorer.this.loadExpandStatus((CategoryNode)FiltersExplorer.this.manager.getRootContext());
        }

        public boolean isLeaf(Category category) {
            if (category == null) {
                return false;
            }
            if (category.equals((Object)QUERIES)) {
                return FiltersExplorer.this.filterLibrary.getLookup().lookupAll(Query.class).isEmpty();
            }
            for (FilterBuilder fb : FiltersExplorer.this.filterLibrary.getLookup().lookupAll(FilterBuilder.class)) {
                if (fb.getCategory() == null && category.equals((Object)FiltersExplorer.this.UNSORTED)) {
                    return false;
                }
                if (fb.getCategory() != null && fb.getCategory().getParent() != null && fb.getCategory().getParent().equals((Object)category)) {
                    return false;
                }
                if (fb.getCategory() == null || !fb.getCategory().equals((Object)category)) continue;
                return false;
            }
            for (CategoryBuilder cb : FiltersExplorer.this.filterLibrary.getLookup().lookupAll(CategoryBuilder.class)) {
                if (cb.getCategory().equals((Object)category)) {
                    return false;
                }
                if (cb.getCategory().getParent() == null || !cb.getCategory().getParent().equals((Object)category)) continue;
                return false;
            }
            return true;
        }

        public Object[] getChildren(Category category) {
            HashSet<Object> cats = new HashSet<Object>();
            if (category != null && category.equals((Object)QUERIES)) {
                for (Query q : FiltersExplorer.this.filterLibrary.getLookup().lookupAll(Query.class)) {
                    cats.add(q);
                }
            } else {
                if (category == null) {
                    cats.add(QUERIES);
                }
                for (FilterBuilder fb : FiltersExplorer.this.filterLibrary.getLookup().lookupAll(FilterBuilder.class)) {
                    if (fb.getCategory() == null) {
                        if (category == null) {
                            cats.add(FiltersExplorer.this.UNSORTED);
                            continue;
                        }
                        if (!category.equals((Object)FiltersExplorer.this.UNSORTED)) continue;
                        cats.add(fb);
                        continue;
                    }
                    if (fb.getCategory().getParent() == category) {
                        if (!this.isValid(fb.getCategory())) continue;
                        cats.add(fb.getCategory());
                        continue;
                    }
                    if (fb.getCategory().getParent() != null && fb.getCategory().getParent().equals((Object)category)) {
                        if (!this.isValid(fb.getCategory())) continue;
                        cats.add(fb.getCategory());
                        continue;
                    }
                    if (!fb.getCategory().equals((Object)category)) continue;
                    cats.add(fb);
                }
                for (CategoryBuilder cb : FiltersExplorer.this.filterLibrary.getLookup().lookupAll(CategoryBuilder.class)) {
                    if (cb.getCategory().getParent() == category) {
                        cats.add(cb.getCategory());
                        continue;
                    }
                    if (cb.getCategory().getParent() != null && cb.getCategory().getParent().getParent() == category) {
                        cats.add(cb.getCategory().getParent());
                        continue;
                    }
                    if (cb.getCategory() != category) continue;
                    for (FilterBuilder fb : cb.getBuilders(FiltersExplorer.this.uiModel.getWorkspace())) {
                        cats.add(fb);
                    }
                }
            }
            return cats.toArray();
        }

        public boolean isValid(Category category) {
            for (FilterLibraryMask mask : FiltersExplorer.this.filterLibrary.getLookup().lookupAll(FilterLibraryMask.class)) {
                if (!mask.getCategory().equals((Object)category)) continue;
                return mask.isValid();
            }
            return true;
        }
    }
}

