/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.plugin;

import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;

public class NormalizationHelper {
    private final boolean enabled;
    protected final float minSize;
    protected final float maxSize;
    protected final float minX;
    protected final float maxX;
    protected final float minY;
    protected final float maxY;
    protected final float minZ;
    protected final float maxZ;

    public static NormalizationHelper build(boolean enabled, Graph graph) {
        return new NormalizationHelper(enabled, graph);
    }

    private NormalizationHelper(boolean enabled, Graph graph) {
        this.enabled = enabled;
        float minX = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float minZ = Float.POSITIVE_INFINITY;
        float maxZ = Float.NEGATIVE_INFINITY;
        float minSize = Float.POSITIVE_INFINITY;
        float maxSize = Float.NEGATIVE_INFINITY;
        for (Node node : graph.getNodes()) {
            minX = Math.min(minX, node.x());
            maxX = Math.max(maxX, node.x());
            minY = Math.min(minY, node.y());
            maxY = Math.max(maxY, node.y());
            minZ = Math.min(minZ, node.z());
            maxZ = Math.max(maxZ, node.z());
            minSize = Math.min(minSize, node.size());
            maxSize = Math.max(maxSize, node.size());
        }
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.minZ = minZ;
        this.maxZ = maxZ;
        this.minSize = minSize;
        this.maxSize = maxSize;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected float normalizeX(float x) {
        if (this.enabled && (double)x != 0.0) {
            if (this.maxX == this.minX) {
                return 1.0f;
            }
            return (x - this.minX) / (this.maxX - this.minX);
        }
        return x;
    }

    protected float normalizeY(float y) {
        if (this.enabled && (double)y != 0.0) {
            if (this.minY == this.maxY) {
                return 1.0f;
            }
            return (y - this.minY) / (this.maxY - this.minY);
        }
        return y;
    }

    protected float normalizeZ(float z) {
        if (this.enabled && (double)z != 0.0) {
            if (this.maxZ == this.minZ) {
                return 1.0f;
            }
            return (z - this.minZ) / (this.maxZ - this.minZ);
        }
        return z;
    }

    protected float normalizeSize(float size) {
        if (this.enabled && (double)size != 0.0) {
            if (this.maxSize == this.minSize) {
                return 1.0f;
            }
            return (size - this.minSize) / (this.maxSize - this.minSize);
        }
        return size;
    }
}

