/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import javajs.util.PT;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class XcrysdenReader
extends AtomSetCollectionReader {
    private int nAtoms;
    private boolean animation = false;
    private float[] unitCellData = new float[9];
    private int animationStep;

    @Override
    protected void initializeReader() throws Exception {
        this.setFractionalCoordinates(false);
        this.doApplySymmetry = true;
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.startsWith("ATOMS")) {
            this.doApplySymmetry = false;
            return this.readCoordinates();
        }
        if (this.line.contains("ANIMSTEP")) {
            this.animation = true;
        } else if (this.line.contains("PRIMVEC")) {
            this.readUnitCell();
        } else if (this.line.contains("PRIMCOORD")) {
            return this.readCoordinates();
        }
        return true;
    }

    private void readUnitCell() throws Exception {
        this.setSymmetry();
        this.fillFloatArray(null, 0, this.unitCellData);
        this.setUnitCell();
    }

    private void setUnitCell() {
        this.addExplicitLatticeVector(0, this.unitCellData, 0);
        this.addExplicitLatticeVector(1, this.unitCellData, 3);
        this.addExplicitLatticeVector(2, this.unitCellData, 6);
    }

    private void setSymmetry() throws Exception {
        this.applySymmetryAndSetTrajectory();
        this.asc.newAtomSet();
        this.setSpaceGroupName("P1");
        this.setFractionalCoordinates(false);
    }

    private boolean readCoordinates() throws Exception {
        String[] tokens;
        int an;
        if (this.doApplySymmetry) {
            String[] atomStr = PT.getTokens(this.rd());
            this.nAtoms = Integer.parseInt(atomStr[0]);
        } else {
            this.nAtoms = Integer.MAX_VALUE;
        }
        this.setFractionalCoordinates(false);
        for (int counter = 0; counter < this.nAtoms && this.rd() != null && (an = PT.parseInt((tokens = this.getTokens())[0])) >= 0; ++counter) {
            this.line = null;
            this.addAtomXYZSymName(tokens, 1, null, XcrysdenReader.getElementSymbol(an));
        }
        this.asc.setAtomSetName(this.animation ? "Structure " + ++this.animationStep : "Initial coordinates");
        if (this.line != null) {
            this.setSymmetry();
        }
        return this.line == null;
    }
}

