/*
 * Decompiled with CFR 0.152.
 */
package jspecview.js2d;

import java.util.Hashtable;
import java.util.Map;
import jspecview.api.PlatformDialog;
import jspecview.common.Annotation;
import jspecview.dialog.DialogManager;
import jspecview.dialog.JSVDialog;
import jspecview.js2d.DialogTableModel;
import org.jmol.awtjs.swing.AbstractTableModel;
import org.jmol.awtjs.swing.Color;
import org.jmol.awtjs.swing.Component;
import org.jmol.awtjs.swing.Dimension;
import org.jmol.awtjs.swing.FlowLayout;
import org.jmol.awtjs.swing.GridBagConstraints;
import org.jmol.awtjs.swing.GridBagLayout;
import org.jmol.awtjs.swing.Insets;
import org.jmol.awtjs.swing.JButton;
import org.jmol.awtjs.swing.JCheckBox;
import org.jmol.awtjs.swing.JComboBox;
import org.jmol.awtjs.swing.JComponent;
import org.jmol.awtjs.swing.JDialog;
import org.jmol.awtjs.swing.JLabel;
import org.jmol.awtjs.swing.JPanel;
import org.jmol.awtjs.swing.JScrollPane;
import org.jmol.awtjs.swing.JSplitPane;
import org.jmol.awtjs.swing.JTable;
import org.jmol.awtjs.swing.JTextField;
import org.jmol.awtjs.swing.LayoutManager;
import org.jmol.awtjs.swing.ListSelectionModel;

public class JsDialog
extends JDialog
implements PlatformDialog {
    protected String optionKey;
    protected String registryKey;
    protected Map<String, Object> options;
    protected DialogManager manager;
    private Annotation.AType type;
    protected JPanel leftPanel;
    private JSplitPane mainSplitPane;
    private JPanel rightPanel;
    private JPanel thisPanel;
    private JTable dataTable;
    private int iRow;
    private boolean haveColors;
    protected boolean tableCellAlignLeft;
    private boolean haveTwoPanels = true;
    private Insets buttonInsets = new Insets(5, 5, 5, 5);
    private Insets panelInsets = new Insets(0, 0, 2, 2);
    protected int selectedRow = -1;

    public JsDialog(DialogManager manager, JSVDialog jsvDialog, String registryKey) {
        this.defaultHeight = 350;
        this.manager = manager;
        this.registryKey = registryKey;
        this.optionKey = jsvDialog.optionKey;
        this.type = jsvDialog.getAType();
        this.options = jsvDialog.options;
        if (this.options == null) {
            this.options = new Hashtable<String, Object>();
        }
        this.getContentPane().setBackground(Color.get3((int)230, (int)230, (int)230));
        this.toFront();
    }

    public void onFocus() {
        this.toFront();
    }

    @Override
    public void setFocus(boolean tf) {
        if (tf) {
            this.toFront();
        }
    }

    @Override
    public Object addButton(String name, String text) {
        JButton btn = new JButton();
        btn.setPreferredSize(new Dimension(120, 25));
        btn.setText(text);
        btn.setName(this.registryKey + "/" + name);
        btn.addActionListener((Object)this.manager);
        this.thisPanel.add((JComponent)btn, (Object)new GridBagConstraints(0, this.iRow++, 3, 1, 0.0, 0.0, 10, 0, this.buttonInsets, 0, 0));
        return btn;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public Object addCheckBox(String name, String title, int level, boolean isSelected) {
        if (name == null) {
            this.iRow = 0;
            this.thisPanel = this.rightPanel;
            return null;
        }
        JCheckBox cb = new JCheckBox();
        cb.setSelected(isSelected);
        cb.setText(title);
        cb.setName(this.registryKey + "/" + name);
        cb.addActionListener((Object)this.manager);
        Insets insets = new Insets(0, 20 * level, 2, 2);
        this.thisPanel.add((JComponent)cb, (Object)new GridBagConstraints(0, this.iRow++, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        return cb;
    }

    private void addPanelLine(String name, String label, JComponent obj, String units) {
        this.thisPanel.add((JComponent)new JLabel(label == null ? name : label), (Object)new GridBagConstraints(0, this.iRow, 1, 1, 0.0, 0.0, 13, 0, this.panelInsets, 0, 0));
        if (units == null) {
            this.thisPanel.add(obj, (Object)new GridBagConstraints(1, this.iRow, 2, 1, 0.0, 0.0, 17, 0, this.panelInsets, 0, 0));
        } else {
            this.thisPanel.add(obj, (Object)new GridBagConstraints(1, this.iRow, 1, 1, 0.0, 0.0, 10, 0, this.panelInsets, 0, 0));
            this.thisPanel.add((JComponent)new JLabel(units), (Object)new GridBagConstraints(2, this.iRow, 1, 1, 0.0, 0.0, 17, 0, this.panelInsets, 0, 0));
        }
        ++this.iRow;
    }

    @Override
    public Object addSelectOption(String name, String label, String[] info, int iPt, boolean visible) {
        JComboBox combo = new JComboBox(info);
        combo.setSelectedIndex(iPt);
        combo.setName(this.registryKey + "/" + name);
        if (visible) {
            combo.addActionListener((Object)this.manager);
            this.addPanelLine(name, label, (JComponent)combo, null);
        }
        return combo;
    }

    @Override
    public Object addTextField(String name, String label, String value, String units, String defaultValue, boolean visible) {
        String key = this.optionKey + "_" + name;
        if (value == null && (value = (String)this.options.get(key)) == null) {
            value = defaultValue;
            this.options.put(key, value);
        }
        JTextField obj = new JTextField(value);
        obj.setName(this.registryKey + "/" + name);
        if (visible) {
            obj.setPreferredSize(new Dimension(45, 15));
            obj.addActionListener((Object)this.manager);
            this.addPanelLine(name, label, (JComponent)obj, units);
        }
        return obj;
    }

    @Override
    public void createTable(Object[][] data, String[] header, int[] widths) {
        try {
            this.dataTable = this.getDataTable(data, header, widths, this.leftPanel == null ? this.defaultHeight : this.leftPanel.getHeight() - 50);
            JScrollPane scrollPane = new JScrollPane((JComponent)this.dataTable);
            if (this.mainSplitPane == null) {
                this.getContentPane().add((Component)scrollPane);
            } else {
                this.mainSplitPane.setRightComponent((JComponent)scrollPane);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void endLayout() {
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)this.mainSplitPane);
        this.pack();
    }

    private synchronized JTable getDataTable(Object[][] data, String[] columnNames, int[] columnWidths, int height) {
        this.selectedRow = -1;
        DialogTableModel tableModel = new DialogTableModel(columnNames, data, !this.haveColors, this.tableCellAlignLeft);
        JTable table = new JTable((AbstractTableModel)tableModel);
        ListSelectionModel selector = table.getSelectionModel();
        selector.addListSelectionListener((Object)this.manager);
        this.manager.registerSelector(this.registryKey + "/ROW", selector);
        selector = table.getColumnModel().getSelectionModel();
        selector.addListSelectionListener((Object)this.manager);
        this.manager.registerSelector(this.registryKey + "/COLUMN", selector);
        int n = 0;
        for (int i = 0; i < columnNames.length; ++i) {
            table.getColumnModel().getColumn(i).setPreferredWidth(columnWidths[i]);
            n += columnWidths[i];
        }
        return table;
    }

    @Override
    public int getSelectedIndex(Object c) {
        return ((JComboBox)c).getSelectedIndex();
    }

    @Override
    public Object getSelectedItem(Object combo) {
        return ((JComboBox)combo).getSelectedItem();
    }

    @Override
    public String getText(Object o) {
        return ((JComponent)o).getText();
    }

    @Override
    public boolean isSelected(Object chkbox) {
        return ((JCheckBox)chkbox).isSelected();
    }

    @Override
    public void selectTableRow(int i) {
        this.selectedRow = i;
        this.dataTable.clearSelection();
        if (this.selectedRow >= 0) {
            this.dataTable.setRowSelectionAllowed(true);
            this.dataTable.setRowSelectionInterval(this.selectedRow, this.selectedRow + 1);
            this.repaint();
        }
    }

    @Override
    public void setCellSelectionEnabled(boolean enabled) {
        this.dataTable.setCellSelectionEnabled(enabled);
    }

    @Override
    public void setEnabled(Object btn, boolean b) {
        ((JComponent)btn).setEnabled(b);
    }

    @Override
    public void setIntLocation(int[] loc) {
        Dimension d = new Dimension(0, 0);
        loc[0] = Math.min(d.width - 50, loc[0]);
        loc[1] = Math.min(d.height - 50, loc[1]);
        this.setLocation(loc);
    }

    @Override
    public void setPreferredSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
    }

    @Override
    public void setSelected(Object chkbox, boolean b) {
        ((JCheckBox)chkbox).setSelected(b);
    }

    @Override
    public void setSelectedIndex(Object combo, int i) {
        ((JComboBox)combo).setSelectedIndex(i);
    }

    @Override
    public void setText(Object o, String text) {
        ((JComponent)o).setText(text);
    }

    @Override
    public void startLayout() {
        this.setPreferredSize(new Dimension(600, 370));
        this.getContentPane().removeAll();
        this.thisPanel = this.rightPanel = new JPanel((LayoutManager)new FlowLayout());
        switch (this.type) {
            case Integration: 
            case Measurements: 
            case PeakList: 
            case NONE: {
                break;
            }
            case OverlayLegend: {
                this.tableCellAlignLeft = true;
                this.haveColors = true;
                this.haveTwoPanels = false;
                break;
            }
            case Views: {
                this.rightPanel = new JPanel((LayoutManager)new GridBagLayout());
            }
        }
        if (this.haveTwoPanels) {
            this.thisPanel = this.leftPanel = new JPanel((LayoutManager)new GridBagLayout());
            this.leftPanel.setMinimumSize(new Dimension(200, 300));
            this.mainSplitPane = new JSplitPane(1);
            this.mainSplitPane.setLeftComponent((JComponent)this.leftPanel);
            this.mainSplitPane.setRightComponent((JComponent)new JScrollPane((JComponent)this.rightPanel));
        }
    }

    protected int getColumnCentering(int column) {
        return this.tableCellAlignLeft ? 2 : (column == 0 ? 0 : 4);
    }
}

