interface Room {
    Ref?: string;
    Creator?: string;
    CreateRoom?: Record<string, unknown>;
    Events?: {
        Type: string;
        Sender: string;
        StateKey?: string;
    }[];
}
/**
 * A blueprint for creating a homeserver deployment.
 */
export interface Blueprint {
    Name: string;
    Homeservers: {
        Name: string;
        Users?: {
            Localpart: string;
            DisplayName: string;
            AvatarURL?: string;
            AccountData?: {
                Key: string;
                Value: Record<string, unknown>;
            }[];
        }[];
        Rooms?: (Room & {
            Ref: string;
        } | Room & {
            Creator: string;
        })[];
        ApplicationServices?: {
            ID: string;
            URL?: string;
            SenderLocalpart?: string;
            RateLimited?: boolean;
        }[];
    }[];
    KeepAccessTokensForUsers?: string[];
}
export {};
