/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.html;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.atmp.CucaDiagram;
import net.sourceforge.plantuml.FileImageData;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.html.LinkHtmlPrinter;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.stereo.Stereotype;

public final class CucaDiagramHtmlMaker {
    private final CucaDiagram diagram;
    private final SFile dir;

    public CucaDiagramHtmlMaker(CucaDiagram diagram, SFile dir) {
        this.diagram = diagram;
        this.dir = dir;
    }

    public List<FileImageData> create() throws IOException {
        this.dir.mkdirs();
        if (!this.dir.exists()) {
            throw new IOException("Cannot create " + this.dir);
        }
        SFile f = this.dir.file("index.html");
        PrintWriter pw = f.createPrintWriter();
        pw.println("<html>");
        this.printAllType(pw, LeafType.ENUM);
        this.printAllType(pw, LeafType.INTERFACE);
        this.printAllType(pw, LeafType.ANNOTATION);
        this.printAllType(pw, LeafType.ABSTRACT_CLASS);
        this.printAllType(pw, LeafType.CLASS);
        this.htmlClose(pw);
        return Arrays.asList(new FileImageData(this.dir, null));
    }

    private void printAllType(PrintWriter pw, LeafType type) throws IOException {
        if (this.hasSome(type)) {
            pw.println("<h2>" + type.toHtml() + "</h2>");
            for (Entity ent : this.diagram.getEntityFactory().leafs()) {
                if (ent.getLeafType() != type) continue;
                this.export(ent);
                pw.println("<li>");
                pw.println(LinkHtmlPrinter.htmlLink(ent));
                pw.println("</li>");
            }
        }
    }

    private boolean hasSome(LeafType type) {
        for (Entity ent : this.diagram.getEntityFactory().leafs()) {
            if (ent.getLeafType() != type) continue;
            return true;
        }
        return false;
    }

    private void export(Entity entity) throws IOException {
        SFile f = this.dir.file(LinkHtmlPrinter.urlOf(entity));
        PrintWriter pw = f.createPrintWriter();
        pw.println("<html>");
        pw.println("<title>" + StringUtils.unicodeForHtml(entity.getName()) + "</title>");
        pw.println("<h2>" + entity.getLeafType().toHtml() + "</h2>");
        for (Object s : entity.getDisplay()) {
            pw.println(StringUtils.unicodeForHtml(s.toString()));
            pw.println("<br>");
        }
        Stereotype stereotype = entity.getStereotype();
        if (stereotype != null) {
            pw.println("<hr>");
            pw.println("<h3>Stereotype</h3>");
            for (String s : stereotype.getLabels(this.diagram.getSkinParam().guillemet())) {
                pw.println(s);
                pw.println("<br>");
            }
        }
        pw.println("<hr>");
        if (entity.getBodier().getFieldsToDisplay().size() == 0) {
            pw.println("<h2>No fields</h2>");
        } else {
            pw.println("<h2>Fields:</h2>");
            pw.println("<ul>");
            for (Object m : entity.getBodier().getFieldsToDisplay()) {
                pw.println("<li>");
                pw.println(StringUtils.unicodeForHtml(m.toString()));
                pw.println("</li>");
            }
            pw.println("</ul>");
        }
        pw.println("<hr>");
        if (entity.getBodier().getMethodsToDisplay().size() == 0) {
            pw.println("<h2>No methods</h2>");
        } else {
            pw.println("<h2>Methods:</h2>");
            pw.println("<ul>");
            for (Object m : entity.getBodier().getMethodsToDisplay()) {
                pw.println("<li>");
                pw.println(StringUtils.unicodeForHtml(m.toString()));
                pw.println("</li>");
            }
            pw.println("</ul>");
        }
        pw.println("<hr>");
        Collection<Link> links = this.getLinksButNotes(entity);
        if (links.size() == 0) {
            pw.println("<h2>No links</h2>");
        } else {
            pw.println("<h2>Links:</h2>");
            pw.println("<ul>");
            for (Link l : links) {
                pw.println("<li>");
                new LinkHtmlPrinter(l, entity).printLink(pw);
                pw.println("</li>");
            }
            pw.println("</ul>");
        }
        Collection<Entity> notes = this.getNotes(entity);
        if (notes.size() > 0) {
            pw.println("<hr>");
            pw.println("<h2>Notes:</h2>");
            pw.println("<ul>");
            for (Entity note : notes) {
                pw.println("<li>");
                for (CharSequence s : note.getDisplay()) {
                    pw.println(StringUtils.unicodeForHtml(s.toString()));
                    pw.println("<br>");
                }
                pw.println("</li>");
            }
            pw.println("</ul>");
        }
        this.htmlClose(pw);
    }

    private void htmlClose(PrintWriter pw) {
        pw.println("<hr>");
        pw.println("<a href=index.html>Back to index</a>");
        pw.println("</html>");
        pw.close();
    }

    private Collection<Entity> getNotes(Entity ent) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Link link : this.diagram.getLinks()) {
            if (!link.contains(ent) || link.getEntity1().getLeafType() != LeafType.NOTE && link.getEntity2().getLeafType() != LeafType.NOTE) continue;
            result.add(link.getOther(ent));
        }
        return Collections.unmodifiableList(result);
    }

    private Collection<Link> getLinksButNotes(Entity ent) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link link : this.diagram.getLinks()) {
            if (!link.contains(ent) || link.getEntity1().getLeafType() == LeafType.NOTE || link.getEntity2().getLeafType() == LeafType.NOTE) continue;
            result.add(link);
        }
        return Collections.unmodifiableList(result);
    }
}

