/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.lang.Sentence;
import net.sourceforge.plantuml.project.lang.SentenceSimple;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;

public class SentenceAndAnd
implements Sentence {
    private final SentenceSimple sentence1;
    private final SentenceSimple sentence2;
    private final SentenceSimple sentence3;

    public SentenceAndAnd(SentenceSimple sentence1, SentenceSimple sentence2, SentenceSimple sentence3) {
        this.sentence1 = sentence1;
        this.sentence2 = sentence2;
        this.sentence3 = sentence3;
    }

    @Override
    public IRegex toRegex() {
        return new RegexConcat(RegexLeaf.start(), this.sentence1.subjectii.toRegex(), RegexLeaf.spaceOneOrMore(), this.sentence1.getVerbRegex(), RegexLeaf.spaceOneOrMore(), this.sentence1.complementii.toRegex("1"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("and"), RegexLeaf.spaceOneOrMore(), this.sentence2.getVerbRegex(), RegexLeaf.spaceOneOrMore(), this.sentence2.complementii.toRegex("2"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("and"), RegexLeaf.spaceOneOrMore(), this.sentence3.getVerbRegex(), RegexLeaf.spaceOneOrMore(), this.sentence3.complementii.toRegex("3"), RegexLeaf.end());
    }

    @Override
    public final CommandExecutionResult execute(GanttDiagram project, RegexResult arg) {
        Failable<? extends Object> subject = this.sentence1.subjectii.getMe(project, arg);
        if (subject.isFail()) {
            return CommandExecutionResult.error(subject.getError());
        }
        Failable<? extends Object> complement1 = this.sentence1.complementii.getMe(project, arg, "1");
        if (complement1.isFail()) {
            return CommandExecutionResult.error(complement1.getError());
        }
        CommandExecutionResult result1 = this.sentence1.execute(project, subject.get(), complement1.get());
        if (!result1.isOk()) {
            return result1;
        }
        Failable<? extends Object> complement2 = this.sentence2.complementii.getMe(project, arg, "2");
        if (complement2.isFail()) {
            return CommandExecutionResult.error(complement2.getError());
        }
        CommandExecutionResult result2 = this.sentence2.execute(project, subject.get(), complement2.get());
        if (!result2.isOk()) {
            return result2;
        }
        Failable<? extends Object> complement3 = this.sentence3.complementii.getMe(project, arg, "3");
        if (complement3.isFail()) {
            return CommandExecutionResult.error(complement3.getError());
        }
        CommandExecutionResult result3 = this.sentence3.execute(project, subject.get(), complement3.get());
        return result3;
    }
}

