/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.utils;

import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.CharInspector;

public class CharInspectorImpl
implements CharInspector {
    private final BlocLines data;
    private final boolean insertNewlines;
    private int line = 0;
    private int pos = 0;

    CharInspectorImpl(BlocLines input, boolean insertNewlines) {
        this.data = input;
        this.insertNewlines = insertNewlines;
    }

    @Override
    public char peek(int ahead) {
        if (this.line == -1) {
            return '\u0000';
        }
        String currentLine = this.getCurrentLine();
        if (this.pos + ahead >= currentLine.length()) {
            return '\u0000';
        }
        return currentLine.charAt(this.pos + ahead);
    }

    private String getCurrentLine() {
        if (this.insertNewlines) {
            return this.data.getAt(this.line).getTrimmed().getString() + "\n";
        }
        return this.data.getAt(this.line).getTrimmed().getString();
    }

    @Override
    public void jump() {
        if (this.line == -1) {
            throw new IllegalStateException();
        }
        ++this.pos;
        if (this.pos >= this.getCurrentLine().length()) {
            ++this.line;
            this.pos = 0;
        }
        while (this.line < this.data.size() && this.getCurrentLine().length() == 0) {
            ++this.line;
        }
        if (this.line >= this.data.size()) {
            this.line = -1;
        }
    }
}

