package PPPUsage::Lib;

# provides:
#
# xbytes      ($bytes)
# format_secs ($seconds)
# usage       ($exit_value)
# version     ($exit_value)

use strict;
use Exporter;
use PPPUsage::Version;

use vars qw(@EXPORT_OK @ISA);

@ISA       = qw(Exporter);
@EXPORT_OK = qw(xbytes format_secs usage version);

# -----> xbytes ($bytes)
#
# Converts $bytes to kilobytes, megabytes and gigabytes and returns the
# three converted values.
#
sub xbytes {

	my $kb =     1024;
	my $mb = $kb*1024;
	my $gb = $mb*1024;

	my $n = shift;
	my @x = ();

	$x[0] = sprintf("%.1f", $n/$kb);
	$x[1] = sprintf("%.1f", $n/$mb);
	$x[2] = sprintf("%.1f", $n/$gb);

	return @x;
}

# -----> format_secs ($seconds)
#
# Converts $seconds to days, hours, minutes and seconds and returns an
# appropriately formatted string.
#
sub format_secs {

	my $arg = shift;
	my ($seconds,$minutes,$hours,$days);

	$seconds =  $arg % 60;
	$arg     = ($arg - $seconds) / 60;
	$minutes =  $arg % 60;
	$arg     = ($arg - $minutes) / 60;
	$hours   =  $arg % 24;
	$days    = ($arg - $hours)   / 24;

	foreach ($hours, $minutes, $seconds) {

		$_ = '0'.$_ if ($_=~/^\d$/);
	}

	return "$days days and $hours:$minutes:$seconds hours";
}

# -----> usage ($exit_value)
#
# Prints usage information to STDERR and exits with $exit_value.
#
sub usage {

	my $return = shift;
	print STDERR <<"EOF";
Usage:
    pppusage [-bcq] [-f *datafile*]
    [-t *yyyy*[*mm*[*dd*]][-*yyyy*[*mm*[*dd*]]]] [*logfile*...]

    pppusage [-hv]

EOF
	exit $return;
}

# -----> version ($exit_value)
#
# Prints version information to STDOUT and exits with 0.
#
sub version {

	print "$main::me $VERSION\n";
	exit 0;
}

1;
