/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Predicate;
import com.strobel.core.StringUtilities;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.CompilationUnit;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.SuperReferenceExpression;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.NamedNode;

public class RemoveHiddenMembersTransform
extends ContextTrackingVisitor<Void> {
    private static final INode DEFAULT_CONSTRUCTOR_BODY = new BlockStatement(new ExpressionStatement(new InvocationExpression(-34, (Expression)new SuperReferenceExpression(-34), new Expression[0])));
    private static final AstNode EMPTY_SUPER = new ExpressionStatement(new NamedNode("target", new SuperReferenceExpression(-34).invoke(new Expression[0])).toExpression());

    public RemoveHiddenMembersTransform(DecompilerContext context) {
        super(context);
    }

    static boolean isHiddenMemberReference(AstNode node, DecompilerContext context) {
        if (node == null || node.isNull()) {
            return false;
        }
        if (RemoveHiddenMembersTransform.isHiddenMemberReference(node.getUserData(Keys.MEMBER_REFERENCE), context)) {
            return true;
        }
        AstNode n = node;
        while (n instanceof InvocationExpression) {
            n = ((InvocationExpression)n).getTarget();
        }
        if (n instanceof MemberReferenceExpression) {
            do {
                if (RemoveHiddenMembersTransform.isHiddenMemberReference(n.getUserData(Keys.MEMBER_REFERENCE), context)) continue;
                return false;
            } while ((n = ((MemberReferenceExpression)n).getTarget()) instanceof MemberReferenceExpression);
            return true;
        }
        return false;
    }

    static boolean isHiddenMemberReference(MemberReference reference, DecompilerContext context) {
        if (reference instanceof MethodReference) {
            MethodDefinition md = ((MethodReference)reference).resolve();
            return md != null && AstBuilder.isMemberHidden(md, context);
        }
        if (reference instanceof FieldReference) {
            FieldDefinition fd = ((FieldReference)reference).resolve();
            return fd != null && AstBuilder.isMemberHidden(fd, context);
        }
        return false;
    }

    @Override
    public Void visitAssignmentExpression(AssignmentExpression node, Void data) {
        Expression left = node.getLeft();
        Expression right = node.getRight();
        if (node.getParent() instanceof ExpressionStatement && RemoveHiddenMembersTransform.isHiddenMemberReference(left, this.context) && RemoveHiddenMembersTransform.isHiddenMemberReference(right, this.context)) {
            node.getParent().remove();
            return null;
        }
        return (Void)super.visitAssignmentExpression(node, data);
    }

    @Override
    protected Void visitTypeDeclarationOverride(TypeDeclaration node, Void p) {
        TypeDefinition type;
        if (!(node.getParent() instanceof CompilationUnit) && (type = node.getUserData(Keys.TYPE_DEFINITION)) != null && AstBuilder.isMemberHidden(type, this.context)) {
            node.remove();
            return null;
        }
        return (Void)super.visitTypeDeclarationOverride(node, p);
    }

    @Override
    public Void visitFieldDeclaration(FieldDeclaration node, Void data) {
        FieldDefinition field = node.getUserData(Keys.FIELD_DEFINITION);
        if (field != null && AstBuilder.isMemberHidden(field, this.context)) {
            node.remove();
            return null;
        }
        return (Void)super.visitFieldDeclaration(node, data);
    }

    @Override
    protected Void visitMethodDeclarationOverride(MethodDeclaration node, Void p) {
        super.visitMethodDeclarationOverride(node, p);
        MethodDefinition method = node.getUserData(Keys.METHOD_DEFINITION);
        if (method != null) {
            if (AstBuilder.isMemberHidden(method, this.context)) {
                node.remove();
                return null;
            }
            if (method.isTypeInitializer() && node.getBody().getStatements().isEmpty()) {
                node.remove();
                return null;
            }
        }
        return null;
    }

    @Override
    public Void visitConstructorDeclaration(ConstructorDeclaration node, Void p) {
        TypeDefinition declaringType;
        final MethodDefinition method = node.getUserData(Keys.METHOD_DEFINITION);
        if (method != null && (declaringType = method.getDeclaringType()) != null) {
            boolean hasOtherConstructors;
            if (AstBuilder.isMemberHidden(method, this.context)) {
                if (declaringType.isEnum() && declaringType.isAnonymous() && !node.getBody().getStatements().isEmpty()) {
                    return (Void)super.visitConstructorDeclaration(node, p);
                }
                node.remove();
                return null;
            }
            if (!this.context.getSettings().getShowSyntheticMembers() && (method.getModifiers() & 7) == (declaringType.getModifiers() & 7) && node.getParameters().isEmpty() && node.getThrownTypes().isEmpty() && node.getTypeParameters().isEmpty() && node.getAnnotations().isEmpty() && DEFAULT_CONSTRUCTOR_BODY.matches(node.getBody()) && !(hasOtherConstructors = CollectionUtilities.any(declaringType.getDeclaredMethods(), new Predicate<MethodDefinition>(){

                @Override
                public boolean test(MethodDefinition m) {
                    return m.isConstructor() && !m.isSynthetic() && !StringUtilities.equals(m.getErasedSignature(), method.getErasedSignature());
                }
            }))) {
                node.remove();
                return null;
            }
        }
        return (Void)super.visitConstructorDeclaration(node, p);
    }

    @Override
    public Void visitExpressionStatement(ExpressionStatement node, Void data) {
        AstNode target;
        MemberReference member;
        Match match;
        super.visitExpressionStatement(node, data);
        if (this.inConstructor() && !this.context.getSettings().getShowSyntheticMembers() && (match = EMPTY_SUPER.match(node)).success() && (member = (target = (AstNode)CollectionUtilities.first(match.get("target"))).getUserData(Keys.MEMBER_REFERENCE)) instanceof MethodReference && ((MethodReference)member).isConstructor()) {
            node.remove();
        }
        return null;
    }
}

