/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.protege.editor.core.ui.util.AugmentedJTextField;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.classexpression.OWLExpressionParserException;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLAutoCompleter;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionChecker;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.protege.editor.owl.ui.frame.OWLObjectPropertyIndividualPair;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;

public class OWLObjectPropertyIndividualPairEditor2
extends AbstractOWLObjectEditor<OWLObjectPropertyIndividualPair>
implements VerifiedInputEditor {
    private JTextField objectPropertyField;
    private JTextField individualField;
    private JPanel panelHolder;
    private JPanel panel;
    private OWLModelManager modelManager;
    private JLabel errorLabel = new JLabel(" ");
    private InputVerificationStatusChangedListener verificationStatusChangedListener = newState -> {};

    public OWLObjectPropertyIndividualPairEditor2(OWLEditorKit editorKit) {
        this.modelManager = editorKit.getOWLModelManager();
        this.panelHolder = new JPanel(new BorderLayout());
        this.panel = new JPanel(new GridBagLayout());
        this.panelHolder.add((Component)this.panel, "North");
        this.objectPropertyField = new AugmentedJTextField("", 20, "Enter object property name");
        this.objectPropertyField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                OWLObjectPropertyIndividualPairEditor2.this.validateInput();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OWLObjectPropertyIndividualPairEditor2.this.validateInput();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.individualField = new AugmentedJTextField("", 20, "Enter individual name");
        this.individualField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                OWLObjectPropertyIndividualPairEditor2.this.validateInput();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OWLObjectPropertyIndividualPairEditor2.this.validateInput();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        Insets insets = new Insets(2, 2, 2, 2);
        this.panel.add((Component)this.objectPropertyField, new GridBagConstraints(0, 0, 1, 1, 100.0, 0.0, 256, 2, insets, 0, 0));
        this.panel.add((Component)this.individualField, new GridBagConstraints(1, 0, 1, 1, 100.0, 0.0, 256, 2, insets, 0, 0));
        this.errorLabel.setForeground(Color.RED);
        this.panel.add((Component)this.errorLabel, new GridBagConstraints(0, 1, 2, 1, 100.0, 0.0, 768, 2, insets, 0, 0));
        JLabel tipLabel = new JLabel("(Tip: Use CTRL+Space to auto-complete names)");
        tipLabel.setForeground(Color.GRAY);
        tipLabel.setHorizontalAlignment(4);
        this.panel.add((Component)tipLabel, new GridBagConstraints(0, 2, 2, 1, 100.0, 0.0, 768, 2, insets, 0, 0));
        new OWLAutoCompleter(editorKit, this.objectPropertyField, new OWLExpressionChecker(){

            @Override
            public void check(String text) throws OWLExpressionParserException {
                if (OWLObjectPropertyIndividualPairEditor2.this.modelManager.getOWLEntityFinder().getOWLObjectProperty(text) == null) {
                    throw new OWLExpressionParserException(text, 0, text.length(), false, true, false, false, false, false, Collections.emptySet());
                }
            }

            public Object createObject(String text) throws OWLExpressionParserException {
                return OWLObjectPropertyIndividualPairEditor2.this.modelManager.getOWLEntityFinder().getOWLObjectProperty(text);
            }
        });
        new OWLAutoCompleter(editorKit, this.individualField, new OWLExpressionChecker(){

            @Override
            public void check(String text) throws OWLExpressionParserException {
                if (OWLObjectPropertyIndividualPairEditor2.this.modelManager.getOWLEntityFinder().getOWLIndividual(text) == null) {
                    throw new OWLExpressionParserException(text, 0, text.length(), false, false, false, true, false, false, Collections.emptySet());
                }
            }

            public Object createObject(String text) throws OWLExpressionParserException {
                return OWLObjectPropertyIndividualPairEditor2.this.modelManager.getOWLEntityFinder().getOWLIndividual(text);
            }
        });
        this.validateInput();
    }

    private void validateInput() {
        this.objectPropertyField.setToolTipText(null);
        this.individualField.setToolTipText(null);
        this.errorLabel.setText(" ");
        String objectPropertyName = this.objectPropertyField.getText().trim();
        if (!objectPropertyName.isEmpty() && this.modelManager.getOWLEntityFinder().getOWLObjectProperty(objectPropertyName) == null) {
            this.objectPropertyField.setToolTipText("Invalid object property");
            this.errorLabel.setText("Invalid property name");
            this.verificationStatusChangedListener.verifiedStatusChanged(false);
            return;
        }
        String individualName = this.individualField.getText().trim();
        if (!individualName.isEmpty() && this.modelManager.getOWLEntityFinder().getOWLIndividual(individualName) == null) {
            this.individualField.setToolTipText("Invalid individual name");
            this.errorLabel.setText("Invalid individual name");
            this.verificationStatusChangedListener.verifiedStatusChanged(false);
            return;
        }
        if (objectPropertyName.isEmpty() || individualName.isEmpty()) {
            this.verificationStatusChangedListener.verifiedStatusChanged(false);
            return;
        }
        this.verificationStatusChangedListener.verifiedStatusChanged(true);
    }

    @Override
    @Nonnull
    public String getEditorTypeName() {
        return "Object property assertion";
    }

    @Override
    public boolean canEdit(Object object) {
        return object instanceof OWLObjectPropertyIndividualPair;
    }

    @Override
    @Nonnull
    public JComponent getEditorComponent() {
        return this.panelHolder;
    }

    @Override
    @Nullable
    public OWLObjectPropertyIndividualPair getEditedObject() {
        OWLObjectProperty property = this.modelManager.getOWLEntityFinder().getOWLObjectProperty(this.objectPropertyField.getText());
        if (property == null) {
            return null;
        }
        OWLNamedIndividual individual = this.modelManager.getOWLEntityFinder().getOWLIndividual(this.individualField.getText());
        if (individual == null) {
            return null;
        }
        return new OWLObjectPropertyIndividualPair((OWLObjectPropertyExpression)property, (OWLIndividual)individual);
    }

    @Override
    public boolean setEditedObject(OWLObjectPropertyIndividualPair editedObject) {
        if (editedObject == null) {
            this.objectPropertyField.setText("");
            this.individualField.setText("");
        } else {
            this.objectPropertyField.setText(this.modelManager.getRendering((OWLObject)editedObject.getProperty()));
            this.individualField.setText(this.modelManager.getRendering((OWLObject)editedObject.getIndividual()));
        }
        return true;
    }

    @Override
    public void dispose() {
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.verificationStatusChangedListener = listener != null ? listener : newState -> {};
        this.validateInput();
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.verificationStatusChangedListener = newState -> {};
    }
}

