/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import com.google.common.base.Optional;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OntologyIRIShortFormProvider;

public class OWLOntologyCellRenderer
extends DefaultListCellRenderer {
    private OWLEditorKit editorKit;

    public OWLOntologyCellRenderer(OWLEditorKit editorKit) {
        this.editorKit = editorKit;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, "", index, isSelected, cellHasFocus);
        if (value instanceof OWLOntology) {
            label.setText(OWLOntologyCellRenderer.getOntologyLabelText((OWLOntology)value, this.editorKit.getModelManager()));
            label.setIcon(this.editorKit.getWorkspace().getOWLIconProvider().getIcon((OWLObject)((OWLOntology)value)));
        } else if (value instanceof IRI) {
            label.setText(OWLOntologyCellRenderer.getOntologyLabelText((Optional<IRI>)Optional.of((Object)((IRI)value)), this.editorKit.getModelManager()));
        }
        return label;
    }

    public static String getOntologyLabelText(OWLOntology ont, OWLModelManager mngr) {
        if (ont.getOntologyID().isAnonymous()) {
            return ont.getOntologyID().toString();
        }
        Optional iri = ont.getOntologyID().getDefaultDocumentIRI();
        return OWLOntologyCellRenderer.getOntologyLabelText((Optional<IRI>)iri, mngr);
    }

    public static String getOntologyLabelText(Optional<IRI> iri, OWLModelManager mngr) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>");
        if (iri.isPresent()) {
            String shortForm = new OntologyIRIShortFormProvider().getShortForm((IRI)iri.get());
            sb.append(shortForm);
        } else {
            sb.append("Anonymous ontology");
        }
        sb.append(" <font color=\"gray\">(");
        if (iri.isPresent()) {
            sb.append(((IRI)iri.get()).toString());
        }
        sb.append(")</font></body></html>");
        return sb.toString();
    }
}

