/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.layout;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import org.protege.editor.owl.ui.renderer.layout.Link;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPLink
extends Link {
    private final Logger logger = LoggerFactory.getLogger(HTTPLink.class);
    private URI linkURI;

    public HTTPLink(URI linkURI) {
        super(linkURI.toString());
        this.linkURI = linkURI;
    }

    public URI getLinkURI() {
        return this.linkURI;
    }

    @Override
    public boolean isRollOverLink() {
        return false;
    }

    @Override
    public void activate(Component component, MouseEvent event) {
        if (!event.isPopupTrigger()) {
            try {
                Desktop.getDesktop().browse(this.linkURI);
            }
            catch (IOException e) {
                this.logger.error("An error occurred whilst trying to activate an http link.  Link: {}", new Object[]{this.linkURI, e.getMessage(), e});
            }
        }
    }
}

