from _typeshed import SupportsGetItem, Unused
from collections.abc import Container, Generator, Iterable, Iterator, Sized
from typing import overload

from networkx.classes.graph import Graph, _Node

def enumerate_all_cliques(G: Graph[_Node]) -> Generator[list[_Node], None, None]: ...
def find_cliques(G: Graph[_Node], nodes: SupportsGetItem[slice, _Node] | None = None) -> Generator[list[_Node], None, None]: ...
def find_cliques_recursive(G: Graph[_Node], nodes: SupportsGetItem[slice, _Node] | None = None) -> Iterator[list[_Node]]: ...
def make_max_clique_graph(G: Graph[_Node], create_using: type[Graph[_Node]] | None = None) -> Graph[_Node]: ...
def make_clique_bipartite(
    G: Graph[_Node], fpos: Unused = None, create_using: type[Graph[_Node]] | None = None, name: Unused = None
) -> Graph[_Node]: ...
def graph_clique_number(G: Graph[_Node], cliques: Iterable[_Node] | None = None) -> int: ...
def graph_number_of_cliques(G: Graph[_Node], cliques: Sized | None = None) -> int: ...
@overload
def node_clique_number(  # type: ignore[misc]  # Incompatible return types
    G: Graph[_Node],
    nodes: Iterable[_Node] | None = None,
    cliques: Iterable[Iterable[_Node]] | None = None,
    separate_nodes: Unused = False,
) -> dict[_Node, int]: ...
@overload
def node_clique_number(
    G: Graph[_Node], nodes: _Node, cliques: Iterable[Sized] | None = None, separate_nodes: Unused = False
) -> int: ...
@overload
def number_of_cliques(  # type: ignore[misc]  # Incompatible return types
    G: Graph[_Node], nodes: list[_Node] | None = None, cliques: Iterable[Container[_Node]] | None = None
) -> dict[_Node, int]: ...
@overload
def number_of_cliques(G: Graph[_Node], nodes: _Node, cliques: Iterable[Container[_Node]] | None = None) -> int: ...
@overload
def cliques_containing_node(  # type: ignore[misc]  # Incompatible return types
    G: Graph[_Node], nodes: list[_Node] | None = None, cliques: Iterable[Container[_Node]] | None = None
) -> dict[_Node, list[_Node]]: ...
@overload
def cliques_containing_node(
    G: Graph[_Node], nodes: _Node, cliques: Iterable[Container[_Node]] | None = None
) -> Generator[list[_Node], None, None]: ...
