/*
 * Copyright (c) 2013 Novell, Inc.
 * Copyright (c) 2023 SUSE LLC
 *
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail, you may
 * find current contact information at www.novell.com.
 */


#ifndef SNAPPER_VERSION_H
#define SNAPPER_VERSION_H


#define LIBSNAPPER_VERSION_STRING "7.4.0"

#define LIBSNAPPER_MAJOR "7"
#define LIBSNAPPER_MINOR "4"
#define LIBSNAPPER_PATCHLEVEL "0"

#define LIBSNAPPER_VERSION_AT_LEAST(major, minor)                                            \
    ((LIBSNAPPER_VERSION_MAJOR > (major)) ||                                                 \
     (LIBSNAPPER_VERSION_MAJOR == (major) && LIBSNAPPER_VERSION_MINOR >= (minor)))


namespace snapper
{

    /**
     * Return LIBSNAPPER_VERSION_STRING libsnapper was compiled with. May differ
     * from the define (compile time vs. link time).
     */
    const char* get_libversion_string();

}


#endif
