/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.cloud.ZkNodeProps;

public class Stats {
    static final int MAX_STORED_FAILURES = 10;
    final Map<String, Stat> stats = new ConcurrentHashMap<String, Stat>();
    private volatile int queueLength;

    public Map<String, Stat> getStats() {
        return this.stats;
    }

    public int getSuccessCount(String operation) {
        Stat stat = this.stats.get(operation.toLowerCase(Locale.ROOT));
        return stat == null ? 0 : stat.success.get();
    }

    public int getErrorCount(String operation) {
        Stat stat = this.stats.get(operation.toLowerCase(Locale.ROOT));
        return stat == null ? 0 : stat.errors.get();
    }

    public void success(String operation) {
        String op = operation.toLowerCase(Locale.ROOT);
        Stat stat = this.stats.get(op);
        if (stat == null) {
            stat = new Stat();
            this.stats.put(op, stat);
        }
        stat.success.incrementAndGet();
    }

    public void error(String operation) {
        String op = operation.toLowerCase(Locale.ROOT);
        Stat stat = this.stats.get(op);
        if (stat == null) {
            stat = new Stat();
            this.stats.put(op, stat);
        }
        stat.errors.incrementAndGet();
    }

    public Timer.Context time(String operation) {
        String op = operation.toLowerCase(Locale.ROOT);
        Stat stat = this.stats.get(op);
        if (stat == null) {
            stat = new Stat();
            this.stats.put(op, stat);
        }
        return stat.requestTime.time();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeFailureDetails(String operation, ZkNodeProps request, SolrResponse resp) {
        LinkedList<FailedOp> failedOps;
        String op = operation.toLowerCase(Locale.ROOT);
        Stat stat = this.stats.get(op);
        if (stat == null) {
            stat = new Stat();
            this.stats.put(op, stat);
        }
        LinkedList<FailedOp> linkedList = failedOps = stat.failureDetails;
        synchronized (linkedList) {
            if (failedOps.size() >= 10) {
                failedOps.removeFirst();
            }
            failedOps.addLast(new FailedOp(request, resp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FailedOp> getFailureDetails(String operation) {
        LinkedList<FailedOp> failedOps;
        Stat stat = this.stats.get(operation.toLowerCase(Locale.ROOT));
        if (stat == null || stat.failureDetails.isEmpty()) {
            return null;
        }
        LinkedList<FailedOp> linkedList = failedOps = stat.failureDetails;
        synchronized (linkedList) {
            ArrayList<FailedOp> ret = new ArrayList<FailedOp>(failedOps);
            return ret;
        }
    }

    public int getQueueLength() {
        return this.queueLength;
    }

    public void setQueueLength(int queueLength) {
        this.queueLength = queueLength;
    }

    public void clear() {
        this.stats.clear();
    }

    public static class Stat {
        public final AtomicInteger success = new AtomicInteger();
        public final AtomicInteger errors = new AtomicInteger();
        public final Timer requestTime = new Timer();
        public final LinkedList<FailedOp> failureDetails = new LinkedList();
    }

    public static class FailedOp {
        public final ZkNodeProps req;
        public final SolrResponse resp;

        public FailedOp(ZkNodeProps req, SolrResponse resp) {
            this.req = req;
            this.resp = resp;
        }
    }
}

