/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.ssl.SSLContexts;
import org.apache.solr.client.solrj.impl.HttpClientBuilderFactory;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.SolrHttpClientBuilder;
import org.apache.solr.client.solrj.impl.SolrHttpClientContextBuilder;
import org.apache.solr.client.solrj.impl.SolrHttpRequestRetryHandler;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger log;
    public static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    public static final int DEFAULT_SO_TIMEOUT = 600000;
    public static final int DEFAULT_MAXCONNECTIONSPERHOST = 100000;
    public static final int DEFAULT_MAXCONNECTIONS = 100000;
    private static final int VALIDATE_AFTER_INACTIVITY_DEFAULT = 3000;
    private static final int EVICT_IDLE_CONNECTIONS_DEFAULT = 50000;
    private static final String VALIDATE_AFTER_INACTIVITY = "validateAfterInactivity";
    private static final String EVICT_IDLE_CONNECTIONS = "evictIdleConnections";
    public static final String PROP_MAX_CONNECTIONS_PER_HOST = "maxConnectionsPerHost";
    public static final String PROP_MAX_CONNECTIONS = "maxConnections";
    public static final String PROP_USE_RETRY = "retry";
    public static final String PROP_ALLOW_COMPRESSION = "allowCompression";
    public static final String PROP_BASIC_AUTH_USER = "httpBasicAuthUser";
    public static final String PROP_BASIC_AUTH_PASS = "httpBasicAuthPassword";
    public static final String SYS_PROP_CHECK_PEER_NAME = "solr.ssl.checkPeerName";
    public static final String PROP_FOLLOW_REDIRECTS = "followRedirects";
    public static final String PROP_SO_TIMEOUT = "socketTimeout";
    public static final String PROP_CONNECTION_TIMEOUT = "connTimeout";
    public static final String SYS_PROP_HTTP_CLIENT_BUILDER_FACTORY = "solr.httpclient.builder.factory";
    public static final String SYS_PROP_SOCKET_FACTORY_REGISTRY_PROVIDER = "solr.httpclient.socketFactory.registry.provider";
    static final DefaultHttpRequestRetryHandler NO_RETRY;
    private static volatile SolrHttpClientBuilder httpClientBuilder;
    private static SolrHttpClientContextBuilder httpClientRequestContextBuilder;
    private static volatile SocketFactoryRegistryProvider socketFactoryRegistryProvider;
    private static volatile String cookiePolicy;
    private static final List<HttpRequestInterceptor> interceptors;

    public static void setHttpClientBuilder(SolrHttpClientBuilder newHttpClientBuilder) {
        httpClientBuilder = newHttpClientBuilder;
    }

    public static void setHttpClientProvider(SolrHttpClientBuilder newHttpClientBuilder) {
        httpClientBuilder = newHttpClientBuilder;
    }

    public static void setSocketFactoryRegistryProvider(SocketFactoryRegistryProvider newRegistryProvider) {
        socketFactoryRegistryProvider = newRegistryProvider;
    }

    public static SolrHttpClientBuilder getHttpClientBuilder() {
        return httpClientBuilder;
    }

    public static SocketFactoryRegistryProvider getSocketFactoryRegistryProvider() {
        return socketFactoryRegistryProvider;
    }

    public static void resetHttpClientBuilder() {
        socketFactoryRegistryProvider = new DefaultSocketFactoryRegistryProvider();
        httpClientBuilder = SolrHttpClientBuilder.create();
    }

    public static CloseableHttpClient createClient(SolrParams params) {
        return HttpClientUtil.createClient(params, HttpClientUtil.createPoolingConnectionManager());
    }

    static PoolingHttpClientConnectionManager createPoolingConnectionManager() {
        return new PoolingHttpClientConnectionManager(socketFactoryRegistryProvider.getSocketFactoryRegistry());
    }

    public static CloseableHttpClient createClient(SolrParams params, PoolingHttpClientConnectionManager cm) {
        if (params == null) {
            params = new ModifiableSolrParams();
        }
        return HttpClientUtil.createClient(params, cm, false);
    }

    public static CloseableHttpClient createClient(SolrParams params, PoolingHttpClientConnectionManager cm, boolean sharedConnectionManager, HttpRequestExecutor httpRequestExecutor) {
        ModifiableSolrParams config = new ModifiableSolrParams(params);
        if (log.isDebugEnabled()) {
            log.debug("Creating new http client, config: {}", (Object)config);
        }
        cm.setMaxTotal(params.getInt(PROP_MAX_CONNECTIONS, 10000));
        cm.setDefaultMaxPerRoute(params.getInt(PROP_MAX_CONNECTIONS_PER_HOST, 10000));
        cm.setValidateAfterInactivity(Integer.getInteger(VALIDATE_AFTER_INACTIVITY, 3000).intValue());
        HttpClientBuilder newHttpClientBuilder = HttpClientBuilder.create();
        if (sharedConnectionManager) {
            newHttpClientBuilder.setConnectionManagerShared(true);
        } else {
            newHttpClientBuilder.setConnectionManagerShared(false);
        }
        ConnectionKeepAliveStrategy keepAliveStrat = new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                return -1L;
            }
        };
        if (httpClientBuilder.getAuthSchemeRegistryProvider() != null) {
            newHttpClientBuilder.setDefaultAuthSchemeRegistry(httpClientBuilder.getAuthSchemeRegistryProvider().getAuthSchemeRegistry());
        }
        if (httpClientBuilder.getCookieSpecRegistryProvider() != null) {
            newHttpClientBuilder.setDefaultCookieSpecRegistry(httpClientBuilder.getCookieSpecRegistryProvider().getCookieSpecRegistry());
        }
        if (httpClientBuilder.getCredentialsProviderProvider() != null) {
            newHttpClientBuilder.setDefaultCredentialsProvider(httpClientBuilder.getCredentialsProviderProvider().getCredentialsProvider());
        }
        newHttpClientBuilder.addInterceptorLast((HttpRequestInterceptor)new DynamicInterceptor());
        newHttpClientBuilder = newHttpClientBuilder.setKeepAliveStrategy(keepAliveStrat).evictIdleConnections((long)Integer.getInteger(EVICT_IDLE_CONNECTIONS, 50000).intValue(), TimeUnit.MILLISECONDS);
        if (httpRequestExecutor != null) {
            newHttpClientBuilder.setRequestExecutor(httpRequestExecutor);
        }
        HttpClientBuilder builder = HttpClientUtil.setupBuilder(newHttpClientBuilder, params);
        CloseableHttpClient httpClient = builder.setConnectionManager((HttpClientConnectionManager)cm).build();
        assert (ObjectReleaseTracker.track(httpClient));
        return httpClient;
    }

    public static CloseableHttpClient createClient(SolrParams params, PoolingHttpClientConnectionManager cm, boolean sharedConnectionManager) {
        return HttpClientUtil.createClient(params, cm, sharedConnectionManager, null);
    }

    private static HttpClientBuilder setupBuilder(HttpClientBuilder builder, SolrParams config) {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setRedirectsEnabled(config.getBool(PROP_FOLLOW_REDIRECTS, false)).setDecompressionEnabled(false).setConnectTimeout(config.getInt(PROP_CONNECTION_TIMEOUT, 60000)).setSocketTimeout(config.getInt(PROP_SO_TIMEOUT, 600000));
        String cpolicy = cookiePolicy;
        if (cpolicy != null) {
            requestConfigBuilder.setCookieSpec(cpolicy);
        }
        RequestConfig requestConfig = requestConfigBuilder.build();
        HttpClientBuilder retBuilder = builder.setDefaultRequestConfig(requestConfig);
        retBuilder = config.getBool(PROP_USE_RETRY, true) ? retBuilder.setRetryHandler((HttpRequestRetryHandler)new SolrHttpRequestRetryHandler(Integer.getInteger("solr.httpclient.retries", 3))) : retBuilder.setRetryHandler((HttpRequestRetryHandler)NO_RETRY);
        String basicAuthUser = config.get(PROP_BASIC_AUTH_USER);
        String basicAuthPass = config.get(PROP_BASIC_AUTH_PASS);
        if (basicAuthUser != null && basicAuthPass != null) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(basicAuthUser, basicAuthPass));
            retBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        if (config.getBool(PROP_ALLOW_COMPRESSION, false)) {
            retBuilder.addInterceptorFirst((HttpRequestInterceptor)new UseCompressionRequestInterceptor());
            retBuilder.addInterceptorFirst((HttpResponseInterceptor)new UseCompressionResponseInterceptor());
        } else {
            retBuilder.disableContentCompression();
        }
        return retBuilder;
    }

    public static void close(HttpClient httpClient) {
        IOUtils.closeQuietly((Closeable)((CloseableHttpClient)httpClient));
        assert (ObjectReleaseTracker.release(httpClient));
    }

    public static void addRequestInterceptor(HttpRequestInterceptor interceptor) {
        interceptors.add(interceptor);
    }

    public static void removeRequestInterceptor(HttpRequestInterceptor interceptor) {
        interceptors.remove(interceptor);
    }

    public static void clearRequestInterceptors() {
        interceptors.clear();
    }

    public static void setHttpClientRequestContextBuilder(SolrHttpClientContextBuilder httpClientContextBuilder) {
        httpClientRequestContextBuilder = httpClientContextBuilder;
    }

    public static HttpClientContext createNewHttpClientRequestContext() {
        HttpClientContext context = httpClientRequestContextBuilder.createContext(HttpSolrClient.cacheKey);
        return context;
    }

    public static RequestConfig.Builder createDefaultRequestConfigBuilder() {
        String cpolicy = cookiePolicy;
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setSocketTimeout(600000).setConnectTimeout(60000).setRedirectsEnabled(false).setDecompressionEnabled(false);
        if (cpolicy != null) {
            builder.setCookieSpec(cpolicy);
        }
        return builder;
    }

    public static void setCookiePolicy(String policyName) {
        cookiePolicy = policyName;
    }

    static boolean toBooleanDefaultIfNull(Boolean bool, boolean valueIfNull) {
        if (bool == null) {
            return valueIfNull;
        }
        return bool != false;
    }

    static Boolean toBooleanObject(String str) {
        if ("true".equalsIgnoreCase(str)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(str)) {
            return Boolean.FALSE;
        }
        return null;
    }

    static {
        String factoryClassName;
        log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        NO_RETRY = new DefaultHttpRequestRetryHandler(0, false);
        httpClientRequestContextBuilder = new SolrHttpClientContextBuilder();
        interceptors = new CopyOnWriteArrayList<HttpRequestInterceptor>();
        HttpClientUtil.resetHttpClientBuilder();
        String socketFactoryRegistryProviderClassName = System.getProperty(SYS_PROP_SOCKET_FACTORY_REGISTRY_PROVIDER);
        if (socketFactoryRegistryProviderClassName != null) {
            log.debug("Using {}", (Object)socketFactoryRegistryProviderClassName);
            try {
                socketFactoryRegistryProvider = (SocketFactoryRegistryProvider)Class.forName(socketFactoryRegistryProviderClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Unable to instantiate Solr SocketFactoryRegistryProvider", e);
            }
        }
        if ((factoryClassName = System.getProperty(SYS_PROP_HTTP_CLIENT_BUILDER_FACTORY)) != null) {
            log.debug("Using {}", (Object)factoryClassName);
            try {
                HttpClientBuilderFactory factory = (HttpClientBuilderFactory)Class.forName(factoryClassName).newInstance();
                httpClientBuilder = factory.getHttpClientBuilder(Optional.of(SolrHttpClientBuilder.create()));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Unable to instantiate Solr HttpClientBuilderFactory", e);
            }
        }
    }

    public static abstract class SocketFactoryRegistryProvider {
        public abstract Registry<ConnectionSocketFactory> getSocketFactoryRegistry();
    }

    private static final class DefaultSocketFactoryRegistryProvider
    extends SocketFactoryRegistryProvider {
        private DefaultSocketFactoryRegistryProvider() {
        }

        @Override
        public Registry<ConnectionSocketFactory> getSocketFactoryRegistry() {
            RegistryBuilder builder = RegistryBuilder.create();
            builder.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
            SSLConnectionSocketFactory sslConnectionSocketFactory = null;
            boolean sslCheckPeerName = HttpClientUtil.toBooleanDefaultIfNull(HttpClientUtil.toBooleanObject(System.getProperty(HttpClientUtil.SYS_PROP_CHECK_PEER_NAME)), true);
            if (sslCheckPeerName) {
                sslConnectionSocketFactory = SSLConnectionSocketFactory.getSystemSocketFactory();
            } else {
                sslConnectionSocketFactory = new SSLConnectionSocketFactory(SSLContexts.createSystemDefault(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                log.debug("{} is false, hostname checks disabled.", (Object)HttpClientUtil.SYS_PROP_CHECK_PEER_NAME);
            }
            builder.register("https", (Object)sslConnectionSocketFactory);
            return builder.build();
        }
    }

    private static class DynamicInterceptor
    implements HttpRequestInterceptor {
        private DynamicInterceptor() {
        }

        public void process(final HttpRequest request, final HttpContext context) throws HttpException, IOException {
            interceptors.forEach(new Consumer<HttpRequestInterceptor>(){

                @Override
                public void accept(HttpRequestInterceptor interceptor) {
                    try {
                        interceptor.process(request, context);
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                    }
                }
            });
        }
    }

    private static class UseCompressionRequestInterceptor
    implements HttpRequestInterceptor {
        private UseCompressionRequestInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            if (!request.containsHeader("Accept-Encoding")) {
                request.addHeader("Accept-Encoding", "gzip, deflate");
            }
        }
    }

    private static class UseCompressionResponseInterceptor
    implements HttpResponseInterceptor {
        private UseCompressionResponseInterceptor() {
        }

        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            HttpEntity entity = response.getEntity();
            Header ceheader = entity.getContentEncoding();
            if (ceheader != null) {
                HeaderElement[] codecs = ceheader.getElements();
                for (int i = 0; i < codecs.length; ++i) {
                    if (codecs[i].getName().equalsIgnoreCase("gzip")) {
                        response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                        return;
                    }
                    if (!codecs[i].getName().equalsIgnoreCase("deflate")) continue;
                    response.setEntity((HttpEntity)new DeflateDecompressingEntity(response.getEntity()));
                    return;
                }
            }
        }
    }

    private static class DeflateDecompressingEntity
    extends GzipDecompressingEntity {
        public DeflateDecompressingEntity(HttpEntity entity) {
            super(entity);
        }

        @Override
        public InputStream getContent() throws IOException, IllegalStateException {
            return new InflaterInputStream(this.wrappedEntity.getContent());
        }
    }

    protected static class GzipDecompressingEntity
    extends HttpEntityWrapper {
        private boolean gzipInputStreamCreated = false;
        private InputStream gzipInputStream = null;

        public GzipDecompressingEntity(HttpEntity entity) {
            super(entity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream getContent() throws IOException, IllegalStateException {
            if (!this.gzipInputStreamCreated || this.wrappedEntity.isRepeatable()) {
                this.gzipInputStreamCreated = true;
                InputStream wrappedContent = this.wrappedEntity.getContent();
                if (wrappedContent != null) {
                    try {
                        this.gzipInputStream = new GZIPInputStream(wrappedContent);
                    }
                    catch (IOException ioException) {
                        try {
                            Utils.readFully(wrappedContent);
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            IOUtils.closeQuietly(wrappedContent);
                        }
                        throw new IOException("Cannot open GZipInputStream for response", ioException);
                    }
                }
            }
            return this.gzipInputStream;
        }

        public long getContentLength() {
            return -1L;
        }
    }
}

