/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.com.amazonaws.protocol.json;

import org.opensearch.notifications.core.repackage.com.amazonaws.annotation.SdkInternalApi;
import org.opensearch.notifications.core.repackage.com.amazonaws.http.HttpResponse;
import org.opensearch.notifications.core.repackage.com.amazonaws.util.IOUtils;
import org.opensearch.notifications.core.repackage.com.fasterxml.jackson.core.JsonFactory;
import org.opensearch.notifications.core.repackage.com.fasterxml.jackson.core.JsonParser;
import org.opensearch.notifications.core.repackage.com.fasterxml.jackson.databind.JsonNode;
import org.opensearch.notifications.core.repackage.com.fasterxml.jackson.databind.ObjectMapper;
import org.opensearch.notifications.core.repackage.org.apache.commons.logging.Log;
import org.opensearch.notifications.core.repackage.org.apache.commons.logging.LogFactory;

@SdkInternalApi
public class JsonContent {
    private static final Log LOG = LogFactory.getLog(JsonContent.class);
    private final byte[] rawContent;
    private final JsonNode jsonNode;

    public static JsonContent createJsonContent(HttpResponse httpResponse, JsonFactory jsonFactory) {
        byte[] rawJsonContent = null;
        try {
            if (httpResponse.getContent() != null) {
                rawJsonContent = IOUtils.toByteArray(httpResponse.getContent());
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"Unable to read HTTP response content", (Throwable)e);
        }
        return new JsonContent(rawJsonContent, new ObjectMapper(jsonFactory).configure(JsonParser.Feature.ALLOW_COMMENTS, true));
    }

    public JsonContent(byte[] rawJsonContent, JsonNode jsonNode) {
        this.rawContent = rawJsonContent;
        this.jsonNode = jsonNode;
    }

    private JsonContent(byte[] rawJsonContent, ObjectMapper mapper) {
        this.rawContent = rawJsonContent;
        this.jsonNode = JsonContent.parseJsonContent(rawJsonContent, mapper);
    }

    private static JsonNode parseJsonContent(byte[] rawJsonContent, ObjectMapper mapper) {
        if (rawJsonContent == null) {
            return mapper.createObjectNode();
        }
        try {
            JsonNode jsonNode = mapper.readTree(rawJsonContent);
            if (jsonNode.isMissingNode()) {
                return mapper.createObjectNode();
            }
            return jsonNode;
        }
        catch (Exception e) {
            LOG.debug((Object)"Unable to parse HTTP response content", (Throwable)e);
            return mapper.createObjectNode();
        }
    }

    public byte[] getRawContent() {
        return this.rawContent;
    }

    public JsonNode getJsonNode() {
        return this.jsonNode;
    }
}

