/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.persistence;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.grpc.FlowUnitMessage;

public class NetPersistor {
    private static final Logger LOG = LogManager.getLogger(NetPersistor.class);
    private static final int PER_GRAPH_NODE_FLOW_UNIT_QUEUE_CAPACITY = 200;
    ConcurrentMap<String, BlockingQueue<FlowUnitMessage>> graphNodeToFlowUnitMap = new ConcurrentHashMap<String, BlockingQueue<FlowUnitMessage>>();

    public List<FlowUnitMessage> read(String graphNode) {
        if (this.graphNodeToFlowUnitMap.containsKey(graphNode)) {
            BlockingQueue flowUnitQueue = (BlockingQueue)this.graphNodeToFlowUnitMap.get(graphNode);
            ArrayList<FlowUnitMessage> returnList = new ArrayList<FlowUnitMessage>();
            flowUnitQueue.drainTo(returnList);
            return returnList;
        }
        return new ArrayList<FlowUnitMessage>();
    }

    public void write(String graphNode, FlowUnitMessage flowUnitMessage) {
        if (flowUnitMessage == null) {
            LOG.debug("receive a null flowunit message. Dropping the flow unit.");
            return;
        }
        this.graphNodeToFlowUnitMap.putIfAbsent(graphNode, new ArrayBlockingQueue(200));
        BlockingQueue flowUnitQueue = (BlockingQueue)this.graphNodeToFlowUnitMap.get(graphNode);
        if (!flowUnitQueue.offer(flowUnitMessage)) {
            LOG.debug("Failed to add flow unit to the buffer. Dropping the flow unit.");
        }
    }
}

