/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.awt.geom.AffineTransform;
import org.apache.batik.dom.svg.AbstractSVGList;
import org.apache.batik.dom.svg.AbstractSVGMatrix;
import org.apache.batik.dom.svg.AbstractSVGTransform;
import org.apache.batik.dom.svg.ListHandler;
import org.apache.batik.dom.svg.SVGItem;
import org.apache.batik.dom.svg.SVGOMMatrix;
import org.apache.batik.dom.svg.SVGOMTransform;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.TransformListHandler;
import org.apache.batik.parser.TransformListParser;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGTransform;
import org.w3c.dom.svg.SVGTransformList;

public abstract class AbstractSVGTransformList
extends AbstractSVGList
implements SVGTransformList {
    public static final String SVG_TRANSFORMATION_LIST_SEPARATOR = "";

    @Override
    protected String getItemSeparator() {
        return SVG_TRANSFORMATION_LIST_SEPARATOR;
    }

    protected abstract SVGException createSVGException(short var1, String var2, Object[] var3);

    public SVGTransform initialize(SVGTransform sVGTransform) throws DOMException, SVGException {
        return (SVGTransform)this.initializeImpl(sVGTransform);
    }

    public SVGTransform getItem(int n) throws DOMException {
        return (SVGTransform)this.getItemImpl(n);
    }

    public SVGTransform insertItemBefore(SVGTransform sVGTransform, int n) throws DOMException, SVGException {
        return (SVGTransform)this.insertItemBeforeImpl(sVGTransform, n);
    }

    public SVGTransform replaceItem(SVGTransform sVGTransform, int n) throws DOMException, SVGException {
        return (SVGTransform)this.replaceItemImpl(sVGTransform, n);
    }

    public SVGTransform removeItem(int n) throws DOMException {
        return (SVGTransform)this.removeItemImpl(n);
    }

    public SVGTransform appendItem(SVGTransform sVGTransform) throws DOMException, SVGException {
        return (SVGTransform)this.appendItemImpl(sVGTransform);
    }

    public SVGTransform createSVGTransformFromMatrix(SVGMatrix sVGMatrix) {
        SVGOMTransform sVGOMTransform = new SVGOMTransform();
        sVGOMTransform.setMatrix(sVGMatrix);
        return sVGOMTransform;
    }

    public SVGTransform consolidate() {
        this.revalidate();
        int n = this.itemList.size();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return this.getItem(0);
        }
        SVGTransformItem sVGTransformItem = (SVGTransformItem)this.getItemImpl(0);
        AffineTransform affineTransform = (AffineTransform)sVGTransformItem.affineTransform.clone();
        for (int i = 1; i < n; ++i) {
            sVGTransformItem = (SVGTransformItem)this.getItemImpl(i);
            affineTransform.concatenate(sVGTransformItem.affineTransform);
        }
        SVGOMMatrix sVGOMMatrix = new SVGOMMatrix(affineTransform);
        return this.initialize(this.createSVGTransformFromMatrix(sVGOMMatrix));
    }

    public AffineTransform getAffineTransform() {
        AffineTransform affineTransform = new AffineTransform();
        for (int i = 0; i < this.getNumberOfItems(); ++i) {
            SVGTransformItem sVGTransformItem = (SVGTransformItem)this.getItem(i);
            affineTransform.concatenate(sVGTransformItem.affineTransform);
        }
        return affineTransform;
    }

    @Override
    protected SVGItem createSVGItem(Object object) {
        return new SVGTransformItem((SVGTransform)object);
    }

    @Override
    protected void doParse(String string, ListHandler listHandler) throws ParseException {
        TransformListParser transformListParser = new TransformListParser();
        TransformListBuilder transformListBuilder = new TransformListBuilder(listHandler);
        transformListParser.setTransformListHandler((TransformListHandler)transformListBuilder);
        transformListParser.parse(string);
    }

    @Override
    protected void checkItemType(Object object) {
        if (!(object instanceof SVGTransform)) {
            this.createSVGException((short)0, "expected.transform", null);
        }
    }

    protected class TransformListBuilder
    implements TransformListHandler {
        protected ListHandler listHandler;

        public TransformListBuilder(ListHandler listHandler) {
            this.listHandler = listHandler;
        }

        public void startTransformList() throws ParseException {
            this.listHandler.startList();
        }

        public void matrix(float f, float f2, float f3, float f4, float f5, float f6) throws ParseException {
            SVGTransformItem sVGTransformItem = new SVGTransformItem();
            sVGTransformItem.matrix(f, f2, f3, f4, f5, f6);
            this.listHandler.item(sVGTransformItem);
        }

        public void rotate(float f) throws ParseException {
            SVGTransformItem sVGTransformItem = new SVGTransformItem();
            sVGTransformItem.rotate(f);
            this.listHandler.item(sVGTransformItem);
        }

        public void rotate(float f, float f2, float f3) throws ParseException {
            SVGTransformItem sVGTransformItem = new SVGTransformItem();
            sVGTransformItem.setRotate(f, f2, f3);
            this.listHandler.item(sVGTransformItem);
        }

        public void translate(float f) throws ParseException {
            SVGTransformItem sVGTransformItem = new SVGTransformItem();
            sVGTransformItem.translate(f);
            this.listHandler.item(sVGTransformItem);
        }

        public void translate(float f, float f2) throws ParseException {
            SVGTransformItem sVGTransformItem = new SVGTransformItem();
            sVGTransformItem.setTranslate(f, f2);
            this.listHandler.item(sVGTransformItem);
        }

        public void scale(float f) throws ParseException {
            SVGTransformItem sVGTransformItem = new SVGTransformItem();
            sVGTransformItem.scale(f);
            this.listHandler.item(sVGTransformItem);
        }

        public void scale(float f, float f2) throws ParseException {
            SVGTransformItem sVGTransformItem = new SVGTransformItem();
            sVGTransformItem.setScale(f, f2);
            this.listHandler.item(sVGTransformItem);
        }

        public void skewX(float f) throws ParseException {
            SVGTransformItem sVGTransformItem = new SVGTransformItem();
            sVGTransformItem.setSkewX(f);
            this.listHandler.item(sVGTransformItem);
        }

        public void skewY(float f) throws ParseException {
            SVGTransformItem sVGTransformItem = new SVGTransformItem();
            sVGTransformItem.setSkewY(f);
            this.listHandler.item(sVGTransformItem);
        }

        public void endTransformList() throws ParseException {
            this.listHandler.endList();
        }
    }

    public class SVGTransformItem
    extends AbstractSVGTransform
    implements SVGItem {
        protected boolean xOnly;
        protected boolean angleOnly;
        protected AbstractSVGList parent;
        protected String itemStringValue;

        public SVGTransformItem() {
        }

        public SVGTransformItem(SVGTransform sVGTransform) {
            this.assign(sVGTransform);
        }

        protected void resetAttribute() {
            if (this.parent != null) {
                this.itemStringValue = null;
                this.parent.itemChanged();
            }
        }

        @Override
        public void setParent(AbstractSVGList abstractSVGList) {
            this.parent = abstractSVGList;
        }

        @Override
        public AbstractSVGList getParent() {
            return this.parent;
        }

        @Override
        public String getValueAsString() {
            if (this.itemStringValue == null) {
                this.itemStringValue = this.getStringValue();
            }
            return this.itemStringValue;
        }

        public void assign(SVGTransform sVGTransform) {
            this.type = sVGTransform.getType();
            SVGMatrix sVGMatrix = sVGTransform.getMatrix();
            switch (this.type) {
                case 2: {
                    this.setTranslate(sVGMatrix.getE(), sVGMatrix.getF());
                    break;
                }
                case 3: {
                    this.setScale(sVGMatrix.getA(), sVGMatrix.getD());
                    break;
                }
                case 4: {
                    if (sVGMatrix.getE() == 0.0f) {
                        this.rotate(sVGTransform.getAngle());
                        break;
                    }
                    this.angleOnly = false;
                    if (sVGMatrix.getA() == 1.0f) {
                        this.setRotate(sVGTransform.getAngle(), sVGMatrix.getE(), sVGMatrix.getF());
                        break;
                    }
                    if (!(sVGTransform instanceof AbstractSVGTransform)) break;
                    AbstractSVGTransform abstractSVGTransform = (AbstractSVGTransform)sVGTransform;
                    this.setRotate(abstractSVGTransform.getAngle(), abstractSVGTransform.getX(), abstractSVGTransform.getY());
                    break;
                }
                case 5: {
                    this.setSkewX(sVGTransform.getAngle());
                    break;
                }
                case 6: {
                    this.setSkewY(sVGTransform.getAngle());
                    break;
                }
                case 1: {
                    this.setMatrix(sVGMatrix);
                }
            }
        }

        protected void translate(float f) {
            this.xOnly = true;
            this.setTranslate(f, 0.0f);
        }

        protected void rotate(float f) {
            this.angleOnly = true;
            this.setRotate(f, 0.0f, 0.0f);
        }

        protected void scale(float f) {
            this.xOnly = true;
            this.setScale(f, f);
        }

        protected void matrix(float f, float f2, float f3, float f4, float f5, float f6) {
            this.setMatrix(new SVGOMMatrix(new AffineTransform(f, f2, f3, f4, f5, f6)));
        }

        @Override
        public void setMatrix(SVGMatrix sVGMatrix) {
            super.setMatrix(sVGMatrix);
            this.resetAttribute();
        }

        @Override
        public void setTranslate(float f, float f2) {
            super.setTranslate(f, f2);
            this.resetAttribute();
        }

        @Override
        public void setScale(float f, float f2) {
            super.setScale(f, f2);
            this.resetAttribute();
        }

        @Override
        public void setRotate(float f, float f2, float f3) {
            super.setRotate(f, f2, f3);
            this.resetAttribute();
        }

        @Override
        public void setSkewX(float f) {
            super.setSkewX(f);
            this.resetAttribute();
        }

        @Override
        public void setSkewY(float f) {
            super.setSkewY(f);
            this.resetAttribute();
        }

        @Override
        protected SVGMatrix createMatrix() {
            return new AbstractSVGMatrix(){

                @Override
                protected AffineTransform getAffineTransform() {
                    return SVGTransformItem.this.affineTransform;
                }

                @Override
                public void setA(float f) throws DOMException {
                    SVGTransformItem.this.type = 1;
                    super.setA(f);
                    SVGTransformItem.this.resetAttribute();
                }

                @Override
                public void setB(float f) throws DOMException {
                    SVGTransformItem.this.type = 1;
                    super.setB(f);
                    SVGTransformItem.this.resetAttribute();
                }

                @Override
                public void setC(float f) throws DOMException {
                    SVGTransformItem.this.type = 1;
                    super.setC(f);
                    SVGTransformItem.this.resetAttribute();
                }

                @Override
                public void setD(float f) throws DOMException {
                    SVGTransformItem.this.type = 1;
                    super.setD(f);
                    SVGTransformItem.this.resetAttribute();
                }

                @Override
                public void setE(float f) throws DOMException {
                    SVGTransformItem.this.type = 1;
                    super.setE(f);
                    SVGTransformItem.this.resetAttribute();
                }

                @Override
                public void setF(float f) throws DOMException {
                    SVGTransformItem.this.type = 1;
                    super.setF(f);
                    SVGTransformItem.this.resetAttribute();
                }
            };
        }

        protected String getStringValue() {
            StringBuffer stringBuffer = new StringBuffer();
            switch (this.type) {
                case 2: {
                    stringBuffer.append("translate(");
                    stringBuffer.append((float)this.affineTransform.getTranslateX());
                    if (!this.xOnly) {
                        stringBuffer.append(' ');
                        stringBuffer.append((float)this.affineTransform.getTranslateY());
                    }
                    stringBuffer.append(')');
                    break;
                }
                case 4: {
                    stringBuffer.append("rotate(");
                    stringBuffer.append(this.angle);
                    if (!this.angleOnly) {
                        stringBuffer.append(' ');
                        stringBuffer.append(this.x);
                        stringBuffer.append(' ');
                        stringBuffer.append(this.y);
                    }
                    stringBuffer.append(')');
                    break;
                }
                case 3: {
                    stringBuffer.append("scale(");
                    stringBuffer.append((float)this.affineTransform.getScaleX());
                    if (!this.xOnly) {
                        stringBuffer.append(' ');
                        stringBuffer.append((float)this.affineTransform.getScaleY());
                    }
                    stringBuffer.append(')');
                    break;
                }
                case 5: {
                    stringBuffer.append("skewX(");
                    stringBuffer.append(this.angle);
                    stringBuffer.append(')');
                    break;
                }
                case 6: {
                    stringBuffer.append("skewY(");
                    stringBuffer.append(this.angle);
                    stringBuffer.append(')');
                    break;
                }
                case 1: {
                    stringBuffer.append("matrix(");
                    double[] dArray = new double[6];
                    this.affineTransform.getMatrix(dArray);
                    for (int i = 0; i < 6; ++i) {
                        if (i != 0) {
                            stringBuffer.append(' ');
                        }
                        stringBuffer.append((float)dArray[i]);
                    }
                    stringBuffer.append(')');
                }
            }
            return stringBuffer.toString();
        }
    }
}

