/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.number;

import java.time.Instant;
import java.time.ZoneId;
import java.time.zone.ZoneRulesException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;

public class NamedTimeZone {
    static Set<String> knownTimeZones = new HashSet<String>(50);
    static HashMap<String, List<String>> idForCountry = new HashMap(50);
    static List<String> worldTimeZones = new ArrayList<String>(20);

    static void tz(String country, String zoneId) {
        List<String> list = idForCountry.get(country);
        if (list == null) {
            list = new ArrayList<String>(4);
        }
        list.add(zoneId);
        idForCountry.put(country, list);
    }

    static void tz(String country, String zoneId, boolean major) {
        NamedTimeZone.tz(country, zoneId);
        if (major) {
            worldTimeZones.add(zoneId);
        }
    }

    public static String getTimeZoneNameForDate(DateTimeValue date, String place) {
        if (!date.hasTimezone()) {
            return "";
        }
        ZoneId referenceTimezone = null;
        if (place.startsWith("America/")) {
            place = "us";
        }
        switch (place) {
            case "us": {
                referenceTimezone = ZoneId.of("America/New_York");
                break;
            }
            case "uk": 
            case "gb": {
                referenceTimezone = ZoneId.of("Europe/London");
            }
        }
        if (referenceTimezone == null) {
            return NamedTimeZone.formatTimeZoneOffset(date);
        }
        boolean summerTime = NamedTimeZone.inDaylightTime(referenceTimezone, date.secondsSinceEpoch().longValue());
        int tzMinutes = date.getTimezoneInMinutes();
        if (summerTime) {
            switch (tzMinutes) {
                case 330: {
                    return "IST";
                }
                case 120: {
                    return "CEST";
                }
                case 60: {
                    return "BST";
                }
                case 0: {
                    return "GMT";
                }
                case -240: {
                    return "EDT";
                }
                case -300: {
                    return "CDT";
                }
                case -360: {
                    return "MDT";
                }
                case -420: {
                    return "PDT";
                }
                case -480: {
                    return "AKDT";
                }
                case -540: {
                    return "HDT";
                }
            }
            return NamedTimeZone.formatTimeZoneOffset(date);
        }
        switch (tzMinutes) {
            case 330: {
                return "IST";
            }
            case 60: {
                return "CET";
            }
            case 0: {
                return "GMT";
            }
            case -300: {
                return "EST";
            }
            case -360: {
                return "CST";
            }
            case -420: {
                return "MST";
            }
            case -480: {
                return "PST";
            }
            case -540: {
                return "AKST";
            }
            case -600: {
                return "HST";
            }
        }
        return NamedTimeZone.formatTimeZoneOffset(date);
    }

    public static String formatTimeZoneOffset(DateTimeValue timeValue) {
        UnicodeBuilder sb = new UnicodeBuilder(16);
        CalendarValue.appendTimezone(timeValue.getTimezoneInMinutes(), sb);
        return sb.toString();
    }

    public static String getOlsonTimeZoneName(DateTimeValue date, String country) {
        if (!date.hasTimezone()) {
            return "";
        }
        List<String> possibleIds = idForCountry.get(country.toLowerCase());
        if (possibleIds == null) {
            return NamedTimeZone.formatTimeZoneOffset(date);
        }
        String exampleId = possibleIds.get(0);
        ZoneId exampleZone = ZoneId.of(exampleId);
        boolean inSummerTime = NamedTimeZone.inDaylightTime(exampleZone, date.secondsSinceEpoch().longValue());
        int tzMinutes = date.getTimezoneInMinutes();
        for (String olson : possibleIds) {
            ZoneId possibleTimeZone = ZoneId.of(olson);
            int offsetSeconds = NamedTimeZone.getOffsetInSecondsAtDateTime(possibleTimeZone, date);
            if (offsetSeconds != tzMinutes * 60) continue;
            return inSummerTime ? olson + "*" : olson;
        }
        return NamedTimeZone.formatTimeZoneOffset(date);
    }

    public static Optional<Boolean> inSummerTime(DateTimeValue date, String region) {
        String olsonName;
        if (region.length() == 2) {
            List<String> possibleIds = idForCountry.get(region.toLowerCase());
            if (possibleIds == null) {
                return Optional.empty();
            }
            olsonName = possibleIds.get(0);
        } else {
            olsonName = region;
        }
        ZoneId zone = NamedTimeZone.olsonZoneOrUtc(olsonName);
        return Optional.of(NamedTimeZone.inDaylightTime(zone, date.secondsSinceEpoch().longValue()));
    }

    private static ZoneId olsonZoneOrUtc(String olsonName) {
        try {
            return ZoneId.of(olsonName);
        }
        catch (ZoneRulesException e) {
            return ZoneId.of("UTC");
        }
    }

    private static boolean inDaylightTime(ZoneId zone, long secondsSinceEpoch) {
        return zone.getRules().isDaylightSavings(Instant.ofEpochSecond(secondsSinceEpoch));
    }

    public static int civilTimeOffsetInSeconds(DateTimeValue date, String olsonName) {
        ZoneId zone = NamedTimeZone.olsonZoneOrUtc(olsonName);
        return NamedTimeZone.getOffsetInSecondsAtDateTime(zone, date);
    }

    public static ZoneId getNamedTimeZone(String olsonName) {
        if (knownTimeZones.contains(olsonName)) {
            return ZoneId.of(olsonName);
        }
        return null;
    }

    private static int getOffsetInSecondsAtDateTime(ZoneId zone, DateTimeValue dateTime) {
        return zone.getRules().getOffset(dateTime.toJavaInstant()).getTotalSeconds();
    }

    static {
        knownTimeZones.addAll(ZoneId.getAvailableZoneIds());
        NamedTimeZone.tz("us", "America/New_York", true);
        NamedTimeZone.tz("us", "America/Chicago", true);
        NamedTimeZone.tz("us", "America/Denver", true);
        NamedTimeZone.tz("us", "America/Los_Angeles", true);
        NamedTimeZone.tz("us", "America/Anchorage", true);
        NamedTimeZone.tz("us", "America/Halifax", true);
        NamedTimeZone.tz("us", "Pacific/Honolulu", true);
        NamedTimeZone.tz("ca", "Canada/Pacific");
        NamedTimeZone.tz("ca", "Canada/Mountain");
        NamedTimeZone.tz("ca", "Canada/Central");
        NamedTimeZone.tz("ca", "Canada/Eastern");
        NamedTimeZone.tz("ca", "Canada/Atlantic");
        NamedTimeZone.tz("au", "Australia/Sydney", true);
        NamedTimeZone.tz("au", "Australia/Darwin", true);
        NamedTimeZone.tz("au", "Australia/Perth", true);
        NamedTimeZone.tz("ru", "Europe/Moscow", true);
        NamedTimeZone.tz("ru", "Europe/Samara");
        NamedTimeZone.tz("ru", "Asia/Yekaterinburg");
        NamedTimeZone.tz("ru", "Asia/Novosibirsk");
        NamedTimeZone.tz("ru", "Asia/Krasnoyarsk");
        NamedTimeZone.tz("ru", "Asia/Irkutsk");
        NamedTimeZone.tz("ru", "Asia/Chita");
        NamedTimeZone.tz("ru", "Asia/Vladivostok");
        NamedTimeZone.tz("an", "Europe/Andorra");
        NamedTimeZone.tz("ae", "Asia/Abu_Dhabi");
        NamedTimeZone.tz("af", "Asia/Kabul");
        NamedTimeZone.tz("al", "Europe/Tirana");
        NamedTimeZone.tz("am", "Asia/Yerevan");
        NamedTimeZone.tz("ao", "Africa/Luanda");
        NamedTimeZone.tz("ar", "America/Buenos_Aires");
        NamedTimeZone.tz("as", "Pacific/Samoa");
        NamedTimeZone.tz("at", "Europe/Vienna");
        NamedTimeZone.tz("aw", "America/Aruba");
        NamedTimeZone.tz("az", "Asia/Baku");
        NamedTimeZone.tz("ba", "Europe/Sarajevo");
        NamedTimeZone.tz("bb", "America/Barbados");
        NamedTimeZone.tz("bd", "Asia/Dhaka");
        NamedTimeZone.tz("be", "Europe/Brussels", true);
        NamedTimeZone.tz("bf", "Africa/Ouagadougou");
        NamedTimeZone.tz("bg", "Europe/Sofia");
        NamedTimeZone.tz("bh", "Asia/Bahrain");
        NamedTimeZone.tz("bi", "Africa/Bujumbura");
        NamedTimeZone.tz("bm", "Atlantic/Bermuda");
        NamedTimeZone.tz("bn", "Asia/Brunei");
        NamedTimeZone.tz("bo", "America/La_Paz");
        NamedTimeZone.tz("br", "America/Sao_Paulo");
        NamedTimeZone.tz("bs", "America/Nassau");
        NamedTimeZone.tz("bw", "Gaborone");
        NamedTimeZone.tz("by", "Europe/Minsk");
        NamedTimeZone.tz("bz", "America/Belize");
        NamedTimeZone.tz("cd", "Africa/Kinshasa");
        NamedTimeZone.tz("ch", "Europe/Zurich");
        NamedTimeZone.tz("ci", "Africa/Abidjan");
        NamedTimeZone.tz("cl", "America/Santiago");
        NamedTimeZone.tz("cn", "Asia/Shanghai");
        NamedTimeZone.tz("co", "America/Bogota");
        NamedTimeZone.tz("cr", "America/Costa_Rica");
        NamedTimeZone.tz("cu", "America/Cuba");
        NamedTimeZone.tz("cv", "Atlantic/Cape_Verde");
        NamedTimeZone.tz("cy", "Asia/Nicosia");
        NamedTimeZone.tz("cz", "Europe/Prague");
        NamedTimeZone.tz("de", "Europe/Berlin");
        NamedTimeZone.tz("dj", "Africa/Djibouti");
        NamedTimeZone.tz("dk", "Europe/Copenhagen");
        NamedTimeZone.tz("do", "America/Santo_Domingo");
        NamedTimeZone.tz("dz", "Africa/Algiers");
        NamedTimeZone.tz("ec", "America/Quito");
        NamedTimeZone.tz("ee", "Europe/Tallinn");
        NamedTimeZone.tz("eg", "Africa/Cairo");
        NamedTimeZone.tz("er", "Africa/Asmara");
        NamedTimeZone.tz("es", "Europe/Madrid");
        NamedTimeZone.tz("fi", "Europe/Helsinki");
        NamedTimeZone.tz("fj", "Pacific/Fiji");
        NamedTimeZone.tz("fk", "America/Stanley");
        NamedTimeZone.tz("fr", "Europe/Paris");
        NamedTimeZone.tz("ga", "Africa/Libreville");
        NamedTimeZone.tz("gb", "Europe/London");
        NamedTimeZone.tz("gd", "America/Grenada");
        NamedTimeZone.tz("ge", "Asia/Tbilisi");
        NamedTimeZone.tz("gh", "Africa/Accra");
        NamedTimeZone.tz("gm", "Africa/Banjul");
        NamedTimeZone.tz("gn", "Africa/Conakry");
        NamedTimeZone.tz("gr", "Europe/Athens");
        NamedTimeZone.tz("gy", "America/Guyana");
        NamedTimeZone.tz("hk", "Asia/Hong_Kong");
        NamedTimeZone.tz("hn", "America/Tegucigalpa");
        NamedTimeZone.tz("hr", "Europe/Zagreb");
        NamedTimeZone.tz("ht", "America/Port-au-Prince");
        NamedTimeZone.tz("hu", "Europe/Budapest");
        NamedTimeZone.tz("id", "Asia/Jakarta");
        NamedTimeZone.tz("ie", "Europe/Dublin");
        NamedTimeZone.tz("il", "Asia/Tel_Aviv", true);
        NamedTimeZone.tz("in", "Asia/Calcutta", true);
        NamedTimeZone.tz("iq", "Asia/Baghdad");
        NamedTimeZone.tz("ir", "Asia/Tehran");
        NamedTimeZone.tz("is", "Atlantic/Reykjavik");
        NamedTimeZone.tz("it", "Europe/Rome");
        NamedTimeZone.tz("jm", "America/Jamaica");
        NamedTimeZone.tz("jo", "Asia/Amman");
        NamedTimeZone.tz("jp", "Asia/Tokyo", true);
        NamedTimeZone.tz("ke", "Africa/Nairobi");
        NamedTimeZone.tz("kg", "Asia/Bishkek");
        NamedTimeZone.tz("kh", "Asia/Phnom_Penh");
        NamedTimeZone.tz("kp", "Asia/Pyongyang");
        NamedTimeZone.tz("kr", "Asia/Seoul");
        NamedTimeZone.tz("kw", "Asia/Kuwait");
        NamedTimeZone.tz("lb", "Asia/Beirut");
        NamedTimeZone.tz("li", "Europe/Liechtenstein");
        NamedTimeZone.tz("lk", "Asia/Colombo");
        NamedTimeZone.tz("lr", "Africa/Monrovia");
        NamedTimeZone.tz("ls", "Africa/Maseru");
        NamedTimeZone.tz("lt", "Europe/Vilnius");
        NamedTimeZone.tz("lu", "Europe/Luxembourg");
        NamedTimeZone.tz("lv", "Europe/Riga");
        NamedTimeZone.tz("ly", "Africa/Tripoli");
        NamedTimeZone.tz("ma", "Africa/Rabat");
        NamedTimeZone.tz("mc", "Europe/Monaco");
        NamedTimeZone.tz("md", "Europe/Chisinau");
        NamedTimeZone.tz("mg", "Indian/Antananarivo");
        NamedTimeZone.tz("mk", "Europe/Skopje");
        NamedTimeZone.tz("ml", "Africa/Bamako");
        NamedTimeZone.tz("mm", "Asia/Rangoon");
        NamedTimeZone.tz("mn", "Asia/Ulaanbaatar");
        NamedTimeZone.tz("mo", "Asia/Macao");
        NamedTimeZone.tz("mq", "America/Martinique");
        NamedTimeZone.tz("mt", "Europe/Malta");
        NamedTimeZone.tz("mu", "Indian/Mauritius");
        NamedTimeZone.tz("mv", "Indian/Maldives");
        NamedTimeZone.tz("mw", "Africa/Lilongwe");
        NamedTimeZone.tz("mx", "America/Mexico_City");
        NamedTimeZone.tz("my", "Asia/Kuala_Lumpur");
        NamedTimeZone.tz("na", "Africa/Windhoek");
        NamedTimeZone.tz("ne", "Africa/Niamey");
        NamedTimeZone.tz("ng", "Africa/Lagos");
        NamedTimeZone.tz("ni", "America/Managua");
        NamedTimeZone.tz("nl", "Europe/Amsterdam");
        NamedTimeZone.tz("no", "Europe/Oslo");
        NamedTimeZone.tz("np", "Asia/Kathmandu");
        NamedTimeZone.tz("nz", "Pacific/Aukland");
        NamedTimeZone.tz("om", "Asia/Muscat");
        NamedTimeZone.tz("pa", "America/Panama");
        NamedTimeZone.tz("pe", "America/Lima");
        NamedTimeZone.tz("pg", "Pacific/Port_Moresby");
        NamedTimeZone.tz("ph", "Asia/Manila");
        NamedTimeZone.tz("pk", "Asia/Karachi");
        NamedTimeZone.tz("pl", "Europe/Warsaw");
        NamedTimeZone.tz("pr", "America/Puerto_Rico");
        NamedTimeZone.tz("pt", "Europe/Lisbon");
        NamedTimeZone.tz("py", "America/Asuncion");
        NamedTimeZone.tz("qa", "Asia/Qatar");
        NamedTimeZone.tz("ro", "Europe/Bucharest");
        NamedTimeZone.tz("rs", "Europe/Belgrade");
        NamedTimeZone.tz("rw", "Africa/Kigali");
        NamedTimeZone.tz("sa", "Asia/Riyadh");
        NamedTimeZone.tz("sd", "Africa/Khartoum");
        NamedTimeZone.tz("se", "Europe/Stockholm");
        NamedTimeZone.tz("sg", "Asia/Singapore");
        NamedTimeZone.tz("si", "Europe/Ljubljana");
        NamedTimeZone.tz("sk", "Europe/Bratislava");
        NamedTimeZone.tz("sl", "Africa/Freetown");
        NamedTimeZone.tz("so", "Africa/Mogadishu");
        NamedTimeZone.tz("sr", "America/Paramaribo");
        NamedTimeZone.tz("sv", "America/El_Salvador");
        NamedTimeZone.tz("sy", "Asia/Damascus");
        NamedTimeZone.tz("sz", "Africa/Mbabane");
        NamedTimeZone.tz("td", "Africa/Ndjamena");
        NamedTimeZone.tz("tg", "Africa/Lome");
        NamedTimeZone.tz("th", "Asia/Bangkok");
        NamedTimeZone.tz("tj", "Asia/Dushanbe");
        NamedTimeZone.tz("tm", "Asia/Ashgabat");
        NamedTimeZone.tz("tn", "Africa/Tunis");
        NamedTimeZone.tz("to", "Pacific/Tongatapu");
        NamedTimeZone.tz("tr", "Asia/Istanbul");
        NamedTimeZone.tz("tw", "Asia/Taipei");
        NamedTimeZone.tz("tz", "Africa/Dar_es_Salaam");
        NamedTimeZone.tz("ua", "Europe/Kiev");
        NamedTimeZone.tz("ug", "Africa/Kampala");
        NamedTimeZone.tz("uk", "Europe/London", true);
        NamedTimeZone.tz("uy", "America/Montevideo");
        NamedTimeZone.tz("uz", "Asia/Tashkent");
        NamedTimeZone.tz("ve", "America/Caracas");
        NamedTimeZone.tz("vn", "Asia/Hanoi");
        NamedTimeZone.tz("za", "Africa/Johannesburg");
        NamedTimeZone.tz("zm", "Africa/Lusaka");
        NamedTimeZone.tz("zw", "Africa/Harare");
    }
}

